/*
 * Decompiled with CFR 0.152.
 */
package i2m.Dialog;

import i2m.ColorRenderer;
import i2m.DanasPreferences;
import i2m.DataStructure.danasDataStructure.DanasDataStructure;
import i2m.DataStructure.danasDataStructure.DanasDataStructureConstants;
import i2m.DataStructure.danasDataStructure.DanasLap;
import i2m.DataStructure.danasDataStructure.DanasSession;
import i2m.DataStructure.danasTable.DefaultCellRenderer;
import i2m.Dialog.DettagliStechioCellRenderer;
import i2m.Dialog.StechioDialog;
import i2m.SincronizzatoreMappaGraficoVideo;
import i2m.grafico.ContenitoreGrafico;
import i2m.grafico.SincronizzatoreGrafico;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;

public class DettagliStechio
extends JDialog
implements ActionListener,
WindowListener,
TableModelListener,
MouseListener {
    private static final long serialVersionUID = 1L;
    JTable table;
    MyTableModel model;
    JScrollPane scrollPane;
    Vector<Object> elencoColonne = new Vector();
    JPanel tablePanel;
    StechioDialog padre;
    JPanel pannelloPrincipale;
    DettagliStechioCellRenderer render;
    boolean mostra = false;
    DanasDataStructureConstants.ValueType tps;
    DanasDataStructureConstants.ValueType lambda;
    DanasDataStructureConstants.ValueType rpm;
    boolean aggiornamentoTabella = false;
    JLabel massimiMinimi;
    double max = Double.MIN_VALUE;
    double min = Double.MAX_VALUE;
    double maxAssoluto = Double.MIN_VALUE;
    double minAssoluto = Double.MAX_VALUE;
    SincronizzatoreMappaGraficoVideo multiSincro = null;
    private SincronizzatoreGrafico sincro = null;
    private ContenitoreGrafico contGrafico = null;
    boolean sessioni = true;

    public DettagliStechio(StechioDialog stechioDialog) {
        super((Dialog)stechioDialog, "Stechio table ");
        this.padre = stechioDialog;
        this.setDefaultCloseOperation(2);
        this.setLocationRelativeTo(null);
        this.model = new MyTableModel();
        this.table = new JTable(this.model);
        this.table.setFillsViewportHeight(false);
        this.table.setDefaultRenderer(Color.class, new ColorRenderer(true));
        Font font = new Font("sansserif", 0, 10);
        this.table.setFont(font);
        this.render = new DettagliStechioCellRenderer(true);
        this.table.setDefaultRenderer(Double.class, this.render);
        this.table.setDefaultRenderer(Integer.class, this.render);
        this.table.setDefaultRenderer(String.class, this.render);
        this.table.setDefaultRenderer(Boolean.class, new DefaultCellRenderer(true));
        this.table.setRowHeight(15);
        this.table.getTableHeader().setReorderingAllowed(true);
        this.model.addTableModelListener(this);
        this.table.addMouseListener(this);
        this.tablePanel = new JPanel();
        this.tablePanel.setLayout(new BoxLayout(this.tablePanel, 1));
        this.tablePanel.add(this.table);
        this.scrollPane = new JScrollPane(this.tablePanel);
        JPanel pannelloTabella = new JPanel(new BorderLayout());
        JPanel pannelloEstremi = new JPanel();
        this.massimiMinimi = new JLabel(" Min-Max(---): --");
        pannelloEstremi.add(this.massimiMinimi);
        pannelloTabella.add((Component)this.table.getTableHeader(), "North");
        pannelloTabella.add((Component)this.scrollPane, "Center");
        pannelloTabella.add((Component)pannelloEstremi, "South");
        this.aggiustaColonne();
        this.add(pannelloTabella);
        this.addWindowListener(this);
        this.setSize(270, 460);
        this.setFocusableWindowState(false);
    }

    public void setMultiSincro(SincronizzatoreMappaGraficoVideo multi) {
        this.multiSincro = multi;
    }

    public void setSincro(SincronizzatoreGrafico sync) {
        this.sincro = sync;
    }

    public void setContenitoreGrafico(ContenitoreGrafico cont) {
        this.contGrafico = cont;
    }

    public void aggiustaColonne() {
        int larghezza = 20;
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            switch (i) {
                case 0: {
                    larghezza = 20;
                    break;
                }
                case 1: {
                    larghezza = 25;
                    break;
                }
                case 2: {
                    larghezza = 15;
                    break;
                }
                case 3: {
                    larghezza = 15;
                    break;
                }
                case 4: {
                    larghezza = 65;
                }
            }
            this.table.getColumnModel().getColumn(i).setPreferredWidth(larghezza);
            this.table.getColumnModel().getColumn(i).setWidth(larghezza);
        }
        this.table.getColumnModel().getColumn(0).setMaxWidth(20);
    }

    public void setValueTps(DanasDataStructureConstants.ValueType tipo) {
        this.tps = tipo;
    }

    public void setValueLambda(DanasDataStructureConstants.ValueType tipo) {
        this.lambda = tipo;
    }

    public void setValueRpm(DanasDataStructureConstants.ValueType tipo) {
        this.rpm = tipo;
    }

    public void inserisciValori(boolean _sessioni, int posizione) {
        this.sessioni = _sessioni;
        this.model.rimuoviTutto();
        this.max = Double.MIN_VALUE;
        this.min = Double.MAX_VALUE;
        this.maxAssoluto = Double.MIN_VALUE;
        this.minAssoluto = Double.MAX_VALUE;
        for (int i = 1; i <= DanasDataStructure.getInstance().getNSessions(); ++i) {
            if (!DanasDataStructure.getInstance().getSession(i).isSelected()) continue;
            DanasSession s = DanasDataStructure.getInstance().getSession(i);
            if (this.sessioni) {
                this.analizzaSessione(s, s.getStartTelemetryTime(), s.getEndTelemetryTime(), posizione);
                continue;
            }
            Vector<DanasLap> laps = s.getLaps();
            for (int j = 0; j < laps.size(); ++j) {
                DanasLap l = laps.get(j);
                if (!l.getSelected()) continue;
                this.analizzaSessione(s, l.getStart(), l.getEnd(), posizione);
            }
        }
        this.aggiustaColonne();
        this.table.setAutoCreateRowSorter(true);
        if (this.max != Double.MIN_VALUE && this.min != Double.MAX_VALUE) {
            this.massimiMinimi.setText(String.format("Min-Max (%.2f-%.2f):  %.2f-%.2f", this.minAssoluto, this.maxAssoluto, this.min, this.max));
        } else if (this.maxAssoluto != Double.MIN_VALUE && this.minAssoluto != Double.MAX_VALUE) {
            this.massimiMinimi.setText(String.format("Min-Max (%.2f-%.2f):  ----", this.minAssoluto, this.maxAssoluto));
        } else {
            this.massimiMinimi.setText(" Min-Max(---): --");
        }
    }

    public void analizzaSessione(DanasSession s, double start, double end, int posizione) {
        this.aggiornamentoTabella = true;
        if (s.getFrequenzaCanale(this.lambda) == 0.0 || s.getFrequenzaCanale(this.tps) == 0.0 || s.getFrequenzaCanale(this.rpm) == 0.0) {
            return;
        }
        DanasDataStructureConstants.ValueType CanaleRiferimento = DanasDataStructureConstants.ValueType.RPM;
        double frequenza = s.getFrequenzaCanale(CanaleRiferimento);
        if (s.getFrequenzaCanale(this.tps) > frequenza) {
            frequenza = s.getFrequenzaCanale(this.tps);
            CanaleRiferimento = this.tps;
        }
        if (s.getFrequenzaCanale(this.lambda) > frequenza) {
            frequenza = s.getFrequenzaCanale(this.lambda);
            CanaleRiferimento = this.lambda;
        }
        double realStart = Math.floor(start / s.getRisoluzioneTemporale()) * s.getRisoluzioneTemporale();
        double tempoPrecedente = -1.0;
        for (double time = realStart; time < end; time += s.getRisoluzioneTemporale()) {
            double tempoRiferimento;
            if (s.getPosizioneStechioAtTime(time, DanasDataStructureConstants.BoundLap.NEAREST) != posizione || (tempoRiferimento = (double)(s.getIndiceAtTime(CanaleRiferimento, time, DanasDataStructureConstants.BoundLap.NEAREST) * 100) / frequenza + s.getTempoIniziale(CanaleRiferimento)) == tempoPrecedente) continue;
            tempoPrecedente = tempoRiferimento;
            int n = this.model.getRowCount();
            this.model.addRow();
            boolean usa = s.getUsaInStechioAtTime(time, DanasDataStructureConstants.BoundLap.NEAREST);
            this.table.setValueAt(usa, n, 0);
            Double valore = s.getDatoAtTime(this.lambda, time, DanasDataStructureConstants.BoundLap.NEAREST, true);
            this.table.setValueAt(String.format(Locale.ENGLISH, "%2.2f", valore), n, 1);
            this.table.setValueAt(String.format(Locale.ENGLISH, "%.2f", s.getDatoAtTime(this.tps, time, DanasDataStructureConstants.BoundLap.NEAREST, true)), n, 2);
            this.table.setValueAt(String.format(Locale.ENGLISH, "%.2f", s.getDatoAtTime(this.rpm, time, DanasDataStructureConstants.BoundLap.NEAREST, true)), n, 3);
            this.table.setValueAt(String.format(Locale.ENGLISH, "%.4f", (tempoRiferimento - s.getStartTelemetryTime()) / 100.0), n, 4);
            this.model.setValueAt(time, n, 5);
            this.model.setValueAt(s.getSessionID(), n, 6);
            if (valore > this.max && usa) {
                this.max = valore;
            }
            if (valore < this.min && usa) {
                this.min = valore;
            }
            if (valore > this.maxAssoluto) {
                this.maxAssoluto = valore;
            }
            if (!(valore < this.minAssoluto)) continue;
            this.minAssoluto = valore;
        }
        this.aggiornamentoTabella = false;
    }

    public double trovaOffset(int sessionId, double tempo) {
        double offset = 0.0;
        DanasSession s = DanasDataStructure.getInstance().getSession(sessionId);
        offset = s.getStartTelemetryTime();
        double tempoAssoluto = tempo + offset;
        Vector<DanasLap> laps = s.getLaps();
        for (int j = 0; j < laps.size(); ++j) {
            DanasLap l = laps.get(j);
            if (!(tempoAssoluto >= l.getStart()) || !(tempoAssoluto <= l.getEnd())) continue;
            offset = l.getStart();
        }
        return offset;
    }

    @Override
    public void windowActivated(WindowEvent arg0) {
    }

    @Override
    public void windowClosed(WindowEvent arg0) {
    }

    @Override
    public void windowClosing(WindowEvent arg0) {
        DanasPreferences.setPosizioneDettagliX(this.getLocationOnScreen().x);
        DanasPreferences.setPosizioneDettagliY(this.getLocationOnScreen().y);
        this.padre.chiusaDettagli();
    }

    @Override
    public void windowDeactivated(WindowEvent arg0) {
    }

    @Override
    public void windowDeiconified(WindowEvent arg0) {
    }

    @Override
    public void windowIconified(WindowEvent arg0) {
    }

    @Override
    public void windowOpened(WindowEvent arg0) {
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
    }

    public static void main(String[] args) {
        DettagliStechio i = new DettagliStechio(null);
        i.setVisible(true);
    }

    @Override
    public void tableChanged(TableModelEvent arg0) {
        if (this.aggiornamentoTabella) {
            return;
        }
        if (arg0.getColumn() == 0) {
            MyTableModel ms = (MyTableModel)arg0.getSource();
            int indice = arg0.getFirstRow();
            double tempo = Double.valueOf((String)this.table.getValueAt(indice, 4)) * 100.0;
            DanasSession s = DanasDataStructure.getInstance().getSession((Integer)this.model.getValueAt(indice, 6));
            if (s.getFrequenzaCanale(this.tps) == 0.0 || s.getFrequenzaCanale(this.rpm) == 0.0 || s.getFrequenzaCanale(this.lambda) == 0.0) {
                return;
            }
            double tempoIniziale = s.getStartTelemetryTime();
            double risoluzione = DanasDataStructure.getInstance().getRisoluzioneStechio();
            for (double time = tempo - 0.5 * risoluzione; time < tempo + 0.5 * risoluzione; time += s.getRisoluzioneTemporale()) {
                if (((Boolean)ms.getValueAt(indice, 0)).booleanValue()) {
                    s.setValoreUsaInStechio(time + tempoIniziale, true);
                    continue;
                }
                s.setValoreUsaInStechio(time + tempoIniziale, false);
            }
            this.padre.aggiorna();
        }
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
        double newMax;
        double newMin;
        double delta;
        int riga = this.table.getSelectedRow();
        if (riga == -1) {
            return;
        }
        double tempo = Double.valueOf((String)this.table.getValueAt(riga, 4)) * 100.0;
        DanasSession sess = DanasDataStructure.getInstance().getSession((Integer)this.model.getValueAt(riga, 6));
        double tempoIniziale = sess.getStartTelemetryTime();
        double valore = 0.0;
        valore = this.sessioni ? tempo : tempo + tempoIniziale - this.trovaOffset((Integer)this.model.getValueAt(riga, 6), tempo);
        double valoreAsse = this.contGrafico.getModoSpazio() ? this.contGrafico.convertiTempoInSpazio(valore) : valore;
        if (valoreAsse < this.sincro.getMin()) {
            delta = this.sincro.getMax() - this.sincro.getMin();
            newMin = valoreAsse - delta / 2.0;
            newMax = newMin + delta;
            this.sincro.setMin(newMin);
            this.sincro.setMax(newMax);
            this.sincro.setAggiornaAsse(true);
        }
        if (valoreAsse > this.sincro.getMax()) {
            delta = this.sincro.getMax() - this.sincro.getMin();
            newMin = valoreAsse - delta / 2.0;
            newMax = newMin + delta;
            this.sincro.setMin(newMin);
            this.sincro.setMax(newMax);
            this.sincro.setAggiornaAsse(true);
        }
        this.multiSincro.setPosizioneCursore(valore);
        this.multiSincro.setAggiornaPosizioneCursore(true);
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }

    class MyTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private ArrayList<Object[]> elencoRighe = new ArrayList();
        private int numeroColonne = 5;

        @Override
        public int getColumnCount() {
            return this.numeroColonne;
        }

        @Override
        public int getRowCount() {
            return this.elencoRighe.size();
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return " ";
                }
                case 1: {
                    return "Lambda";
                }
                case 2: {
                    return "Tps";
                }
                case 3: {
                    return "Rpm";
                }
                case 4: {
                    return "Tempo Sess.(s)";
                }
                case 5: {
                    return "";
                }
                case 6: {
                    return "";
                }
            }
            return "";
        }

        @Override
        public Object getValueAt(int row, int col) {
            return this.elencoRighe.get(row)[col];
        }

        @Override
        public Class<?> getColumnClass(int c) {
            if (c == 0) {
                return Boolean.class;
            }
            return String.class;
        }

        public void addRow() {
            Object[] riga = new Object[this.numeroColonne + 2];
            this.elencoRighe.add(riga);
            this.fireTableStructureChanged();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 0;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            this.elencoRighe.get((int)row)[col] = value;
            if (col < this.numeroColonne) {
                this.fireTableCellUpdated(row, col);
            }
        }

        public void setIndiceSessione(int value, int row, int col) {
            this.elencoRighe.get((int)row)[col] = value;
        }

        public void rimuoviTutto() {
            this.elencoRighe.clear();
            this.fireTableStructureChanged();
        }
    }
}

