/*
 * Decompiled with CFR 0.152.
 */
package i2m.Dialog;

import i2m.DanasPreferences;
import i2m.DataStructure.danasDataStructure.DanasParser;
import i2m.FileDatabase;
import i2m.Language;
import i2m.MainFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ProgressMonitor;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DatabaseDialog
extends JDialog
implements ListSelectionListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    private JButton aggiornaB;
    private JButton caricaB;
    private JButton esciB;
    private JButton openB;
    private JList listSessioni;
    private DefaultListModel sessioniLM;
    private DefaultListModel sessioniFiltrateLM;
    private JComboBox circuitoCB;
    private JComboBox dataCB;
    private JComboBox tipoCB;
    private JComboBox pilotaCB;
    private static Thread aperturaMonitorThread;
    private static int percentualeApertura;
    private Thread caricaRiassuntoSessioniThread;
    private boolean aperturaInterrotta = false;
    private static File fileSessioniCaricate;
    public static final double nauticNodesToMetersPerSeconds = 0.514444444444;
    private String directorySettaggi;
    private JLabel nomeFile;
    private JLabel nomeLabel;
    private JScrollPane listScroller;
    private DanasParser dParser;
    private JTextField nomeDatabase;
    private MainFrame danas;
    private ArrayList<File> elencoFiles = new ArrayList();
    private Vector<Integer> elencoAnni = new Vector();

    public DatabaseDialog(Frame owner, DanasParser ds_) {
        super(owner, Language.string("Sfoglia Database"), true);
        this.dParser = ds_;
        this.danas = (MainFrame)owner;
        this.setProgress(0);
        if (aperturaMonitorThread != null) {
            aperturaMonitorThread.stop();
        }
        if (this.caricaRiassuntoSessioniThread != null) {
            this.caricaRiassuntoSessioniThread.stop();
        }
        this.setResizable(true);
        this.sessioniLM = new DefaultListModel();
        this.sessioniLM.clear();
        this.sessioniFiltrateLM = new DefaultListModel();
        this.sessioniFiltrateLM.clear();
        this.costruisciInterfaccia();
        this.directorySettaggi = DanasPreferences.getPrefDirectory("openDatabaseOpen");
        this.caricaRiassuntoSessioniThread = new Thread(){

            @Override
            public void run() {
                if (DatabaseDialog.this.directorySettaggi != null) {
                    DatabaseDialog.this.nomeDatabase.setText(DatabaseDialog.this.directorySettaggi);
                    DatabaseDialog.this.listf(DatabaseDialog.this.directorySettaggi, DatabaseDialog.this.elencoFiles);
                }
                System.out.println("File nel database:" + DatabaseDialog.this.elencoFiles.size());
                DatabaseDialog.this.sessioniLM.clear();
                DatabaseDialog.this.elencoAnni.clear();
                for (int i = 0; i < DatabaseDialog.this.elencoFiles.size(); ++i) {
                    DatabaseDialog.this.estraiInformazioniFile((File)DatabaseDialog.this.elencoFiles.get(i));
                    int progresso = i * 100 / DatabaseDialog.this.elencoFiles.size();
                    DatabaseDialog.this.setProgress(progresso);
                }
                System.out.println("File riconosciuti:" + DatabaseDialog.this.sessioniLM.size());
                DatabaseDialog.this.ordinaDate();
                DatabaseDialog.this.ordinaCircuiti();
                DatabaseDialog.this.ordinaLista();
                DatabaseDialog.this.setProgress(100);
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException i) {
                    // empty catch block
                }
                System.out.println("Dati trovati=" + DatabaseDialog.this.sessioniLM.size());
                for (int i = 0; i < DatabaseDialog.this.sessioniLM.size(); ++i) {
                    DatabaseDialog.this.sessioniFiltrateLM.addElement(DatabaseDialog.this.sessioniLM.getElementAt(i));
                }
                if (DatabaseDialog.this.sessioniFiltrateLM.size() > 0) {
                    DatabaseDialog.this.listSessioni.setSelectedIndex(0);
                }
                DatabaseDialog.this.caricaRiassuntoSessioniThread = null;
            }
        };
        this.caricaRiassuntoSessioniThread.start();
        aperturaMonitorThread = new Thread(){

            @Override
            public void run() {
                DatabaseDialog.this.monitorApertura();
            }
        };
        aperturaMonitorThread.start();
    }

    public synchronized int getProgress() {
        return percentualeApertura;
    }

    private synchronized void setProgress(int progress) {
        percentualeApertura = progress;
    }

    public synchronized boolean isAperturaInterrotta() {
        return this.aperturaInterrotta;
    }

    private synchronized void setAperturaInterrotta(boolean interrotta) {
        this.aperturaInterrotta = interrotta;
    }

    private void monitorApertura() {
        this.setEnabled(false);
        this.setAperturaInterrotta(false);
        ProgressMonitor mon = new ProgressMonitor(this, Language.string("Elaborazione database in corso"), "", 0, 100);
        while (!mon.isCanceled() && this.getProgress() < 100) {
            mon.setProgress(this.getProgress());
            mon.setNote(Language.string("Completato: ") + this.getProgress() + "%");
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        if (mon.isCanceled()) {
            this.setAperturaInterrotta(true);
        }
        mon.setProgress(100);
        this.setEnabled(true);
        this.setVisible(true);
        aperturaMonitorThread = null;
    }

    public void listf(String directoryName, ArrayList<File> files) {
        File[] fList;
        File directory = new File(directoryName);
        for (File file : fList = directory.listFiles()) {
            if (file.isFile() && file.getName().endsWith(".dat")) {
                files.add(file);
                continue;
            }
            if (!file.isDirectory()) continue;
            this.listf(file.getAbsolutePath(), files);
        }
    }

    private void estraiTipo(String line, FileDatabase sessione) {
        StringTokenizer st = new StringTokenizer(line, ",");
        String t = st.nextToken();
        t = st.nextToken();
        if (t == null || t == "") {
            return;
        }
        int tipo = 0;
        try {
            tipo = Integer.valueOf(t);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (tipo == 0) {
            sessione.setTipo("Test");
        }
        if (tipo == 1) {
            sessione.setTipo(Language.string("Prove"));
        }
        if (tipo == 2) {
            sessione.setTipo(Language.string("Gara"));
        }
        if (!st.hasMoreTokens()) {
            return;
        }
        t = st.nextToken();
        if (t == null || t == "") {
            return;
        }
        int tipo2 = 0;
        try {
            tipo2 = Integer.valueOf(t);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (tipo2 == 0) {
            sessione.setTipo2("Test");
        }
        if (tipo2 == 1) {
            sessione.setTipo2(Language.string("Prove"));
        }
        if (tipo2 == 2) {
            sessione.setTipo2(Language.string("Gara"));
        }
        if (!st.hasMoreTokens()) {
            return;
        }
        t = st.nextToken();
        if (t == null || t == "") {
            return;
        }
        int tipo3 = 0;
        try {
            tipo3 = Integer.valueOf(t);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (tipo3 == 0) {
            sessione.setTipo3("Test");
        }
        if (tipo3 == 1) {
            sessione.setTipo3(Language.string("Prove"));
        }
        if (tipo3 == 2) {
            sessione.setTipo3(Language.string("Gara"));
        }
    }

    public void estraiInformazioniFile(File f) {
        FileDatabase sessione = new FileDatabase();
        boolean inizioTrovato = false;
        try {
            String line;
            sessione = new FileDatabase();
            sessione.setNomeFile(f.getAbsolutePath());
            BufferedReader fileIngresso = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
            while ((line = fileIngresso.readLine()) != null && !this.isAperturaInterrotta()) {
                String[] s;
                if (line.startsWith("$NEW SESSION")) {
                    inizioTrovato = false;
                }
                if (line.startsWith("$DATE")) {
                    s = line.split(",");
                    if (s.length > 1) {
                        sessione.setData(s[1]);
                    }
                    if (this.isNuovaData(s[1])) {
                        this.dataCB.addItem(s[1].substring(4) + "/" + s[1].substring(2, 4) + "/" + s[1].substring(0, 2));
                    }
                    try {
                        int anno = 0;
                        anno = Integer.valueOf(s[1].substring(4));
                        if (this.isNuovoAnno(anno)) {
                            this.elencoAnni.add(anno);
                        }
                    }
                    catch (NumberFormatException anno) {
                        // empty catch block
                    }
                }
                if (line.startsWith("$PILOTA")) {
                    s = line.split(",");
                    if (s.length > 1) {
                        sessione.setPilota(s[1]);
                    }
                    if (this.isNuovoPilota(s[1])) {
                        this.pilotaCB.addItem(s[1]);
                    }
                }
                if (line.startsWith("$BEST") && (s = line.split(",")).length > 1) {
                    sessione.setBest(s[1]);
                }
                if (line.startsWith("$DIST") && (s = line.split(",")).length > 1) {
                    sessione.setDistanza(s[1]);
                }
                if (line.startsWith("$TIPO")) {
                    this.estraiTipo(line, sessione);
                }
                if (!line.startsWith("$GPS") || (s = line.split(",")).length <= 2 || !s[2].equals("A")) continue;
                sessione.setGpsValido(true);
                if (inizioTrovato || s.length <= 8) continue;
                inizioTrovato = true;
                String c = this.trovaCircuito(line);
                sessione.setCircuito(c);
                if (this.isNuovoCircuito(c)) {
                    this.circuitoCB.addItem(c);
                }
                this.sessioniLM.addElement(sessione);
                break;
            }
            fileIngresso.close();
        }
        catch (IOException ex) {
            System.out.println("Non sono riuscito ad aprire il buffer di lettura sul file che mi \u00e8 stato passato");
        }
    }

    private boolean isNuovoCircuito(String s) {
        for (int i = 0; i < this.circuitoCB.getItemCount(); ++i) {
            if (!this.circuitoCB.getItemAt(i).equals(s)) continue;
            return false;
        }
        return true;
    }

    private boolean isNuovoAnno(int anno) {
        for (int i = 0; i < this.elencoAnni.size(); ++i) {
            if (this.elencoAnni.get(i) != anno) continue;
            return false;
        }
        return true;
    }

    private boolean isNuovaData(String s) {
        String data = s.substring(4) + "/" + s.substring(2, 4) + "/" + s.substring(0, 2);
        for (int i = 0; i < this.dataCB.getItemCount(); ++i) {
            if (!this.dataCB.getItemAt(i).equals(data)) continue;
            return false;
        }
        return true;
    }

    private boolean isNuovoPilota(String s) {
        for (int i = 0; i < this.pilotaCB.getItemCount(); ++i) {
            if (!this.pilotaCB.getItemAt(i).equals(s)) continue;
            return false;
        }
        return true;
    }

    private void filtra() {
        String dataScelta;
        this.sessioniFiltrateLM.clear();
        String nome = null;
        boolean filtraAnno = false;
        String anno = "xx";
        String circuitoScelto = this.circuitoCB.getSelectedIndex() != -1 && this.circuitoCB.getSelectedIndex() != 0 ? (String)this.circuitoCB.getSelectedItem() : "Tutti";
        if (this.dataCB.getSelectedIndex() != -1 && this.dataCB.getSelectedIndex() != 0) {
            dataScelta = (String)this.dataCB.getSelectedItem();
            if (dataScelta.startsWith(Language.string("Anno"))) {
                filtraAnno = true;
            }
            anno = dataScelta.substring(7);
        } else {
            dataScelta = "Tutti";
        }
        String tipoScelto = "Tutti";
        if (this.tipoCB.getSelectedIndex() == 1) {
            tipoScelto = "Test";
        }
        if (this.tipoCB.getSelectedIndex() == 2) {
            tipoScelto = Language.string("Prove");
        }
        if (this.tipoCB.getSelectedIndex() == 3) {
            tipoScelto = Language.string("Gara");
        }
        String pilotaScelto = this.pilotaCB.getSelectedIndex() != -1 && this.pilotaCB.getSelectedIndex() != 0 ? (String)this.pilotaCB.getSelectedItem() : "Tutti";
        for (int i = 0; i < this.sessioniLM.size(); ++i) {
            nome = ((FileDatabase)this.sessioniLM.getElementAt(i)).getCircuito();
            String data = ((FileDatabase)this.sessioniLM.getElementAt(i)).getData();
            String tipo = ((FileDatabase)this.sessioniLM.getElementAt(i)).getTipo();
            String tipo2 = ((FileDatabase)this.sessioniLM.getElementAt(i)).getTipo2();
            String tipo3 = ((FileDatabase)this.sessioniLM.getElementAt(i)).getTipo3();
            String pilota = ((FileDatabase)this.sessioniLM.getElementAt(i)).getPilota();
            if (!circuitoScelto.equals("Tutti") && !nome.equals(circuitoScelto) || !dataScelta.equals("Tutti") && !data.equals(dataScelta) && (!filtraAnno || !data.startsWith(anno)) || !pilotaScelto.equals("Tutti") && !pilota.equals(pilotaScelto) || !tipoScelto.equals("Tutti") && !tipo.equals(tipoScelto) && !tipo2.equals(tipoScelto) && !tipo3.equals(tipoScelto)) continue;
            this.sessioniFiltrateLM.addElement(this.sessioniLM.getElementAt(i));
        }
        if (this.sessioniFiltrateLM.size() > 0) {
            this.listSessioni.setSelectedIndex(0);
        }
        this.listScroller.getVerticalScrollBar().setValue(0);
    }

    private void caricaSessioni() {
        int[] indiciSelezionati = this.listSessioni.getSelectedIndices();
        if (indiciSelezionati.length == 0) {
            return;
        }
        File[] filesSelezionati = new File[indiciSelezionati.length];
        for (int i = 0; i < indiciSelezionati.length; ++i) {
            FileDatabase sess = (FileDatabase)this.sessioniFiltrateLM.elementAt(indiciSelezionati[i]);
            filesSelezionati[i] = new File(sess.getNomeFile());
        }
        this.danas.doApriSessioni(true, filesSelezionati);
        this.dispose();
    }

    public File getSessioniCaricate() {
        return fileSessioniCaricate;
    }

    public String trovaCircuito(String fraseGPS) {
        String risultato = null;
        String[] s = fraseGPS.split(",");
        int indice = 0;
        boolean trovato = false;
        try {
            String line;
            StringTokenizer st = new StringTokenizer(s[5], ".");
            String primaParte = st.nextToken();
            String secondaParte = st.nextToken();
            int longitudineGrezza1 = Integer.valueOf(primaParte);
            int longitudine = longitudineGrezza1 / 100 * 600000 + longitudineGrezza1 % 100 * 10000 + Integer.valueOf(secondaParte);
            int latitudine = Integer.valueOf(s[3].substring(0, 2)) * 600000 + Integer.valueOf(s[3].substring(2, 4)) * 10000 + Integer.valueOf(s[3].substring(5));
            File f = new File("./defaultCircuits.cir");
            BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
            while ((line = in.readLine()) != null) {
                String[] temp = line.split(",");
                if (!line.startsWith("t")) continue;
                ++indice;
                int latitudineTraguardo = Integer.valueOf(temp[3].substring(0, 2)) * 600000 + Integer.valueOf(temp[3].substring(2, 4)) * 10000 + Integer.valueOf(temp[3].substring(5));
                int longitudineTraguardo = Integer.valueOf(temp[5].substring(0, 3)) * 600000 + Integer.valueOf(temp[5].substring(3, 5)) * 10000 + Integer.valueOf(temp[5].substring(6));
                if (trovato || !s[4].equals(temp[4]) || !s[6].equals(temp[6]) || Math.abs(latitudine - latitudineTraguardo) >= 7000 || Math.abs(longitudine - longitudineTraguardo) >= 7000) continue;
                trovato = true;
                risultato = temp[2];
            }
            in.close();
            if (trovato) {
                return risultato;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(e.toString());
            System.out.println(fraseGPS);
            System.out.println("errore nel parsing dei dati GPS");
        }
        return Language.string("Unknown");
    }

    private void costruisciInterfaccia() {
        JPanel pannelloPrincipale = new JPanel(new BorderLayout());
        this.setContentPane(pannelloPrincipale);
        this.aggiornaB = new JButton(Language.string("Filtra"));
        this.aggiornaB.addActionListener(this);
        this.caricaB = new JButton(Language.string("Apri file selezionato"));
        this.caricaB.addActionListener(this);
        this.esciB = new JButton(Language.string("Esci"));
        this.esciB.addActionListener(this);
        JPanel pannelloBottoni = new JPanel();
        pannelloBottoni.add(this.aggiornaB);
        pannelloBottoni.add(this.caricaB);
        pannelloBottoni.add(this.esciB);
        pannelloBottoni.setBorder(BorderFactory.createEtchedBorder(0));
        pannelloPrincipale.add((Component)pannelloBottoni, "South");
        JPanel panelFile = new JPanel();
        panelFile.setLayout(new BoxLayout(panelFile, 0));
        this.openB = new JButton(Language.string("Sfoglia"));
        this.openB.addActionListener(this);
        this.openB.setMaximumSize(new Dimension(110, 25));
        JLabel fileLabel = new JLabel(Language.string(" Directory files: "));
        this.nomeDatabase = new JTextField();
        this.nomeDatabase.setMaximumSize(new Dimension(600, 25));
        panelFile.add(Box.createRigidArea(new Dimension(5, 40)));
        panelFile.add(fileLabel);
        panelFile.add(Box.createRigidArea(new Dimension(20, 40)));
        panelFile.add(this.nomeDatabase);
        panelFile.add(Box.createRigidArea(new Dimension(20, 40)));
        panelFile.add(this.openB);
        panelFile.add(Box.createRigidArea(new Dimension(10, 30)));
        pannelloPrincipale.add((Component)panelFile, "North");
        JPanel pannelloCentrale = new JPanel(new BorderLayout());
        JPanel pannelloScelte = new JPanel(new GridLayout(1, 4, 5, 0));
        String[] def = new String[]{Language.string("Tutti")};
        String[] def2 = new String[]{Language.string("Tutti"), "Test", Language.string("Prove"), Language.string("Gara")};
        this.circuitoCB = new JComboBox<String>(def);
        this.dataCB = new JComboBox<String>(def);
        this.tipoCB = new JComboBox<String>(def2);
        this.pilotaCB = new JComboBox<String>(def);
        pannelloScelte.add(this.circuitoCB);
        pannelloScelte.add(this.dataCB);
        pannelloScelte.add(this.tipoCB);
        pannelloScelte.add(this.pilotaCB);
        JPanel pannelloFiltri = new JPanel(new BorderLayout());
        JPanel pannelloNomi = new JPanel(new GridLayout(1, 4, 5, 0));
        JPanel pannelloEtichette = new JPanel(new BorderLayout());
        pannelloNomi.add(new JLabel(Language.string("Circuito:")));
        pannelloNomi.add(new JLabel(Language.string("Data:")));
        pannelloNomi.add(new JLabel(Language.string("Tipo:")));
        pannelloNomi.add(new JLabel(Language.string("Pilota:")));
        pannelloEtichette.add(Box.createRigidArea(new Dimension(0, 10)), "North");
        pannelloEtichette.add(Box.createRigidArea(new Dimension(10, 0)), "West");
        pannelloEtichette.add(Box.createRigidArea(new Dimension(10, 0)), "East");
        pannelloEtichette.add(Box.createRigidArea(new Dimension(5, 10)), "South");
        pannelloEtichette.add((Component)pannelloNomi, "Center");
        pannelloFiltri.add((Component)pannelloEtichette, "North");
        pannelloFiltri.add(Box.createRigidArea(new Dimension(10, 0)), "West");
        pannelloFiltri.add(Box.createRigidArea(new Dimension(10, 0)), "East");
        pannelloFiltri.add(Box.createRigidArea(new Dimension(0, 10)), "South");
        pannelloFiltri.add((Component)pannelloScelte, "Center");
        this.listSessioni = new JList(this.sessioniFiltrateLM);
        this.listSessioni.setSelectionMode(2);
        this.listSessioni.setLayoutOrientation(0);
        this.listSessioni.setSelectedIndex(0);
        this.listSessioni.setPreferredSize(new Dimension(90, 8000));
        this.listSessioni.setFont(new Font("Courier", 0, 13));
        this.listSessioni.addListSelectionListener(this);
        this.listScroller = new JScrollPane(this.listSessioni);
        this.listScroller.setPreferredSize(new Dimension(90, 190));
        this.listScroller.setVerticalScrollBarPolicy(22);
        this.listScroller.setAlignmentX(0.0f);
        JPanel panelNome = new JPanel();
        panelNome.setLayout(new BoxLayout(panelNome, 0));
        this.nomeLabel = new JLabel(Language.string(" Nome File selezionato: "));
        this.nomeFile = new JLabel("----");
        panelNome.add(Box.createRigidArea(new Dimension(0, 25)));
        panelNome.add(this.nomeLabel);
        panelNome.add(Box.createRigidArea(new Dimension(0, 25)));
        panelNome.add(this.nomeFile);
        pannelloCentrale.add((Component)pannelloFiltri, "North");
        pannelloCentrale.add((Component)this.listScroller, "Center");
        pannelloCentrale.add((Component)panelNome, "South");
        pannelloPrincipale.add((Component)pannelloCentrale, "Center");
        this.setSize(new Dimension(750, 420));
        this.setResizable(true);
        this.setVisible(false);
    }

    public void aggiornaSettaggiComboBox(File[] elencoFile) {
    }

    private void ordinaLista() {
        int i;
        Vector<FileDatabase> elenco = new Vector<FileDatabase>();
        for (i = 0; i < this.sessioniLM.size(); ++i) {
            elenco.add((FileDatabase)this.sessioniLM.get(i));
        }
        Collections.sort(elenco);
        this.sessioniLM.clear();
        for (i = 0; i < elenco.size(); ++i) {
            this.sessioniLM.addElement(elenco.get(i));
        }
    }

    private void ordinaDate() {
        int i;
        for (int i2 = 0; i2 < this.elencoAnni.size(); ++i2) {
            String s = Language.string("Anno-20") + String.format("%02d", this.elencoAnni.get(i2));
            this.dataCB.addItem(s);
        }
        Vector<String> elenco = new Vector<String>();
        if (this.dataCB.getItemCount() == 1) {
            return;
        }
        for (i = 1; i < this.dataCB.getItemCount(); ++i) {
            elenco.add((String)this.dataCB.getItemAt(i));
        }
        Collections.sort(elenco);
        this.dataCB.removeAllItems();
        this.dataCB.addItem(Language.string("Tutti"));
        for (i = 0; i < elenco.size(); ++i) {
            this.dataCB.addItem(elenco.get(i));
        }
    }

    private void ordinaCircuiti() {
        int i;
        Vector<String> elenco = new Vector<String>();
        if (this.circuitoCB.getItemCount() == 1) {
            return;
        }
        for (i = 1; i < this.circuitoCB.getItemCount(); ++i) {
            elenco.add((String)this.circuitoCB.getItemAt(i));
        }
        Collections.sort(elenco);
        this.circuitoCB.removeAllItems();
        this.circuitoCB.addItem(Language.string("Tutti"));
        for (i = 0; i < elenco.size(); ++i) {
            this.circuitoCB.addItem(elenco.get(i));
        }
    }

    private double kmPercorsi() {
        int[] elencoIndici = this.listSessioni.getSelectedIndices();
        if (elencoIndici.length == 0) {
            return 0.0;
        }
        double kmAttuali = 0.0;
        for (int i = 0; i < elencoIndici.length; ++i) {
            FileDatabase sess = (FileDatabase)this.sessioniFiltrateLM.getElementAt(elencoIndici[i]);
            String s = sess.getDistanza();
            try {
                double kmsess = Double.valueOf(s);
                kmAttuali += kmsess;
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return kmAttuali;
    }

    @Override
    public void valueChanged(ListSelectionEvent arg0) {
        int[] elencoIndici = this.listSessioni.getSelectedIndices();
        if (elencoIndici.length > 1) {
            this.nomeLabel.setText(Language.string("  Somma dei km percorsi nei file selezionati: "));
            double kmTotali = this.kmPercorsi();
            this.nomeFile.setText(String.format("%5.2fkm", kmTotali));
            return;
        }
        this.caricaB.setEnabled(true);
        int index = this.listSessioni.getSelectedIndex();
        if (index != -1) {
            FileDatabase riass = (FileDatabase)this.sessioniFiltrateLM.getElementAt(index);
            this.nomeLabel.setText(Language.string(" Nome File selezionato: "));
            this.nomeFile.setText(riass.getNomeFile());
        }
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (arg0.getSource().equals(this.esciB)) {
            this.dispose();
        }
        if (arg0.getSource().equals(this.aggiornaB)) {
            this.filtra();
        }
        if (arg0.getSource().equals(this.caricaB)) {
            this.caricaSessioni();
        }
        if (arg0.getSource().equals(this.openB)) {
            int res;
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setFileSelectionMode(1);
            String s = DanasPreferences.getPrefDirectory("openDatabaseOpen");
            if (s != null) {
                fileChooser.setCurrentDirectory(new File(s));
            }
            if ((res = fileChooser.showOpenDialog(this)) == 0) {
                File f = fileChooser.getSelectedFile();
                this.directorySettaggi = f.getAbsolutePath();
                this.nomeDatabase.setText(this.directorySettaggi);
                DanasPreferences.setPrefDirectory("openDatabaseOpen", this.directorySettaggi);
                try {
                    f.setReadable(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.setProgress(0);
                if (aperturaMonitorThread != null) {
                    aperturaMonitorThread.stop();
                }
                if (this.caricaRiassuntoSessioniThread != null) {
                    this.caricaRiassuntoSessioniThread.stop();
                }
                this.sessioniLM.clear();
                this.sessioniFiltrateLM.clear();
                this.elencoFiles.clear();
                this.circuitoCB.removeAllItems();
                this.circuitoCB.addItem(Language.string("Tutti"));
                this.dataCB.removeAllItems();
                this.dataCB.addItem(Language.string("Tutti"));
                this.caricaRiassuntoSessioniThread = new Thread(){

                    @Override
                    public void run() {
                        if (DatabaseDialog.this.directorySettaggi != null) {
                            DatabaseDialog.this.nomeDatabase.setText(DatabaseDialog.this.directorySettaggi);
                            DatabaseDialog.this.listf(DatabaseDialog.this.directorySettaggi, DatabaseDialog.this.elencoFiles);
                        }
                        System.out.println("File nel database:" + DatabaseDialog.this.elencoFiles.size());
                        DatabaseDialog.this.sessioniLM.clear();
                        DatabaseDialog.this.elencoAnni.clear();
                        for (int i = 0; i < DatabaseDialog.this.elencoFiles.size(); ++i) {
                            DatabaseDialog.this.estraiInformazioniFile((File)DatabaseDialog.this.elencoFiles.get(i));
                            int progresso = i * 100 / DatabaseDialog.this.elencoFiles.size();
                            DatabaseDialog.this.setProgress(progresso);
                        }
                        DatabaseDialog.this.ordinaDate();
                        DatabaseDialog.this.ordinaCircuiti();
                        DatabaseDialog.this.ordinaLista();
                        DatabaseDialog.this.listScroller.getVerticalScrollBar().setValue(0);
                        DatabaseDialog.this.setProgress(100);
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException i) {
                            // empty catch block
                        }
                        System.out.println("Dati trovati=" + DatabaseDialog.this.sessioniLM.size());
                        for (int i = 0; i < DatabaseDialog.this.sessioniLM.size(); ++i) {
                            DatabaseDialog.this.sessioniFiltrateLM.addElement(DatabaseDialog.this.sessioniLM.getElementAt(i));
                        }
                        if (DatabaseDialog.this.sessioniFiltrateLM.size() > 0) {
                            DatabaseDialog.this.listSessioni.setSelectedIndex(0);
                        }
                        DatabaseDialog.this.caricaRiassuntoSessioniThread = null;
                    }
                };
                this.caricaRiassuntoSessioniThread.start();
                aperturaMonitorThread = new Thread(){

                    @Override
                    public void run() {
                        DatabaseDialog.this.monitorApertura();
                    }
                };
                aperturaMonitorThread.start();
            }
        }
    }

    static {
        percentualeApertura = 0;
        fileSessioniCaricate = null;
    }
}

