/*
 * Decompiled with CFR 0.152.
 */
package i2m.Dialog;

import i2m.DanasPreferences;
import i2m.DataStructure.danasDataStructure.DanasDataStructure;
import i2m.DataStructure.danasDataStructure.DanasDataStructureConstants;
import i2m.DataStructure.danasDataStructure.DanasLap;
import i2m.DataStructure.danasDataStructure.DanasSession;
import i2m.Dialog.SettaggioCurva;
import i2m.Language;
import i2m.MainFrame;
import i2m.SincronizzatoreMappaGraficoVideo;
import i2m.mappa.Mappa2D;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.NumberFormat;
import java.util.Collections;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CurvaCurvaDialog
extends JDialog
implements ActionListener,
ChangeListener,
ListSelectionListener {
    private static final long serialVersionUID = 1L;
    private JButton addB;
    private JButton esciB;
    private JButton rimuoviB;
    private JButton esportaB;
    private JButton importaB;
    private JButton parameter1B;
    private JButton parameter2B;
    private JButton parameter3B;
    private JButton parameter4B;
    private JButton parameter5B;
    private DefaultListModel elencoSettoriLM;
    private JFormattedTextField spazioTF;
    private JTextField nomeTF;
    private JLabel posizioneLabel;
    private JLabel parametro1Label;
    private JLabel parametro2Label;
    private JLabel parametro3Label;
    private JLabel parametro4Label;
    private JLabel parametro5Label;
    private JLabel mostraLabel;
    private JLabel tipoMotoLabel;
    private JLabel nomeLabel;
    private SincronizzatoreMappaGraficoVideo multiSincro;
    private MainFrame padre;
    private JList list;
    private JComboBox comboMoto;
    private JComboBox comboParameter1;
    private JComboBox comboParameter2;
    private JComboBox comboParameter3;
    private JComboBox comboParameter4;
    private JComboBox comboParameter5;
    private int mostraAttuale = -1;
    private Vector<SettaggioCurva> elencoSettaggi;

    public CurvaCurvaDialog(MainFrame owner) {
        super(owner, Language.string(Language.string("Modifica dinamica dei parametri")), false);
        this.setDefaultCloseOperation(0);
        this.padre = owner;
        this.elencoSettoriLM = new DefaultListModel();
        this.elencoSettoriLM.clear();
        JPanel pannelloPrincipale = new JPanel(new BorderLayout());
        this.setContentPane(pannelloPrincipale);
        this.comboParameter1 = new JComboBox();
        this.comboParameter1.setEditable(false);
        this.comboParameter2 = new JComboBox();
        this.comboParameter2.setEditable(false);
        this.comboParameter3 = new JComboBox();
        this.comboParameter3.setEditable(false);
        this.comboParameter4 = new JComboBox();
        this.comboParameter4.setEditable(false);
        this.comboParameter5 = new JComboBox();
        this.comboParameter5.setEditable(false);
        this.parameter1B = new JButton(Language.string("Parameter 1"));
        this.parameter1B.addActionListener(this);
        this.parameter2B = new JButton(Language.string("Parameter 2"));
        this.parameter2B.addActionListener(this);
        this.parameter3B = new JButton(Language.string("Parameter 3"));
        this.parameter3B.addActionListener(this);
        this.parameter4B = new JButton(Language.string("Parameter 4"));
        this.parameter4B.addActionListener(this);
        this.parameter5B = new JButton(Language.string("Parameter 5"));
        this.parameter5B.addActionListener(this);
        this.addB = new JButton(Language.string("Aggiungi/Modifica"));
        this.addB.addActionListener(this);
        this.esciB = new JButton(Language.string("Esci"));
        this.esciB.addActionListener(this);
        this.rimuoviB = new JButton(Language.string("Rimuovi"));
        this.rimuoviB.addActionListener(this);
        this.posizioneLabel = new JLabel(Language.string("    Posizione (m):"));
        this.parametro1Label = new JLabel("    Parameter 1:");
        this.parametro2Label = new JLabel("    Parameter 2:");
        this.parametro3Label = new JLabel("    Parameter 3:");
        this.parametro4Label = new JLabel("    Parameter 4:");
        this.parametro5Label = new JLabel("    Parameter 5:");
        this.tipoMotoLabel = new JLabel(Language.string("    Tipo di moto:"));
        this.mostraLabel = new JLabel(Language.string("  Mostra su mappa:"));
        this.nomeLabel = new JLabel(Language.string("  Nome settaggio:"));
        this.esportaB = new JButton(Language.string("Esporta"));
        this.esportaB.addActionListener(this);
        this.importaB = new JButton(Language.string("Importa"));
        this.importaB.addActionListener(this);
        NumberFormat TFormat = NumberFormat.getNumberInstance(Locale.US);
        TFormat.setMaximumIntegerDigits(10);
        TFormat.setMaximumFractionDigits(0);
        TFormat.setGroupingUsed(false);
        this.spazioTF = new JFormattedTextField(TFormat);
        this.spazioTF.setValue(0);
        this.nomeTF = new JTextField(13);
        this.spazioTF.setHorizontalAlignment(4);
        this.nomeTF.setText("nome");
        this.nomeTF.setHorizontalAlignment(4);
        JPanel pannelloBottoni = new JPanel();
        JPanel pannelloTesto = new JPanel();
        JPanel pannelloImportazione = new JPanel();
        JPanel pannelloMostra = new JPanel();
        this.comboMoto = new JComboBox();
        this.comboMoto.setEditable(false);
        this.comboMoto.addActionListener(this);
        this.comboMoto.addItem("Kawasaki ZX10R 2016");
        this.comboMoto.addItem("BMW S1000RR 2015");
        this.comboMoto.addItem("Yamaha R1/R1M (15-19)");
        this.comboMoto.addItem("Yamaha R1/R1M 2020");
        this.comboMoto.addItem("Honda CBR 2020 (No HRC)");
        this.comboMoto.addItem("Ducati V4");
        this.comboMoto.setSelectedIndex(0);
        GridLayout mostraLayout = new GridLayout(1, 6, 2, 2);
        pannelloMostra.setLayout(mostraLayout);
        pannelloMostra.add(this.mostraLabel);
        pannelloMostra.add(this.parameter1B);
        pannelloMostra.add(this.parameter2B);
        pannelloMostra.add(this.parameter3B);
        pannelloMostra.add(this.parameter4B);
        pannelloMostra.add(this.parameter5B);
        GridLayout bottoniLayout = new GridLayout(1, 3, 2, 2);
        pannelloBottoni.setLayout(bottoniLayout);
        pannelloBottoni.add(this.addB);
        pannelloBottoni.add(this.rimuoviB);
        pannelloBottoni.add(this.esciB);
        pannelloBottoni.setBorder(BorderFactory.createEtchedBorder(0));
        GridLayout importazioneLayout = new GridLayout(1, 2, 2, 2);
        pannelloImportazione.setLayout(importazioneLayout);
        pannelloImportazione.add(this.importaB);
        pannelloImportazione.add(this.esportaB);
        pannelloImportazione.setBorder(BorderFactory.createEtchedBorder(0));
        GridLayout posizioneLayout = new GridLayout(9, 2, 2, 2);
        pannelloTesto.setLayout(posizioneLayout);
        pannelloTesto.add(this.posizioneLabel);
        pannelloTesto.add(this.spazioTF);
        pannelloTesto.add(this.parametro1Label);
        pannelloTesto.add(this.comboParameter1);
        pannelloTesto.add(this.parametro2Label);
        pannelloTesto.add(this.comboParameter2);
        pannelloTesto.add(this.parametro3Label);
        pannelloTesto.add(this.comboParameter3);
        pannelloTesto.add(this.parametro4Label);
        pannelloTesto.add(this.comboParameter4);
        pannelloTesto.add(this.parametro5Label);
        pannelloTesto.add(this.comboParameter5);
        pannelloTesto.add(this.tipoMotoLabel);
        pannelloTesto.add(this.comboMoto);
        pannelloTesto.add(this.nomeLabel);
        pannelloTesto.add(this.nomeTF);
        this.list = new JList(this.elencoSettoriLM);
        this.list.setSelectionMode(0);
        this.list.setLayoutOrientation(0);
        this.list.setFont(new Font("Courier", 0, 13));
        this.list.addListSelectionListener(this);
        JScrollPane listScroller = new JScrollPane(this.list);
        listScroller.setPreferredSize(new Dimension(150, 100));
        listScroller.setVerticalScrollBarPolicy(22);
        JPanel pannelloLista = new JPanel(new BorderLayout());
        pannelloLista.add((Component)pannelloMostra, "North");
        pannelloLista.add((Component)listScroller, "Center");
        pannelloLista.add((Component)pannelloTesto, "South");
        pannelloPrincipale.add((Component)pannelloImportazione, "North");
        pannelloPrincipale.add((Component)pannelloLista, "Center");
        pannelloPrincipale.add((Component)pannelloBottoni, "South");
        this.setTipoMoto(0);
        this.pack();
        this.setSize(new Dimension(750, 600));
        this.elencoSettaggi = new Vector();
        if (DanasDataStructure.getInstance().getDefaultLap() == null) {
            JOptionPane.showMessageDialog(null, Language.string("Nessun giro di default presente"), Language.string("Attenzione"), 2);
            return;
        }
        double distanzaGps = DanasDataStructure.getInstance().getDefaultLap().getDistanceCovered(DanasDataStructureConstants.DataType.GPS);
        double distanzaVel1 = DanasDataStructure.getInstance().getDefaultLap().getDistanceCovered(DanasDataStructureConstants.DataType.VALUE);
    }

    public void configuraMappaDDS(boolean ddsOn) {
        Mappa2D mappa = DanasDataStructure.getInstance().getMainFrame().getMappa();
        if (ddsOn) {
            if (mappa.getNumeroTracciati() != 1 || mappa.getModoVisualizzazioni() == 1 || DanasDataStructure.getInstance().getDefaultLap() == null) {
                JOptionPane.showMessageDialog(null, Language.string("Funzione mappa disponibile solo in modalit\u00e0 giri e con solo il giro di default visualizzato."), Language.string("Attenzione"), 2);
                this.mostraAttuale = -1;
                this.aggiornaPulsanti();
                mappa.setModoColore(0);
                mappa.aggiornaTracciati();
                return;
            }
            mappa.setCanale(DanasDataStructureConstants.ValueType.DDS.ordinal());
            mappa.setModoColore(1);
            mappa.scegliGiriVisibili();
        } else {
            mappa.setModoColore(0);
            mappa.aggiornaTracciati();
        }
    }

    private void aggiornaDdsMappa() {
        if (this.mostraAttuale == -1) {
            return;
        }
        Mappa2D mappa = DanasDataStructure.getInstance().getMainFrame().getMappa();
        if (mappa.getNumeroTracciati() != 1 || mappa.getModoVisualizzazioni() == 1 || DanasDataStructure.getInstance().getDefaultLap() == null) {
            JOptionPane.showMessageDialog(null, Language.string("Funzione mappa disponibile solo in modalit\u00e0 giri e con solo il giro di default visualizzato."), Language.string("Attenzione"), 2);
            this.mostraAttuale = -1;
            this.aggiornaPulsanti();
            mappa.setModoColore(0);
            mappa.aggiornaTracciati();
            return;
        }
        DanasLap l = DanasDataStructure.getInstance().getDefaultLap();
        DanasSession session = l.getSession();
        int indiceInizioGps = session.getIndiceAtTime(DanasDataStructureConstants.ValueType.VEL_GPS, l.getStart(), DanasDataStructureConstants.BoundLap.NEXT);
        int indiceFineGps = session.getIndiceAtTime(DanasDataStructureConstants.ValueType.VEL_GPS, l.getEnd(), DanasDataStructureConstants.BoundLap.PREVIOUS);
        int dimensione = indiceFineGps - indiceInizioGps + 1;
        if (dimensione <= 1) {
            return;
        }
        for (int i = 0; i < dimensione; ++i) {
            double tempo = session.getTempoIniziale(DanasDataStructureConstants.ValueType.VEL_GPS) + (double)((i + indiceInizioGps) * 100) / session.getFrequenzaCanale(DanasDataStructureConstants.ValueType.VEL_GPS);
            double spazio = l.getSpazioAtTime(tempo, DanasDataStructureConstants.BoundLap.NEAREST);
            if (this.elencoSettaggi.size() >= 1 && spazio < (double)this.elencoSettaggi.get(0).getSpazioGps()) {
                int ultimo = this.elencoSettaggi.size() - 1;
                switch (this.mostraAttuale) {
                    case 0: {
                        session.scriviDDS(this.getValoreParametro(1, this.elencoSettaggi.get(ultimo).getParametroUno()), indiceInizioGps + i);
                        break;
                    }
                    case 1: {
                        session.scriviDDS(this.getValoreParametro(2, this.elencoSettaggi.get(ultimo).getParametroDue()), indiceInizioGps + i);
                        break;
                    }
                    case 2: {
                        session.scriviDDS(this.getValoreParametro(3, this.elencoSettaggi.get(ultimo).getParametroTre()), indiceInizioGps + i);
                        break;
                    }
                    case 3: {
                        session.scriviDDS(this.getValoreParametro(4, this.elencoSettaggi.get(ultimo).getParametroQuattro()), indiceInizioGps + i);
                        break;
                    }
                    case 4: {
                        session.scriviDDS(this.getValoreParametro(5, this.elencoSettaggi.get(ultimo).getParametroCinque()), indiceInizioGps + i);
                    }
                }
            }
            block15: for (int j = 0; j < this.elencoSettaggi.size(); ++j) {
                if (!(spazio >= (double)this.elencoSettaggi.get(j).getSpazioGps())) continue;
                switch (this.mostraAttuale) {
                    case 0: {
                        session.scriviDDS(this.getValoreParametro(1, this.elencoSettaggi.get(j).getParametroUno()), indiceInizioGps + i);
                        continue block15;
                    }
                    case 1: {
                        session.scriviDDS(this.getValoreParametro(2, this.elencoSettaggi.get(j).getParametroDue()), indiceInizioGps + i);
                        continue block15;
                    }
                    case 2: {
                        session.scriviDDS(this.getValoreParametro(3, this.elencoSettaggi.get(j).getParametroTre()), indiceInizioGps + i);
                        continue block15;
                    }
                    case 3: {
                        session.scriviDDS(this.getValoreParametro(4, this.elencoSettaggi.get(j).getParametroQuattro()), indiceInizioGps + i);
                        continue block15;
                    }
                    case 4: {
                        session.scriviDDS(this.getValoreParametro(5, this.elencoSettaggi.get(j).getParametroCinque()), indiceInizioGps + i);
                    }
                }
            }
        }
        mappa.scegliGiriVisibili();
    }

    private double calcolaSpazioVel1(double tempo) {
        if (DanasDataStructure.getInstance().getDefaultLap() == null) {
            return 0.0;
        }
        DanasLap l = DanasDataStructure.getInstance().getDefaultLap();
        DanasSession session = l.getSession();
        if (session.getFrequenzaCanale(DanasDataStructureConstants.ValueType.SPEED1) == 0.0) {
            return 0.0;
        }
        int indiceInizioSpeed = session.getIndiceAtTime(DanasDataStructureConstants.ValueType.SPEED1, l.getStart(), DanasDataStructureConstants.BoundLap.NEXT);
        int indiceFineSpeed = session.getIndiceAtTime(DanasDataStructureConstants.ValueType.SPEED1, l.getEnd(), DanasDataStructureConstants.BoundLap.PREVIOUS);
        int dimensione = indiceFineSpeed - indiceInizioSpeed + 1;
        if (dimensione <= 1) {
            return 0.0;
        }
        if (tempo < 0.0) {
            return 0.0;
        }
        double distanza = 0.0;
        double deltaT = 100.0 / session.getFrequenzaCanale(DanasDataStructureConstants.ValueType.SPEED1);
        for (int i = 0; i < dimensione; ++i) {
            double tempoSpeed = session.getTempoIniziale(DanasDataStructureConstants.ValueType.SPEED1) + (double)((i + indiceInizioSpeed) * 100) / session.getFrequenzaCanale(DanasDataStructureConstants.ValueType.SPEED1);
            double vel = session.getDatoAtTime(DanasDataStructureConstants.ValueType.SPEED1, tempoSpeed, DanasDataStructureConstants.BoundLap.NEAREST, true) / 3.6;
            double spazio = deltaT * vel / 100.0;
            distanza += spazio;
            if (tempoSpeed >= tempo + l.getStart()) break;
        }
        return distanza;
    }

    public void impostaCursore(int metri) {
        if (DanasDataStructure.getInstance().getDefaultLap() == null) {
            return;
        }
        DanasLap l = DanasDataStructure.getInstance().getDefaultLap();
        DanasSession session = l.getSession();
        if (session.getFrequenzaCanale(DanasDataStructureConstants.ValueType.SPEED1) == 0.0) {
            return;
        }
        int indiceInizioSpeed = session.getIndiceAtTime(DanasDataStructureConstants.ValueType.SPEED1, l.getStart(), DanasDataStructureConstants.BoundLap.NEXT);
        int indiceFineSpeed = session.getIndiceAtTime(DanasDataStructureConstants.ValueType.SPEED1, l.getEnd(), DanasDataStructureConstants.BoundLap.PREVIOUS);
        int dimensione = indiceFineSpeed - indiceInizioSpeed + 1;
        if (dimensione <= 1) {
            return;
        }
        double distanza = 0.0;
        double tempo = 0.0;
        double deltaT = 100.0 / session.getFrequenzaCanale(DanasDataStructureConstants.ValueType.SPEED1);
        for (int i = 0; i < dimensione; ++i) {
            double tempoSpeed = session.getTempoIniziale(DanasDataStructureConstants.ValueType.SPEED1) + (double)((i + indiceInizioSpeed) * 100) / session.getFrequenzaCanale(DanasDataStructureConstants.ValueType.SPEED1);
            double vel = session.getDatoAtTime(DanasDataStructureConstants.ValueType.SPEED1, tempoSpeed, DanasDataStructureConstants.BoundLap.NEAREST, true) / 3.6;
            double spazio = deltaT * vel / 100.0;
            if (!((distanza += spazio) >= (double)metri)) continue;
            if (!DanasDataStructure.getInstance().getMainFrame().getVisualizzazioneGrafico()) {
                tempo = tempoSpeed - l.getStart();
                break;
            }
            tempo = tempoSpeed - session.getStartTelemetryTime();
            break;
        }
        this.multiSincro.setPosizioneCursore((int)tempo);
        this.multiSincro.setAggiornaPosizioneCursore(true);
    }

    public void setMultisincro(SincronizzatoreMappaGraficoVideo multi) {
        this.multiSincro = multi;
        this.multiSincro.addChangeListener(this);
        Mappa2D mappa = DanasDataStructure.getInstance().getMainFrame().getMappa();
        if (mappa.getNumeroTracciati() != 1 || mappa.getModoVisualizzazioni() == 1 || DanasDataStructure.getInstance().getDefaultLap() == null) {
            JOptionPane.showMessageDialog(null, Language.string("Funzione disponibile solo in modalit\u00e0 giri e con solo il giro di default visualizzato."), Language.string("Attenzione"), 2);
            this.dispose();
        }
    }

    private void setMostraAttuale(int pulsante) {
        if (pulsante == -1) {
            this.mostraAttuale = -1;
        }
        switch (pulsante) {
            case 0: {
                if (this.mostraAttuale == 0) {
                    this.mostraAttuale = -1;
                    break;
                }
                this.mostraAttuale = 0;
                break;
            }
            case 1: {
                if (this.mostraAttuale == 1) {
                    this.mostraAttuale = -1;
                    break;
                }
                this.mostraAttuale = 1;
                break;
            }
            case 2: {
                if (this.mostraAttuale == 2) {
                    this.mostraAttuale = -1;
                    break;
                }
                this.mostraAttuale = 2;
                break;
            }
            case 3: {
                if (this.mostraAttuale == 3) {
                    this.mostraAttuale = -1;
                    break;
                }
                this.mostraAttuale = 3;
                break;
            }
            case 4: {
                this.mostraAttuale = this.mostraAttuale == 4 ? -1 : 4;
            }
        }
        if (this.mostraAttuale != -1) {
            this.configuraMappaDDS(true);
        } else {
            this.configuraMappaDDS(false);
        }
        this.aggiornaPulsanti();
    }

    public void aggiornaPulsanti() {
        this.parameter1B.setSelected(false);
        this.parameter2B.setSelected(false);
        this.parameter3B.setSelected(false);
        this.parameter4B.setSelected(false);
        this.parameter5B.setSelected(false);
        this.parameter1B.setBackground(null);
        this.parameter2B.setBackground(null);
        this.parameter3B.setBackground(null);
        this.parameter4B.setBackground(null);
        this.parameter5B.setBackground(null);
        switch (this.mostraAttuale) {
            case 0: {
                this.parameter1B.setSelected(true);
                this.parameter1B.setBackground(new Color(0.52f, 0.61f, 0.69f, 1.0f));
                break;
            }
            case 1: {
                this.parameter2B.setSelected(true);
                this.parameter2B.setBackground(new Color(0.52f, 0.61f, 0.69f, 1.0f));
                break;
            }
            case 2: {
                this.parameter3B.setSelected(true);
                this.parameter3B.setBackground(new Color(0.52f, 0.61f, 0.69f, 1.0f));
                break;
            }
            case 3: {
                this.parameter4B.setSelected(true);
                this.parameter4B.setBackground(new Color(0.52f, 0.61f, 0.69f, 1.0f));
                break;
            }
            case 4: {
                this.parameter5B.setSelected(true);
                this.parameter5B.setBackground(new Color(0.52f, 0.61f, 0.69f, 1.0f));
            }
        }
    }

    public void esporta() {
        int res;
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileSelectionMode(1);
        String s = DanasPreferences.getPrefDirectory("esportaFileDds");
        if (s != null) {
            fileChooser.setCurrentDirectory(new File(s));
        }
        if ((res = fileChooser.showSaveDialog(this)) == 0) {
            File f = new File(fileChooser.getSelectedFile().toString(), "dynamicMap.dds");
            if (!f.isAbsolute()) {
                f = new File(f.getAbsolutePath());
            }
            if (f.exists() && f.canWrite()) {
                int resultSovrascrivo = JOptionPane.showConfirmDialog(this, Language.string("Sovrascrivere il file esistente?"), Language.string("ATTENZIONE"), 0);
                if (resultSovrascrivo == -1 || resultSovrascrivo == 1) {
                    return;
                }
            } else if (f.exists() || !f.getParentFile().exists() || !f.getParentFile().isDirectory() || !f.getParentFile().canWrite()) {
                JOptionPane.showMessageDialog(this, Language.string("Nome del file o percorso non valido"), Language.string("ATTENZIONE"), 0);
                return;
            }
            try {
                PrintWriter out = new PrintWriter(new OutputStreamWriter(new FileOutputStream(f)));
                out.println("DDS_N," + this.nomeTF.getText() + ",");
                out.println("DDS_T," + this.comboMoto.getSelectedIndex() + ",");
                for (int i = 0; i < this.elencoSettaggi.size(); ++i) {
                    out.println(this.elencoSettaggi.get(i).getStringa());
                }
                out.close();
                JOptionPane.showMessageDialog(this, Language.string("Mappa dinamica salvata correttamente"), Language.string("INFO"), 1);
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this, Language.string("Percorso non valido"), Language.string("ATTENZIONE"), 0);
                ex.printStackTrace();
            }
        }
    }

    public void modificaSettaggio(int index) {
        if (index == -1) {
            return;
        }
        String s = "" + this.elencoSettaggi.get(index).getSpazio();
        this.spazioTF.setText(s);
        try {
            if (this.comboMoto.getSelectedIndex() == 1) {
                this.comboParameter1.setSelectedIndex(this.elencoSettaggi.get(index).getParametroUno() + 7);
            } else {
                this.comboParameter1.setSelectedIndex(this.elencoSettaggi.get(index).getParametroUno());
            }
            this.comboParameter2.setSelectedIndex(this.elencoSettaggi.get(index).getParametroDue());
            this.comboParameter3.setSelectedIndex(this.elencoSettaggi.get(index).getParametroTre());
            this.comboParameter4.setSelectedIndex(this.elencoSettaggi.get(index).getParametroQuattro());
            this.comboParameter5.setSelectedIndex(this.elencoSettaggi.get(index).getParametroCinque());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.impostaCursore(this.elencoSettaggi.get(index).getSpazio());
    }

    public void aggiungiSettaggio() {
        int spazio = 0;
        int spazioGps = 0;
        int p1 = 0;
        int p2 = 0;
        int p3 = 0;
        int p4 = 0;
        int p5 = 0;
        spazio = Integer.valueOf(this.spazioTF.getText());
        spazioGps = (int)this.calcolaSpazioGps(Double.valueOf(this.spazioTF.getText()));
        for (int i = 0; i < this.elencoSettaggi.size(); ++i) {
            if (this.elencoSettaggi.get(i).getSpazio() != spazio) continue;
            this.rimuoviSettaggio(i);
        }
        p1 = this.comboParameter1.getSelectedIndex();
        p2 = this.comboParameter2.getSelectedIndex();
        p3 = this.comboParameter3.getSelectedIndex();
        p4 = this.comboParameter4.getSelectedIndex();
        p5 = this.comboParameter5.getSelectedIndex();
        if (this.comboMoto.getSelectedIndex() == 1) {
            p1 -= 7;
        }
        SettaggioCurva set = new SettaggioCurva(spazio, spazioGps, p1, p2, p3, p4, p5);
        this.elencoSettaggi.add(set);
        Collections.sort(this.elencoSettaggi);
        this.elencoSettoriLM.clear();
        for (int i = 0; i < this.elencoSettaggi.size(); ++i) {
            this.elencoSettoriLM.addElement(this.getStringaSettaggio(this.elencoSettaggi.get(i)));
        }
    }

    public void rimuoviSettaggio(int index) {
        if (index != -1) {
            this.elencoSettaggi.remove(index);
            Collections.sort(this.elencoSettaggi);
            this.elencoSettoriLM.clear();
            for (int i = 0; i < this.elencoSettaggi.size(); ++i) {
                this.elencoSettoriLM.addElement(this.getStringaSettaggio(this.elencoSettaggi.get(i)));
            }
        }
    }

    public String getStringaSettaggio(SettaggioCurva set) {
        String s = " Spazio:" + this.getStringaSpazio(set.getSpazio()) + "   Spazio Gps:" + this.getStringaSpazio(set.getSpazioGps()) + this.getStringParametro(1, set.getParametroUno()) + this.getStringParametro(2, set.getParametroDue()) + this.getStringParametro(3, set.getParametroTre()) + this.getStringParametro(4, set.getParametroQuattro()) + this.getStringParametro(5, set.getParametroCinque());
        return s;
    }

    public void importa() {
        int res;
        JFileChooser fileChooser = new JFileChooser();
        String s = DanasPreferences.getPrefDirectory("importaFileDds");
        if (s != null) {
            fileChooser.setCurrentDirectory(new File(s));
        }
        if ((res = fileChooser.showOpenDialog(this)) == 0) {
            File f = fileChooser.getSelectedFile();
            try {
                f.setReadable(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                String line;
                BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
                this.elencoSettaggi.removeAllElements();
                while ((line = in.readLine()) != null) {
                    String t;
                    StringTokenizer st;
                    if (line.startsWith("DDS_T,")) {
                        st = new StringTokenizer(line, ",");
                        t = st.nextToken();
                        t = st.nextToken();
                        this.comboMoto.setSelectedIndex(Integer.parseInt(t));
                    }
                    if (line.startsWith("DDS_S,")) {
                        SettaggioCurva set = new SettaggioCurva(line);
                        this.elencoSettaggi.add(set);
                    }
                    if (!line.startsWith("DDS_N,")) continue;
                    st = new StringTokenizer(line, ",");
                    t = st.nextToken();
                    t = st.nextToken();
                    this.nomeTF.setText(t);
                }
                in.close();
                Collections.sort(this.elencoSettaggi);
                this.elencoSettoriLM.clear();
                for (int i = 0; i < this.elencoSettaggi.size(); ++i) {
                    this.elencoSettoriLM.addElement(this.getStringaSettaggio(this.elencoSettaggi.get(i)));
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public String getStringaSpazio(int space) {
        if (space < 10) {
            String s = "    " + space;
            return s;
        }
        if (space < 100) {
            String s = "   " + space;
            return s;
        }
        if (space < 1000) {
            String s = "  " + space;
            return s;
        }
        String s = " " + space;
        return s;
    }

    public String getStringParametro(int parametro, int valore) {
        String s = "";
        switch (this.comboMoto.getSelectedIndex()) {
            case 0: {
                switch (parametro) {
                    case 1: {
                        if (valore == 0) {
                            s = "   Map:F   ";
                        }
                        if (valore == 1) {
                            s = "   Map:M   ";
                        }
                        if (valore == 2) {
                            s = "   Map:L   ";
                        }
                        if (valore == 3) {
                            s = "   Map:Man.";
                        }
                        return s;
                    }
                    case 2: {
                        int value = valore + 1;
                        s = value != 6 ? (value == 7 ? "   S-KTRC:Man." : "   S-KTRC:" + value + "   ") : "   S-KTRC:OFF";
                        return s;
                    }
                    case 3: {
                        if (valore == 0) {
                            s = "   KEBC:OFF";
                        }
                        if (valore == 1) {
                            s = "   KEBC:L";
                        }
                        if (valore == 2) {
                            s = "   KEBC:Man.";
                        }
                        return s;
                    }
                    case 4: {
                        return " ";
                    }
                    case 5: {
                        return " ";
                    }
                }
                break;
            }
            case 1: {
                switch (parametro) {
                    case 1: {
                        return "   TC=" + valore;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        return " ";
                    }
                }
                break;
            }
            case 2: {
                switch (parametro) {
                    case 1: {
                        return "   PWR=" + (valore + 1);
                    }
                    case 2: {
                        return "   TCS=" + (valore + 1);
                    }
                    case 3: {
                        if (valore == 3) {
                            return "   SCS=OFF";
                        }
                        return "   SCS=" + (valore + 1) + "  ";
                    }
                    case 4: {
                        if (valore == 3) {
                            return "   LIF=OFF";
                        }
                        return "   LIF=" + (valore + 1);
                    }
                    case 5: {
                        return " ";
                    }
                }
                break;
            }
            case 3: {
                switch (parametro) {
                    case 1: {
                        return "   PWR=" + (valore + 1);
                    }
                    case 2: {
                        return "   TCS=" + (valore + 1);
                    }
                    case 3: {
                        if (valore == 3) {
                            return "   SCS=OFF";
                        }
                        return "   SCS=" + (valore + 1) + "  ";
                    }
                    case 4: {
                        if (valore == 3) {
                            return "   LIF=OFF";
                        }
                        return "   LIF=" + (valore + 1) + "  ";
                    }
                    case 5: {
                        return "   EBM=" + (valore + 1);
                    }
                }
                break;
            }
            case 4: {
                switch (parametro) {
                    case 1: {
                        return "   P=" + (valore + 1);
                    }
                    case 2: {
                        if (valore == 0) {
                            return "   TC=OFF";
                        }
                        return "   TC=" + valore + "  ";
                    }
                    case 3: {
                        return "   EB=" + (valore + 1);
                    }
                    case 4: {
                        if (valore == 0) {
                            return "   W=OFF";
                        }
                        return "   W=" + valore + "  ";
                    }
                    case 5: {
                        return " ";
                    }
                }
                break;
            }
            case 5: {
                switch (parametro) {
                    case 1: {
                        if (valore == 0) {
                            return "   TC=OFF";
                        }
                        return "   TC=" + valore + "  ";
                    }
                    case 2: {
                        return "   EB=" + (valore + 1);
                    }
                    case 3: {
                        if (valore == 0) {
                            return "   DWC=OFF";
                        }
                        return "   DWC=" + valore + "  ";
                    }
                    case 4: {
                        if (valore == 0) {
                            return "   DSC=OFF";
                        }
                        return "   DSC=" + valore + "  ";
                    }
                    case 5: {
                        return " ";
                    }
                }
            }
        }
        return "";
    }

    public int getValoreParametro(int parametro, int valore) {
        int res = 0;
        switch (this.comboMoto.getSelectedIndex()) {
            case 0: {
                switch (parametro) {
                    case 1: {
                        if (valore == 0) {
                            res = 1;
                        }
                        if (valore == 1) {
                            res = 2;
                        }
                        if (valore == 2) {
                            res = 3;
                        }
                        return res;
                    }
                    case 2: {
                        res = valore + 1;
                        if (res == 6) {
                            res = 0;
                        }
                        return res;
                    }
                    case 3: {
                        return valore;
                    }
                }
                break;
            }
            case 1: {
                return valore;
            }
            case 2: {
                return valore;
            }
            case 3: {
                return valore;
            }
            case 4: {
                return valore;
            }
            case 5: {
                return valore;
            }
        }
        return 0;
    }

    private void setTipoMoto(int tipo) {
        switch (tipo) {
            case 0: {
                this.parametro1Label.setText("    Map:");
                this.parametro2Label.setText("    S-KTRC:");
                this.parametro3Label.setText("    KEBC:");
                this.parametro4Label.setText("    ");
                this.parametro5Label.setText("    ");
                this.parameter1B.setText("Map:");
                this.parameter2B.setText("S-KTRC:");
                this.parameter3B.setText("KEBC:");
                this.parameter4B.setText("");
                this.parameter5B.setText("");
                this.comboParameter1.removeAllItems();
                this.comboParameter2.removeAllItems();
                this.comboParameter3.removeAllItems();
                this.comboParameter4.removeAllItems();
                this.comboParameter5.removeAllItems();
                this.comboParameter1.addItem("F");
                this.comboParameter1.addItem("M");
                this.comboParameter1.addItem("L");
                this.comboParameter1.addItem("Manual");
                this.comboParameter2.addItem("1");
                this.comboParameter2.addItem("2");
                this.comboParameter2.addItem("3");
                this.comboParameter2.addItem("4");
                this.comboParameter2.addItem("5");
                this.comboParameter2.addItem("OFF");
                this.comboParameter2.addItem("Manual");
                this.comboParameter3.addItem("OFF");
                this.comboParameter3.addItem("L");
                this.comboParameter3.addItem("Manual");
                break;
            }
            case 1: {
                this.parametro1Label.setText("    TC:");
                this.parametro2Label.setText("        ");
                this.parametro3Label.setText("        ");
                this.parametro4Label.setText("        ");
                this.parametro5Label.setText("        ");
                this.parameter1B.setText("TC:");
                this.parameter2B.setText(" ");
                this.parameter3B.setText(" ");
                this.parameter4B.setText(" ");
                this.parameter5B.setText(" ");
                this.comboParameter1.removeAllItems();
                this.comboParameter2.removeAllItems();
                this.comboParameter3.removeAllItems();
                this.comboParameter4.removeAllItems();
                this.comboParameter5.removeAllItems();
                this.comboParameter1.addItem("-7");
                this.comboParameter1.addItem("-6");
                this.comboParameter1.addItem("-5");
                this.comboParameter1.addItem("-4");
                this.comboParameter1.addItem("-3");
                this.comboParameter1.addItem("-2");
                this.comboParameter1.addItem("-1");
                this.comboParameter1.addItem("0");
                this.comboParameter1.addItem("1");
                this.comboParameter1.addItem("2");
                this.comboParameter1.addItem("3");
                this.comboParameter1.addItem("4");
                this.comboParameter1.addItem("5");
                this.comboParameter1.addItem("6");
                this.comboParameter1.addItem("7");
                break;
            }
            case 2: {
                this.parametro1Label.setText("    PWR:");
                this.parametro2Label.setText("    TCS:");
                this.parametro3Label.setText("    SCS:");
                this.parametro4Label.setText("    LIF:");
                this.parametro5Label.setText("        ");
                this.parameter1B.setText("PWR:");
                this.parameter2B.setText("TCS:");
                this.parameter3B.setText("SCS:");
                this.parameter4B.setText("LIF");
                this.parameter5B.setText(" ");
                this.comboParameter1.removeAllItems();
                this.comboParameter2.removeAllItems();
                this.comboParameter3.removeAllItems();
                this.comboParameter4.removeAllItems();
                this.comboParameter5.removeAllItems();
                this.comboParameter1.addItem("1");
                this.comboParameter1.addItem("2");
                this.comboParameter1.addItem("3");
                this.comboParameter1.addItem("4");
                this.comboParameter2.addItem("1");
                this.comboParameter2.addItem("2");
                this.comboParameter2.addItem("3");
                this.comboParameter2.addItem("4");
                this.comboParameter2.addItem("5");
                this.comboParameter2.addItem("6");
                this.comboParameter2.addItem("7");
                this.comboParameter2.addItem("8");
                this.comboParameter2.addItem("9");
                this.comboParameter3.addItem("1");
                this.comboParameter3.addItem("2");
                this.comboParameter3.addItem("3");
                this.comboParameter3.addItem("OFF");
                this.comboParameter4.addItem("1");
                this.comboParameter4.addItem("2");
                this.comboParameter4.addItem("3");
                this.comboParameter4.addItem("OFF");
                break;
            }
            case 3: {
                this.parametro1Label.setText("    PWR:");
                this.parametro2Label.setText("    TCS:");
                this.parametro3Label.setText("    SCS:");
                this.parametro4Label.setText("    LIF:");
                this.parametro5Label.setText("    EBM:");
                this.parameter1B.setText("PWR:");
                this.parameter2B.setText("TCS:");
                this.parameter3B.setText("SCS:");
                this.parameter4B.setText("LIF");
                this.parameter5B.setText("EBM");
                this.comboParameter1.removeAllItems();
                this.comboParameter2.removeAllItems();
                this.comboParameter3.removeAllItems();
                this.comboParameter4.removeAllItems();
                this.comboParameter5.removeAllItems();
                this.comboParameter1.addItem("1");
                this.comboParameter1.addItem("2");
                this.comboParameter1.addItem("3");
                this.comboParameter1.addItem("4");
                this.comboParameter2.addItem("1");
                this.comboParameter2.addItem("2");
                this.comboParameter2.addItem("3");
                this.comboParameter2.addItem("4");
                this.comboParameter2.addItem("5");
                this.comboParameter2.addItem("6");
                this.comboParameter2.addItem("7");
                this.comboParameter2.addItem("8");
                this.comboParameter2.addItem("9");
                this.comboParameter3.addItem("1");
                this.comboParameter3.addItem("2");
                this.comboParameter3.addItem("3");
                this.comboParameter3.addItem("OFF");
                this.comboParameter4.addItem("1");
                this.comboParameter4.addItem("2");
                this.comboParameter4.addItem("3");
                this.comboParameter4.addItem("OFF");
                this.comboParameter5.addItem("1");
                this.comboParameter5.addItem("2");
                this.comboParameter5.addItem("3");
                break;
            }
            case 4: {
                this.parametro1Label.setText("    P:");
                this.parametro2Label.setText("    T:");
                this.parametro3Label.setText("    EB:");
                this.parametro4Label.setText("    W:");
                this.parametro5Label.setText(" ");
                this.parameter1B.setText("P:");
                this.parameter2B.setText("T:");
                this.parameter3B.setText("EB:");
                this.parameter4B.setText("W");
                this.parameter5B.setText(" ");
                this.comboParameter1.removeAllItems();
                this.comboParameter2.removeAllItems();
                this.comboParameter3.removeAllItems();
                this.comboParameter4.removeAllItems();
                this.comboParameter5.removeAllItems();
                this.comboParameter1.addItem("1");
                this.comboParameter1.addItem("2");
                this.comboParameter1.addItem("3");
                this.comboParameter1.addItem("4");
                this.comboParameter1.addItem("5");
                this.comboParameter2.addItem("OFF");
                this.comboParameter2.addItem("1");
                this.comboParameter2.addItem("2");
                this.comboParameter2.addItem("3");
                this.comboParameter2.addItem("4");
                this.comboParameter2.addItem("5");
                this.comboParameter2.addItem("6");
                this.comboParameter2.addItem("7");
                this.comboParameter2.addItem("8");
                this.comboParameter2.addItem("9");
                this.comboParameter3.addItem("1");
                this.comboParameter3.addItem("2");
                this.comboParameter3.addItem("3");
                this.comboParameter4.addItem("OFF");
                this.comboParameter4.addItem("1");
                this.comboParameter4.addItem("2");
                this.comboParameter4.addItem("3");
                break;
            }
            case 5: {
                this.parametro1Label.setText("    TC:");
                this.parametro2Label.setText("    EB:");
                this.parametro3Label.setText("    DWC:");
                this.parametro4Label.setText("    DSC:");
                this.parameter1B.setText("TC:");
                this.parameter2B.setText("EB:");
                this.parameter3B.setText("DWC:");
                this.parameter4B.setText("DSC:");
                this.parameter5B.setText(" ");
                this.comboParameter1.removeAllItems();
                this.comboParameter2.removeAllItems();
                this.comboParameter3.removeAllItems();
                this.comboParameter4.removeAllItems();
                this.comboParameter5.removeAllItems();
                this.comboParameter1.addItem("OFF");
                this.comboParameter1.addItem("1");
                this.comboParameter1.addItem("2");
                this.comboParameter1.addItem("3");
                this.comboParameter1.addItem("4");
                this.comboParameter1.addItem("5");
                this.comboParameter1.addItem("6");
                this.comboParameter1.addItem("7");
                this.comboParameter1.addItem("8");
                this.comboParameter2.addItem("1");
                this.comboParameter2.addItem("2");
                this.comboParameter2.addItem("3");
                this.comboParameter3.addItem("OFF");
                this.comboParameter3.addItem("1");
                this.comboParameter3.addItem("2");
                this.comboParameter3.addItem("3");
                this.comboParameter3.addItem("4");
                this.comboParameter3.addItem("5");
                this.comboParameter3.addItem("6");
                this.comboParameter3.addItem("7");
                this.comboParameter3.addItem("8");
                this.comboParameter4.addItem("OFF");
                this.comboParameter4.addItem("1");
                this.comboParameter4.addItem("2");
            }
        }
    }

    private double calcolaSpazioGps(double distanzaVel1) {
        if (DanasDataStructure.getInstance().getDefaultLap() == null) {
            return 0.0;
        }
        DanasLap l = DanasDataStructure.getInstance().getDefaultLap();
        DanasSession session = l.getSession();
        if (session.getFrequenzaCanale(DanasDataStructureConstants.ValueType.SPEED1) == 0.0) {
            return 0.0;
        }
        int indiceInizioSpeed = session.getIndiceAtTime(DanasDataStructureConstants.ValueType.SPEED1, l.getStart(), DanasDataStructureConstants.BoundLap.NEXT);
        int indiceFineSpeed = session.getIndiceAtTime(DanasDataStructureConstants.ValueType.SPEED1, l.getEnd(), DanasDataStructureConstants.BoundLap.PREVIOUS);
        int dimensione = indiceFineSpeed - indiceInizioSpeed + 1;
        if (dimensione <= 1) {
            return 0.0;
        }
        double distanza = 0.0;
        double deltaT = 100.0 / session.getFrequenzaCanale(DanasDataStructureConstants.ValueType.SPEED1);
        for (int i = 0; i < dimensione; ++i) {
            double tempoSpeed = session.getTempoIniziale(DanasDataStructureConstants.ValueType.SPEED1) + (double)((i + indiceInizioSpeed) * 100) / session.getFrequenzaCanale(DanasDataStructureConstants.ValueType.SPEED1);
            double vel = session.getDatoAtTime(DanasDataStructureConstants.ValueType.SPEED1, tempoSpeed, DanasDataStructureConstants.BoundLap.NEAREST, true) / 3.6;
            double spazio = deltaT * vel / 100.0;
            if (!((distanza += spazio) >= distanzaVel1)) continue;
            return l.getSpazioAtTime(tempoSpeed, DanasDataStructureConstants.BoundLap.PREVIOUS);
        }
        return l.getSpazioAtTime(l.getEnd(), DanasDataStructureConstants.BoundLap.PREVIOUS);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.addB)) {
            this.aggiungiSettaggio();
            this.aggiornaDdsMappa();
        }
        if (e.getSource().equals(this.comboMoto)) {
            if (this.comboMoto.getSelectedIndex() == -1) {
                return;
            }
            this.setTipoMoto(this.comboMoto.getSelectedIndex());
            if (this.elencoSettaggi != null) {
                this.elencoSettaggi.clear();
            }
            if (this.elencoSettoriLM != null) {
                this.elencoSettoriLM.clear();
            }
            this.setMostraAttuale(-1);
            this.aggiornaPulsanti();
        }
        if (e.getSource().equals(this.rimuoviB)) {
            this.rimuoviSettaggio(this.list.getSelectedIndex());
            this.aggiornaDdsMappa();
        }
        if (e.getSource().equals(this.esciB)) {
            this.setMostraAttuale(-1);
            this.aggiornaDdsMappa();
            this.dispose();
        }
        if (e.getSource().equals(this.esportaB)) {
            this.esporta();
        }
        if (e.getSource().equals(this.importaB)) {
            this.importa();
        }
        if (e.getSource().equals(this.parameter1B)) {
            this.setMostraAttuale(0);
            this.aggiornaDdsMappa();
        }
        if (e.getSource().equals(this.parameter2B)) {
            this.setMostraAttuale(1);
            this.aggiornaDdsMappa();
        }
        if (e.getSource().equals(this.parameter3B)) {
            this.setMostraAttuale(2);
            this.aggiornaDdsMappa();
        }
        if (e.getSource().equals(this.parameter4B)) {
            this.setMostraAttuale(3);
            this.aggiornaDdsMappa();
        }
        if (e.getSource().equals(this.parameter5B)) {
            this.setMostraAttuale(4);
            this.aggiornaDdsMappa();
        }
    }

    public static void main(String[] args) {
        CurvaCurvaDialog t = new CurvaCurvaDialog(null);
        t.setVisible(true);
    }

    @Override
    public void stateChanged(ChangeEvent arg0) {
        if (arg0.getSource().equals(this.multiSincro)) {
            if (!this.multiSincro.getAggionrnaMappaGrafico()) {
                return;
            }
            this.spazioTF.setText("" + (int)this.calcolaSpazioVel1(this.multiSincro.getPosizioneCursore()));
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent arg0) {
        if (this.list.getSelectedIndex() != -1) {
            this.modificaSettaggio(this.list.getSelectedIndex());
            this.aggiornaDdsMappa();
        }
    }

    public static enum KindOfBike {
        ZX10R_2016;

    }
}

