/*
 * Decompiled with CFR 0.152.
 */
package i2m.Dialog;

import i2m.DataStructure.danasDataStructure.DanasDataStructure;
import i2m.DataStructure.danasUtils.MeasuresUtil;
import i2m.Language;
import i2m.MainFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class AssiDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    JButton openB;
    JButton esciB;
    JTextField nomeTF;
    private JFormattedTextField minimo;
    private JFormattedTextField massimo;
    private JTextField minimoT;
    private JTextField massimoT;
    private int indice;
    private boolean asseY;

    public AssiDialog(MainFrame owner, boolean asseY) {
        super(owner, Language.string("Valori asse"), true);
        NumberFormat TFormat = NumberFormat.getNumberInstance(Locale.US);
        TFormat.setMaximumIntegerDigits(10);
        TFormat.setMaximumFractionDigits(2);
        TFormat.setGroupingUsed(false);
        this.asseY = asseY;
        JPanel pannelloPrincipale = new JPanel(new BorderLayout());
        this.setContentPane(pannelloPrincipale);
        this.openB = new JButton(Language.string("Applica"));
        this.openB.addActionListener(this);
        this.esciB = new JButton(Language.string("Esci"));
        this.esciB.addActionListener(this);
        JPanel pannelloBottoni = new JPanel();
        pannelloBottoni.add(this.openB);
        pannelloBottoni.add(this.esciB);
        pannelloBottoni.setBorder(BorderFactory.createEtchedBorder(0));
        pannelloPrincipale.add((Component)pannelloBottoni, "South");
        this.minimo = new JFormattedTextField(TFormat);
        this.minimo.setValue(0);
        this.minimo.setHorizontalAlignment(11);
        this.minimo.setAlignmentX(0.0f);
        this.minimo.setMinimumSize(new Dimension(80, 10));
        this.massimo = new JFormattedTextField(TFormat);
        this.massimo.setValue(0);
        this.massimo.setHorizontalAlignment(11);
        this.massimo.setAlignmentX(0.0f);
        this.massimo.setMinimumSize(new Dimension(80, 10));
        this.minimoT = new JTextField();
        this.minimoT.setHorizontalAlignment(11);
        this.minimoT.setAlignmentX(0.0f);
        this.minimoT.setMinimumSize(new Dimension(80, 10));
        this.massimoT = new JTextField();
        this.massimoT.setHorizontalAlignment(11);
        this.massimoT.setAlignmentX(0.0f);
        this.massimoT.setMinimumSize(new Dimension(80, 10));
        if (!asseY) {
            this.minimoT.setText(DanasDataStructure.getInstance().getMainFrame().getContenitoreGrafico().getMinimoAsseX());
            this.massimoT.setText(DanasDataStructure.getInstance().getMainFrame().getContenitoreGrafico().getMassimoAsseX());
        }
        JLabel minLabel = new JLabel(Language.string("  Min:  "));
        JLabel maxLabel = new JLabel(Language.string("  Max:  "));
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(minLabel);
        if (asseY) {
            panel.add(this.minimo);
        } else {
            panel.add(this.minimoT);
        }
        panel.add(maxLabel);
        if (asseY) {
            panel.add(this.massimo);
        } else {
            panel.add(this.massimoT);
        }
        pannelloPrincipale.add((Component)panel, "Center");
        this.pack();
        this.setResizable(false);
        this.setSize(new Dimension(300, 100));
    }

    public void setIndice(int index) {
        this.indice = index;
    }

    public double getMin() {
        return Double.valueOf(this.minimo.getValue().toString());
    }

    public double getMax() {
        return Double.valueOf(this.massimo.getValue().toString());
    }

    public void setMin(float min) {
        this.minimo.setValue(Float.valueOf(min));
    }

    public void setMax(float max) {
        this.massimo.setValue(Float.valueOf(max));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JButton source = (JButton)e.getSource();
        if (source.equals(this.esciB)) {
            this.dispose();
        }
        if (source.equals(this.openB)) {
            if (this.asseY) {
                DanasDataStructure.getInstance().getMainFrame().getContenitoreGrafico().cambiaValoriAsse(this.getMin(), this.getMax(), this.indice);
            } else if (DanasDataStructure.getInstance().getMainFrame().getContenitoreGrafico().getModoSpazio()) {
                double min = Double.valueOf(this.minimoT.getText());
                double max = Double.valueOf(this.massimoT.getText());
                DanasDataStructure.getInstance().getMainFrame().getContenitoreGrafico().setAsseX(min, max);
            } else {
                try {
                    double min = MeasuresUtil.parseHumanTime(this.minimoT.getText()) / 10L;
                    double max = MeasuresUtil.parseHumanTime(this.massimoT.getText()) / 10L;
                    DanasDataStructure.getInstance().getMainFrame().getContenitoreGrafico().setAsseX(min, max);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
            this.dispose();
        }
    }

    public static void main(String[] args) {
        AssiDialog test = new AssiDialog(null, true);
        test.setVisible(true);
    }
}

