/*
 * Decompiled with CFR 0.152.
 */
package i2m.DataStructure.sessionViewer;

import i2m.DataStructure.danasDataStructure.DanasDataStructure;
import i2m.DataStructure.danasDataStructure.DanasDataStructureConstants;
import i2m.DataStructure.danasDataStructure.DanasLap;
import i2m.DataStructure.danasDataStructure.DanasSession;
import i2m.DataStructure.danasUtils.MeasuresUtil;
import i2m.DataStructure.sessionViewer.MyDefaultCellRenderer;
import i2m.DataStructure.sessionViewer.MyTableModel;
import i2m.Language;
import i2m.grafico.ContenitoreGrafico;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SessionViewerGiri
extends JPanel
implements ChangeListener {
    private static final long serialVersionUID = 1L;
    private static DanasDataStructure ds;
    private static JScrollPane viewerScrollPaneMinimo;
    private static JScrollPane viewerScrollPaneMassimo;
    private static JScrollPane viewerScrollPaneAvg;
    private static JTable tableMinimo;
    private static JTable tableMassimo;
    private static JTable tableAvg;
    private static MyTableModel modelloMinimo;
    private static MyTableModel modelloMassimo;
    private static MyTableModel modelloAvg;
    static int NUM_CURVE;
    static boolean[] canaliGiri;
    static int canaliAttivi;

    public SessionViewerGiri() {
        modelloMinimo = new MyTableModel();
        modelloMassimo = new MyTableModel();
        modelloAvg = new MyTableModel();
        tableMinimo = new JTable(modelloMinimo);
        tableMinimo.getTableHeader().setReorderingAllowed(false);
        tableMinimo.setDefaultRenderer(Object.class, new MyDefaultCellRenderer(true));
        tableMinimo.setFillsViewportHeight(true);
        tableMassimo = new JTable(modelloMassimo);
        tableMassimo.getTableHeader().setReorderingAllowed(false);
        tableMassimo.setDefaultRenderer(Object.class, new MyDefaultCellRenderer(true));
        tableMassimo.setFillsViewportHeight(true);
        tableAvg = new JTable(modelloAvg);
        tableAvg.getTableHeader().setReorderingAllowed(false);
        tableAvg.setDefaultRenderer(Object.class, new MyDefaultCellRenderer(true));
        tableAvg.setFillsViewportHeight(true);
        DanasDataStructure.getInstance().addChangeListener(this);
        this.setLayout(new GridLayout(3, 1));
        JPanel pannelloMinimo = new JPanel();
        JPanel pannelloMassimo = new JPanel();
        JPanel pannelloAvg = new JPanel();
        viewerScrollPaneMinimo = new JScrollPane(tableMinimo);
        viewerScrollPaneMassimo = new JScrollPane(tableMassimo);
        viewerScrollPaneAvg = new JScrollPane(tableAvg);
        Font font = new Font("sansserif", 1, 24);
        JLabel labelMinimo = new JLabel(Language.string("Valori minimi"));
        labelMinimo.setFont(font);
        JLabel labelMassimo = new JLabel(Language.string("Valori Massimi"));
        labelMassimo.setFont(font);
        JLabel labelAvg = new JLabel(Language.string("Valori medi"));
        labelAvg.setFont(font);
        pannelloMinimo.setLayout(new BorderLayout());
        pannelloMinimo.add((Component)labelMinimo, "First");
        pannelloMinimo.add((Component)viewerScrollPaneMinimo, "Center");
        pannelloMassimo.setLayout(new BorderLayout());
        pannelloMassimo.add((Component)labelMassimo, "First");
        pannelloMassimo.add((Component)viewerScrollPaneMassimo, "Center");
        pannelloAvg.setLayout(new BorderLayout());
        pannelloAvg.add((Component)labelAvg, "First");
        pannelloAvg.add((Component)viewerScrollPaneAvg, "Center");
        this.add(pannelloMinimo);
        this.add(pannelloMassimo);
        this.add(pannelloAvg);
    }

    public static void updateView() {
        System.out.println("SessionViewerGiri: chiamo update");
        for (int i = 0; i < NUM_CURVE && canaliGiri[i] == DanasDataStructure.getInstance().getMainFrame().getContenitoreGrafico().isChannelOnInfo(i); ++i) {
        }
        SessionViewerGiri.refreshAll();
    }

    public static void refreshAll() {
        int i;
        if (modelloMinimo == null) {
            return;
        }
        if (modelloMassimo == null) {
            return;
        }
        if (modelloAvg == null) {
            return;
        }
        modelloMinimo.svuotaTabella();
        modelloMassimo.svuotaTabella();
        modelloAvg.svuotaTabella();
        if (ds.getDefaultSession() == null) {
            return;
        }
        System.out.println("Aggiorno sessionViewer giri");
        ContenitoreGrafico grafico = DanasDataStructure.getInstance().getMainFrame().getContenitoreGrafico();
        for (i = 0; i < NUM_CURVE; ++i) {
            SessionViewerGiri.canaliGiri[i] = DanasDataStructure.getInstance().getMainFrame().getContenitoreGrafico().isChannelOnInfo(i);
            if (MeasuresUtil.getValueType(i) != DanasDataStructureConstants.ValueType.SIM1 && MeasuresUtil.getValueType(i) != DanasDataStructureConstants.ValueType.SIM2) continue;
            SessionViewerGiri.canaliGiri[i] = false;
        }
        canaliAttivi = 0;
        modelloMinimo.addColunmName("Laps");
        modelloMassimo.addColunmName("Laps");
        modelloAvg.addColunmName("Laps");
        for (i = 0; i < NUM_CURVE; ++i) {
            if (!canaliGiri[i]) continue;
            ++canaliAttivi;
            modelloMinimo.addColunmName(grafico.getNomeAsse(i));
            modelloMassimo.addColunmName(grafico.getNomeAsse(i));
            modelloAvg.addColunmName(grafico.getNomeAsse(i));
        }
        String[] valoriMin = new String[canaliAttivi + 1];
        String[] valoriMax = new String[canaliAttivi + 1];
        String[] valoriAvg = new String[canaliAttivi + 1];
        int colonna = 0;
        for (DanasSession s : ds.getSessions()) {
            for (DanasLap dl : s.getLaps()) {
                valoriMin = new String[canaliAttivi + 1];
                valoriMax = new String[canaliAttivi + 1];
                valoriAvg = new String[canaliAttivi + 1];
                valoriMin[0] = s.getSessionName() + "-" + dl.getLapID() + " ( " + MeasuresUtil.timeToHumanReadable((int)dl.getDuration()) + " )";
                valoriMax[0] = s.getSessionName() + "-" + dl.getLapID() + " ( " + MeasuresUtil.timeToHumanReadable((int)dl.getDuration()) + " )";
                valoriAvg[0] = s.getSessionName() + "-" + dl.getLapID() + " ( " + MeasuresUtil.timeToHumanReadable((int)dl.getDuration()) + " )";
                colonna = 1;
                for (int i2 = 0; i2 < NUM_CURVE; ++i2) {
                    if (!canaliGiri[i2]) continue;
                    valoriMin[colonna] = MeasuresUtil.getValorePulito(MeasuresUtil.getValueType(i2), dl.getMinGenericData(MeasuresUtil.getValueType(i2)));
                    valoriMax[colonna] = MeasuresUtil.getValorePulito(MeasuresUtil.getValueType(i2), dl.getMaxGenericData(MeasuresUtil.getValueType(i2)));
                    valoriAvg[colonna] = MeasuresUtil.valueToHumanReadable(dl.getAvgGenericData(MeasuresUtil.getValueType(i2)), 2);
                    ++colonna;
                }
                modelloMinimo.addRow(valoriMin);
                modelloMassimo.addRow(valoriMax);
                modelloAvg.addRow(valoriAvg);
            }
        }
        modelloMinimo.calcolaEstremi();
        modelloMassimo.calcolaEstremi();
        modelloAvg.calcolaEstremi();
    }

    public void setDataStructure(DanasDataStructure dds) {
        ds = dds;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        DanasDataStructureConstants.ChangeType ct = DanasDataStructureConstants.ChangeType.valueOf(ds.getChange().name());
        switch (ct) {
            case SEL_SESSION: {
                break;
            }
            case DESEL_SESSION: {
                break;
            }
            case SEL_LAP: {
                break;
            }
            case DESEL_LAP: {
                break;
            }
            case SEL_ALL_SESSION: {
                break;
            }
            case DESEL_ALL_SESSION: {
                break;
            }
            case SEL_ALL_LAP: {
                break;
            }
            case DESEL_ALL_LAP: {
                break;
            }
            case SESSION_COLOR: {
                break;
            }
            case LAP_COLOR: {
                break;
            }
            case REFRESH_ALL: {
                break;
            }
            case NEW_SETTINGS: {
                break;
            }
            case NEW_DATA: {
                break;
            }
            case REMOVE_DATA: {
                SessionViewerGiri.refreshAll();
                break;
            }
            case NOTES: {
                break;
            }
            default: {
                System.err.println("SessionViewer: Unknown ChangeType");
            }
        }
    }

    static {
        NUM_CURVE = DanasDataStructure.getInstance().getMainFrame().getContenitoreGrafico().getNumCurve();
        canaliGiri = new boolean[DanasDataStructure.getInstance().getMainFrame().getContenitoreGrafico().getNumCurve()];
        canaliAttivi = 0;
    }
}

