/*
 * Decompiled with CFR 0.152.
 */
package i2m.DataStructure.danasUtils;

import i2m.DanasPreferences;
import i2m.DataStructure.danasDataStructure.DanasDataStructure;
import i2m.DataStructure.danasDataStructure.DanasDataStructureConstants;
import i2m.DataStructure.danasDataStructure.DanasSession;
import i2m.DataStructure.danasDataStructure.DanasValueData;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.StringTokenizer;

public class MeasuresUtil {
    private static int NUM_CURVE = 194;

    public static int getNumeroCurve() {
        return NUM_CURVE;
    }

    public static boolean copy(File in, File out) {
        try {
            int bytesRead;
            FileInputStream input = new FileInputStream(in);
            FileOutputStream output = new FileOutputStream(out);
            byte[] buf = new byte[1024];
            while ((bytesRead = input.read(buf)) > 0) {
                output.write(buf, 0, bytesRead);
            }
            input.close();
            output.close();
            return true;
        }
        catch (FileNotFoundException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static long parseHumanTime(String str) throws Exception {
        boolean negative = false;
        if ((str = str.trim()).startsWith("-")) {
            negative = true;
            str = str.substring(1);
        }
        long time = 0L;
        int p = str.indexOf(".") + 1;
        if (p > 0) {
            String ms_str = str.substring(p);
            int m = 100;
            for (int i = 0; i < ms_str.length(); ++i) {
                int c = Integer.parseInt(ms_str.charAt(i) + "");
                time += (long)(m * c);
                m /= 10;
            }
            str = str.substring(0, p - 1);
        }
        int hc = 0;
        int[] tks = new int[3];
        StringTokenizer st = new StringTokenizer(str, ":");
        while (st.hasMoreTokens()) {
            tks[hc++] = Integer.parseInt(st.nextToken());
        }
        if (hc == 1) {
            time += (long)(tks[0] * 1000);
        } else if (hc == 2) {
            time += (long)(tks[1] * 1000);
            time += (long)(tks[0] * 60000);
        } else if (hc == 3) {
            time += (long)(tks[2] * 1000);
            time += (long)(tks[1] * 60000);
            time += (long)(tks[0] * 60 * 60000);
        }
        if (negative) {
            return -time;
        }
        return time;
    }

    public static double[] estraiParametriFrizione(String line) {
        double[] parametri = new double[11];
        try {
            if (line.length() > 9) {
                line = line.substring(9);
            }
            for (int i = 0; i < 11; ++i) {
                parametri[i] = i + 1;
            }
            StringTokenizer st = new StringTokenizer(line, ",");
            String t = st.nextToken();
            for (int i = 0; i < 10; ++i) {
                parametri[i] = Double.valueOf(t);
                t = st.nextToken();
            }
            parametri[10] = 0.0;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return parametri;
    }

    public static byte[] float2Bytes(float value) {
        int bits = Float.floatToIntBits(value);
        byte[] bytes = new byte[]{(byte)(bits & 0xFF), (byte)(bits >> 8 & 0xFF), (byte)(bits >> 16 & 0xFF), (byte)(bits >> 24 & 0xFF)};
        return bytes;
    }

    public static float fromByteArray(byte[] bytes) {
        return ByteBuffer.wrap(bytes).getFloat();
    }

    public static int[] estraiParametriTaglioBrake(String line, boolean brake) {
        int[] parametri = new int[3];
        try {
            if (!brake) {
                if (line.length() > 7) {
                    line = line.substring(7);
                }
            } else if (line.length() > 13) {
                line = line.substring(13);
            }
            parametri[0] = 0;
            parametri[1] = 0;
            parametri[2] = 0;
            StringTokenizer st = new StringTokenizer(line, ",");
            for (int i = 0; i < 2; ++i) {
                String t = st.nextToken();
                if (t.equals("An1")) {
                    parametri[i] = 1;
                }
                if (t.equals("An2")) {
                    parametri[i] = 2;
                }
                if (t.equals("An3")) {
                    parametri[i] = 3;
                }
                if (t.equals("An4")) {
                    parametri[i] = 4;
                }
                if (t.equals("An5")) {
                    parametri[i] = 5;
                }
                if (t.equals("An6")) {
                    parametri[i] = 6;
                }
                if (t.equals("An7")) {
                    parametri[i] = 7;
                }
                if (t.equals("An8")) {
                    parametri[i] = 8;
                }
                if (t.equals("mu1")) {
                    parametri[i] = 9;
                }
                if (t.equals("mu2")) {
                    parametri[i] = 10;
                }
                if (t.equals("mu3")) {
                    parametri[i] = 11;
                }
                if (t.equals("mu4")) {
                    parametri[i] = 12;
                }
                if (t.equals("mu5")) {
                    parametri[i] = 13;
                }
                if (t.equals("mu6")) {
                    parametri[i] = 14;
                }
                if (t.equals("mu7")) {
                    parametri[i] = 15;
                }
                if (t.equals("mu8")) {
                    parametri[i] = 16;
                }
                if (t.equals("mu9")) {
                    parametri[i] = 17;
                }
                if (t.equals("mu10")) {
                    parametri[i] = 18;
                }
                if (t.equals("Ext1")) {
                    parametri[i] = 19;
                }
                if (t.equals("Ext2")) {
                    parametri[i] = 20;
                }
                if (t.equals("Ext3")) {
                    parametri[i] = 21;
                }
                if (t.equals("Ext4")) {
                    parametri[i] = 22;
                }
                if (!t.startsWith("can")) continue;
                String numero = t.substring(3, 6);
                parametri[i] = 22 + Integer.valueOf(numero);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (parametri[0] == 0 || parametri[1] == 0) {
            parametri[2] = 1;
        }
        return parametri;
    }

    public static int getKeyStroke(String s) {
        if (s.equals("a")) {
            return 65;
        }
        if (s.equals("b")) {
            return 66;
        }
        if (s.equals("c")) {
            return 67;
        }
        if (s.equals("d")) {
            return 68;
        }
        if (s.equals("e")) {
            return 69;
        }
        if (s.equals("f")) {
            return 70;
        }
        if (s.equals("g")) {
            return 71;
        }
        if (s.equals("h")) {
            return 72;
        }
        if (s.equals("i")) {
            return 73;
        }
        if (s.equals("l")) {
            return 76;
        }
        if (s.equals("m")) {
            return 77;
        }
        if (s.equals("n")) {
            return 78;
        }
        if (s.equals("o")) {
            return 79;
        }
        if (s.equals("p")) {
            return 80;
        }
        if (s.equals("q")) {
            return 81;
        }
        if (s.equals("r")) {
            return 82;
        }
        if (s.equals("s")) {
            return 83;
        }
        if (s.equals("t")) {
            return 84;
        }
        if (s.equals("u")) {
            return 85;
        }
        if (s.equals("v")) {
            return 86;
        }
        if (s.equals("z")) {
            return 90;
        }
        if (s.equals("y")) {
            return 89;
        }
        if (s.equals("x")) {
            return 88;
        }
        if (s.equals("w")) {
            return 87;
        }
        if (s.equals("j")) {
            return 74;
        }
        if (s.equals("k")) {
            return 75;
        }
        if (s.equals("1")) {
            return 49;
        }
        if (s.equals("2")) {
            return 50;
        }
        if (s.equals("3")) {
            return 51;
        }
        if (s.equals("4")) {
            return 52;
        }
        if (s.equals("5")) {
            return 53;
        }
        if (s.equals("6")) {
            return 54;
        }
        if (s.equals("7")) {
            return 55;
        }
        if (s.equals("8")) {
            return 56;
        }
        if (s.equals("9")) {
            return 57;
        }
        if (s.equals("0")) {
            return 48;
        }
        if (s.equals("+")) {
            return 521;
        }
        if (s.equals("-")) {
            return 45;
        }
        if (s.equals("F1")) {
            return 112;
        }
        if (s.equals("F2")) {
            return 113;
        }
        if (s.equals("F3")) {
            return 114;
        }
        if (s.equals("F4")) {
            return 115;
        }
        if (s.equals("F5")) {
            return 116;
        }
        if (s.equals("F6")) {
            return 117;
        }
        if (s.equals("F7")) {
            return 118;
        }
        if (s.equals("F8")) {
            return 119;
        }
        if (s.equals("F9")) {
            return 120;
        }
        if (s.equals("F10")) {
            return 121;
        }
        if (s.equals("F11")) {
            return 122;
        }
        if (s.equals("F12")) {
            return 123;
        }
        if (s.equals("F13")) {
            return 61440;
        }
        if (s.equals("F14")) {
            return 61441;
        }
        if (s.equals("F15")) {
            return 61442;
        }
        if (s.equals("F16")) {
            return 61443;
        }
        if (s.equals("F17")) {
            return 61444;
        }
        if (s.equals("F18")) {
            return 61445;
        }
        if (s.equals("F19")) {
            return 61446;
        }
        if (s.equals("F20")) {
            return 61447;
        }
        if (s.equals(",")) {
            return 44;
        }
        if (s.equals(".")) {
            return 46;
        }
        if (s.equals("Space")) {
            return 32;
        }
        if (s.equals("Enter")) {
            return 10;
        }
        if (s.equals("Right")) {
            return 39;
        }
        if (s.equals("Left")) {
            return 37;
        }
        if (s.equals("Up")) {
            return 38;
        }
        if (s.equals("Down")) {
            return 40;
        }
        return 0;
    }

    public static String timeToHumanHours(long millis) {
        boolean neg = false;
        if (millis < 0L) {
            neg = true;
            millis = -millis;
        }
        long longtime = millis;
        long seconds = longtime / 1000L;
        long minutes = seconds / 60L;
        long hours = minutes / 60L;
        seconds -= minutes * 60L;
        String secs_str = "" + seconds;
        String mins_str = "" + (minutes -= hours * 60L);
        String hours_str = "" + hours;
        while (secs_str.length() < 2) {
            secs_str = "0" + secs_str;
        }
        while (mins_str.length() < 2) {
            mins_str = "0" + mins_str;
        }
        while (hours_str.length() < 2) {
            hours_str = "0" + hours_str;
        }
        if (neg) {
            return new String("-" + hours_str + ":" + mins_str + ":" + secs_str);
        }
        return new String(hours_str + ":" + mins_str + ":" + secs_str);
    }

    public static String getValorePulito(DanasDataStructureConstants.ValueType vt, Double valore) {
        int modo = DanasDataStructure.getInstance().getMainFrame().getModoAttuale();
        int decimali = DanasPreferences.getDecimali(vt, modo);
        switch (decimali) {
            case 0: {
                return String.format("%.0f", valore);
            }
            case 1: {
                return String.format("%.1f", valore);
            }
            case 2: {
                return String.format("%.2f", valore);
            }
            case 3: {
                return String.format("%.3f", valore);
            }
        }
        return String.format("%.2f", valore);
    }

    public static String timeToHumanReadable(long millis) {
        boolean neg = false;
        if (millis < 0L) {
            neg = true;
            millis = -millis;
        }
        long longtime = millis;
        long seconds = longtime / 1000L;
        long milliseconds = longtime - seconds * 1000L;
        long minutes = seconds / 60L;
        long hours = minutes / 60L;
        seconds -= minutes * 60L;
        String millis_str = "" + (double)milliseconds / 1000.0;
        String secs_str = "" + seconds;
        String mins_str = "" + (minutes -= hours * 60L);
        millis_str = millis_str.substring(2, Math.min(millis_str.length(), 5));
        while (millis_str.length() < 3) {
            millis_str = millis_str + "0";
        }
        while (secs_str.length() < 2) {
            secs_str = "0" + secs_str;
        }
        while (mins_str.length() < 2 && hours > 0L) {
            mins_str = "0" + mins_str;
        }
        if (hours > 0L) {
            if (neg) {
                return new String("-" + hours + ":" + mins_str + ":" + secs_str + "." + millis_str);
            }
            return new String(hours + ":" + mins_str + ":" + secs_str + "." + millis_str);
        }
        if (neg) {
            return new String("-" + mins_str + ":" + secs_str + "." + millis_str);
        }
        return new String(mins_str + ":" + secs_str + "." + millis_str);
    }

    public static String timeToHumanReadableCompact(long millis) {
        boolean neg = false;
        if (millis < 0L) {
            neg = true;
            millis = -millis;
        }
        long longtime = millis;
        long seconds = longtime / 1000L;
        long milliseconds = longtime - seconds * 1000L;
        long minutes = seconds / 60L;
        long hours = minutes / 60L;
        seconds -= minutes * 60L;
        String millis_str = "" + (double)milliseconds / 1000.0;
        String secs_str = "" + seconds;
        String mins_str = "" + (minutes -= hours * 60L);
        millis_str = millis_str.substring(2, Math.min(millis_str.length(), 4));
        while (millis_str.length() < 2) {
            millis_str = millis_str + "0";
        }
        while (secs_str.length() < 2) {
            secs_str = "0" + secs_str;
        }
        while (mins_str.length() < 2 && hours > 0L) {
            mins_str = "0" + mins_str;
        }
        if (hours > 0L) {
            if (neg) {
                return new String("-" + hours + ":" + mins_str + ":" + secs_str + "." + millis_str);
            }
            return new String(hours + ":" + mins_str + ":" + secs_str + "." + millis_str);
        }
        if (neg) {
            return new String("-" + mins_str + ":" + secs_str + "." + millis_str);
        }
        return new String(mins_str + ":" + secs_str + "." + millis_str);
    }

    public static double getTemperatura(double celsiusValue) {
        if (DanasDataStructure.getInstance().isTemperaturaCelsius()) {
            return celsiusValue;
        }
        return celsiusValue * 1.8 + 32.0;
    }

    public static double getPressione(double barValue) {
        if (DanasDataStructure.getInstance().isPressioneBar()) {
            return barValue;
        }
        return barValue * 14.5038;
    }

    public static double getVelocita(double kmhValue) {
        if (DanasDataStructure.getInstance().isVelocitakmh()) {
            return kmhValue;
        }
        return kmhValue * 0.621371;
    }

    public static double getRapportoPulito(double rapporto) {
        if (DanasDataStructure.getInstance().isVelocitakmh()) {
            return rapporto;
        }
        return rapporto * 0.621371;
    }

    public static double degreesToMeters(double degrees) {
        double mtrs = 2.0037508342789244E7 * degrees / 180.0;
        return mtrs;
    }

    public static double metersToDegrees(double meters) {
        double degs = 180.0 * meters / 6378137.0 * Math.PI;
        return degs;
    }

    public static double getValoreTpms(double val, int indice) {
        switch (indice) {
            case 0: 
            case 2: {
                return MeasuresUtil.getPressione((1.376 * val + 98.624) / 100.0 - 1.0);
            }
            case 1: 
            case 3: {
                return MeasuresUtil.getTemperatura(val - 55.0);
            }
        }
        return 0.0;
    }

    public static String valueToHumanReadable(double value, int decimals) {
        if (decimals == 0) {
            return "" + Math.round(value);
        }
        int fact = (int)Math.pow(10.0, decimals);
        long rounded = Math.round(value * (double)fact);
        return "" + (double)rounded / (double)fact;
    }

    public static double valueToHumanReadableDouble(double value, int decimals) {
        if (decimals == 0) {
            return Math.round(value);
        }
        int fact = (int)Math.pow(10.0, decimals);
        long rounded = Math.round(value * (double)fact);
        return (double)rounded / (double)fact;
    }

    public static String valueToLatitude(double value) {
        double valore = Math.abs(value);
        int parziale = (int)(valore / 10000.0);
        int gradi = parziale / 60;
        int secondi = parziale - gradi * 60;
        int millesimi = (int)valore - parziale * 10000;
        String verso = "N";
        if (value < 0.0) {
            verso = "S";
        }
        String str = String.format("%02d%02d.%04d,%s,", gradi, secondi, millesimi, verso);
        return str;
    }

    public static String valueToLongitudine(double value) {
        double valore = Math.abs(value);
        int parziale = (int)(valore / 10000.0);
        int gradi = parziale / 60;
        int secondi = parziale - gradi * 60;
        int millesimi = (int)valore - parziale * 10000;
        String verso = "E";
        if (value < 0.0) {
            verso = "W";
        }
        String str = String.format("%03d%02d.%04d,%s,", gradi, secondi, millesimi, verso);
        return str;
    }

    public static String timeToGpsTime(double centesimi) {
        long longtime = (long)centesimi * 10L;
        long seconds = longtime / 1000L;
        long milliseconds = longtime - seconds * 1000L;
        long minutes = seconds / 60L;
        long hours = minutes / 60L;
        seconds -= minutes * 60L;
        return String.format("%02d%02d%02d.%03d,", hours, minutes -= hours * 60L, seconds, milliseconds);
    }

    public static String getFraseGps(double lat, double lon, double speed, double gpsTime, double altitudine, double tempo) {
        String frase = String.format("$GPS,%7d,A,", (int)tempo);
        frase = frase + MeasuresUtil.valueToLatitude(lat) + MeasuresUtil.valueToLongitudine(lon) + String.format("%.02f,", speed) + MeasuresUtil.timeToGpsTime(gpsTime) + String.format("%.02f,", altitudine);
        return frase;
    }

    public static long parseGPStime(String gps_time) {
        long l = -1L;
        if (gps_time.equals("") || gps_time.length() != 10) {
            return -1L;
        }
        int lt = gps_time.length();
        int h = Integer.parseInt("" + gps_time.charAt(0) + gps_time.charAt(1));
        int m = Integer.parseInt("" + gps_time.charAt(2) + gps_time.charAt(3));
        int s = Integer.parseInt("" + gps_time.charAt(4) + gps_time.charAt(5));
        int u = lt - 7 > 3 ? 3 : lt - 7;
        int eu = (int)Math.pow(10.0, 3 - u);
        int ms = Integer.parseInt(gps_time.substring(7, 7 + u)) * eu;
        l = (h * 3600 + m * 60 + s) * 1000 + ms;
        return l;
    }

    public static double nauticNodesToMetersPerSeconds(double val) {
        double mps = val * 0.514444444444;
        return mps;
    }

    public static double MpsToKph(double mps) {
        return mps * 3.6;
    }

    public static double KphtoMps(double kph) {
        return kph / 3.6;
    }

    public static double doubleToRPM(double value) {
        if (value == 65535.0) {
            return 0.0;
        }
        double rpm = 6.0E7 / (value * 1.6);
        return rpm;
    }

    public static double doubleToVel1(double value, int sessionID) {
        if (value == 65535.0) {
            return 0.0;
        }
        double vel1 = 3.6 * ((double)(DanasDataStructure.getInstance().getSession(sessionID).getSessionSettings().getPinion(1) * DanasDataStructure.getInstance().getSession(sessionID).getSessionSettings().getCircumference(1)) / (value * 2.56E-5 * (double)DanasDataStructure.getInstance().getSession(sessionID).getSessionSettings().getGearTeeth(1) * 1000.0));
        return vel1;
    }

    public static double doubleToVel1(double value, DanasSession session) {
        if (value == 65535.0) {
            return 0.0;
        }
        double vel1 = 3.6 * ((double)(session.getSessionSettings().getPinion(1) * session.getSessionSettings().getCircumference(1)) / (value * 2.56E-5 * (double)session.getSessionSettings().getGearTeeth(1) * 1000.0));
        return vel1;
    }

    public static double doubleToVel2(double value, int sessionID) {
        if (value == 65535.0) {
            return 0.0;
        }
        double vel2 = 3.6 * ((double)(DanasDataStructure.getInstance().getSession(sessionID).getSessionSettings().getPinion(2) * DanasDataStructure.getInstance().getSession(sessionID).getSessionSettings().getCircumference(2)) / (value * 2.56E-5 * (double)DanasDataStructure.getInstance().getSession(sessionID).getSessionSettings().getGearTeeth(2) * 1000.0));
        return vel2;
    }

    public static double doubleToVel2(double value, DanasSession session) {
        if (value == 65535.0) {
            return 0.0;
        }
        double vel2 = 3.6 * ((double)(session.getSessionSettings().getPinion(2) * session.getSessionSettings().getCircumference(2)) / (value * 2.56E-5 * (double)session.getSessionSettings().getGearTeeth(2) * 1000.0));
        return vel2;
    }

    public static int convertiRealtoCanRpm(int valore, int moto) {
        int realRpm;
        switch (moto) {
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                realRpm = valore * 4;
                break;
            }
            case 16: {
                realRpm = valore / 5;
                break;
            }
            case 17: {
                realRpm = (int)((double)valore * 2.5641025641025643);
                break;
            }
            default: {
                realRpm = valore;
            }
        }
        return realRpm;
    }

    public static int convertiCantoRealRpm(int valore, int moto) {
        int realRpm;
        switch (moto) {
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                realRpm = valore / 4;
                break;
            }
            case 16: {
                realRpm = valore * 5;
                break;
            }
            case 17: {
                realRpm = (int)((double)valore / 2.5641025641025643);
                break;
            }
            default: {
                realRpm = valore;
            }
        }
        return realRpm;
    }

    public static int convertiRealToCanSpeed(int valore, int moto) {
        double parziale = 0.0;
        switch (moto) {
            case 1: {
                parziale = (double)valore / (double)0.877f;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                parziale = (double)valore * 16.0;
                break;
            }
            case 16: {
                parziale = (double)valore * 8.0;
                break;
            }
            case 4: 
            case 5: {
                parziale = (double)valore * 64.0;
                break;
            }
            case 8: {
                parziale = (double)valore * 85.0;
                break;
            }
            case 10: 
            case 13: 
            case 14: {
                parziale = (double)valore * 16.0;
                break;
            }
            case 15: {
                parziale = (double)valore * 96.0;
                break;
            }
            case 17: 
            case 18: {
                parziale = (double)valore * 96.0;
                break;
            }
            default: {
                parziale = valore;
            }
        }
        return (int)parziale;
    }

    public static int convertiCanToRealSpeed(int valore, int moto) {
        double parziale = 0.0;
        switch (moto) {
            case 1: {
                parziale = (double)valore * (double)0.877f;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                parziale = (double)valore / 16.0;
                break;
            }
            case 16: {
                parziale = (double)valore / 8.0;
                break;
            }
            case 4: 
            case 5: {
                parziale = (double)valore / 64.0;
                break;
            }
            case 8: {
                parziale = (double)valore / 85.0;
                break;
            }
            case 10: 
            case 13: 
            case 14: {
                parziale = (double)valore / 16.0;
                break;
            }
            case 15: {
                parziale = (double)valore / 96.0;
                break;
            }
            case 17: {
                parziale = (double)valore / 96.0;
                break;
            }
            default: {
                parziale = valore;
            }
        }
        return (int)parziale;
    }

    public static int convertiValoreSpeedCan(int valore, int speed, int moto) {
        double parziale = 0.0;
        int finale = 65535;
        switch (moto) {
            case 1: {
                parziale = (double)valore * (double)0.877f;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                parziale = (double)valore / 16.0;
                break;
            }
            case 16: {
                parziale = (double)valore / 8.0;
                break;
            }
            case 4: 
            case 5: {
                parziale = (double)valore / 64.0;
                break;
            }
            case 8: {
                parziale = (double)valore / 85.0;
                break;
            }
            case 10: 
            case 13: 
            case 14: {
                parziale = (double)valore / 16.0;
                break;
            }
            case 15: {
                parziale = (double)valore / 96.0;
                break;
            }
            case 17: {
                parziale = (double)valore / 96.0;
                break;
            }
            default: {
                parziale = valore;
            }
        }
        if (moto == 0 || (moto == 4 || moto == 5) && speed == 2) {
            return valore;
        }
        double circonferenza = speed == 1 ? 1980.0 : 1950.0;
        if (parziale > 350.0) {
            parziale = 350.0;
        }
        if ((int)parziale == 0) {
            return 65535;
        }
        double calcolo = 1.0 / (parziale * 1000.0 / circonferenza / (double)3.6f) / (double)2.56E-5f;
        finale = (int)calcolo;
        if (finale > 65535) {
            finale = 65535;
        }
        if (finale < 0) {
            finale = 0;
        }
        return finale;
    }

    public static int convertiValoreRpmCan(int valore, int moto) {
        int realRpm;
        switch (moto) {
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                realRpm = (int)((double)valore / 4.0);
                break;
            }
            case 16: {
                realRpm = (int)((double)valore * 5.0);
                break;
            }
            case 17: {
                realRpm = (int)((double)valore / 2.5641025641025643);
                break;
            }
            default: {
                realRpm = valore;
            }
        }
        if (moto == 0) {
            return realRpm;
        }
        if (realRpm == 0) {
            return 65535;
        }
        double calcolo = 1.0 / ((double)realRpm / 60.0) / (double)1.6E-6f;
        int r = (int)calcolo;
        if (r > 65535) {
            r = 65535;
        }
        if (r < 0) {
            r = 0;
        }
        return r;
    }

    public static boolean isTipoDaSalvare(DanasDataStructureConstants.ValueType vt) {
        return vt != DanasDataStructureConstants.ValueType.GEARS && vt != DanasDataStructureConstants.ValueType.R_GEARS && vt != DanasDataStructureConstants.ValueType.SIM1 && vt != DanasDataStructureConstants.ValueType.SIM2 && vt != DanasDataStructureConstants.ValueType.ANGLE_GPS && vt != DanasDataStructureConstants.ValueType.ACC_LAT && vt != DanasDataStructureConstants.ValueType.DELAY && vt != DanasDataStructureConstants.ValueType.SLIP && vt != DanasDataStructureConstants.ValueType.dEXT1 && vt != DanasDataStructureConstants.ValueType.dEXT2 && vt != DanasDataStructureConstants.ValueType.dEXT3 && vt != DanasDataStructureConstants.ValueType.dEXT4 && vt != DanasDataStructureConstants.ValueType.DDS && vt != DanasDataStructureConstants.ValueType.LAT && vt != DanasDataStructureConstants.ValueType.LONG && vt != DanasDataStructureConstants.ValueType.GPS_TIME && vt != DanasDataStructureConstants.ValueType.VEL_GPS && vt != DanasDataStructureConstants.ValueType.ALTITUDE && (vt.ordinal() < DanasDataStructureConstants.ValueType.dVEL_GPS.ordinal() || vt.ordinal() > DanasDataStructureConstants.ValueType.dANALOG8.ordinal());
    }

    public static double fitAnalog(double analog, double min, double max, boolean derivata) {
        double real_analog = min < max ? (derivata ? analog * (max - min) / 1023.0 : analog * (max - min) / 1023.0 + min) : (derivata ? (1023.0 - analog) * (min - max) / 1023.0 : (1023.0 - analog) * (min - max) / 1023.0 + max);
        return real_analog;
    }

    public static double GearRatio(DanasValueData v, int sessionID) {
        double vel = 0.0;
        vel = 1.0 / (v.getSpeed1() * 2.56E-5);
        if (vel == 0.0) {
            return 0.0;
        }
        double rps = MeasuresUtil.doubleToRPM(v.getRPM()) / 60.0;
        double gear = rps / vel;
        if (gear > 20.0) {
            return 0.0;
        }
        return -gear;
    }

    public static int InsertedGear(double gear, int sessionID) {
        float[] gs = new float[6];
        gs = DanasDataStructure.getInstance().getSession(sessionID).getSessionSettings().getGears();
        double diff = -1.0;
        int best = -1;
        for (int i = 0; i < gs.length; ++i) {
            if (gs[i] == 0.0f) continue;
            if (diff < 0.0) {
                diff = Math.abs(gear - (double)gs[i]);
                best = i;
                continue;
            }
            double dtmp = Math.abs(gear - (double)gs[i]);
            if (!(diff > dtmp)) continue;
            diff = dtmp;
            best = i;
        }
        return best + 1;
    }

    public static String getNomeCanale(int numCanale, int sessioneID) {
        DanasSession sess = DanasDataStructure.getInstance().getSession(sessioneID);
        if (sess != null) {
            return sess.getSessionSettings().getNome(MeasuresUtil.getValueType(numCanale));
        }
        return MeasuresUtil.getValueType(numCanale).toString();
    }

    public static String getNomeCanale(int numCanale) {
        if (DanasDataStructure.getInstance().getDefaultSession() != null) {
            return DanasDataStructure.getInstance().getDefaultSession().getSessionSettings().getNome(MeasuresUtil.getValueType(numCanale));
        }
        return MeasuresUtil.getValueType(numCanale).toString();
    }

    public static DanasDataStructureConstants.ValueType getValueType(int index) {
        switch (index) {
            case 0: {
                return DanasDataStructureConstants.ValueType.VEL_GPS;
            }
            case 1: {
                return DanasDataStructureConstants.ValueType.RPM;
            }
            case 2: {
                return DanasDataStructureConstants.ValueType.SPEED1;
            }
            case 3: {
                return DanasDataStructureConstants.ValueType.SPEED2;
            }
            case 4: {
                return DanasDataStructureConstants.ValueType.ANALOG1;
            }
            case 5: {
                return DanasDataStructureConstants.ValueType.ANALOG2;
            }
            case 6: {
                return DanasDataStructureConstants.ValueType.ANALOG3;
            }
            case 7: {
                return DanasDataStructureConstants.ValueType.ANALOG4;
            }
            case 8: {
                return DanasDataStructureConstants.ValueType.ANALOG5;
            }
            case 9: {
                return DanasDataStructureConstants.ValueType.ANALOG6;
            }
            case 10: {
                return DanasDataStructureConstants.ValueType.ANALOG7;
            }
            case 11: {
                return DanasDataStructureConstants.ValueType.ANALOG8;
            }
            case 12: {
                return DanasDataStructureConstants.ValueType.EXT1;
            }
            case 13: {
                return DanasDataStructureConstants.ValueType.EXT2;
            }
            case 14: {
                return DanasDataStructureConstants.ValueType.EXT3;
            }
            case 15: {
                return DanasDataStructureConstants.ValueType.EXT4;
            }
            case 16: {
                return DanasDataStructureConstants.ValueType.dVEL_GPS;
            }
            case 17: {
                return DanasDataStructureConstants.ValueType.dRPM;
            }
            case 18: {
                return DanasDataStructureConstants.ValueType.dSPEED1;
            }
            case 19: {
                return DanasDataStructureConstants.ValueType.dSPEED2;
            }
            case 20: {
                return DanasDataStructureConstants.ValueType.dANALOG1;
            }
            case 21: {
                return DanasDataStructureConstants.ValueType.dANALOG2;
            }
            case 22: {
                return DanasDataStructureConstants.ValueType.dANALOG3;
            }
            case 23: {
                return DanasDataStructureConstants.ValueType.dANALOG4;
            }
            case 24: {
                return DanasDataStructureConstants.ValueType.dANALOG5;
            }
            case 25: {
                return DanasDataStructureConstants.ValueType.dANALOG6;
            }
            case 26: {
                return DanasDataStructureConstants.ValueType.dANALOG7;
            }
            case 27: {
                return DanasDataStructureConstants.ValueType.dANALOG8;
            }
            case 28: {
                return DanasDataStructureConstants.ValueType.dEXT1;
            }
            case 29: {
                return DanasDataStructureConstants.ValueType.dEXT2;
            }
            case 30: {
                return DanasDataStructureConstants.ValueType.dEXT3;
            }
            case 31: {
                return DanasDataStructureConstants.ValueType.dEXT4;
            }
            case 32: {
                return DanasDataStructureConstants.ValueType.GEARS;
            }
            case 33: {
                return DanasDataStructureConstants.ValueType.R_GEARS;
            }
            case 34: {
                return DanasDataStructureConstants.ValueType.SIM1;
            }
            case 35: {
                return DanasDataStructureConstants.ValueType.SIM2;
            }
            case 36: {
                return DanasDataStructureConstants.ValueType.MULTI;
            }
            case 37: {
                return DanasDataStructureConstants.ValueType.MULTI2;
            }
            case 38: {
                return DanasDataStructureConstants.ValueType.MULTI3;
            }
            case 39: {
                return DanasDataStructureConstants.ValueType.MULTI4;
            }
            case 40: {
                return DanasDataStructureConstants.ValueType.MULTI5;
            }
            case 41: {
                return DanasDataStructureConstants.ValueType.MULTI6;
            }
            case 42: {
                return DanasDataStructureConstants.ValueType.MULTI7;
            }
            case 43: {
                return DanasDataStructureConstants.ValueType.MULTI8;
            }
            case 44: {
                return DanasDataStructureConstants.ValueType.MULTI9;
            }
            case 45: {
                return DanasDataStructureConstants.ValueType.MULTI10;
            }
            case 46: {
                return DanasDataStructureConstants.ValueType.ANGLE_GPS;
            }
            case 47: {
                return DanasDataStructureConstants.ValueType.ACC_LAT;
            }
            case 48: {
                return DanasDataStructureConstants.ValueType.ALTITUDE;
            }
            case 49: {
                return DanasDataStructureConstants.ValueType.DELAY;
            }
            case 50: {
                return DanasDataStructureConstants.ValueType.SLIP;
            }
            case 51: {
                return DanasDataStructureConstants.ValueType.MATH_1;
            }
            case 52: {
                return DanasDataStructureConstants.ValueType.MATH_2;
            }
            case 53: {
                return DanasDataStructureConstants.ValueType.MATH_3;
            }
            case 54: {
                return DanasDataStructureConstants.ValueType.MATH_4;
            }
            case 55: {
                return DanasDataStructureConstants.ValueType.MATH_5;
            }
            case 56: {
                return DanasDataStructureConstants.ValueType.MATH_6;
            }
            case 57: {
                return DanasDataStructureConstants.ValueType.MATH_7;
            }
            case 58: {
                return DanasDataStructureConstants.ValueType.MATH_8;
            }
            case 59: {
                return DanasDataStructureConstants.ValueType.MATH_9;
            }
            case 60: {
                return DanasDataStructureConstants.ValueType.MATH_10;
            }
            case 61: {
                return DanasDataStructureConstants.ValueType.HEART;
            }
            case 62: {
                return DanasDataStructureConstants.ValueType.P_ANT;
            }
            case 63: {
                return DanasDataStructureConstants.ValueType.T_ANT;
            }
            case 64: {
                return DanasDataStructureConstants.ValueType.P_POST;
            }
            case 65: {
                return DanasDataStructureConstants.ValueType.T_POST;
            }
            case 194: {
                return DanasDataStructureConstants.ValueType.DDS;
            }
        }
        if (index < 194) {
            return DanasDataStructureConstants.ValueType.values()[DanasDataStructureConstants.ValueType.CAN1.ordinal() + index - 66];
        }
        return DanasDataStructureConstants.ValueType.ANALOG1;
    }

    public static int getPositionType(DanasDataStructureConstants.ValueType type) {
        int posizione = 0;
        switch (type) {
            case VEL_GPS: {
                posizione = 0;
                break;
            }
            case RPM: {
                posizione = 1;
                break;
            }
            case SPEED1: {
                posizione = 2;
                break;
            }
            case SPEED2: {
                posizione = 3;
                break;
            }
            case ANALOG1: {
                posizione = 4;
                break;
            }
            case ANALOG2: {
                posizione = 5;
                break;
            }
            case ANALOG3: {
                posizione = 6;
                break;
            }
            case ANALOG4: {
                posizione = 7;
                break;
            }
            case ANALOG5: {
                posizione = 8;
                break;
            }
            case ANALOG6: {
                posizione = 9;
                break;
            }
            case ANALOG7: {
                posizione = 10;
                break;
            }
            case ANALOG8: {
                posizione = 11;
                break;
            }
            case EXT1: {
                posizione = 12;
                break;
            }
            case EXT2: {
                posizione = 13;
                break;
            }
            case EXT3: {
                posizione = 14;
                break;
            }
            case EXT4: {
                posizione = 15;
                break;
            }
            case dVEL_GPS: {
                posizione = 16;
                break;
            }
            case dRPM: {
                posizione = 17;
                break;
            }
            case dSPEED1: {
                posizione = 18;
                break;
            }
            case dSPEED2: {
                posizione = 19;
                break;
            }
            case dANALOG1: {
                posizione = 20;
                break;
            }
            case dANALOG2: {
                posizione = 21;
                break;
            }
            case dANALOG3: {
                posizione = 22;
                break;
            }
            case dANALOG4: {
                posizione = 23;
                break;
            }
            case dANALOG5: {
                posizione = 24;
                break;
            }
            case dANALOG6: {
                posizione = 25;
                break;
            }
            case dANALOG7: {
                posizione = 26;
                break;
            }
            case dANALOG8: {
                posizione = 27;
                break;
            }
            case dEXT1: {
                posizione = 28;
                break;
            }
            case dEXT2: {
                posizione = 29;
                break;
            }
            case dEXT3: {
                posizione = 30;
                break;
            }
            case dEXT4: {
                posizione = 31;
                break;
            }
            case GEARS: {
                posizione = 32;
                break;
            }
            case R_GEARS: {
                posizione = 33;
                break;
            }
            case SIM1: {
                posizione = 34;
                break;
            }
            case SIM2: {
                posizione = 35;
                break;
            }
            case MULTI: {
                posizione = 36;
                break;
            }
            case MULTI2: {
                posizione = 37;
                break;
            }
            case MULTI3: {
                posizione = 38;
                break;
            }
            case MULTI4: {
                posizione = 39;
                break;
            }
            case MULTI5: {
                posizione = 40;
                break;
            }
            case MULTI6: {
                posizione = 41;
                break;
            }
            case MULTI7: {
                posizione = 42;
                break;
            }
            case MULTI8: {
                posizione = 43;
                break;
            }
            case MULTI9: {
                posizione = 44;
                break;
            }
            case MULTI10: {
                posizione = 45;
                break;
            }
            case ANGLE_GPS: {
                posizione = 46;
                break;
            }
            case ACC_LAT: {
                posizione = 47;
                break;
            }
            case ALTITUDE: {
                posizione = 48;
                break;
            }
            case DELAY: {
                posizione = 49;
                break;
            }
            case SLIP: {
                posizione = 50;
                break;
            }
            case MATH_1: {
                posizione = 51;
                break;
            }
            case MATH_2: {
                posizione = 52;
                break;
            }
            case MATH_3: {
                posizione = 53;
                break;
            }
            case MATH_4: {
                posizione = 54;
                break;
            }
            case MATH_5: {
                posizione = 55;
                break;
            }
            case MATH_6: {
                posizione = 56;
                break;
            }
            case MATH_7: {
                posizione = 57;
                break;
            }
            case MATH_8: {
                posizione = 58;
                break;
            }
            case MATH_9: {
                posizione = 59;
                break;
            }
            case MATH_10: {
                posizione = 60;
                break;
            }
            case HEART: {
                posizione = 61;
                break;
            }
            case P_ANT: {
                posizione = 62;
                break;
            }
            case T_ANT: {
                posizione = 63;
                break;
            }
            case P_POST: {
                posizione = 64;
                break;
            }
            case T_POST: {
                posizione = 65;
                break;
            }
            case DDS: {
                posizione = 194;
                break;
            }
            default: {
                if (type.ordinal() < DanasDataStructureConstants.ValueType.CAN1.ordinal() || type.ordinal() > DanasDataStructureConstants.ValueType.CAN128.ordinal()) break;
                return type.ordinal() - DanasDataStructureConstants.ValueType.CAN1.ordinal() + 66;
            }
        }
        return posizione;
    }

    public static int getIndiceFiltro(String filtro) {
        if (filtro.equals("--")) {
            return 0;
        }
        if (filtro.equals("20Hz")) {
            return 1;
        }
        if (filtro.equals("10Hz")) {
            return 2;
        }
        if (filtro.equals("7Hz")) {
            return 3;
        }
        if (filtro.equals("5Hz")) {
            return 4;
        }
        if (filtro.equals("2Hz")) {
            return 5;
        }
        if (filtro.equals("1Hz")) {
            return 6;
        }
        return 0;
    }

    public static String getFiltroDaIndice(int indice) {
        switch (indice) {
            case 0: {
                return "--";
            }
            case 1: {
                return "20Hz";
            }
            case 2: {
                return "10Hz";
            }
            case 3: {
                return "7Hz";
            }
            case 4: {
                return "5Hz";
            }
            case 5: {
                return "2Hz";
            }
            case 6: {
                return "1Hz";
            }
        }
        return "--";
    }

    public static double GenericDataConverter(double val, DanasDataStructureConstants.ValueType t, DanasSession session) {
        if (Double.isNaN(val)) {
            return Double.NaN;
        }
        switch (t) {
            case VEL_GPS: {
                return MeasuresUtil.getVelocita(MeasuresUtil.MpsToKph(MeasuresUtil.nauticNodesToMetersPerSeconds(val)));
            }
            case RPM: {
                return MeasuresUtil.doubleToRPM(val);
            }
            case SPEED1: {
                return MeasuresUtil.getVelocita(MeasuresUtil.doubleToVel1(val, session));
            }
            case SPEED2: {
                return MeasuresUtil.getVelocita(MeasuresUtil.doubleToVel2(val, session));
            }
            case dANALOG1: {
                return MeasuresUtil.fitAnalog(val, session.getSessionSettings().getMinimo(DanasDataStructureConstants.ValueType.ANALOG1), session.getSessionSettings().getMassimo(DanasDataStructureConstants.ValueType.ANALOG1), true);
            }
            case ANALOG1: {
                return MeasuresUtil.fitAnalog(val, session.getSessionSettings().getMinimo(DanasDataStructureConstants.ValueType.ANALOG1), session.getSessionSettings().getMassimo(DanasDataStructureConstants.ValueType.ANALOG1), false);
            }
            case dANALOG2: {
                return MeasuresUtil.fitAnalog(val, session.getSessionSettings().getMinimo(DanasDataStructureConstants.ValueType.ANALOG2), session.getSessionSettings().getMassimo(DanasDataStructureConstants.ValueType.ANALOG2), true);
            }
            case ANALOG2: {
                return MeasuresUtil.fitAnalog(val, session.getSessionSettings().getMinimo(DanasDataStructureConstants.ValueType.ANALOG2), session.getSessionSettings().getMassimo(DanasDataStructureConstants.ValueType.ANALOG2), false);
            }
            case dANALOG3: {
                return MeasuresUtil.fitAnalog(val, session.getSessionSettings().getMinimo(DanasDataStructureConstants.ValueType.ANALOG3), session.getSessionSettings().getMassimo(DanasDataStructureConstants.ValueType.ANALOG3), true);
            }
            case ANALOG3: {
                return MeasuresUtil.fitAnalog(val, session.getSessionSettings().getMinimo(DanasDataStructureConstants.ValueType.ANALOG3), session.getSessionSettings().getMassimo(DanasDataStructureConstants.ValueType.ANALOG3), false);
            }
            case dANALOG4: {
                return MeasuresUtil.fitAnalog(val, session.getSessionSettings().getMinimo(DanasDataStructureConstants.ValueType.ANALOG4), session.getSessionSettings().getMassimo(DanasDataStructureConstants.ValueType.ANALOG4), true);
            }
            case ANALOG4: {
                return MeasuresUtil.fitAnalog(val, session.getSessionSettings().getMinimo(DanasDataStructureConstants.ValueType.ANALOG4), session.getSessionSettings().getMassimo(DanasDataStructureConstants.ValueType.ANALOG4), false);
            }
            case dANALOG5: {
                return MeasuresUtil.fitAnalog(val, session.getSessionSettings().getMinimo(DanasDataStructureConstants.ValueType.ANALOG5), session.getSessionSettings().getMassimo(DanasDataStructureConstants.ValueType.ANALOG5), true);
            }
            case ANALOG5: {
                return MeasuresUtil.fitAnalog(val, session.getSessionSettings().getMinimo(DanasDataStructureConstants.ValueType.ANALOG5), session.getSessionSettings().getMassimo(DanasDataStructureConstants.ValueType.ANALOG5), false);
            }
            case dANALOG6: {
                return MeasuresUtil.fitAnalog(val, session.getSessionSettings().getMinimo(DanasDataStructureConstants.ValueType.ANALOG6), session.getSessionSettings().getMassimo(DanasDataStructureConstants.ValueType.ANALOG6), true);
            }
            case ANALOG6: {
                return MeasuresUtil.fitAnalog(val, session.getSessionSettings().getMinimo(DanasDataStructureConstants.ValueType.ANALOG6), session.getSessionSettings().getMassimo(DanasDataStructureConstants.ValueType.ANALOG6), false);
            }
            case dANALOG7: {
                return MeasuresUtil.fitAnalog(val, session.getSessionSettings().getMinimo(DanasDataStructureConstants.ValueType.ANALOG7), session.getSessionSettings().getMassimo(DanasDataStructureConstants.ValueType.ANALOG7), true);
            }
            case ANALOG7: {
                return MeasuresUtil.fitAnalog(val, session.getSessionSettings().getMinimo(DanasDataStructureConstants.ValueType.ANALOG7), session.getSessionSettings().getMassimo(DanasDataStructureConstants.ValueType.ANALOG7), false);
            }
            case dANALOG8: {
                return MeasuresUtil.fitAnalog(val, session.getSessionSettings().getMinimo(DanasDataStructureConstants.ValueType.ANALOG8), session.getSessionSettings().getMassimo(DanasDataStructureConstants.ValueType.ANALOG8), true);
            }
            case ANALOG8: {
                return MeasuresUtil.fitAnalog(val, session.getSessionSettings().getMinimo(DanasDataStructureConstants.ValueType.ANALOG8), session.getSessionSettings().getMassimo(DanasDataStructureConstants.ValueType.ANALOG8), false);
            }
            case dEXT1: {
                return MeasuresUtil.fitAnalog(val, session.getSessionSettings().getMinimo(DanasDataStructureConstants.ValueType.EXT1), session.getSessionSettings().getMassimo(DanasDataStructureConstants.ValueType.EXT1), true);
            }
            case EXT1: {
                return MeasuresUtil.fitAnalog(val, session.getSessionSettings().getMinimo(DanasDataStructureConstants.ValueType.EXT1), session.getSessionSettings().getMassimo(DanasDataStructureConstants.ValueType.EXT1), false);
            }
            case dEXT2: {
                return MeasuresUtil.fitAnalog(val, session.getSessionSettings().getMinimo(DanasDataStructureConstants.ValueType.EXT2), session.getSessionSettings().getMassimo(DanasDataStructureConstants.ValueType.EXT2), true);
            }
            case EXT2: {
                return MeasuresUtil.fitAnalog(val, session.getSessionSettings().getMinimo(DanasDataStructureConstants.ValueType.EXT2), session.getSessionSettings().getMassimo(DanasDataStructureConstants.ValueType.EXT2), false);
            }
            case dEXT3: {
                return MeasuresUtil.fitAnalog(val, session.getSessionSettings().getMinimo(DanasDataStructureConstants.ValueType.EXT3), session.getSessionSettings().getMassimo(DanasDataStructureConstants.ValueType.EXT3), true);
            }
            case EXT3: {
                return MeasuresUtil.fitAnalog(val, session.getSessionSettings().getMinimo(DanasDataStructureConstants.ValueType.EXT3), session.getSessionSettings().getMassimo(DanasDataStructureConstants.ValueType.EXT3), false);
            }
            case dEXT4: {
                return MeasuresUtil.fitAnalog(val, session.getSessionSettings().getMinimo(DanasDataStructureConstants.ValueType.EXT4), session.getSessionSettings().getMassimo(DanasDataStructureConstants.ValueType.EXT4), true);
            }
            case EXT4: {
                return MeasuresUtil.fitAnalog(val, session.getSessionSettings().getMinimo(DanasDataStructureConstants.ValueType.EXT4), session.getSessionSettings().getMassimo(DanasDataStructureConstants.ValueType.EXT4), false);
            }
            case MULTI: {
                return DanasDataStructure.getInstance().getValoreCanaleMulti(0, session.getSessionSettings().getTipoMoto(), val);
            }
            case MULTI2: {
                return DanasDataStructure.getInstance().getValoreCanaleMulti(1, session.getSessionSettings().getTipoMoto(), val);
            }
            case MULTI3: {
                return DanasDataStructure.getInstance().getValoreCanaleMulti(2, session.getSessionSettings().getTipoMoto(), val);
            }
            case MULTI4: {
                return DanasDataStructure.getInstance().getValoreCanaleMulti(3, session.getSessionSettings().getTipoMoto(), val);
            }
            case MULTI5: {
                return DanasDataStructure.getInstance().getValoreCanaleMulti(4, session.getSessionSettings().getTipoMoto(), val);
            }
            case MULTI6: {
                return DanasDataStructure.getInstance().getValoreCanaleMulti(5, session.getSessionSettings().getTipoMoto(), val);
            }
            case MULTI7: {
                return DanasDataStructure.getInstance().getValoreCanaleMulti(6, session.getSessionSettings().getTipoMoto(), val);
            }
            case MULTI8: {
                return DanasDataStructure.getInstance().getValoreCanaleMulti(7, session.getSessionSettings().getTipoMoto(), val);
            }
            case MULTI9: {
                return DanasDataStructure.getInstance().getValoreCanaleMulti(8, session.getSessionSettings().getTipoMoto(), val);
            }
            case MULTI10: {
                return DanasDataStructure.getInstance().getValoreCanaleMulti(9, session.getSessionSettings().getTipoMoto(), val);
            }
            case P_ANT: {
                return MeasuresUtil.getValoreTpms(val, 0);
            }
            case T_ANT: {
                return MeasuresUtil.getValoreTpms(val, 1);
            }
            case P_POST: {
                return MeasuresUtil.getValoreTpms(val, 2);
            }
            case T_POST: {
                return MeasuresUtil.getValoreTpms(val, 3);
            }
            case dVEL_GPS: {
                return MeasuresUtil.nauticNodesToMetersPerSeconds(val) / 9.81;
            }
            case GEARS: {
                return MeasuresUtil.InsertedGear(-val, session.getSessionID());
            }
            case dRPM: 
            case dSPEED1: 
            case dSPEED2: 
            case R_GEARS: 
            case ANGLE_GPS: 
            case ACC_LAT: 
            case ALTITUDE: 
            case DELAY: 
            case SLIP: 
            case MATH_1: 
            case MATH_2: 
            case MATH_3: 
            case MATH_4: 
            case MATH_5: 
            case MATH_6: 
            case MATH_7: 
            case MATH_8: 
            case MATH_9: 
            case MATH_10: 
            case HEART: {
                return val;
            }
        }
        if (t.ordinal() >= DanasDataStructureConstants.ValueType.CAN1.ordinal() && t.ordinal() <= DanasDataStructureConstants.ValueType.CAN128.ordinal()) {
            return MeasuresUtil.fitAnalog(val, session.getSessionSettings().getMinimo(t), session.getSessionSettings().getMassimo(t), false);
        }
        return val;
    }

    public static double GenericDataConverter(double val, DanasDataStructureConstants.ValueType t, int sessionID) {
        DanasSession sess = DanasDataStructure.getInstance().getSession(sessionID);
        return MeasuresUtil.GenericDataConverter(val, t, sess);
    }
}

