/*
 * Decompiled with CFR 0.152.
 */
package i2m.DataStructure.danasUtils;

import i2m.DataStructure.danasDataStructure.DanasDataStructure;
import i2m.Language;
import java.awt.Component;
import java.awt.GridLayout;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class Internet {
    public static boolean downloadFile(String remoteFile, String localFile) throws IOException {
        try {
            URL url = new URL(remoteFile);
            BufferedInputStream in = new BufferedInputStream(url.openStream());
            FileOutputStream fos = new FileOutputStream(localFile);
            BufferedOutputStream bout = new BufferedOutputStream(fos, 1024);
            byte[] data = new byte[1024];
            int count = 0;
            while ((count = in.read(data, 0, 1024)) > 0) {
                bout.write(data, 0, count);
            }
            bout.close();
            in.close();
            System.out.println(remoteFile + " - Download Successful.");
            return true;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            System.out.println("The file " + remoteFile + " doesn't exist.");
            return false;
        }
    }

    public static int getVersioneInternet(boolean newJvm) {
        int versione = 0;
        try {
            File temp = File.createTempFile("tempfileVersione", ".tmp");
            boolean res = newJvm ? Internet.downloadFile("https://i2m.it/download/DanasProJvm/versioneProJvm.txt", temp.getAbsolutePath()) : Internet.downloadFile("https://i2m.it/download/versionePro.txt", temp.getAbsolutePath());
            if (!res) {
                return 0;
            }
            BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(temp)));
            String line = in.readLine();
            if (line != null) {
                versione = Integer.valueOf(line);
                System.out.println("Log:linea internet=" + line + " versione=" + versione);
            }
            in.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return versione;
    }

    public static boolean testConnessioneInternet() {
        return Internet.testInet("www.google.com");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean testInet(String site) {
        Socket sock = new Socket();
        System.out.println("creo InetSocketAddress");
        InetSocketAddress addr = new InetSocketAddress(site, 80);
        System.out.println("creato InetSocketAddress");
        try {
            sock.connect(addr, 3000);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                sock.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void gestisciAggiornamentoSoftware(boolean backgr, boolean newJvm) {
        final boolean background = backgr;
        final boolean nuovaJvm = newJvm;
        Thread t1 = new Thread(new Runnable(){

            @Override
            public void run() {
                if (!Internet.testConnessioneInternet()) {
                    if (!background) {
                        JOptionPane.showMessageDialog(null, Language.string("Connessione a internet non rilevata."), Language.string("Attenzione"), 2);
                    }
                    return;
                }
                int versione = Internet.getVersioneInternet(nuovaJvm);
                if (versione == 0) {
                    if (!background) {
                        JOptionPane.showMessageDialog(null, Language.string("Errore durante la lettura della versione software"), Language.string("Attenzione"), 2);
                    }
                    return;
                }
                System.out.println("Versione attuale=" + DanasDataStructure.getInstance().getMainFrame().getVersioneSofware());
                if (versione > DanasDataStructure.getInstance().getMainFrame().getVersioneSofware()) {
                    int res = JOptionPane.showConfirmDialog(null, Language.string("E'disponibile una versione pi\u00f9 recente. Aggiornare?"), Language.string("Attenzione"), 0);
                    if (res == -1 || res == 1) {
                        return;
                    }
                    final JDialog dlg = new JDialog(DanasDataStructure.getInstance().getMainFrame(), "Download", false);
                    dlg.setDefaultCloseOperation(0);
                    dlg.setResizable(true);
                    JProgressBar progressBar = new JProgressBar(0, 500);
                    progressBar.setIndeterminate(true);
                    JPanel panel = new JPanel();
                    panel.setLayout(new GridLayout(2, 1));
                    panel.add(new JLabel(Language.string("Download in corso..")));
                    panel.add(progressBar);
                    dlg.add((Component)panel, "First");
                    panel.setBorder(BorderFactory.createEmptyBorder(10, 20, 20, 20));
                    dlg.setLocationRelativeTo(null);
                    dlg.setSize(400, 150);
                    dlg.pack();
                    dlg.setVisible(true);
                    final String s = Language.string("Riavviare Danas per rendere operativi gli aggiornamenti.");
                    String s1 = Language.string("Riavviare nuovamente Danas per rendere effettive le modifiche");
                    Thread t = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                System.out.println("INIZIO DOWNLOAD aggiornamenti");
                                File temp = File.createTempFile("tempDownloadDanas", ".tmp");
                                if (nuovaJvm) {
                                    Internet.downloadFile("https://i2m.it/download/DanasProJvm/DanasPro-1.0-SNAPSHOT.jar", temp.getAbsolutePath());
                                    Internet.copy(temp, new File("./DanasPro-1.0-SNAPSHOT.jar"));
                                } else {
                                    Internet.downloadFile("https://i2m.it/download/DanasPro.jar", temp.getAbsolutePath());
                                    Internet.copy(temp, new File("./DanasPro.jar"));
                                    File tempLingua = File.createTempFile("tempDownloadLingua", ".tmp");
                                    Internet.downloadFile("http://www.i2m.it/download/language.en", tempLingua.getAbsolutePath());
                                    Internet.copy(tempLingua, new File("./lang/languageNew.en"));
                                }
                                System.out.println("FINE DOWNLOAD");
                                dlg.setVisible(false);
                                JOptionPane.showMessageDialog(null, s, Language.string("Attenzione"), 1);
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                                dlg.setVisible(false);
                            }
                        }
                    });
                    t.start();
                } else if (!background) {
                    JOptionPane.showMessageDialog(null, Language.string("Il software \u00e8 gi\u00e0 aggiornato."), Language.string("Attenzione"), 1);
                }
            }
        });
        t1.start();
    }

    public static void copy(File src, File dst) throws IOException {
        int len;
        FileInputStream in = new FileInputStream(src);
        FileOutputStream out = new FileOutputStream(dst);
        byte[] buf = new byte[1024];
        while ((len = ((InputStream)in).read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }
}

