/*
 * Decompiled with CFR 0.152.
 */
package i2m.DataStructure.danasTable;

import i2m.DataStructure.danasTable.TableRowLap;
import i2m.Language;
import java.awt.Color;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public class MyTableModelLap
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    public static final int SEL = 0;
    public static final int SESSIONLAP = 2;
    public static final int TIME = 3;
    public static final int LENGTH = 4;
    public static final int COLOR = 1;
    public static final int SPLIT = 5;
    Vector<String> columnNames = new Vector();
    Vector<TableRowLap> vector = new Vector();

    public MyTableModelLap() {
        this.columnNames.add("Sel");
        this.columnNames.add(Language.string("Color"));
        this.columnNames.add(Language.string("Session-Lap"));
        this.columnNames.add(Language.string("Time"));
        this.columnNames.add(Language.string("Length(Km)"));
    }

    public void refreshSplits(int ns, Vector<String> vs) {
        this.fireTableStructureChanged();
    }

    public void refreshSplits() {
        this.fireTableStructureChanged();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.size();
    }

    @Override
    public int getRowCount() {
        return this.vector.size();
    }

    @Override
    public String getColumnName(int column) {
        if (column < 0 || column >= this.columnNames.size()) {
            return "";
        }
        return this.columnNames.get(column);
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (row >= this.vector.size()) {
            return null;
        }
        TableRowLap tr = this.vector.get(row);
        switch (col) {
            case 0: {
                return tr.getSel();
            }
            case 2: {
                return tr.getSessionlap();
            }
            case 3: {
                return tr.getTime();
            }
            case 4: {
                return tr.getLength();
            }
            case 1: {
                return tr.getCol();
            }
        }
        if (col > 4) {
            return tr.getSplit(col - 5);
        }
        return new Object();
    }

    @Override
    public Class<?> getColumnClass(int col) {
        switch (col) {
            case 2: 
            case 3: 
            case 4: {
                return String.class;
            }
            case 0: {
                return Boolean.class;
            }
            case 1: {
                return Color.class;
            }
        }
        if (col > 4) {
            return String.class;
        }
        return Object.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col <= 1;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        TableRowLap tr = this.vector.get(row);
        switch (col) {
            case 0: {
                tr.setSel((Boolean)value);
                this.fireTableCellUpdated(row, col);
                break;
            }
            case 2: {
                tr.setSessionlap((String)value);
                this.fireTableCellUpdated(row, col);
                break;
            }
            case 3: {
                tr.setTime((String)value);
                this.fireTableCellUpdated(row, col);
                break;
            }
            case 4: {
                tr.setLength((String)value);
                this.fireTableCellUpdated(row, col);
                break;
            }
            case 1: {
                tr.setCol((Color)value);
                break;
            }
            default: {
                if (col > 3 && col < this.columnNames.size() - 1) {
                    tr.setSplit((String)value);
                    break;
                }
                System.out.println("Danas:invalid index:setValueAt metod(MyTableModelSession)");
            }
        }
    }

    private void printDebugData() {
        int numRows = this.getRowCount();
        int numCols = this.getColumnCount();
        for (int i = 0; i < numRows; ++i) {
            System.out.print("    row " + i + ":");
            System.out.println(this.vector.get(i).toString());
            System.out.println();
        }
        System.out.println("--------------------------");
    }

    public void addRow(TableRowLap tr) {
        boolean v = false;
        if (tr.getNumSplit() > 0 && this.getNumSplitColumn() != tr.getNumSplit()) {
            v = true;
            for (int i = 0; i < tr.getNumSplit(); ++i) {
                this.columnNames.add("Split" + (this.getNumSplitColumn() + 1));
                this.fireTableStructureChanged();
            }
            this.vector.add(tr);
            this.fireTableRowsInserted(this.vector.size() - 1, this.vector.size() - 1);
        }
        if (this.getNumSplitColumn() == tr.getNumSplit() && !v) {
            this.vector.add(tr);
            this.fireTableRowsInserted(this.vector.size() - 1, this.vector.size() - 1);
        }
    }

    public void addRow(Boolean b, String ses, String time, String length, Vector<String> vs, Color col) {
        if (vs != null && this.columnNames.size() != 5 + vs.size()) {
            for (int i = 0; i < vs.size(); ++i) {
                this.columnNames.add("Split" + (this.getNumSplitColumn() + 1));
                this.fireTableStructureChanged();
            }
        }
        this.vector.add(new TableRowLap(b, ses, time, length, vs, col));
        this.fireTableRowsInserted(this.vector.size() - 1, this.vector.size() - 1);
    }

    public void addRow(String ses, String time, String length) {
        this.vector.add(new TableRowLap(ses, time, length));
        this.fireTableRowsInserted(this.vector.size() - 1, this.vector.size() - 1);
    }

    public int getNumSplitColumn() {
        return this.getColumnCount() - 5;
    }

    public void remAllSplits() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            this.vector.get(i).remAllSplit();
        }
        for (int column = this.getColumnCount() - 1; column != 4; --column) {
            this.columnNames.remove(column);
            this.fireTableStructureChanged();
        }
    }

    public void clear() {
        this.remAllSplits();
        this.vector.size();
        this.vector.removeAllElements();
        this.fireTableStructureChanged();
    }

    public void remSplit(int i) {
    }
}

