/*
 * Decompiled with CFR 0.152.
 */
package i2m.DataStructure.danasDataStructure;

import i2m.DanasPreferences;
import i2m.DataStructure.danasDataStructure.DanasDataStructure;
import i2m.DataStructure.danasDataStructure.DanasDataStructureConstants;
import i2m.DataStructure.danasDataStructure.DanasParserTask;
import i2m.DataStructure.danasUtils.MeasuresUtil;
import i2m.Language;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;

public class DanasSessionSettings {
    private int sid;
    private String settingsFileName = null;
    private String[] elencoNomi;
    private float[] elencoMinimi;
    private float[] elencoMassimi;
    private DanasDataStructureConstants.SpeedTypeGear speedType = DanasDataStructureConstants.SpeedTypeGear.SPEED1;
    private float[] gears = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
    private int tipoMoto = 8;
    private int wheelCirconference1 = 1900;
    private int pinionTeeth1 = 1;
    private int ringGearTeeth1 = 1;
    private int wheelCirconference2 = 1900;
    private int pinionTeeth2 = 1;
    private int ringGearTeeth2 = 1;

    public DanasSessionSettings() {
        this.elencoNomi = new String[DanasDataStructureConstants.ValueType.values().length];
        this.elencoMinimi = new float[DanasDataStructureConstants.ValueType.values().length];
        this.elencoMassimi = new float[DanasDataStructureConstants.ValueType.values().length];
        for (int i = 0; i < DanasDataStructureConstants.ValueType.values().length; ++i) {
            this.elencoNomi[i] = DanasDataStructureConstants.ValueType.values()[i].toString();
            this.elencoMinimi[i] = 0.0f;
            this.elencoMassimi[i] = 1023.0f;
        }
    }

    public boolean isFilePresente() {
        return this.settingsFileName != null;
    }

    public int getSessionID() {
        return this.sid;
    }

    public void setSessionID(int sid) {
        this.sid = sid;
    }

    public int getCircumference(int Nspeed) {
        if (Nspeed == 1) {
            return this.wheelCirconference1;
        }
        return this.wheelCirconference2;
    }

    public int getPinion(int Nspeed) {
        if (Nspeed == 1) {
            return this.pinionTeeth1;
        }
        return this.pinionTeeth2;
    }

    public int getGearTeeth(int Nspeed) {
        if (Nspeed == 1) {
            return this.ringGearTeeth1;
        }
        return this.ringGearTeeth2;
    }

    public void setCircumference(int Nspeed, int value) {
        if (Nspeed == 1) {
            this.wheelCirconference1 = value;
        } else {
            this.wheelCirconference2 = value;
        }
    }

    public void setPinion(int Nspeed, int value) {
        if (Nspeed == 1) {
            this.pinionTeeth1 = value;
        } else {
            this.pinionTeeth2 = value;
        }
    }

    public void setGearTeeth(int Nspeed, int value) {
        if (Nspeed == 1) {
            this.ringGearTeeth1 = value;
        } else {
            this.ringGearTeeth2 = value;
        }
    }

    public String getNome(DanasDataStructureConstants.ValueType vt) {
        switch (vt) {
            case VEL_GPS: {
                return "Gps speed";
            }
            case RPM: {
                return "Rpm";
            }
            case SPEED1: {
                return Language.string("Vel1");
            }
            case SPEED2: {
                return Language.string("Vel2");
            }
            case dVEL_GPS: {
                return "LongAcc[g]";
            }
            case dRPM: {
                return "d(Rpm)";
            }
            case dSPEED1: {
                return "d(" + this.getNome(DanasDataStructureConstants.ValueType.SPEED1) + ")";
            }
            case dSPEED2: {
                return "d(" + this.getNome(DanasDataStructureConstants.ValueType.SPEED2) + ")";
            }
            case dANALOG1: {
                return "d(" + this.getNome(DanasDataStructureConstants.ValueType.ANALOG1) + ")";
            }
            case dANALOG2: {
                return "d(" + this.getNome(DanasDataStructureConstants.ValueType.ANALOG2) + ")";
            }
            case dANALOG3: {
                return "d(" + this.getNome(DanasDataStructureConstants.ValueType.ANALOG3) + ")";
            }
            case dANALOG4: {
                return "d(" + this.getNome(DanasDataStructureConstants.ValueType.ANALOG4) + ")";
            }
            case dANALOG5: {
                return "d(" + this.getNome(DanasDataStructureConstants.ValueType.ANALOG5) + ")";
            }
            case dANALOG6: {
                return "d(" + this.getNome(DanasDataStructureConstants.ValueType.ANALOG6) + ")";
            }
            case dANALOG7: {
                return "d(" + this.getNome(DanasDataStructureConstants.ValueType.ANALOG7) + ")";
            }
            case dANALOG8: {
                return "d(" + this.getNome(DanasDataStructureConstants.ValueType.ANALOG8) + ")";
            }
            case dEXT1: {
                return "d(" + this.getNome(DanasDataStructureConstants.ValueType.EXT1) + ")";
            }
            case dEXT2: {
                return "d(" + this.getNome(DanasDataStructureConstants.ValueType.EXT2) + ")";
            }
            case dEXT3: {
                return "d(" + this.getNome(DanasDataStructureConstants.ValueType.EXT3) + ")";
            }
            case dEXT4: {
                return "d(" + this.getNome(DanasDataStructureConstants.ValueType.EXT4) + ")";
            }
            case GEARS: {
                return Language.string("Marce calcolate");
            }
            case R_GEARS: {
                return Language.string("Rapporto Marce");
            }
            case SIM1: {
                return DanasDataStructure.getInstance().getMath1Name();
            }
            case SIM2: {
                return DanasDataStructure.getInstance().getMath2Name();
            }
            case ANGLE_GPS: {
                return "Angle_gps";
            }
            case ACC_LAT: {
                return "LatAcc[g]";
            }
            case DELAY: {
                return "Delay";
            }
            case SLIP: {
                return "Slip";
            }
            case ALTITUDE: {
                return "Altitud.";
            }
            case MATH_1: {
                return DanasPreferences.getNomeMath(0, false);
            }
            case MATH_2: {
                return DanasPreferences.getNomeMath(1, false);
            }
            case MATH_3: {
                return DanasPreferences.getNomeMath(2, false);
            }
            case MATH_4: {
                return DanasPreferences.getNomeMath(3, false);
            }
            case MATH_5: {
                return DanasPreferences.getNomeMath(4, false);
            }
            case MATH_6: {
                return DanasPreferences.getNomeMath(5, false);
            }
            case MATH_7: {
                return DanasPreferences.getNomeMath(6, false);
            }
            case MATH_8: {
                return DanasPreferences.getNomeMath(7, false);
            }
            case MATH_9: {
                return DanasPreferences.getNomeMath(8, false);
            }
            case MATH_10: {
                return DanasPreferences.getNomeMath(9, false);
            }
            case HEART: {
                return Language.string("Cuore");
            }
            case P_ANT: {
                return Language.string("P. Ant.");
            }
            case T_ANT: {
                return Language.string("T. Ant.");
            }
            case T_POST: {
                return Language.string("T. Post.");
            }
            case P_POST: {
                return Language.string("P. Post.");
            }
            case LAT: {
                return Language.string("LAT [Degrees]");
            }
            case LONG: {
                return Language.string("LONG [Degrees]");
            }
            case GPS_TIME: {
                return Language.string("GPS_TIME [1/100s]");
            }
        }
        return this.elencoNomi[vt.ordinal()];
    }

    public void setNome(DanasDataStructureConstants.ValueType vt, String nome) {
        this.elencoNomi[vt.ordinal()] = nome;
    }

    public float getMinimo(DanasDataStructureConstants.ValueType vt) {
        return this.elencoMinimi[vt.ordinal()];
    }

    public void setMinimo(DanasDataStructureConstants.ValueType vt, float minimo) {
        this.elencoMinimi[vt.ordinal()] = minimo;
    }

    public float getMassimo(DanasDataStructureConstants.ValueType vt) {
        return this.elencoMassimi[vt.ordinal()];
    }

    public void setMassimo(DanasDataStructureConstants.ValueType vt, float massmo) {
        this.elencoMassimi[vt.ordinal()] = massmo;
    }

    public int getTipoMoto() {
        return this.tipoMoto;
    }

    public void setTipoMoto(int moto) {
        this.tipoMoto = moto;
        for (int i = 0; i < 10; ++i) {
            int posizione = i + DanasDataStructureConstants.ValueType.MULTI.ordinal();
            this.elencoNomi[posizione] = DanasDataStructure.getInstance().getNomeMulti(this.tipoMoto, i);
        }
    }

    public void setSpeedTypeGear2(DanasDataStructureConstants.SpeedTypeGear s) {
        this.speedType = s;
    }

    public DanasDataStructureConstants.SpeedTypeGear getSpeedTypeGear() {
        return this.speedType;
    }

    public void setGears(float[] g) {
        this.gears = g;
    }

    public void setGears(float g, int i) {
        this.gears[i - 1] = g;
    }

    public float[] getGears() {
        return this.gears;
    }

    public void setSettingsFileName(String settingsFileName) {
        this.settingsFileName = settingsFileName;
    }

    public String getSettingsFileName() {
        return this.settingsFileName;
    }

    public void refreshSettings() {
        try {
            if (this.getSettingsFileName().equals("Default")) {
                DanasParserTask.parseImposFile("defaultSettings.dfs", this.sid, false);
            } else {
                DanasParserTask.parseImposFile(this.getSettingsFileName(), this.sid, false);
            }
            System.out.println("Log: refresh settings su:" + this.getSettingsFileName());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void salvaSettaggiAnalog() {
        File lettura = this.getSettingsFileName().equals("Default") ? new File("defaultSettings.dfs") : new File(this.getSettingsFileName());
        this.saveSettingsToFile(lettura);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveSettingsToFile(File f) {
        try (PrintWriter outputStream = null;){
            outputStream = null;
            outputStream = new PrintWriter(new FileWriter(f));
            outputStream.println(this.getStringaSettaggiCanali());
            outputStream.println(this.getStringaSettaggiBase());
        }
    }

    public String getStringaSettaggiCanali() {
        String frase = "$SETTAGGICANALI,";
        for (DanasDataStructureConstants.ValueType vt : DanasDataStructureConstants.ValueType.values()) {
            if (!MeasuresUtil.isTipoDaSalvare(vt)) continue;
            frase = frase + vt.ordinal() + ";" + this.getNome(vt) + ";" + this.getMinimo(vt) + ";" + this.getMassimo(vt) + ",";
        }
        return frase;
    }

    public String getStringaSettaggiBase() {
        String frase = "$SETTAGGIBASE,";
        frase = frase + this.getTipoMoto() + ",";
        frase = frase + this.getGears()[0] + "," + this.getGears()[1] + "," + this.getGears()[2] + "," + this.getGears()[3] + "," + this.getGears()[4] + "," + this.getGears()[5] + ",";
        frase = frase + this.getPinion(1) + "," + this.getGearTeeth(1) + "," + this.getCircumference(1) + "," + this.getPinion(2) + "," + this.getGearTeeth(2) + "," + this.getCircumference(2) + ",";
        return frase;
    }

    public DanasDataStructureConstants.ValueType getValueAnalogico(int indice) {
        switch (indice) {
            case 1: {
                return DanasDataStructureConstants.ValueType.ANALOG1;
            }
            case 2: {
                return DanasDataStructureConstants.ValueType.ANALOG2;
            }
            case 3: {
                return DanasDataStructureConstants.ValueType.ANALOG3;
            }
            case 4: {
                return DanasDataStructureConstants.ValueType.ANALOG4;
            }
            case 5: {
                return DanasDataStructureConstants.ValueType.ANALOG5;
            }
            case 6: {
                return DanasDataStructureConstants.ValueType.ANALOG6;
            }
            case 7: {
                return DanasDataStructureConstants.ValueType.ANALOG7;
            }
            case 8: {
                return DanasDataStructureConstants.ValueType.ANALOG8;
            }
            case 9: {
                return DanasDataStructureConstants.ValueType.EXT1;
            }
            case 10: {
                return DanasDataStructureConstants.ValueType.EXT2;
            }
            case 11: {
                return DanasDataStructureConstants.ValueType.EXT3;
            }
            case 12: {
                return DanasDataStructureConstants.ValueType.EXT4;
            }
        }
        return DanasDataStructureConstants.ValueType.RPM;
    }

    public String getNomeAnalogici(int indice) {
        return this.elencoNomi[this.getValueAnalogico(indice).ordinal()];
    }
}

