/*
 * Decompiled with CFR 0.152.
 */
package i2m.DataStructure.danasDataStructure;

import i2m.DanasPreferences;
import i2m.DataStructure.danasDataStructure.ArrayDouble;
import i2m.DataStructure.danasDataStructure.DanasDataStructure;
import i2m.DataStructure.danasDataStructure.DanasDataStructureConstants;
import i2m.DataStructure.danasDataStructure.DanasIRData;
import i2m.DataStructure.danasDataStructure.DanasLap;
import i2m.DataStructure.danasDataStructure.DanasSessionSettings;
import i2m.DataStructure.danasDataStructure.DanasValueData;
import i2m.DataStructure.danasDataStructure.GPSPoint;
import i2m.DataStructure.danasUtils.GearValueTime;
import i2m.DataStructure.danasUtils.MeasuresUtil;
import i2m.grafico.ContenitoreGrafico;
import i2m.mappa.Mappa2D;
import java.awt.Color;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;

public class DanasSession {
    private DanasDataStructure dataStructure;
    private int sessionID;
    private String sessionName;
    private String filename;
    private int filePosition;
    private Color color;
    private boolean selected;
    private Date date;
    private String videoFilename;
    private String endHour;
    private String notes = "";
    private DanasDataStructureConstants.SpeedType speedType = DanasDataStructureConstants.SpeedType.SPEED1;
    private int tipo = 0;
    private String pilota = "---";
    private int pignone1 = -1;
    private int corona1 = -1;
    private int circonferenza1 = 2000;
    private int pignone2 = -1;
    private int corona2 = -1;
    private int circonferenza2 = 2000;
    private double differenzaTempiGps = 0.0;
    private int puntiGpsAnalizzati = 0;
    private double tempoMinimo = 0.0;
    private int offsetVideo = 0;
    private int fuso = 0;
    private int contatoreDatiSbagliati = 0;
    private List<DanasIRData> irData = new ArrayList<DanasIRData>();
    private Vector<DanasLap> laps = new Vector();
    double[] resMath;
    double[] frequenzeCanali = new double[DanasDataStructureConstants.ValueType.values().length];
    ArrayDouble[] valoriCanali = new ArrayDouble[DanasDataStructureConstants.ValueType.values().length];
    double[] tempiIniziali = new double[DanasDataStructureConstants.ValueType.values().length];
    String[] pathCanali = new String[DanasDataStructureConstants.ValueType.values().length];
    double risoluzioneTemporale = 0.05;
    List<Double> canaleSpazio;
    List<Integer> canalePosizioniStechio;
    List<Boolean> canaleUsaInStechio;
    int[] dimensioniPerFrequenza;
    double tempoPrimoDato = 0.0;
    boolean datiFormatoVecchio = false;
    double tempoAttualeGps = 0.0;
    boolean sessioneVuota = true;
    boolean giriManuali = false;
    boolean angoliCalcolati = false;
    List<Double> listaTempiManuali = new ArrayList<Double>();
    boolean settaggioInterno = false;
    boolean[] canaliAnalizzati = new boolean[DanasDataStructureConstants.ValueType.values().length];
    double percentualeGasAperto = 0.0;
    double percentualeM1 = 0.0;
    double percentualeM2 = 0.0;
    double percentualeM3 = 0.0;
    double percentualeM4 = 0.0;
    String[] formuleMath = new String[]{"0", "0", "0", "0", "0", "0", "0", "0", "0", "0"};
    Reader reader = null;
    private DanasSessionSettings sessionSettings = new DanasSessionSettings();
    private List<DanasValueData> values = new ArrayList<DanasValueData>();
    private double[][] GenericValueAnalisys = new double[DanasDataStructureConstants.ValueType.values().length][3];
    private Vector<GearValueTime> gears;
    private GearValueTime[] gears_found = null;

    public DanasSession() {
        this.inizializzaVariabili();
        this.azzeraCanaliAnalizzati();
    }

    public void inizializzaVariabili() {
        for (int i = 0; i < this.frequenzeCanali.length; ++i) {
            this.frequenzeCanali[i] = 0.0;
            this.tempiIniziali[i] = Double.MAX_VALUE;
            this.pathCanali[i] = "";
        }
    }

    public void setGiriManual(boolean manuali) {
        this.giriManuali = manuali;
    }

    public boolean getGiriManual() {
        return this.getAllIRData().size() != 0;
    }

    public void setOffsetVideoSessione(int offset) {
        this.offsetVideo = offset;
    }

    public int getOffsetVideoSessione() {
        return this.offsetVideo;
    }

    public void setFusoSessione(int valore) {
        this.fuso = valore;
    }

    public int getFusoSessione() {
        return this.fuso;
    }

    public double getMaxFrequenza() {
        double frequenza = 0.0;
        for (int i = 0; i < this.frequenzeCanali.length; ++i) {
            if (!(this.frequenzeCanali[i] > frequenza)) continue;
            frequenza = this.frequenzeCanali[i];
        }
        return frequenza;
    }

    public void cacheCanali(boolean forzaTutti) {
        boolean[] canaliUtilizzati = DanasDataStructure.getInstance().getTuttiCanaliUtilizzati();
        for (int i = 0; i < canaliUtilizzati.length; ++i) {
            if (canaliUtilizzati[i] && !forzaTutti || this.frequenzeCanali[i] == 0.0) continue;
            if (this.pathCanali[i] == "") {
                this.pathCanali[i] = this.cacheCanale(DanasDataStructureConstants.ValueType.values()[i]);
            }
            if (this.valoriCanali[i] == null) continue;
            this.valoriCanali[i].clear();
        }
    }

    public ArrayDouble getValori(DanasDataStructureConstants.ValueType vt) {
        return this.valoriCanali[vt.ordinal()];
    }

    public void setDatiFormatoVecchio(boolean formatoVecchio) {
        this.datiFormatoVecchio = formatoVecchio;
    }

    public boolean isDatiFormatoVecchio() {
        return this.datiFormatoVecchio;
    }

    public void trasformaDatiVecchi() {
        if (!this.datiFormatoVecchio) {
            return;
        }
        int campionamento = this.getTempoCampionamentoOld();
        if (campionamento == -1) {
            return;
        }
        double frequenza = 100.0;
        if (campionamento == 0) {
            campionamento = 1;
        }
        if (campionamento == 1) {
            frequenza = 100.0;
        }
        if (campionamento > 1 && campionamento < 4) {
            frequenza = 50.0;
        }
        if (campionamento > 3 && campionamento < 7) {
            frequenza = 20.0;
        }
        if (campionamento > 6 && campionamento < 15) {
            frequenza = 10.0;
        }
        if (campionamento > 14 && campionamento < 25) {
            frequenza = 5.0;
        }
        if (campionamento > 24) {
            frequenza = 1.0;
        }
        System.out.println("Log:Traformo " + this.values.size() + " dati del vecchio formato, frequenza trovata=" + frequenza + "Hz");
        this.sessioneVuota = false;
        this.setFrequenzaFormatoVecchio(frequenza);
        this.inizializzaListeFormatoVecchio();
        double tempoAttuale = 0.0;
        int ultimoIndiceMulti = 0;
        int ultimoIndiceTPMS = 0;
        for (int i = 0; i < this.values.size(); ++i) {
            DanasValueData v = this.values.get(i);
            if (i == 0) {
                tempoAttuale = v.getTelemetryTime();
            }
            if (this.valoriCanali[DanasDataStructureConstants.ValueType.RPM.ordinal()].size() == 0) {
                this.setTempoInizialeFormatoVecchio(tempoAttuale);
            }
            double deltaTempoOk = 100.0 / this.frequenzeCanali[DanasDataStructureConstants.ValueType.RPM.ordinal()] + 0.5;
            if (v.getTelemetryTime() > tempoAttuale + deltaTempoOk && v.getTelemetryTime() < tempoAttuale + 1000.0) {
                System.out.println("DEBUG:saltato tempo, ultimo tempo=" + tempoAttuale + " attuale=" + v.getTelemetryTime());
                int campioniAggiunti = 1;
                if (i != 0) {
                    while (tempoAttuale + (double)(campioniAggiunti * 100) / this.frequenzeCanali[DanasDataStructureConstants.ValueType.RPM.ordinal()] + 0.5 < v.getTelemetryTime()) {
                        this.scriviValueFormatoVecchio100Hz(this.values.get(i - 1));
                        this.duplicaUltimoValoreFormatoVecchioMulti(ultimoIndiceMulti, campioniAggiunti);
                        this.duplicaUltimoValoreFormatoVecchioTPMS(ultimoIndiceTPMS, campioniAggiunti);
                        ++campioniAggiunti;
                    }
                }
            }
            double deltaTempoCambioOra = 0.0;
            if (v.getTelemetryTime() > tempoAttuale + 1000.0) {
                int indice;
                deltaTempoCambioOra = v.getTelemetryTime() - tempoAttuale + 100.0 / this.frequenzeCanali[DanasDataStructureConstants.ValueType.RPM.ordinal()];
                this.setTempoInizialeFormatoVecchio(this.tempiIniziali[DanasDataStructureConstants.ValueType.RPM.ordinal()] + deltaTempoCambioOra);
                for (indice = 0; indice < 10; ++indice) {
                    if (this.valoriCanali[DanasDataStructureConstants.ValueType.MULTI.ordinal() + indice].size() == 0) continue;
                    this.tempiIniziali[DanasDataStructureConstants.ValueType.MULTI.ordinal() + indice] = this.tempiIniziali[DanasDataStructureConstants.ValueType.MULTI.ordinal() + indice] + deltaTempoCambioOra;
                }
                for (indice = 0; indice < 4; ++indice) {
                    if (this.valoriCanali[DanasDataStructureConstants.ValueType.P_ANT.ordinal() + indice].size() == 0) continue;
                    this.tempiIniziali[DanasDataStructureConstants.ValueType.P_ANT.ordinal() + indice] = this.tempiIniziali[DanasDataStructureConstants.ValueType.P_ANT.ordinal() + indice] + deltaTempoCambioOra;
                }
            }
            tempoAttuale = v.getTelemetryTime();
            this.scriviValueFormatoVecchio100Hz(v);
            ultimoIndiceMulti = this.scriviValueFormatoVecchio10HzMulti(v);
            ultimoIndiceTPMS = this.scriviValueFormatoVecchio10HzTPMS(v);
        }
        this.values.clear();
    }

    public void duplicaUltimoValoreFormatoVecchioMulti(int ulitmoIndiceVisto, int indiceAttuale) {
        int indiceTotale = (ulitmoIndiceVisto + indiceAttuale) % 10;
        if (this.valoriCanali[DanasDataStructureConstants.ValueType.MULTI.ordinal() + indiceTotale].size() == 0) {
            return;
        }
        int dimensione = this.valoriCanali[DanasDataStructureConstants.ValueType.MULTI.ordinal() + indiceTotale].size();
        double ultimoValore = this.valoriCanali[DanasDataStructureConstants.ValueType.MULTI.ordinal() + indiceTotale].get(dimensione - 1);
        this.valoriCanali[DanasDataStructureConstants.ValueType.MULTI.ordinal() + indiceTotale].add(ultimoValore);
    }

    public void duplicaUltimoValoreFormatoVecchioTPMS(int ulitmoIndiceVisto, int indiceAttuale) {
        int indiceTotale = (ulitmoIndiceVisto + indiceAttuale) % 10;
        if (indiceTotale >= 4) {
            return;
        }
        if (this.frequenzeCanali[DanasDataStructureConstants.ValueType.P_ANT.ordinal() + indiceTotale] == 0.0) {
            return;
        }
        if (this.valoriCanali[DanasDataStructureConstants.ValueType.P_ANT.ordinal() + indiceTotale].size() == 0) {
            return;
        }
        int dimensione = this.valoriCanali[DanasDataStructureConstants.ValueType.P_ANT.ordinal() + indiceTotale].size();
        double ultimoValore = this.valoriCanali[DanasDataStructureConstants.ValueType.P_ANT.ordinal() + indiceTotale].get(dimensione - 1);
        this.valoriCanali[DanasDataStructureConstants.ValueType.P_ANT.ordinal() + indiceTotale].add(ultimoValore);
    }

    public void scriviValueFormatoVecchio100Hz(DanasValueData v) {
        this.valoriCanali[DanasDataStructureConstants.ValueType.RPM.ordinal()].add(v.getRPM());
        this.valoriCanali[DanasDataStructureConstants.ValueType.SPEED1.ordinal()].add(v.getSpeed1());
        this.valoriCanali[DanasDataStructureConstants.ValueType.SPEED2.ordinal()].add(v.getSpeed2());
        this.valoriCanali[DanasDataStructureConstants.ValueType.R_GEARS.ordinal()].add(MeasuresUtil.GearRatio(v, this.getSessionID()));
        this.valoriCanali[DanasDataStructureConstants.ValueType.GEARS.ordinal()].add(MeasuresUtil.GearRatio(v, this.getSessionID()));
        this.valoriCanali[DanasDataStructureConstants.ValueType.ANALOG1.ordinal()].add(v.getAnalogs(1));
        this.valoriCanali[DanasDataStructureConstants.ValueType.ANALOG2.ordinal()].add(v.getAnalogs(2));
        this.valoriCanali[DanasDataStructureConstants.ValueType.ANALOG3.ordinal()].add(v.getAnalogs(3));
        this.valoriCanali[DanasDataStructureConstants.ValueType.ANALOG4.ordinal()].add(v.getAnalogs(4));
        this.valoriCanali[DanasDataStructureConstants.ValueType.ANALOG5.ordinal()].add(v.getAnalogs(5));
        this.valoriCanali[DanasDataStructureConstants.ValueType.ANALOG6.ordinal()].add(v.getAnalogs(6));
        this.valoriCanali[DanasDataStructureConstants.ValueType.ANALOG7.ordinal()].add(v.getAnalogs(7));
        this.valoriCanali[DanasDataStructureConstants.ValueType.ANALOG8.ordinal()].add(v.getAnalogs(8));
        this.valoriCanali[DanasDataStructureConstants.ValueType.EXT1.ordinal()].add(v.getAnalogs(10));
        this.valoriCanali[DanasDataStructureConstants.ValueType.EXT2.ordinal()].add(v.getAnalogs(11));
        this.valoriCanali[DanasDataStructureConstants.ValueType.EXT3.ordinal()].add(v.getAnalogs(12));
        this.valoriCanali[DanasDataStructureConstants.ValueType.EXT4.ordinal()].add(v.getAnalogs(13));
        double speed1 = MeasuresUtil.GenericDataConverter(v.getSpeed1(), DanasDataStructureConstants.ValueType.SPEED1, this);
        double speed2 = MeasuresUtil.GenericDataConverter(v.getSpeed2(), DanasDataStructureConstants.ValueType.SPEED2, this);
        this.valoriCanali[DanasDataStructureConstants.ValueType.SLIP.ordinal()].add(100.0 * (speed1 - speed2) / speed1);
        this.valoriCanali[DanasDataStructureConstants.ValueType.HEART.ordinal()].add(v.getBattito());
        if (this.valoriCanali[DanasDataStructureConstants.ValueType.RPM.ordinal()].size() == 1) {
            this.valoriCanali[DanasDataStructureConstants.ValueType.dRPM.ordinal()].add(0.0);
            this.valoriCanali[DanasDataStructureConstants.ValueType.dSPEED1.ordinal()].add(0.0);
            this.valoriCanali[DanasDataStructureConstants.ValueType.dSPEED2.ordinal()].add(0.0);
            this.valoriCanali[DanasDataStructureConstants.ValueType.dANALOG1.ordinal()].add(0.0);
            this.valoriCanali[DanasDataStructureConstants.ValueType.dANALOG2.ordinal()].add(0.0);
            this.valoriCanali[DanasDataStructureConstants.ValueType.dANALOG3.ordinal()].add(0.0);
            this.valoriCanali[DanasDataStructureConstants.ValueType.dANALOG4.ordinal()].add(0.0);
            this.valoriCanali[DanasDataStructureConstants.ValueType.dANALOG5.ordinal()].add(0.0);
            this.valoriCanali[DanasDataStructureConstants.ValueType.dANALOG6.ordinal()].add(0.0);
            this.valoriCanali[DanasDataStructureConstants.ValueType.dANALOG7.ordinal()].add(0.0);
            this.valoriCanali[DanasDataStructureConstants.ValueType.dANALOG8.ordinal()].add(0.0);
            this.valoriCanali[DanasDataStructureConstants.ValueType.dEXT1.ordinal()].add(0.0);
            this.valoriCanali[DanasDataStructureConstants.ValueType.dEXT2.ordinal()].add(0.0);
            this.valoriCanali[DanasDataStructureConstants.ValueType.dEXT3.ordinal()].add(0.0);
            this.valoriCanali[DanasDataStructureConstants.ValueType.dEXT4.ordinal()].add(0.0);
        } else {
            int dimensione = this.valoriCanali[DanasDataStructureConstants.ValueType.SPEED1.ordinal()].size();
            double valore1 = MeasuresUtil.GenericDataConverter(this.valoriCanali[DanasDataStructureConstants.ValueType.RPM.ordinal()].get(dimensione - 1), DanasDataStructureConstants.ValueType.RPM, this);
            double valore2 = MeasuresUtil.GenericDataConverter(this.valoriCanali[DanasDataStructureConstants.ValueType.RPM.ordinal()].get(dimensione - 2), DanasDataStructureConstants.ValueType.RPM, this);
            this.valoriCanali[DanasDataStructureConstants.ValueType.dRPM.ordinal()].add((valore1 - valore2) * this.frequenzeCanali[DanasDataStructureConstants.ValueType.RPM.ordinal()]);
            valore1 = MeasuresUtil.GenericDataConverter(this.valoriCanali[DanasDataStructureConstants.ValueType.SPEED1.ordinal()].get(dimensione - 1), DanasDataStructureConstants.ValueType.SPEED1, this);
            valore2 = MeasuresUtil.GenericDataConverter(this.valoriCanali[DanasDataStructureConstants.ValueType.SPEED1.ordinal()].get(dimensione - 2), DanasDataStructureConstants.ValueType.SPEED1, this);
            this.valoriCanali[DanasDataStructureConstants.ValueType.dSPEED1.ordinal()].add((valore1 - valore2) * this.frequenzeCanali[DanasDataStructureConstants.ValueType.SPEED1.ordinal()]);
            valore1 = MeasuresUtil.GenericDataConverter(this.valoriCanali[DanasDataStructureConstants.ValueType.SPEED2.ordinal()].get(dimensione - 1), DanasDataStructureConstants.ValueType.SPEED2, this);
            valore2 = MeasuresUtil.GenericDataConverter(this.valoriCanali[DanasDataStructureConstants.ValueType.SPEED2.ordinal()].get(dimensione - 2), DanasDataStructureConstants.ValueType.SPEED2, this);
            this.valoriCanali[DanasDataStructureConstants.ValueType.dSPEED2.ordinal()].add((valore1 - valore2) * this.frequenzeCanali[DanasDataStructureConstants.ValueType.SPEED2.ordinal()]);
            this.valoriCanali[DanasDataStructureConstants.ValueType.dANALOG1.ordinal()].add((this.valoriCanali[DanasDataStructureConstants.ValueType.ANALOG1.ordinal()].get(dimensione - 1) - this.valoriCanali[DanasDataStructureConstants.ValueType.ANALOG1.ordinal()].get(dimensione - 2)) * this.frequenzeCanali[DanasDataStructureConstants.ValueType.ANALOG1.ordinal()]);
            this.valoriCanali[DanasDataStructureConstants.ValueType.dANALOG2.ordinal()].add((this.valoriCanali[DanasDataStructureConstants.ValueType.ANALOG2.ordinal()].get(dimensione - 1) - this.valoriCanali[DanasDataStructureConstants.ValueType.ANALOG2.ordinal()].get(dimensione - 2)) * this.frequenzeCanali[DanasDataStructureConstants.ValueType.ANALOG2.ordinal()]);
            this.valoriCanali[DanasDataStructureConstants.ValueType.dANALOG3.ordinal()].add((this.valoriCanali[DanasDataStructureConstants.ValueType.ANALOG3.ordinal()].get(dimensione - 1) - this.valoriCanali[DanasDataStructureConstants.ValueType.ANALOG3.ordinal()].get(dimensione - 2)) * this.frequenzeCanali[DanasDataStructureConstants.ValueType.ANALOG3.ordinal()]);
            this.valoriCanali[DanasDataStructureConstants.ValueType.dANALOG4.ordinal()].add((this.valoriCanali[DanasDataStructureConstants.ValueType.ANALOG4.ordinal()].get(dimensione - 1) - this.valoriCanali[DanasDataStructureConstants.ValueType.ANALOG4.ordinal()].get(dimensione - 2)) * this.frequenzeCanali[DanasDataStructureConstants.ValueType.ANALOG4.ordinal()]);
            this.valoriCanali[DanasDataStructureConstants.ValueType.dANALOG5.ordinal()].add((this.valoriCanali[DanasDataStructureConstants.ValueType.ANALOG5.ordinal()].get(dimensione - 1) - this.valoriCanali[DanasDataStructureConstants.ValueType.ANALOG5.ordinal()].get(dimensione - 2)) * this.frequenzeCanali[DanasDataStructureConstants.ValueType.ANALOG5.ordinal()]);
            this.valoriCanali[DanasDataStructureConstants.ValueType.dANALOG6.ordinal()].add((this.valoriCanali[DanasDataStructureConstants.ValueType.ANALOG6.ordinal()].get(dimensione - 1) - this.valoriCanali[DanasDataStructureConstants.ValueType.ANALOG6.ordinal()].get(dimensione - 2)) * this.frequenzeCanali[DanasDataStructureConstants.ValueType.ANALOG6.ordinal()]);
            this.valoriCanali[DanasDataStructureConstants.ValueType.dANALOG7.ordinal()].add((this.valoriCanali[DanasDataStructureConstants.ValueType.ANALOG7.ordinal()].get(dimensione - 1) - this.valoriCanali[DanasDataStructureConstants.ValueType.ANALOG7.ordinal()].get(dimensione - 2)) * this.frequenzeCanali[DanasDataStructureConstants.ValueType.ANALOG7.ordinal()]);
            this.valoriCanali[DanasDataStructureConstants.ValueType.dANALOG8.ordinal()].add((this.valoriCanali[DanasDataStructureConstants.ValueType.ANALOG8.ordinal()].get(dimensione - 1) - this.valoriCanali[DanasDataStructureConstants.ValueType.ANALOG8.ordinal()].get(dimensione - 2)) * this.frequenzeCanali[DanasDataStructureConstants.ValueType.ANALOG8.ordinal()]);
            this.valoriCanali[DanasDataStructureConstants.ValueType.dEXT1.ordinal()].add((this.valoriCanali[DanasDataStructureConstants.ValueType.EXT1.ordinal()].get(dimensione - 1) - this.valoriCanali[DanasDataStructureConstants.ValueType.EXT1.ordinal()].get(dimensione - 2)) * this.frequenzeCanali[DanasDataStructureConstants.ValueType.EXT1.ordinal()]);
            this.valoriCanali[DanasDataStructureConstants.ValueType.dEXT2.ordinal()].add((this.valoriCanali[DanasDataStructureConstants.ValueType.EXT2.ordinal()].get(dimensione - 1) - this.valoriCanali[DanasDataStructureConstants.ValueType.EXT2.ordinal()].get(dimensione - 2)) * this.frequenzeCanali[DanasDataStructureConstants.ValueType.EXT2.ordinal()]);
            this.valoriCanali[DanasDataStructureConstants.ValueType.dEXT3.ordinal()].add((this.valoriCanali[DanasDataStructureConstants.ValueType.EXT3.ordinal()].get(dimensione - 1) - this.valoriCanali[DanasDataStructureConstants.ValueType.EXT3.ordinal()].get(dimensione - 2)) * this.frequenzeCanali[DanasDataStructureConstants.ValueType.EXT3.ordinal()]);
            this.valoriCanali[DanasDataStructureConstants.ValueType.dEXT4.ordinal()].add((this.valoriCanali[DanasDataStructureConstants.ValueType.EXT4.ordinal()].get(dimensione - 1) - this.valoriCanali[DanasDataStructureConstants.ValueType.EXT4.ordinal()].get(dimensione - 2)) * this.frequenzeCanali[DanasDataStructureConstants.ValueType.EXT4.ordinal()]);
        }
    }

    public void scriviRitardo(double ritardo, int indice) {
        if (this.frequenzeCanali[DanasDataStructureConstants.ValueType.DELAY.ordinal()] == 0.0) {
            return;
        }
        if (indice >= this.valoriCanali[DanasDataStructureConstants.ValueType.DELAY.ordinal()].size()) {
            return;
        }
        this.valoriCanali[DanasDataStructureConstants.ValueType.DELAY.ordinal()].set(indice, ritardo);
    }

    public void scriviDDS(double valoreDds, int indice) {
        if (this.frequenzeCanali[DanasDataStructureConstants.ValueType.DDS.ordinal()] == 0.0) {
            return;
        }
        if (indice >= this.valoriCanali[DanasDataStructureConstants.ValueType.DDS.ordinal()].size()) {
            return;
        }
        this.valoriCanali[DanasDataStructureConstants.ValueType.DDS.ordinal()].set(indice, valoreDds);
    }

    public void setArrayDimensioni(int[] dimensioni) {
        this.dimensioniPerFrequenza = dimensioni;
    }

    public boolean isCanaleUsato(DanasDataStructureConstants.ValueType vt) {
        return this.frequenzeCanali[vt.ordinal()] != 0.0;
    }

    public void ricalcolaDerivateDigitali() {
        double valore2;
        double valore1;
        int i;
        if (this.frequenzeCanali[DanasDataStructureConstants.ValueType.RPM.ordinal()] != 0.0) {
            this.valoriCanali[DanasDataStructureConstants.ValueType.dRPM.ordinal()].clear();
            this.valoriCanali[DanasDataStructureConstants.ValueType.dRPM.ordinal()].add(0.0);
            for (i = 1; i < this.valoriCanali[DanasDataStructureConstants.ValueType.RPM.ordinal()].size(); ++i) {
                valore1 = MeasuresUtil.GenericDataConverter(this.valoriCanali[DanasDataStructureConstants.ValueType.RPM.ordinal()].get(i), DanasDataStructureConstants.ValueType.RPM, this);
                valore2 = MeasuresUtil.GenericDataConverter(this.valoriCanali[DanasDataStructureConstants.ValueType.RPM.ordinal()].get(i - 1), DanasDataStructureConstants.ValueType.RPM, this);
                this.valoriCanali[DanasDataStructureConstants.ValueType.dRPM.ordinal()].add((valore1 - valore2) * this.frequenzeCanali[DanasDataStructureConstants.ValueType.RPM.ordinal()]);
            }
        }
        if (this.frequenzeCanali[DanasDataStructureConstants.ValueType.SPEED1.ordinal()] != 0.0) {
            this.valoriCanali[DanasDataStructureConstants.ValueType.dSPEED1.ordinal()].clear();
            this.valoriCanali[DanasDataStructureConstants.ValueType.dSPEED1.ordinal()].add(0.0);
            for (i = 1; i < this.valoriCanali[DanasDataStructureConstants.ValueType.SPEED1.ordinal()].size(); ++i) {
                valore1 = MeasuresUtil.GenericDataConverter(this.valoriCanali[DanasDataStructureConstants.ValueType.SPEED1.ordinal()].get(i), DanasDataStructureConstants.ValueType.SPEED1, this);
                valore2 = MeasuresUtil.GenericDataConverter(this.valoriCanali[DanasDataStructureConstants.ValueType.SPEED1.ordinal()].get(i - 1), DanasDataStructureConstants.ValueType.SPEED1, this);
                this.valoriCanali[DanasDataStructureConstants.ValueType.dSPEED1.ordinal()].add((valore1 - valore2) * this.frequenzeCanali[DanasDataStructureConstants.ValueType.SPEED1.ordinal()]);
            }
        }
        if (this.frequenzeCanali[DanasDataStructureConstants.ValueType.SPEED2.ordinal()] != 0.0) {
            this.valoriCanali[DanasDataStructureConstants.ValueType.dSPEED2.ordinal()].clear();
            this.valoriCanali[DanasDataStructureConstants.ValueType.dSPEED2.ordinal()].add(0.0);
            for (i = 1; i < this.valoriCanali[DanasDataStructureConstants.ValueType.SPEED2.ordinal()].size(); ++i) {
                valore1 = MeasuresUtil.GenericDataConverter(this.valoriCanali[DanasDataStructureConstants.ValueType.SPEED2.ordinal()].get(i), DanasDataStructureConstants.ValueType.SPEED2, this);
                valore2 = MeasuresUtil.GenericDataConverter(this.valoriCanali[DanasDataStructureConstants.ValueType.SPEED2.ordinal()].get(i - 1), DanasDataStructureConstants.ValueType.SPEED2, this);
                this.valoriCanali[DanasDataStructureConstants.ValueType.dSPEED2.ordinal()].add((valore1 - valore2) * this.frequenzeCanali[DanasDataStructureConstants.ValueType.SPEED2.ordinal()]);
            }
        }
    }

    public void ricalcolaValoriSlip(boolean refresh) {
        if (!refresh && this.pignone1 == this.sessionSettings.getPinion(1) && this.corona1 == this.sessionSettings.getGearTeeth(1) && this.circonferenza1 == this.sessionSettings.getCircumference(1) && this.pignone2 == this.sessionSettings.getPinion(2) && this.corona2 == this.sessionSettings.getGearTeeth(2) && this.circonferenza2 == this.sessionSettings.getCircumference(2)) {
            return;
        }
        this.pignone1 = this.sessionSettings.getPinion(1);
        this.corona1 = this.sessionSettings.getGearTeeth(1);
        this.circonferenza1 = this.sessionSettings.getCircumference(1);
        this.pignone2 = this.sessionSettings.getPinion(2);
        this.corona2 = this.sessionSettings.getGearTeeth(2);
        this.circonferenza2 = this.sessionSettings.getCircumference(2);
        if (this.valoriCanali[DanasDataStructureConstants.ValueType.SLIP.ordinal()] != null) {
            this.valoriCanali[DanasDataStructureConstants.ValueType.SLIP.ordinal()].clear();
        } else {
            this.valoriCanali[DanasDataStructureConstants.ValueType.SLIP.ordinal()] = new ArrayDouble();
        }
        DanasDataStructureConstants.ValueType canale = DanasDataStructureConstants.ValueType.SPEED1;
        double frequenza = this.frequenzeCanali[DanasDataStructureConstants.ValueType.SPEED1.ordinal()];
        if (this.frequenzeCanali[DanasDataStructureConstants.ValueType.SPEED2.ordinal()] > frequenza) {
            frequenza = this.frequenzeCanali[DanasDataStructureConstants.ValueType.SPEED2.ordinal()];
            canale = DanasDataStructureConstants.ValueType.SPEED2;
        }
        this.frequenzeCanali[DanasDataStructureConstants.ValueType.SLIP.ordinal()] = frequenza;
        this.tempiIniziali[DanasDataStructureConstants.ValueType.SLIP.ordinal()] = this.tempiIniziali[canale.ordinal()];
        ArrayDouble valoriSpeed1 = this.getAllValueData(DanasDataStructureConstants.ValueType.SPEED1, true);
        ArrayDouble valoriSpeed2 = this.getAllValueData(DanasDataStructureConstants.ValueType.SPEED2, true);
        for (int i = 0; i < this.valoriCanali[canale.ordinal()].size(); ++i) {
            double tempo = this.tempiIniziali[canale.ordinal()] + (double)i * 100.0 / frequenza;
            double speed1 = valoriSpeed1.get(this.getIndiceAtTime(DanasDataStructureConstants.ValueType.SPEED1, tempo, DanasDataStructureConstants.BoundLap.NEAREST));
            double speed2 = valoriSpeed2.get(this.getIndiceAtTime(DanasDataStructureConstants.ValueType.SPEED2, tempo, DanasDataStructureConstants.BoundLap.NEAREST));
            if (speed2 == 0.0) {
                this.valoriCanali[DanasDataStructureConstants.ValueType.SLIP.ordinal()].add(0.0);
                continue;
            }
            this.valoriCanali[DanasDataStructureConstants.ValueType.SLIP.ordinal()].add(100.0 * (speed1 - speed2) / speed1);
        }
        if (this.valoriCanali[DanasDataStructureConstants.ValueType.R_GEARS.ordinal()] != null) {
            this.valoriCanali[DanasDataStructureConstants.ValueType.R_GEARS.ordinal()].clear();
            this.valoriCanali[DanasDataStructureConstants.ValueType.GEARS.ordinal()].clear();
        } else {
            this.valoriCanali[DanasDataStructureConstants.ValueType.R_GEARS.ordinal()] = new ArrayDouble();
            this.valoriCanali[DanasDataStructureConstants.ValueType.GEARS.ordinal()] = new ArrayDouble();
        }
        DanasDataStructureConstants.ValueType canaleG = DanasDataStructureConstants.ValueType.SPEED1;
        double frequenzaG = this.frequenzeCanali[DanasDataStructureConstants.ValueType.SPEED1.ordinal()];
        if (this.frequenzeCanali[DanasDataStructureConstants.ValueType.RPM.ordinal()] > frequenzaG) {
            frequenzaG = this.frequenzeCanali[DanasDataStructureConstants.ValueType.RPM.ordinal()];
            canaleG = DanasDataStructureConstants.ValueType.RPM;
        }
        this.frequenzeCanali[DanasDataStructureConstants.ValueType.R_GEARS.ordinal()] = frequenzaG;
        this.frequenzeCanali[DanasDataStructureConstants.ValueType.GEARS.ordinal()] = frequenzaG;
        this.tempiIniziali[DanasDataStructureConstants.ValueType.R_GEARS.ordinal()] = this.tempiIniziali[canaleG.ordinal()];
        this.tempiIniziali[DanasDataStructureConstants.ValueType.GEARS.ordinal()] = this.tempiIniziali[canaleG.ordinal()];
        ArrayDouble valoriSpeed_1 = this.getAllValueData(DanasDataStructureConstants.ValueType.SPEED1, true);
        ArrayDouble valoriRpm = this.getAllValueData(DanasDataStructureConstants.ValueType.RPM, true);
        for (int i = 0; i < this.valoriCanali[canaleG.ordinal()].size(); ++i) {
            double tempo = this.tempiIniziali[canaleG.ordinal()] + (double)i * 100.0 / frequenzaG;
            double speed1 = valoriSpeed_1.get(this.getIndiceAtTime(DanasDataStructureConstants.ValueType.SPEED1, tempo, DanasDataStructureConstants.BoundLap.NEAREST)) / 3600.0 * 1000.0 / (double)this.circonferenza1 * (double)this.corona1 / (double)this.pignone1 * 1000.0;
            double rpm = valoriRpm.get(this.getIndiceAtTime(DanasDataStructureConstants.ValueType.RPM, tempo, DanasDataStructureConstants.BoundLap.NEAREST)) / 60.0;
            double rapporto = rpm / speed1;
            if (rapporto > 10000.0) {
                rapporto = 0.0;
            }
            this.valoriCanali[DanasDataStructureConstants.ValueType.R_GEARS.ordinal()].add(MeasuresUtil.getRapportoPulito(-rapporto));
            this.valoriCanali[DanasDataStructureConstants.ValueType.GEARS.ordinal()].add(MeasuresUtil.getRapportoPulito(-rapporto));
        }
    }

    public void aggiungiValorePro(DanasDataStructureConstants.ValueType vt, double tempo, double frequenza, double valore) {
        this.sessioneVuota = false;
        if (this.frequenzeCanali[vt.ordinal()] == 0.0) {
            this.frequenzeCanali[vt.ordinal()] = frequenza;
            this.tempiIniziali[vt.ordinal()] = tempo;
            this.valoriCanali[vt.ordinal()] = new ArrayDouble();
            this.valoriCanali[vt.ordinal()].add(valore);
            switch (vt) {
                case RPM: {
                    this.valoriCanali[DanasDataStructureConstants.ValueType.dRPM.ordinal()] = new ArrayDouble();
                    this.tempiIniziali[DanasDataStructureConstants.ValueType.dRPM.ordinal()] = tempo;
                    this.frequenzeCanali[DanasDataStructureConstants.ValueType.dRPM.ordinal()] = frequenza;
                }
                case SPEED1: {
                    this.valoriCanali[DanasDataStructureConstants.ValueType.dSPEED1.ordinal()] = new ArrayDouble();
                    this.tempiIniziali[DanasDataStructureConstants.ValueType.dSPEED1.ordinal()] = tempo;
                    this.frequenzeCanali[DanasDataStructureConstants.ValueType.dSPEED1.ordinal()] = frequenza;
                    break;
                }
                case SPEED2: {
                    this.valoriCanali[DanasDataStructureConstants.ValueType.dSPEED2.ordinal()] = new ArrayDouble();
                    this.tempiIniziali[DanasDataStructureConstants.ValueType.dSPEED2.ordinal()] = tempo;
                    this.frequenzeCanali[DanasDataStructureConstants.ValueType.dSPEED2.ordinal()] = frequenza;
                    break;
                }
                case ANALOG1: {
                    this.valoriCanali[DanasDataStructureConstants.ValueType.dANALOG1.ordinal()] = new ArrayDouble();
                    this.tempiIniziali[DanasDataStructureConstants.ValueType.dANALOG1.ordinal()] = tempo;
                    this.frequenzeCanali[DanasDataStructureConstants.ValueType.dANALOG1.ordinal()] = frequenza;
                    break;
                }
                case ANALOG2: {
                    this.valoriCanali[DanasDataStructureConstants.ValueType.dANALOG2.ordinal()] = new ArrayDouble();
                    this.tempiIniziali[DanasDataStructureConstants.ValueType.dANALOG2.ordinal()] = tempo;
                    this.frequenzeCanali[DanasDataStructureConstants.ValueType.dANALOG2.ordinal()] = frequenza;
                    break;
                }
                case ANALOG3: {
                    this.valoriCanali[DanasDataStructureConstants.ValueType.dANALOG3.ordinal()] = new ArrayDouble();
                    this.tempiIniziali[DanasDataStructureConstants.ValueType.dANALOG3.ordinal()] = tempo;
                    this.frequenzeCanali[DanasDataStructureConstants.ValueType.dANALOG3.ordinal()] = frequenza;
                    break;
                }
                case ANALOG4: {
                    this.valoriCanali[DanasDataStructureConstants.ValueType.dANALOG4.ordinal()] = new ArrayDouble();
                    this.tempiIniziali[DanasDataStructureConstants.ValueType.dANALOG4.ordinal()] = tempo;
                    this.frequenzeCanali[DanasDataStructureConstants.ValueType.dANALOG4.ordinal()] = frequenza;
                    break;
                }
                case ANALOG5: {
                    this.valoriCanali[DanasDataStructureConstants.ValueType.dANALOG5.ordinal()] = new ArrayDouble();
                    this.tempiIniziali[DanasDataStructureConstants.ValueType.dANALOG5.ordinal()] = tempo;
                    this.frequenzeCanali[DanasDataStructureConstants.ValueType.dANALOG5.ordinal()] = frequenza;
                    break;
                }
                case ANALOG6: {
                    this.valoriCanali[DanasDataStructureConstants.ValueType.dANALOG6.ordinal()] = new ArrayDouble();
                    this.tempiIniziali[DanasDataStructureConstants.ValueType.dANALOG6.ordinal()] = tempo;
                    this.frequenzeCanali[DanasDataStructureConstants.ValueType.dANALOG6.ordinal()] = frequenza;
                    break;
                }
                case ANALOG7: {
                    this.valoriCanali[DanasDataStructureConstants.ValueType.dANALOG7.ordinal()] = new ArrayDouble();
                    this.tempiIniziali[DanasDataStructureConstants.ValueType.dANALOG7.ordinal()] = tempo;
                    this.frequenzeCanali[DanasDataStructureConstants.ValueType.dANALOG7.ordinal()] = frequenza;
                    break;
                }
                case ANALOG8: {
                    this.valoriCanali[DanasDataStructureConstants.ValueType.dANALOG8.ordinal()] = new ArrayDouble();
                    this.tempiIniziali[DanasDataStructureConstants.ValueType.dANALOG8.ordinal()] = tempo;
                    this.frequenzeCanali[DanasDataStructureConstants.ValueType.dANALOG8.ordinal()] = frequenza;
                    break;
                }
                case EXT1: {
                    this.valoriCanali[DanasDataStructureConstants.ValueType.dEXT1.ordinal()] = new ArrayDouble();
                    this.tempiIniziali[DanasDataStructureConstants.ValueType.dEXT1.ordinal()] = tempo;
                    this.frequenzeCanali[DanasDataStructureConstants.ValueType.dEXT1.ordinal()] = frequenza;
                    break;
                }
                case EXT2: {
                    this.valoriCanali[DanasDataStructureConstants.ValueType.dEXT2.ordinal()] = new ArrayDouble();
                    this.tempiIniziali[DanasDataStructureConstants.ValueType.dEXT2.ordinal()] = tempo;
                    this.frequenzeCanali[DanasDataStructureConstants.ValueType.dEXT2.ordinal()] = frequenza;
                    break;
                }
                case EXT3: {
                    this.valoriCanali[DanasDataStructureConstants.ValueType.dEXT3.ordinal()] = new ArrayDouble();
                    this.tempiIniziali[DanasDataStructureConstants.ValueType.dEXT3.ordinal()] = tempo;
                    this.frequenzeCanali[DanasDataStructureConstants.ValueType.dEXT3.ordinal()] = frequenza;
                    break;
                }
                case EXT4: {
                    this.valoriCanali[DanasDataStructureConstants.ValueType.dEXT4.ordinal()] = new ArrayDouble();
                    this.tempiIniziali[DanasDataStructureConstants.ValueType.dEXT4.ordinal()] = tempo;
                    this.frequenzeCanali[DanasDataStructureConstants.ValueType.dEXT4.ordinal()] = frequenza;
                    break;
                }
            }
        } else {
            int dimensione = this.valoriCanali[vt.ordinal()].size();
            double tempoAttuale = this.tempiIniziali[vt.ordinal()] + (double)((dimensione - 1) * 100) / frequenza;
            if (tempo <= tempoAttuale) {
                if (vt == DanasDataStructureConstants.ValueType.RPM) {
                    ++this.contatoreDatiSbagliati;
                    System.err.println("Contatore dati sbagliati=" + this.contatoreDatiSbagliati + " ---------------------------------------------------");
                    System.err.println("Ricevuto dato non in ordine al tempo:" + (tempo - this.tempiIniziali[vt.ordinal()]) + " assoluto=" + tempo);
                }
                return;
            }
            int campioniDaAggiungere = 0;
            double ultimoValore = this.valoriCanali[vt.ordinal()].get(dimensione - 1);
            if (tempo > tempoAttuale + 100.0 / frequenza * 1.5) {
                System.out.println("saltato tempo, ultimo tempo=" + tempoAttuale + " attuale=" + tempo);
                campioniDaAggiungere = (int)((tempo - tempoAttuale) / 100.0 * frequenza) - 1;
                for (int i = 0; i < campioniDaAggiungere; ++i) {
                    this.valoriCanali[vt.ordinal()].add(ultimoValore);
                }
            }
            this.valoriCanali[vt.ordinal()].add(valore);
            switch (vt) {
                case RPM: {
                    double valore1 = MeasuresUtil.GenericDataConverter(valore, DanasDataStructureConstants.ValueType.RPM, this);
                    double valore2 = MeasuresUtil.GenericDataConverter(ultimoValore, DanasDataStructureConstants.ValueType.RPM, this);
                    this.aggiungiCampioniMancanti(campioniDaAggiungere, DanasDataStructureConstants.ValueType.dRPM);
                    this.valoriCanali[DanasDataStructureConstants.ValueType.dRPM.ordinal()].add((valore1 - valore2) * frequenza);
                    break;
                }
                case SPEED1: {
                    double valore1 = MeasuresUtil.GenericDataConverter(valore, DanasDataStructureConstants.ValueType.SPEED1, this);
                    double valore2 = MeasuresUtil.GenericDataConverter(ultimoValore, DanasDataStructureConstants.ValueType.SPEED1, this);
                    this.aggiungiCampioniMancanti(campioniDaAggiungere, DanasDataStructureConstants.ValueType.dSPEED1);
                    this.valoriCanali[DanasDataStructureConstants.ValueType.dSPEED1.ordinal()].add((valore1 - valore2) * frequenza);
                    break;
                }
                case SPEED2: {
                    double valore1 = MeasuresUtil.GenericDataConverter(valore, DanasDataStructureConstants.ValueType.SPEED2, this);
                    double valore2 = MeasuresUtil.GenericDataConverter(ultimoValore, DanasDataStructureConstants.ValueType.SPEED2, this);
                    this.aggiungiCampioniMancanti(campioniDaAggiungere, DanasDataStructureConstants.ValueType.dSPEED2);
                    this.valoriCanali[DanasDataStructureConstants.ValueType.dSPEED2.ordinal()].add((valore1 - valore2) * frequenza);
                    break;
                }
                case ANALOG1: {
                    this.aggiungiCampioniMancanti(campioniDaAggiungere, DanasDataStructureConstants.ValueType.dANALOG1);
                    this.valoriCanali[DanasDataStructureConstants.ValueType.dANALOG1.ordinal()].add((valore - ultimoValore) * frequenza);
                    break;
                }
                case ANALOG2: {
                    this.aggiungiCampioniMancanti(campioniDaAggiungere, DanasDataStructureConstants.ValueType.dANALOG2);
                    this.valoriCanali[DanasDataStructureConstants.ValueType.dANALOG2.ordinal()].add((valore - ultimoValore) * frequenza);
                    break;
                }
                case ANALOG3: {
                    this.aggiungiCampioniMancanti(campioniDaAggiungere, DanasDataStructureConstants.ValueType.dANALOG3);
                    this.valoriCanali[DanasDataStructureConstants.ValueType.dANALOG3.ordinal()].add((valore - ultimoValore) * frequenza);
                    break;
                }
                case ANALOG4: {
                    this.aggiungiCampioniMancanti(campioniDaAggiungere, DanasDataStructureConstants.ValueType.dANALOG4);
                    this.valoriCanali[DanasDataStructureConstants.ValueType.dANALOG4.ordinal()].add((valore - ultimoValore) * frequenza);
                    break;
                }
                case ANALOG5: {
                    this.aggiungiCampioniMancanti(campioniDaAggiungere, DanasDataStructureConstants.ValueType.dANALOG5);
                    this.valoriCanali[DanasDataStructureConstants.ValueType.dANALOG5.ordinal()].add((valore - ultimoValore) * frequenza);
                    break;
                }
                case ANALOG6: {
                    this.aggiungiCampioniMancanti(campioniDaAggiungere, DanasDataStructureConstants.ValueType.dANALOG6);
                    this.valoriCanali[DanasDataStructureConstants.ValueType.dANALOG6.ordinal()].add((valore - ultimoValore) * frequenza);
                    break;
                }
                case ANALOG7: {
                    this.aggiungiCampioniMancanti(campioniDaAggiungere, DanasDataStructureConstants.ValueType.dANALOG7);
                    this.valoriCanali[DanasDataStructureConstants.ValueType.dANALOG7.ordinal()].add((valore - ultimoValore) * frequenza);
                    break;
                }
                case ANALOG8: {
                    this.aggiungiCampioniMancanti(campioniDaAggiungere, DanasDataStructureConstants.ValueType.dANALOG8);
                    this.valoriCanali[DanasDataStructureConstants.ValueType.dANALOG8.ordinal()].add((valore - ultimoValore) * frequenza);
                    break;
                }
                case EXT1: {
                    this.aggiungiCampioniMancanti(campioniDaAggiungere, DanasDataStructureConstants.ValueType.dEXT1);
                    this.valoriCanali[DanasDataStructureConstants.ValueType.dEXT1.ordinal()].add((valore - ultimoValore) * frequenza);
                    break;
                }
                case EXT2: {
                    this.aggiungiCampioniMancanti(campioniDaAggiungere, DanasDataStructureConstants.ValueType.dEXT2);
                    this.valoriCanali[DanasDataStructureConstants.ValueType.dEXT2.ordinal()].add((valore - ultimoValore) * frequenza);
                    break;
                }
                case EXT3: {
                    this.aggiungiCampioniMancanti(campioniDaAggiungere, DanasDataStructureConstants.ValueType.dEXT3);
                    this.valoriCanali[DanasDataStructureConstants.ValueType.dEXT3.ordinal()].add((valore - ultimoValore) * frequenza);
                    break;
                }
                case EXT4: {
                    this.aggiungiCampioniMancanti(campioniDaAggiungere, DanasDataStructureConstants.ValueType.dEXT4);
                    this.valoriCanali[DanasDataStructureConstants.ValueType.dEXT4.ordinal()].add((valore - ultimoValore) * frequenza);
                    break;
                }
            }
        }
    }

    public void aggiungiCampioniMancanti(int campioniDaAggiungere, DanasDataStructureConstants.ValueType vt) {
        double valore = 0.0;
        if (this.valoriCanali[vt.ordinal()].size() != 0) {
            valore = this.valoriCanali[vt.ordinal()].get(this.valoriCanali[vt.ordinal()].size() - 1);
        }
        for (int i = 0; i < campioniDaAggiungere; ++i) {
            this.valoriCanali[vt.ordinal()].add(valore);
        }
    }

    public int scriviValueFormatoVecchio10HzMulti(DanasValueData v) {
        int indice1 = (int)(v.getAnalogs(9) / 65535.0);
        double valore = v.getAnalogs(9) - (double)(65535 * (int)(v.getAnalogs(9) / 65535.0));
        if (this.valoriCanali[DanasDataStructureConstants.ValueType.MULTI.ordinal() + indice1].size() == 0) {
            this.tempiIniziali[DanasDataStructureConstants.ValueType.MULTI.ordinal() + indice1] = v.getTelemetryTime();
        }
        this.valoriCanali[DanasDataStructureConstants.ValueType.MULTI.ordinal() + indice1].add(valore);
        return indice1;
    }

    public int scriviValueFormatoVecchio10HzTPMS(DanasValueData v) {
        int indice = (int)(v.getCanaleMultiTpms() / 65535.0);
        if (v.getCanaleMultiTpms() != -1.0) {
            double valore = v.getCanaleMultiTpms() - (double)(65535 * (int)(v.getCanaleMultiTpms() / 65535.0));
            if (indice < 4) {
                if (this.frequenzeCanali[DanasDataStructureConstants.ValueType.P_ANT.ordinal() + indice] == 0.0) {
                    this.frequenzeCanali[DanasDataStructureConstants.ValueType.P_ANT.ordinal() + indice] = this.frequenzeCanali[DanasDataStructureConstants.ValueType.RPM.ordinal()] / 10.0;
                }
                if (this.valoriCanali[DanasDataStructureConstants.ValueType.P_ANT.ordinal() + indice].size() == 0) {
                    this.tempiIniziali[DanasDataStructureConstants.ValueType.P_ANT.ordinal() + indice] = v.getTelemetryTime();
                }
                this.valoriCanali[DanasDataStructureConstants.ValueType.P_ANT.ordinal() + indice].add(valore);
            }
        }
        return indice;
    }

    public void setFrequenzaFormatoVecchio(double frequenza) {
        int i;
        this.frequenzeCanali[DanasDataStructureConstants.ValueType.RPM.ordinal()] = frequenza;
        this.frequenzeCanali[DanasDataStructureConstants.ValueType.SPEED1.ordinal()] = frequenza;
        this.frequenzeCanali[DanasDataStructureConstants.ValueType.SPEED2.ordinal()] = frequenza;
        this.frequenzeCanali[DanasDataStructureConstants.ValueType.dRPM.ordinal()] = frequenza;
        this.frequenzeCanali[DanasDataStructureConstants.ValueType.dSPEED1.ordinal()] = frequenza;
        this.frequenzeCanali[DanasDataStructureConstants.ValueType.dSPEED2.ordinal()] = frequenza;
        for (i = DanasDataStructureConstants.ValueType.ANALOG1.ordinal(); i <= DanasDataStructureConstants.ValueType.ANALOG8.ordinal(); ++i) {
            this.frequenzeCanali[i] = frequenza;
        }
        for (i = DanasDataStructureConstants.ValueType.dANALOG1.ordinal(); i <= DanasDataStructureConstants.ValueType.dANALOG8.ordinal(); ++i) {
            this.frequenzeCanali[i] = frequenza;
        }
        for (i = DanasDataStructureConstants.ValueType.MULTI.ordinal(); i <= DanasDataStructureConstants.ValueType.MULTI10.ordinal(); ++i) {
            this.frequenzeCanali[i] = frequenza / 10.0;
        }
        this.frequenzeCanali[DanasDataStructureConstants.ValueType.EXT1.ordinal()] = frequenza;
        this.frequenzeCanali[DanasDataStructureConstants.ValueType.EXT2.ordinal()] = frequenza;
        this.frequenzeCanali[DanasDataStructureConstants.ValueType.EXT3.ordinal()] = frequenza;
        this.frequenzeCanali[DanasDataStructureConstants.ValueType.EXT4.ordinal()] = frequenza;
        this.frequenzeCanali[DanasDataStructureConstants.ValueType.dEXT1.ordinal()] = frequenza;
        this.frequenzeCanali[DanasDataStructureConstants.ValueType.dEXT2.ordinal()] = frequenza;
        this.frequenzeCanali[DanasDataStructureConstants.ValueType.dEXT3.ordinal()] = frequenza;
        this.frequenzeCanali[DanasDataStructureConstants.ValueType.dEXT4.ordinal()] = frequenza;
        this.frequenzeCanali[DanasDataStructureConstants.ValueType.HEART.ordinal()] = frequenza;
        this.frequenzeCanali[DanasDataStructureConstants.ValueType.GEARS.ordinal()] = frequenza;
        this.frequenzeCanali[DanasDataStructureConstants.ValueType.R_GEARS.ordinal()] = frequenza;
        this.frequenzeCanali[DanasDataStructureConstants.ValueType.SLIP.ordinal()] = frequenza;
    }

    public void inizializzaListeFormatoVecchio() {
        int i;
        this.valoriCanali[DanasDataStructureConstants.ValueType.RPM.ordinal()] = new ArrayDouble();
        this.valoriCanali[DanasDataStructureConstants.ValueType.SPEED1.ordinal()] = new ArrayDouble();
        this.valoriCanali[DanasDataStructureConstants.ValueType.SPEED2.ordinal()] = new ArrayDouble();
        this.valoriCanali[DanasDataStructureConstants.ValueType.dRPM.ordinal()] = new ArrayDouble();
        this.valoriCanali[DanasDataStructureConstants.ValueType.dSPEED1.ordinal()] = new ArrayDouble();
        this.valoriCanali[DanasDataStructureConstants.ValueType.dSPEED2.ordinal()] = new ArrayDouble();
        this.valoriCanali[DanasDataStructureConstants.ValueType.GEARS.ordinal()] = new ArrayDouble();
        this.valoriCanali[DanasDataStructureConstants.ValueType.R_GEARS.ordinal()] = new ArrayDouble();
        this.valoriCanali[DanasDataStructureConstants.ValueType.SLIP.ordinal()] = new ArrayDouble();
        for (i = DanasDataStructureConstants.ValueType.ANALOG1.ordinal(); i <= DanasDataStructureConstants.ValueType.ANALOG8.ordinal(); ++i) {
            this.valoriCanali[i] = new ArrayDouble();
        }
        for (i = DanasDataStructureConstants.ValueType.dANALOG1.ordinal(); i <= DanasDataStructureConstants.ValueType.dANALOG8.ordinal(); ++i) {
            this.valoriCanali[i] = new ArrayDouble();
        }
        for (i = DanasDataStructureConstants.ValueType.MULTI.ordinal(); i <= DanasDataStructureConstants.ValueType.MULTI10.ordinal(); ++i) {
            this.valoriCanali[i] = new ArrayDouble();
        }
        this.valoriCanali[DanasDataStructureConstants.ValueType.EXT1.ordinal()] = new ArrayDouble();
        this.valoriCanali[DanasDataStructureConstants.ValueType.EXT2.ordinal()] = new ArrayDouble();
        this.valoriCanali[DanasDataStructureConstants.ValueType.EXT3.ordinal()] = new ArrayDouble();
        this.valoriCanali[DanasDataStructureConstants.ValueType.EXT4.ordinal()] = new ArrayDouble();
        this.valoriCanali[DanasDataStructureConstants.ValueType.dEXT1.ordinal()] = new ArrayDouble();
        this.valoriCanali[DanasDataStructureConstants.ValueType.dEXT2.ordinal()] = new ArrayDouble();
        this.valoriCanali[DanasDataStructureConstants.ValueType.dEXT3.ordinal()] = new ArrayDouble();
        this.valoriCanali[DanasDataStructureConstants.ValueType.dEXT4.ordinal()] = new ArrayDouble();
        this.valoriCanali[DanasDataStructureConstants.ValueType.P_ANT.ordinal()] = new ArrayDouble();
        this.valoriCanali[DanasDataStructureConstants.ValueType.T_ANT.ordinal()] = new ArrayDouble();
        this.valoriCanali[DanasDataStructureConstants.ValueType.P_POST.ordinal()] = new ArrayDouble();
        this.valoriCanali[DanasDataStructureConstants.ValueType.T_POST.ordinal()] = new ArrayDouble();
        this.valoriCanali[DanasDataStructureConstants.ValueType.HEART.ordinal()] = new ArrayDouble();
    }

    public void setTempoInizialeFormatoVecchio(double tempo) {
        this.tempiIniziali[DanasDataStructureConstants.ValueType.RPM.ordinal()] = tempo;
        this.tempiIniziali[DanasDataStructureConstants.ValueType.SPEED1.ordinal()] = tempo;
        this.tempiIniziali[DanasDataStructureConstants.ValueType.SPEED2.ordinal()] = tempo;
        this.tempiIniziali[DanasDataStructureConstants.ValueType.GEARS.ordinal()] = tempo;
        this.tempiIniziali[DanasDataStructureConstants.ValueType.R_GEARS.ordinal()] = tempo;
        this.tempiIniziali[DanasDataStructureConstants.ValueType.ANALOG1.ordinal()] = tempo;
        this.tempiIniziali[DanasDataStructureConstants.ValueType.ANALOG2.ordinal()] = tempo;
        this.tempiIniziali[DanasDataStructureConstants.ValueType.ANALOG3.ordinal()] = tempo;
        this.tempiIniziali[DanasDataStructureConstants.ValueType.ANALOG4.ordinal()] = tempo;
        this.tempiIniziali[DanasDataStructureConstants.ValueType.ANALOG5.ordinal()] = tempo;
        this.tempiIniziali[DanasDataStructureConstants.ValueType.ANALOG6.ordinal()] = tempo;
        this.tempiIniziali[DanasDataStructureConstants.ValueType.ANALOG7.ordinal()] = tempo;
        this.tempiIniziali[DanasDataStructureConstants.ValueType.ANALOG8.ordinal()] = tempo;
        this.tempiIniziali[DanasDataStructureConstants.ValueType.EXT1.ordinal()] = tempo;
        this.tempiIniziali[DanasDataStructureConstants.ValueType.EXT2.ordinal()] = tempo;
        this.tempiIniziali[DanasDataStructureConstants.ValueType.EXT3.ordinal()] = tempo;
        this.tempiIniziali[DanasDataStructureConstants.ValueType.EXT4.ordinal()] = tempo;
        this.tempiIniziali[DanasDataStructureConstants.ValueType.SLIP.ordinal()] = tempo;
        this.tempiIniziali[DanasDataStructureConstants.ValueType.dRPM.ordinal()] = tempo;
        this.tempiIniziali[DanasDataStructureConstants.ValueType.dSPEED1.ordinal()] = tempo;
        this.tempiIniziali[DanasDataStructureConstants.ValueType.dSPEED2.ordinal()] = tempo;
        this.tempiIniziali[DanasDataStructureConstants.ValueType.dANALOG1.ordinal()] = tempo;
        this.tempiIniziali[DanasDataStructureConstants.ValueType.dANALOG2.ordinal()] = tempo;
        this.tempiIniziali[DanasDataStructureConstants.ValueType.dANALOG3.ordinal()] = tempo;
        this.tempiIniziali[DanasDataStructureConstants.ValueType.dANALOG4.ordinal()] = tempo;
        this.tempiIniziali[DanasDataStructureConstants.ValueType.dANALOG5.ordinal()] = tempo;
        this.tempiIniziali[DanasDataStructureConstants.ValueType.dANALOG6.ordinal()] = tempo;
        this.tempiIniziali[DanasDataStructureConstants.ValueType.dANALOG7.ordinal()] = tempo;
        this.tempiIniziali[DanasDataStructureConstants.ValueType.dANALOG8.ordinal()] = tempo;
        this.tempiIniziali[DanasDataStructureConstants.ValueType.dEXT1.ordinal()] = tempo;
        this.tempiIniziali[DanasDataStructureConstants.ValueType.dEXT2.ordinal()] = tempo;
        this.tempiIniziali[DanasDataStructureConstants.ValueType.dEXT3.ordinal()] = tempo;
        this.tempiIniziali[DanasDataStructureConstants.ValueType.dEXT4.ordinal()] = tempo;
        this.tempiIniziali[DanasDataStructureConstants.ValueType.HEART.ordinal()] = tempo;
    }

    public void setTempoInizialeDatiGps(double tempo) {
        this.tempiIniziali[DanasDataStructureConstants.ValueType.VEL_GPS.ordinal()] = tempo;
        this.tempiIniziali[DanasDataStructureConstants.ValueType.dVEL_GPS.ordinal()] = tempo;
        this.tempiIniziali[DanasDataStructureConstants.ValueType.LAT.ordinal()] = tempo;
        this.tempiIniziali[DanasDataStructureConstants.ValueType.LONG.ordinal()] = tempo;
        this.tempiIniziali[DanasDataStructureConstants.ValueType.GPS_TIME.ordinal()] = tempo;
        this.tempiIniziali[DanasDataStructureConstants.ValueType.ALTITUDE.ordinal()] = tempo;
        this.tempiIniziali[DanasDataStructureConstants.ValueType.ACC_LAT.ordinal()] = tempo;
        this.tempiIniziali[DanasDataStructureConstants.ValueType.DELAY.ordinal()] = tempo;
        this.tempiIniziali[DanasDataStructureConstants.ValueType.DDS.ordinal()] = tempo;
        this.tempiIniziali[DanasDataStructureConstants.ValueType.ANGLE_GPS.ordinal()] = tempo;
    }

    public void inizializzaListeDatiGps() {
        this.valoriCanali[DanasDataStructureConstants.ValueType.VEL_GPS.ordinal()] = new ArrayDouble();
        this.valoriCanali[DanasDataStructureConstants.ValueType.dVEL_GPS.ordinal()] = new ArrayDouble();
        this.valoriCanali[DanasDataStructureConstants.ValueType.LAT.ordinal()] = new ArrayDouble();
        this.valoriCanali[DanasDataStructureConstants.ValueType.LONG.ordinal()] = new ArrayDouble();
        this.valoriCanali[DanasDataStructureConstants.ValueType.GPS_TIME.ordinal()] = new ArrayDouble();
        this.valoriCanali[DanasDataStructureConstants.ValueType.ALTITUDE.ordinal()] = new ArrayDouble();
        this.valoriCanali[DanasDataStructureConstants.ValueType.ACC_LAT.ordinal()] = new ArrayDouble();
        this.valoriCanali[DanasDataStructureConstants.ValueType.DELAY.ordinal()] = new ArrayDouble();
        this.valoriCanali[DanasDataStructureConstants.ValueType.DDS.ordinal()] = new ArrayDouble();
        this.valoriCanali[DanasDataStructureConstants.ValueType.ANGLE_GPS.ordinal()] = new ArrayDouble();
    }

    public void svuotaListeGps() {
        this.valoriCanali[DanasDataStructureConstants.ValueType.VEL_GPS.ordinal()].clear();
        this.valoriCanali[DanasDataStructureConstants.ValueType.dVEL_GPS.ordinal()].clear();
        this.valoriCanali[DanasDataStructureConstants.ValueType.LAT.ordinal()].clear();
        this.valoriCanali[DanasDataStructureConstants.ValueType.LONG.ordinal()].clear();
        this.valoriCanali[DanasDataStructureConstants.ValueType.GPS_TIME.ordinal()].clear();
        this.valoriCanali[DanasDataStructureConstants.ValueType.ALTITUDE.ordinal()].clear();
        this.valoriCanali[DanasDataStructureConstants.ValueType.ACC_LAT.ordinal()].clear();
        this.valoriCanali[DanasDataStructureConstants.ValueType.DELAY.ordinal()].clear();
        this.valoriCanali[DanasDataStructureConstants.ValueType.DDS.ordinal()].clear();
        this.valoriCanali[DanasDataStructureConstants.ValueType.ANGLE_GPS.ordinal()].clear();
    }

    public void duplicaUltimoValoreGps() {
        if (this.frequenzeCanali[DanasDataStructureConstants.ValueType.VEL_GPS.ordinal()] == 0.0) {
            return;
        }
        int indice = this.valoriCanali[DanasDataStructureConstants.ValueType.VEL_GPS.ordinal()].size() - 1;
        this.valoriCanali[DanasDataStructureConstants.ValueType.VEL_GPS.ordinal()].add(this.valoriCanali[DanasDataStructureConstants.ValueType.VEL_GPS.ordinal()].get(indice));
        this.valoriCanali[DanasDataStructureConstants.ValueType.dVEL_GPS.ordinal()].add(this.valoriCanali[DanasDataStructureConstants.ValueType.dVEL_GPS.ordinal()].get(indice));
        this.valoriCanali[DanasDataStructureConstants.ValueType.LAT.ordinal()].add(this.valoriCanali[DanasDataStructureConstants.ValueType.LAT.ordinal()].get(indice));
        this.valoriCanali[DanasDataStructureConstants.ValueType.LONG.ordinal()].add(this.valoriCanali[DanasDataStructureConstants.ValueType.LONG.ordinal()].get(indice));
        this.valoriCanali[DanasDataStructureConstants.ValueType.GPS_TIME.ordinal()].add(this.valoriCanali[DanasDataStructureConstants.ValueType.GPS_TIME.ordinal()].get(indice) + 10.0);
        this.valoriCanali[DanasDataStructureConstants.ValueType.ALTITUDE.ordinal()].add(this.valoriCanali[DanasDataStructureConstants.ValueType.ALTITUDE.ordinal()].get(indice));
    }

    public void scriviValoriGps(GPSPoint data) {
        this.valoriCanali[DanasDataStructureConstants.ValueType.VEL_GPS.ordinal()].add(data.getSpeed());
        if (this.valoriCanali[DanasDataStructureConstants.ValueType.dVEL_GPS.ordinal()].size() == 0) {
            this.valoriCanali[DanasDataStructureConstants.ValueType.dVEL_GPS.ordinal()].add(0.0);
        } else {
            int indice = this.valoriCanali[DanasDataStructureConstants.ValueType.VEL_GPS.ordinal()].size() - 2;
            double deriv = (data.getSpeed() - this.valoriCanali[DanasDataStructureConstants.ValueType.VEL_GPS.ordinal()].get(indice)) * this.frequenzeCanali[DanasDataStructureConstants.ValueType.VEL_GPS.ordinal()];
            this.valoriCanali[DanasDataStructureConstants.ValueType.dVEL_GPS.ordinal()].add(deriv);
        }
        this.valoriCanali[DanasDataStructureConstants.ValueType.LAT.ordinal()].add(data.getLat());
        this.valoriCanali[DanasDataStructureConstants.ValueType.LONG.ordinal()].add(data.getLon());
        this.valoriCanali[DanasDataStructureConstants.ValueType.GPS_TIME.ordinal()].add(data.getCentesimiGps());
        this.valoriCanali[DanasDataStructureConstants.ValueType.ALTITUDE.ordinal()].add(data.getAltitudine());
        this.valoriCanali[DanasDataStructureConstants.ValueType.DDS.ordinal()].add(0.0);
        this.valoriCanali[DanasDataStructureConstants.ValueType.DELAY.ordinal()].add(0.0);
    }

    public void aggiungiPuntoGps(GPSPoint data) {
        double differenza;
        double delta;
        if (this.frequenzeCanali[DanasDataStructureConstants.ValueType.VEL_GPS.ordinal()] == 0.0) {
            this.frequenzeCanali[DanasDataStructureConstants.ValueType.VEL_GPS.ordinal()] = 10.0;
            this.frequenzeCanali[DanasDataStructureConstants.ValueType.dVEL_GPS.ordinal()] = 10.0;
            this.frequenzeCanali[DanasDataStructureConstants.ValueType.LAT.ordinal()] = 10.0;
            this.frequenzeCanali[DanasDataStructureConstants.ValueType.LONG.ordinal()] = 10.0;
            this.frequenzeCanali[DanasDataStructureConstants.ValueType.GPS_TIME.ordinal()] = 10.0;
            this.frequenzeCanali[DanasDataStructureConstants.ValueType.ALTITUDE.ordinal()] = 10.0;
            this.frequenzeCanali[DanasDataStructureConstants.ValueType.ACC_LAT.ordinal()] = 10.0;
            this.frequenzeCanali[DanasDataStructureConstants.ValueType.DELAY.ordinal()] = 10.0;
            this.frequenzeCanali[DanasDataStructureConstants.ValueType.DDS.ordinal()] = 10.0;
            this.frequenzeCanali[DanasDataStructureConstants.ValueType.ANGLE_GPS.ordinal()] = 10.0;
            this.inizializzaListeDatiGps();
            this.tempoAttualeGps = data.getCentesimiGps();
            this.setTempoInizialeDatiGps(data.getTelemetry_time());
            this.sessioneVuota = false;
            this.differenzaTempiGps = (double)data.getCentesimiGps() - data.getTelemetry_time();
        }
        ++this.puntiGpsAnalizzati;
        if (this.puntiGpsAnalizzati < 100 && (delta = Math.abs((differenza = (double)data.getCentesimiGps() - data.getTelemetry_time()) - this.differenzaTempiGps)) > 3.0) {
            System.out.println("DEBUG: eliminato punto gps, sessione:" + this.getSessionID() + " punto:" + this.puntiGpsAnalizzati + " delta=" + delta);
            this.differenzaTempiGps = (double)data.getCentesimiGps() - data.getTelemetry_time();
            this.tempoAttualeGps = data.getCentesimiGps();
            this.setTempoInizialeDatiGps(data.getTelemetry_time());
            this.svuotaListeGps();
        }
        if (data.getCentesimiGps() > 8640000) {
            System.out.println("DEBUG: trovato tempo GPS corroptto superiore alle 24h :" + data.getGps_time());
            return;
        }
        if ((double)data.getCentesimiGps() > this.tempoAttualeGps + 100.0 / this.frequenzeCanali[DanasDataStructureConstants.ValueType.VEL_GPS.ordinal()] + 50.0 / this.frequenzeCanali[DanasDataStructureConstants.ValueType.VEL_GPS.ordinal()]) {
            System.out.println("saltato tempo GPS, ultimo tempo=" + this.tempoAttualeGps + " attuale=" + data.getCentesimiGps() + " ora gps=" + data.getGps_time());
            int campioniAggiunti = 1;
            while (this.tempoAttualeGps + (double)(campioniAggiunti * 100) / this.frequenzeCanali[DanasDataStructureConstants.ValueType.VEL_GPS.ordinal()] + 50.0 / this.frequenzeCanali[DanasDataStructureConstants.ValueType.VEL_GPS.ordinal()] < (double)data.getCentesimiGps()) {
                this.duplicaUltimoValoreGps();
                ++campioniAggiunti;
            }
        }
        this.tempoAttualeGps = data.getCentesimiGps();
        this.scriviValoriGps(data);
    }

    public void calcolaRitardiGiri() {
        for (int i = 0; i < this.laps.size(); ++i) {
            this.laps.get(i).calcolaRitardi();
        }
    }

    public void calcolaTempiDistanze() {
        if (this.sessioneVuota) {
            return;
        }
        for (int i = 0; i < this.frequenzeCanali.length; ++i) {
            if (this.frequenzeCanali[i] == 0.0 || this.valoriCanali[i].size() != 0) continue;
            this.frequenzeCanali[i] = 0.0;
        }
        if (this.frequenzeCanali[DanasDataStructureConstants.ValueType.VEL_GPS.ordinal()] != 0.0) {
            this.frequenzeCanali[DanasDataStructureConstants.ValueType.dVEL_GPS.ordinal()] = 10.0;
            this.frequenzeCanali[DanasDataStructureConstants.ValueType.LAT.ordinal()] = 10.0;
            this.frequenzeCanali[DanasDataStructureConstants.ValueType.LONG.ordinal()] = 10.0;
            this.frequenzeCanali[DanasDataStructureConstants.ValueType.GPS_TIME.ordinal()] = 10.0;
            this.frequenzeCanali[DanasDataStructureConstants.ValueType.ALTITUDE.ordinal()] = 10.0;
            this.frequenzeCanali[DanasDataStructureConstants.ValueType.ACC_LAT.ordinal()] = 10.0;
            this.frequenzeCanali[DanasDataStructureConstants.ValueType.DELAY.ordinal()] = 10.0;
            this.frequenzeCanali[DanasDataStructureConstants.ValueType.DDS.ordinal()] = 10.0;
            this.frequenzeCanali[DanasDataStructureConstants.ValueType.ANGLE_GPS.ordinal()] = 10.0;
        }
        long tempoAttesa = System.currentTimeMillis();
        this.canaleSpazio = new ArrayList<Double>();
        this.canalePosizioniStechio = new ArrayList<Integer>();
        this.canaleUsaInStechio = new ArrayList<Boolean>();
        this.tempoPrimoDato = Double.MAX_VALUE;
        for (int i = 0; i < this.tempiIniziali.length; ++i) {
            double valoreTempo = this.tempiIniziali[i];
            if (i == DanasDataStructureConstants.ValueType.VEL_GPS.ordinal()) {
                valoreTempo += (double)DanasDataStructure.getOffsetGps();
            }
            if (!(valoreTempo < this.tempoPrimoDato)) continue;
            this.tempoPrimoDato = valoreTempo;
        }
        if (this.tempoPrimoDato == Double.MAX_VALUE) {
            this.sessioneVuota = true;
            return;
        }
        double tempoFinale = 0.0;
        for (int i = 0; i < this.frequenzeCanali.length; ++i) {
            if (this.frequenzeCanali[i] == 0.0 || this.valoriCanali[i].size() <= 0) continue;
            double tempoFinaleCanale = this.tempiIniziali[i] + 100.0 / this.frequenzeCanali[i] * (double)(this.valoriCanali[i].size() - 1);
            if (i == DanasDataStructureConstants.ValueType.VEL_GPS.ordinal()) {
                tempoFinaleCanale += (double)DanasDataStructure.getOffsetGps();
            }
            if (!(tempoFinaleCanale > tempoFinale)) continue;
            tempoFinale = tempoFinaleCanale;
        }
        if (this.frequenzeCanali[DanasDataStructureConstants.ValueType.VEL_GPS.ordinal()] == 0.0 && this.frequenzeCanali[DanasDataStructureConstants.ValueType.SPEED1.ordinal()] == 0.0) {
            return;
        }
        DanasDataStructureConstants.ValueType canaleVelocit\u00e0 = this.frequenzeCanali[DanasDataStructureConstants.ValueType.VEL_GPS.ordinal()] == 0.0 ? DanasDataStructureConstants.ValueType.SPEED1 : DanasDataStructureConstants.ValueType.VEL_GPS;
        this.canaleSpazio.clear();
        this.canalePosizioniStechio.clear();
        this.canaleUsaInStechio.clear();
        this.canaleSpazio.add(0.0);
        this.canalePosizioniStechio.add(0);
        this.canaleUsaInStechio.add(true);
        double spazioAttuale = 0.0;
        double tempoAttuale = 0.0;
        int indice = 0;
        int numeroPunti = (int)((tempoFinale - this.tempoPrimoDato) / this.risoluzioneTemporale) + 1;
        for (int i = 1; i < numeroPunti; ++i) {
            tempoAttuale = this.tempoPrimoDato + (double)i * this.risoluzioneTemporale;
            indice = canaleVelocit\u00e0 == DanasDataStructureConstants.ValueType.VEL_GPS ? this.getIndiceAtTime(canaleVelocit\u00e0, tempoAttuale + (double)DanasDataStructure.getOffsetGps(), DanasDataStructureConstants.BoundLap.PREVIOUS) : this.getIndiceAtTime(canaleVelocit\u00e0, tempoAttuale, DanasDataStructureConstants.BoundLap.PREVIOUS);
            double vel = MeasuresUtil.GenericDataConverter(this.valoriCanali[canaleVelocit\u00e0.ordinal()].get(indice), canaleVelocit\u00e0, this) / 3.6;
            double spazio = this.risoluzioneTemporale * vel / 100.0;
            this.canaleSpazio.add(spazioAttuale + spazio);
            this.canalePosizioniStechio.add(0);
            this.canaleUsaInStechio.add(true);
            spazioAttuale += spazio;
        }
    }

    public int getDimensioneCanaleSpazi() {
        return this.canaleSpazio.size();
    }

    public int getDimensioneCanale(DanasDataStructureConstants.ValueType vt) {
        if (this.frequenzeCanali[vt.ordinal()] == 0.0) {
            return 0;
        }
        return this.valoriCanali[vt.ordinal()].size();
    }

    public int getDimensioneCanale(DanasDataStructureConstants.ValueType vt, double tempoInizio, double tempoFine) {
        if (tempoFine < tempoInizio) {
            return 0;
        }
        if (!(vt != DanasDataStructureConstants.ValueType.ANGLE_GPS && vt != DanasDataStructureConstants.ValueType.ACC_LAT || this.getAngoliCalcolati())) {
            this.calcolaRaggi();
        }
        if ((vt == DanasDataStructureConstants.ValueType.SIM1 || vt == DanasDataStructureConstants.ValueType.SIM2) && this.frequenzeCanali[DanasDataStructureConstants.ValueType.SIM1.ordinal()] == 0.0) {
            this.creaCanaliSimulazione();
        }
        if (vt.ordinal() >= DanasDataStructureConstants.ValueType.MATH_1.ordinal() && vt.ordinal() <= DanasDataStructureConstants.ValueType.MATH_10.ordinal()) {
            this.verificaCanaleMatematico(vt);
        }
        int inizio = this.getIndiceAtTime(vt, tempoInizio, DanasDataStructureConstants.BoundLap.NEXT);
        int fine = this.getIndiceAtTime(vt, tempoFine, DanasDataStructureConstants.BoundLap.PREVIOUS);
        if (inizio == -1 || fine == -1) {
            return 0;
        }
        return fine - inizio + 1;
    }

    public void azzeraCanaliAnalizzati() {
        for (int i = 0; i < DanasDataStructureConstants.ValueType.values().length; ++i) {
            this.canaliAnalizzati[i] = false;
        }
    }

    public boolean isCanaleAnalizzato(DanasDataStructureConstants.ValueType val) {
        return this.canaliAnalizzati[val.ordinal()];
    }

    public void setCanaleAnalizzato(DanasDataStructureConstants.ValueType val) {
        this.canaliAnalizzati[val.ordinal()] = true;
    }

    public String getFormulaMath(int index) {
        return this.formuleMath[index];
    }

    public void setFormulaMath(String formula, int index) {
        this.formuleMath[index] = formula;
    }

    public String getPilota() {
        return this.pilota;
    }

    public void setPilota(String pilot) {
        this.pilota = pilot;
    }

    public int getTipo() {
        return this.tipo;
    }

    public void setTipo(int type) {
        this.tipo = type;
    }

    public double getPercentualeM(int numero) {
        switch (numero) {
            case 1: {
                return this.percentualeM1;
            }
            case 2: {
                return this.percentualeM2;
            }
            case 3: {
                return this.percentualeM3;
            }
            case 4: {
                return this.percentualeM4;
            }
        }
        return 0.0;
    }

    public double getPercentualeGasAperto() {
        return this.percentualeGasAperto;
    }

    public void setPercentualeGasAperto(double percentuale) {
        this.percentualeGasAperto = percentuale;
    }

    public void setDanasDataStructure(DanasDataStructure s) {
        this.dataStructure = s;
    }

    public DanasDataStructure getDanasDataStructure() {
        return this.dataStructure;
    }

    public void setSettaggioInterno(boolean interno) {
        this.settaggioInterno = interno;
    }

    public boolean getSettaggioInterno() {
        return this.settaggioInterno;
    }

    public void setSessionID(int id) {
        this.sessionID = id;
    }

    public int getSessionID() {
        return this.sessionID;
    }

    public void setSessionName(String sessionName) {
        this.sessionName = sessionName;
    }

    public String getSessionName() {
        return this.sessionName;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilePosition(int filePosition) {
        this.filePosition = filePosition;
    }

    public int getFilePosition() {
        return this.filePosition;
    }

    public void setColor(Color c) {
        this.color = c;
        this.dataStructure.setChange(DanasDataStructureConstants.ChangeType.SESSION_COLOR, String.valueOf(this.sessionID));
    }

    public Color getColor() {
        return this.color;
    }

    public void setRandomColor() {
        this.color = Color.getHSBColor((float)Math.random(), (float)Math.random(), (float)Math.random());
    }

    public void select() {
        boolean sessioneSingola = false;
        boolean settatoDefault = false;
        if (DanasDataStructure.getInstance().getNumberSelectedSessions() == 0) {
            sessioneSingola = true;
        }
        this.selected = true;
        if (sessioneSingola && DanasDataStructure.getInstance().getSingoloDefault()) {
            settatoDefault = true;
            DanasDataStructure.getInstance().setDefaultSession(this);
        }
        if (this.dataStructure != null && !settatoDefault) {
            this.dataStructure.setChange(DanasDataStructureConstants.ChangeType.SEL_SESSION, String.valueOf(this.sessionID));
        }
    }

    public void deselect() {
        boolean sessiomeSingoloAltro = false;
        boolean settatoDefault = false;
        if (DanasDataStructure.getInstance().getNumberSelectedSessions() == 2) {
            sessiomeSingoloAltro = true;
        }
        this.selected = false;
        if (sessiomeSingoloAltro && DanasDataStructure.getInstance().getSingoloDefault() && !DanasDataStructure.getInstance().getConfrontaDefault()) {
            DanasDataStructure.getInstance().setDefaultSession(DanasDataStructure.getInstance().getfirstSessionSelected());
        }
        if (this.dataStructure != null && !settatoDefault) {
            this.dataStructure.setChange(DanasDataStructureConstants.ChangeType.DESEL_SESSION, String.valueOf(this.sessionID));
        }
        this.azzeraUsoePosizioni();
    }

    public void select2() {
        this.selected = true;
    }

    public void deselect2() {
        this.selected = false;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setDate(Date d) {
        this.date = d;
    }

    public Date getDate() {
        return this.date;
    }

    public String getDateString() {
        if (this.getDate() != null) {
            this.getDate().getYear();
            String.format("%d/%02d/%02d", this.getDate().getYear() + 1900, this.getDate().getMonth() + 1, this.getDate().getDate());
        }
        return "010170";
    }

    public void setVideoFilename(String video) {
        this.videoFilename = video;
    }

    public String getVideoFilename() {
        return this.videoFilename;
    }

    public boolean hasVideo() {
        return this.videoFilename != null;
    }

    public long getSessionStartHour() {
        if (this.getDimensioneCanale(DanasDataStructureConstants.ValueType.GPS_TIME) > 0) {
            return 10L * (long)this.getDatoAtIndex(DanasDataStructureConstants.ValueType.GPS_TIME, 0);
        }
        return 0L;
    }

    public void setEndHour(String endHour) {
        this.endHour = endHour;
    }

    public String getEndHour() {
        return this.endHour;
    }

    public long getSessionEndHour() {
        if (this.getDimensioneCanale(DanasDataStructureConstants.ValueType.GPS_TIME) > 0) {
            return 10L * (long)this.getDatoAtIndex(DanasDataStructureConstants.ValueType.GPS_TIME, this.getDimensioneCanale(DanasDataStructureConstants.ValueType.GPS_TIME) - 1);
        }
        return 0L;
    }

    public String getStringaCanaliAtFrequenza(double frequenza) {
        boolean frequenzaTrovata = false;
        String frase = "$CANALI," + (int)frequenza + ",";
        for (DanasDataStructureConstants.ValueType vt : DanasDataStructureConstants.ValueType.values()) {
            if (!MeasuresUtil.isTipoDaSalvare(vt) || this.getFrequenzaCanale(vt) != frequenza) continue;
            frequenzaTrovata = true;
            frase = frase + vt.ordinal() + ",";
        }
        if (!frequenzaTrovata) {
            return null;
        }
        return frase;
    }

    public String getStringaSettaggiCanali() {
        String frase = "$SETTAGGICANALI,";
        for (DanasDataStructureConstants.ValueType vt : DanasDataStructureConstants.ValueType.values()) {
            if (!MeasuresUtil.isTipoDaSalvare(vt) || this.getFrequenzaCanale(vt) == 0.0) continue;
            frase = frase + vt.ordinal() + ";" + this.sessionSettings.getNome(vt) + ";" + this.sessionSettings.getMinimo(vt) + ";" + this.sessionSettings.getMassimo(vt) + ",";
        }
        return frase;
    }

    public String getStringaSettaggiBase() {
        String frase = "$SETTAGGIBASE,";
        DanasSessionSettings set = this.getSessionSettings();
        frase = frase + set.getTipoMoto() + ",";
        frase = frase + set.getGears()[0] + "," + set.getGears()[1] + "," + set.getGears()[2] + "," + set.getGears()[3] + "," + set.getGears()[4] + "," + set.getGears()[5] + ",";
        frase = frase + set.getPinion(1) + "," + set.getGearTeeth(1) + "," + set.getCircumference(1) + "," + set.getPinion(2) + "," + set.getGearTeeth(2) + "," + set.getCircumference(2) + ",";
        return frase;
    }

    public boolean getAngoliCalcolati() {
        return this.angoliCalcolati;
    }

    public void calcolaRaggi() {
        int i;
        double segno = 1.0;
        int filtro = 6;
        ArrayDouble elencoPuntiLat = this.getAllValueData(DanasDataStructureConstants.ValueType.LAT, false);
        ArrayDouble elencoPuntiLong = this.getAllValueData(DanasDataStructureConstants.ValueType.LONG, false);
        ArrayDouble elencoPuntiSpeed = this.getAllValueData(DanasDataStructureConstants.ValueType.VEL_GPS, false);
        if (elencoPuntiSpeed == null) {
            return;
        }
        int size = elencoPuntiSpeed.size();
        if (size < 2 * filtro + 1) {
            for (int i2 = 0; i2 < size; ++i2) {
                this.valoriCanali[DanasDataStructureConstants.ValueType.ANGLE_GPS.ordinal()].add(0.0);
                this.valoriCanali[DanasDataStructureConstants.ValueType.ACC_LAT.ordinal()].add(0.0);
            }
            this.angoliCalcolati = true;
            return;
        }
        for (i = 0; i < filtro; ++i) {
            this.valoriCanali[DanasDataStructureConstants.ValueType.ANGLE_GPS.ordinal()].add(0.0);
            this.valoriCanali[DanasDataStructureConstants.ValueType.ACC_LAT.ordinal()].add(0.0);
        }
        for (i = filtro; i < size - filtro; ++i) {
            double angoloTemp;
            double ya = elencoPuntiLat.get(i - filtro);
            double yb = elencoPuntiLat.get(i);
            double yc = elencoPuntiLat.get(i + filtro);
            double xa = Mappa2D.convertiX(elencoPuntiLong.get(i - filtro), ya);
            double xb = Mappa2D.convertiX(elencoPuntiLong.get(i), yb);
            double xc = Mappa2D.convertiX(elencoPuntiLong.get(i + filtro), yc);
            double a = Mappa2D.distanzaGeograficaDouble(xa, ya, xb, yb);
            double b = Mappa2D.distanzaGeograficaDouble(xb, yb, xc, yc);
            double c = Mappa2D.distanzaGeograficaDouble(xa, ya, xc, yc);
            double x0 = xb - xa;
            double y0 = yb - ya;
            double x1 = xc - xb;
            double y1 = yc - yb;
            double angolo1 = (360.0 + 57.324840764331206 * Math.atan2(y0, x0)) % 360.0;
            double angolo2 = (360.0 + 57.324840764331206 * Math.atan2(y1, x1)) % 360.0;
            if (angolo1 >= 180.0) {
                angoloTemp = angolo1 - 180.0;
                segno = angolo2 > angoloTemp && angolo2 < angolo1 ? 1.0 : -1.0;
            } else {
                angoloTemp = angolo1 + 180.0;
                segno = angolo2 > angolo1 && angolo2 < angoloTemp ? -1.0 : 1.0;
            }
            double fattore1 = 0.5 * (a + b + c) - a;
            double fattore2 = 0.5 * (a + b + c) - b;
            double fattore3 = 0.5 * (a + b + c) - c;
            if (fattore1 < 0.0) {
                fattore1 = 0.0;
            }
            if (fattore2 < 0.0) {
                fattore2 = 0.0;
            }
            if (fattore3 < 0.0) {
                fattore3 = 0.0;
            }
            double speed = elencoPuntiSpeed.get(i) * 1.852 * 1000.0 / 3600.0;
            double r = a * b * c / (4.0 * Math.sqrt(0.5 * (a + b + c) * fattore1 * fattore2 * fattore3));
            double alat = speed * speed / r;
            double leanAngle = segno * Math.atan(alat / 9.81) * 180.0 / Math.PI;
            this.valoriCanali[DanasDataStructureConstants.ValueType.ANGLE_GPS.ordinal()].add(leanAngle);
            this.valoriCanali[DanasDataStructureConstants.ValueType.ACC_LAT.ordinal()].add(alat * segno / 9.81);
        }
        this.angoliCalcolati = true;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public String getNotes() {
        return this.notes;
    }

    public DanasDataStructureConstants.SpeedType getBestSpeedType() {
        return this.speedType;
    }

    public void setBestSpeedType(DanasDataStructureConstants.SpeedType speedType) {
        this.speedType = speedType;
    }

    public void removeLaps() {
        this.getLaps().clear();
    }

    public void createLaps(boolean sel) {
        int i = 0;
        for (i = 1; i < this.getAllIRData().size(); ++i) {
            DanasLap l = new DanasLap(this, this.getAllIRData().get(i - 1).getTelemetry(), this.getAllIRData().get(i).getTelemetry(), new Color((int)(Math.random() * 255.0), (int)(Math.random() * 255.0), (int)(Math.random() * 255.0)), i, sel);
            this.getLaps().add(l);
            System.out.println(l.toString());
        }
        for (i = 0; i < this.getAllIRData().size(); ++i) {
            this.listaTempiManuali.add(this.getAllIRData().get(i).getTelemetry());
        }
    }

    public void createLapsNew(Vector<Double> tempi, boolean sel) {
        int i = 0;
        if (tempi.size() == 0) {
            return;
        }
        for (i = 1; i < tempi.size(); ++i) {
            DanasLap l = new DanasLap(this, tempi.get(i - 1), tempi.get(i), new Color((int)(Math.random() * 255.0), (int)(Math.random() * 255.0), (int)(Math.random() * 255.0)), i, sel);
            this.getLaps().add(l);
        }
    }

    public Vector<DanasLap> getLaps() {
        return this.laps;
    }

    public int getNumberOfLaps() {
        return this.laps.size();
    }

    public DanasLap getLap(int lapID) {
        for (int i = 0; i < this.laps.size(); ++i) {
            if (this.laps.get(i).getLapID() != lapID) continue;
            return this.laps.get(i);
        }
        return null;
    }

    public DanasLap getLap(String name) {
        return null;
    }

    public void setTempoMinimo(double tempo) {
        this.tempoMinimo = tempo;
    }

    public double getTempoMinimo() {
        return this.tempoMinimo;
    }

    public DanasLap getBestLap(DanasDataStructureConstants.SelectionFlag f) {
        DanasLap d = null;
        if (f.equals((Object)DanasDataStructureConstants.SelectionFlag.ALL)) {
            for (DanasLap dl : this.getLaps()) {
                if (d == null) {
                    if (!(dl.getDuration() >= this.tempoMinimo)) continue;
                    d = dl;
                    continue;
                }
                if (d == null || !(dl.getDuration() < d.getDuration()) || !(dl.getDuration() >= this.tempoMinimo)) continue;
                d = dl;
            }
            return d;
        }
        if (f.equals((Object)DanasDataStructureConstants.SelectionFlag.SELECTED)) {
            for (DanasLap dl : this.getLaps()) {
                if (d == null && dl.getSelected()) {
                    if (!(dl.getDuration() >= this.tempoMinimo)) continue;
                    d = dl;
                    continue;
                }
                if (d == null || !(dl.getDuration() < d.getDuration()) || !dl.getSelected() || !(dl.getDuration() >= this.tempoMinimo)) continue;
                d = dl;
            }
            return d;
        }
        return null;
    }

    public DanasLap getBestLapSplit(int numeroSplit, DanasDataStructureConstants.SelectionFlag f) {
        DanasLap d = null;
        if (f.equals((Object)DanasDataStructureConstants.SelectionFlag.ALL)) {
            for (DanasLap dl : this.getLaps()) {
                if (d == null) {
                    d = dl;
                    continue;
                }
                if (d == null || !(dl.getSplitTime(numeroSplit) < d.getSplitTime(numeroSplit))) continue;
                d = dl;
            }
            return d;
        }
        if (f.equals((Object)DanasDataStructureConstants.SelectionFlag.SELECTED)) {
            for (DanasLap dl : this.getLaps()) {
                if (d == null && dl.getSelected()) {
                    d = dl;
                    continue;
                }
                if (d == null || !(dl.getSplitTime(numeroSplit) < d.getSplitTime(numeroSplit)) || !dl.getSelected()) continue;
                d = dl;
            }
            return d;
        }
        return null;
    }

    public void selectAllLaps() {
        for (DanasLap l : this.getLaps()) {
            l.setSelected2(true);
        }
        this.dataStructure.setChange(DanasDataStructureConstants.ChangeType.SEL_ALL_LAP, String.valueOf(this.sessionID));
    }

    public void deselectAllLaps() {
        for (DanasLap l : this.getLaps()) {
            l.setSelected2(false);
        }
        this.dataStructure.setChange(DanasDataStructureConstants.ChangeType.DESEL_ALL_LAP, String.valueOf(this.sessionID));
    }

    public double differenceFromBestLap(DanasLap lap) {
        return 0.0;
    }

    public void setSessionSettings(DanasSessionSettings sessionSettings) {
        this.sessionSettings = sessionSettings;
        this.ricalcolaDerivateDigitali();
        this.dataStructure.setChange(DanasDataStructureConstants.ChangeType.NEW_SETTINGS, String.valueOf(this.sessionID));
    }

    public DanasSessionSettings getSessionSettings() {
        return this.sessionSettings;
    }

    public void verificaCanaleMatematico(DanasDataStructureConstants.ValueType type) {
        int index;
        switch (type) {
            case MATH_1: {
                index = 0;
                break;
            }
            case MATH_2: {
                index = 1;
                break;
            }
            case MATH_3: {
                index = 2;
                break;
            }
            case MATH_4: {
                index = 3;
                break;
            }
            case MATH_5: {
                index = 4;
                break;
            }
            case MATH_6: {
                index = 5;
                break;
            }
            case MATH_7: {
                index = 6;
                break;
            }
            case MATH_8: {
                index = 7;
                break;
            }
            case MATH_9: {
                index = 8;
                break;
            }
            case MATH_10: {
                index = 9;
                break;
            }
            default: {
                return;
            }
        }
        if (!this.formuleMath[index].equals(DanasPreferences.getFormulaMath(index, false))) {
            this.creaArrayMath(index);
        }
    }

    public List<Double> getListaTempiManuali() {
        ArrayList<Double> esporta = null;
        esporta = new ArrayList<Double>();
        for (int i = 0; i < this.listaTempiManuali.size(); ++i) {
            esporta.add(this.listaTempiManuali.get(i));
        }
        return esporta;
    }

    public void setListaTempiManuali(List<Double> lista) {
        this.listaTempiManuali.clear();
        for (int i = 0; i < lista.size(); ++i) {
            this.listaTempiManuali.add(lista.get(i));
        }
    }

    public boolean isArraySimCreated() {
        return this.frequenzeCanali[DanasDataStructureConstants.ValueType.SIM1.ordinal()] != 0.0;
    }

    public void setArraySimuNotCreated() {
        this.frequenzeCanali[DanasDataStructureConstants.ValueType.SIM1.ordinal()] = 0.0;
        this.frequenzeCanali[DanasDataStructureConstants.ValueType.SIM2.ordinal()] = 0.0;
        if (this.valoriCanali[DanasDataStructureConstants.ValueType.SIM1.ordinal()] != null) {
            this.valoriCanali[DanasDataStructureConstants.ValueType.SIM1.ordinal()].clear();
            this.valoriCanali[DanasDataStructureConstants.ValueType.SIM2.ordinal()].clear();
        }
    }

    public List<DanasIRData> getAllIRData() {
        return this.irData;
    }

    public int puntoGPSPrecedente(double tempo, int indiceIniziale) {
        if (this.getFrequenzaCanale(DanasDataStructureConstants.ValueType.LAT) == 0.0 || this.getDimensioneCanale(DanasDataStructureConstants.ValueType.LAT) == 0) {
            return -1;
        }
        for (int i = indiceIniziale; i < this.getDimensioneCanale(DanasDataStructureConstants.ValueType.LAT); ++i) {
            double time = this.getTempoIniziale(DanasDataStructureConstants.ValueType.LAT) + (double)i * 100.0 / this.getFrequenzaCanale(DanasDataStructureConstants.ValueType.LAT);
            if (!(time > tempo)) continue;
            return i - 1;
        }
        return -1;
    }

    public double calculateDistanceGPS(GPSPoint from, GPSPoint to) {
        double speed = from.getSpeed() * 0.514444444444;
        double time = (to.getTelemetry_time() - from.getTelemetry_time()) / 100.0;
        return speed * time;
    }

    public double getMaxGenericData(DanasDataStructureConstants.ValueType t) {
        return this.GenericValueAnalisys[t.ordinal()][0];
    }

    public double getMinGenericData(DanasDataStructureConstants.ValueType t) {
        return this.GenericValueAnalisys[t.ordinal()][1];
    }

    public double getAvgGenericData(DanasDataStructureConstants.ValueType t) {
        return this.GenericValueAnalisys[t.ordinal()][2];
    }

    public double[][] getGenericValueAnalisys() {
        return this.GenericValueAnalisys;
    }

    public void setGenericValueAnalisys(double[][] GenericValueAnalisys) {
        this.GenericValueAnalisys = GenericValueAnalisys;
    }

    public Vector<Double> calculateGears() {
        this.gears = new Vector();
        this.findGears();
        Vector<GearValueTime> new_gears = new Vector<GearValueTime>();
        for (int j = 0; j < this.gears.size(); ++j) {
            GearValueTime t = this.gears.get(j);
            new_gears.add(t);
        }
        this.gears = new_gears;
        return this.findBestGears();
    }

    private GearValueTime[] fitGear(GearValueTime[] gears, int index, GearValueTime gear) {
        if (gears[index] == null) {
            gears[index] = gear;
        } else if (gears[index].time < gear.time) {
            GearValueTime vt = gears[index];
            gears[index] = gear;
            if (index != gears.length - 1) {
                gears = this.fitGear(gears, index + 1, vt);
            }
        } else if (index != gears.length - 1) {
            gears = this.fitGear(gears, index + 1, gear);
        }
        return gears;
    }

    private Vector<Double> findBestGears() {
        int i;
        GearValueTime[] best = new GearValueTime[6];
        for (i = 0; i < this.gears.size(); ++i) {
            GearValueTime vt = this.gears.get(i);
            best = this.fitGear(best, 0, vt);
        }
        for (i = 0; i < best.length; ++i) {
            if (best[i] != null) continue;
        }
        for (i = 0; i < 5; ++i) {
            GearValueTime max = best[i];
            int maxidx = i;
            for (int j = i + 1; j < 6; ++j) {
                GearValueTime t = best[j];
                if (t == null || !(max.value < t.value)) continue;
                max = t;
                maxidx = j;
            }
            GearValueTime tmp = best[i];
            best[i] = max;
            best[maxidx] = tmp;
        }
        this.gears_found = best;
        Vector<Double> marce = new Vector<Double>();
        for (int i2 = 0; i2 < this.gears_found.length; ++i2) {
            if (this.gears_found[i2] == null) continue;
            System.out.println("marcia: " + this.gears_found[i2].getValue());
            marce.add(this.gears_found[i2].getValue());
        }
        return marce;
    }

    private static double normalizeGear(double gear) {
        return (double)((int)(gear * 1000.0)) / 1000.0;
    }

    public void findBestSpeedType() {
        double delta = 1.0;
        double avgmax1 = Math.abs(this.getAvgGenericData(DanasDataStructureConstants.ValueType.SPEED1)) - Math.abs(this.getMaxGenericData(DanasDataStructureConstants.ValueType.SPEED1));
        double avgmin1 = Math.abs(this.getAvgGenericData(DanasDataStructureConstants.ValueType.SPEED1)) - Math.abs(this.getMinGenericData(DanasDataStructureConstants.ValueType.SPEED1));
        if (Math.abs(avgmax1) < delta || Math.abs(avgmin1) < delta) {
            double avgmax2 = Math.abs(this.getAvgGenericData(DanasDataStructureConstants.ValueType.SPEED2)) - Math.abs(this.getMaxGenericData(DanasDataStructureConstants.ValueType.SPEED2));
            double avgmin2 = Math.abs(this.getAvgGenericData(DanasDataStructureConstants.ValueType.SPEED2)) - Math.abs(this.getMinGenericData(DanasDataStructureConstants.ValueType.SPEED2));
            if (Math.abs(avgmax2) < delta || Math.abs(avgmin2) < delta) {
                this.speedType = DanasDataStructureConstants.SpeedType.SPEED1;
                return;
            }
            this.speedType = DanasDataStructureConstants.SpeedType.SPEED2;
            return;
        }
        this.speedType = DanasDataStructureConstants.SpeedType.SPEED1;
    }

    public String replaceDerivative(String s) {
        if (!s.contains("DERIVATIVE(")) {
            return s;
        }
        int parentesiAperte = 1;
        int pos = s.indexOf("DERIVATIVE(");
        while (pos != -1) {
            parentesiAperte = 1;
            for (int i = pos + 11; i < s.length(); ++i) {
                if (s.charAt(i) == '(') {
                    ++parentesiAperte;
                }
                if (s.charAt(i) == ')') {
                    --parentesiAperte;
                }
                if (parentesiAperte != 0) continue;
                String contenuto = s.substring(pos + 11, i);
                s = s.substring(0, pos) + "DER('" + contenuto + "')" + s.substring(i + 1, s.length());
                break;
            }
            pos = s.indexOf("DERIVATIVE(");
        }
        return s;
    }

    public String replaceDerivative2(String s) {
        if (!s.contains("DERIVATIVE2(")) {
            return s;
        }
        int parentesiAperte = 1;
        int pos = s.indexOf("DERIVATIVE2(");
        while (pos != -1) {
            parentesiAperte = 1;
            for (int i = pos + 12; i < s.length(); ++i) {
                if (s.charAt(i) == '(') {
                    ++parentesiAperte;
                }
                if (s.charAt(i) == ')') {
                    --parentesiAperte;
                }
                if (parentesiAperte != 0) continue;
                String contenuto = s.substring(pos + 12, i);
                s = s.substring(0, pos) + "DER2('" + contenuto + "')" + s.substring(i + 1, s.length());
                break;
            }
            pos = s.indexOf("DERIVATIVE2(");
        }
        return s;
    }

    public boolean isAggiornamentoAnalisiRichiesto(boolean analizzaAn1) {
        ContenitoreGrafico grafico = DanasDataStructure.getInstance().getMainFrame().getContenitoreGrafico();
        for (DanasDataStructureConstants.ValueType t : DanasDataStructureConstants.ValueType.values()) {
            if (t == DanasDataStructureConstants.ValueType.SIM1 || t == DanasDataStructureConstants.ValueType.SIM2 || !grafico.isChannelOnInfo(MeasuresUtil.getPositionType(t)) && !this.isCanaleAnalizzato(t) || this.isCanaleAnalizzato(t) && grafico.isChannelOnInfo(MeasuresUtil.getPositionType(t))) continue;
            return true;
        }
        return false;
    }

    public int getTempoCampionamentoOld() {
        double tempoInizio;
        double precedente = tempoInizio = this.getAllValueData().get(0).getTelemetryTime();
        double indicePrimo = 0.0;
        for (int i = 0; i < this.getAllValueData().size(); ++i) {
            if (this.getAllValueData().get(i).getTelemetryTime() > precedente + 1000.0) {
                indicePrimo = i;
                tempoInizio = this.getAllValueData().get(i).getTelemetryTime();
            }
            precedente = this.getAllValueData().get(i).getTelemetryTime();
        }
        double tempoFine = this.getAllValueData().get(this.getAllValueData().size() - 1).getTelemetryTime();
        if (tempoFine == tempoInizio) {
            return -1;
        }
        int deltaT = (int)Math.round((tempoFine - tempoInizio) / ((double)(this.getAllValueData().size() - 1) - indicePrimo));
        return deltaT;
    }

    public void consolidaArrayDati() {
        for (int i = 0; i < DanasDataStructureConstants.ValueType.values().length; ++i) {
            if (this.valoriCanali[i] == null) continue;
            this.valoriCanali[i].consolidate();
        }
    }

    public List<Double> getSelectionValueData(DanasDataStructureConstants.ValueType vt, double tempoInizio, double tempoFine, boolean convertito) {
        ArrayList<Double> out = new ArrayList<Double>();
        if (tempoFine < tempoInizio) {
            return out;
        }
        if (!(vt != DanasDataStructureConstants.ValueType.ANGLE_GPS && vt != DanasDataStructureConstants.ValueType.ACC_LAT || this.getAngoliCalcolati())) {
            this.calcolaRaggi();
        }
        if ((vt == DanasDataStructureConstants.ValueType.SIM1 || vt == DanasDataStructureConstants.ValueType.SIM2) && this.frequenzeCanali[DanasDataStructureConstants.ValueType.SIM1.ordinal()] == 0.0) {
            this.creaCanaliSimulazione();
        }
        if (vt.ordinal() >= DanasDataStructureConstants.ValueType.MATH_1.ordinal() && vt.ordinal() <= DanasDataStructureConstants.ValueType.MATH_10.ordinal()) {
            this.verificaCanaleMatematico(vt);
        }
        int inizio = this.getIndiceAtTime(vt, tempoInizio, DanasDataStructureConstants.BoundLap.NEXT);
        int fine = this.getIndiceAtTime(vt, tempoFine, DanasDataStructureConstants.BoundLap.PREVIOUS);
        if (inizio == -1 || fine == -1) {
            return out;
        }
        ArrayDouble origine = this.getAllValueData(vt, convertito);
        for (int i = inizio; i <= fine; ++i) {
            out.add(origine.get(i));
        }
        return out;
    }

    public List<Double> getSelectionValueDataFiltrati(DanasDataStructureConstants.ValueType vt, double tempoInizio, double tempoFine, boolean convertito) {
        ArrayList<Double> out = new ArrayList<Double>();
        if (tempoFine < tempoInizio) {
            return out;
        }
        if (!(vt != DanasDataStructureConstants.ValueType.ANGLE_GPS && vt != DanasDataStructureConstants.ValueType.ACC_LAT || this.getAngoliCalcolati())) {
            this.calcolaRaggi();
        }
        if ((vt == DanasDataStructureConstants.ValueType.SIM1 || vt == DanasDataStructureConstants.ValueType.SIM2) && this.frequenzeCanali[DanasDataStructureConstants.ValueType.SIM1.ordinal()] == 0.0) {
            this.creaCanaliSimulazione();
        }
        if (vt.ordinal() >= DanasDataStructureConstants.ValueType.MATH_1.ordinal() && vt.ordinal() <= DanasDataStructureConstants.ValueType.MATH_10.ordinal()) {
            this.verificaCanaleMatematico(vt);
        }
        int inizio = this.getIndiceAtTime(vt, tempoInizio, DanasDataStructureConstants.BoundLap.NEXT);
        int fine = this.getIndiceAtTime(vt, tempoFine, DanasDataStructureConstants.BoundLap.PREVIOUS);
        if (inizio == -1 || fine == -1) {
            return out;
        }
        ArrayDouble origine = this.getAllValueDataFiltrati(vt, convertito);
        for (int i = inizio; i <= fine; ++i) {
            out.add(origine.get(i));
        }
        return out;
    }

    public ArrayDouble getAllValueData(DanasDataStructureConstants.ValueType vt, boolean convertito) {
        if (!(vt != DanasDataStructureConstants.ValueType.ANGLE_GPS && vt != DanasDataStructureConstants.ValueType.ACC_LAT || this.getAngoliCalcolati())) {
            this.calcolaRaggi();
        }
        if ((vt == DanasDataStructureConstants.ValueType.SIM1 || vt == DanasDataStructureConstants.ValueType.SIM2) && this.frequenzeCanali[DanasDataStructureConstants.ValueType.SIM1.ordinal()] == 0.0) {
            this.creaCanaliSimulazione();
        }
        if (vt.ordinal() >= DanasDataStructureConstants.ValueType.MATH_1.ordinal() && vt.ordinal() <= DanasDataStructureConstants.ValueType.MATH_10.ordinal()) {
            this.verificaCanaleMatematico(vt);
        }
        if (!convertito) {
            return this.getValori(vt);
        }
        ArrayDouble out = new ArrayDouble();
        if (this.getFrequenzaCanale(vt) == 0.0) {
            return out;
        }
        out = new ArrayDouble(this.getValori(vt).size());
        for (int i = 0; i < this.getValori(vt).size(); ++i) {
            out.add(MeasuresUtil.GenericDataConverter(this.getValori(vt).get(i), vt, this));
        }
        return out;
    }

    public ArrayDouble getValueCoordinate(DanasDataStructureConstants.ValueType vt) {
        ArrayDouble out = new ArrayDouble();
        double inizio = this.getTempoIniziale(vt);
        double fine = (double)(this.getDimensioneCanale(vt) * 10) + inizio;
        for (double tempo = inizio; tempo <= fine; tempo += 8.0) {
            out.add(this.getDatoAtTime(vt, tempo, DanasDataStructureConstants.BoundLap.NEAREST, false));
        }
        return out;
    }

    public ArrayDouble getAllValueDataFiltrati(DanasDataStructureConstants.ValueType vt, boolean convertito) {
        double deltaT;
        int elementiFiltro;
        DanasDataStructure.getInstance();
        if ((vt == DanasDataStructureConstants.ValueType.ANALOG2 || vt == DanasDataStructureConstants.ValueType.ANALOG3 || vt == DanasDataStructureConstants.ValueType.dANALOG2 || vt == DanasDataStructureConstants.ValueType.dANALOG3) && this.frequenzeCanali[vt.ordinal()] >= 100.0 && this.frequenzeCanali[vt.ordinal()] != 400.0 && DanasDataStructure.getModInterpolazione()) {
            if (vt == DanasDataStructureConstants.ValueType.ANALOG2 || vt == DanasDataStructureConstants.ValueType.dANALOG2) {
                DanasDataStructure.getInstance().interpolaDati(DanasDataStructureConstants.ValueType.ANALOG2, this);
            }
            if (vt == DanasDataStructureConstants.ValueType.ANALOG3 || vt == DanasDataStructureConstants.ValueType.dANALOG3) {
                DanasDataStructure.getInstance().interpolaDati(DanasDataStructureConstants.ValueType.ANALOG3, this);
            }
        }
        if (!(vt != DanasDataStructureConstants.ValueType.ANGLE_GPS && vt != DanasDataStructureConstants.ValueType.ACC_LAT || this.getAngoliCalcolati())) {
            this.calcolaRaggi();
        }
        if ((vt == DanasDataStructureConstants.ValueType.SIM1 || vt == DanasDataStructureConstants.ValueType.SIM2) && this.frequenzeCanali[DanasDataStructureConstants.ValueType.SIM1.ordinal()] == 0.0) {
            this.creaCanaliSimulazione();
        }
        if (vt.ordinal() >= DanasDataStructureConstants.ValueType.MATH_1.ordinal() && vt.ordinal() <= DanasDataStructureConstants.ValueType.MATH_10.ordinal()) {
            this.verificaCanaleMatematico(vt);
        }
        if (vt == DanasDataStructureConstants.ValueType.SLIP && this.frequenzeCanali[DanasDataStructureConstants.ValueType.SLIP.ordinal()] == 0.0 || vt == DanasDataStructureConstants.ValueType.R_GEARS && this.frequenzeCanali[DanasDataStructureConstants.ValueType.R_GEARS.ordinal()] == 0.0 || vt == DanasDataStructureConstants.ValueType.GEARS && this.frequenzeCanali[DanasDataStructureConstants.ValueType.GEARS.ordinal()] == 0.0) {
            this.ricalcolaValoriSlip(true);
        }
        if ((elementiFiltro = DanasPreferences.getLunghezzaFiltroPro(deltaT = 100.0 / this.frequenzeCanali[vt.ordinal()], vt)) <= 1) {
            if (!convertito) {
                return this.getValori(vt);
            }
            ArrayDouble out = new ArrayDouble();
            if (this.getFrequenzaCanale(vt) == 0.0) {
                return out;
            }
            out = new ArrayDouble(this.getValori(vt).size());
            for (int i = 0; i < this.getValori(vt).size(); ++i) {
                out.add(MeasuresUtil.GenericDataConverter(this.getValori(vt).get(i), vt, this));
            }
            return out;
        }
        ArrayDouble valori = this.getValori(vt);
        ArrayDouble out = new ArrayDouble(valori.size());
        double valore = 0.0;
        if (valori.size() > elementiFiltro && elementiFiltro % 2 == 1) {
            int k;
            int h;
            int lunghezzaFiltroIniziale = 1;
            for (h = 0; h < (elementiFiltro - 1) / 2; ++h) {
                lunghezzaFiltroIniziale = h * 2 + 1;
                valore = 0.0;
                for (k = 0; k < lunghezzaFiltroIniziale; ++k) {
                    valore += valori.get(h - (lunghezzaFiltroIniziale - 1) / 2 + k);
                }
                valore /= (double)lunghezzaFiltroIniziale;
                if (!convertito) {
                    out.add(valore);
                    continue;
                }
                out.add(MeasuresUtil.GenericDataConverter(valore, vt, this));
            }
            for (h = (elementiFiltro - 1) / 2; h < valori.size() - (elementiFiltro - 1) / 2; ++h) {
                valore = 0.0;
                for (k = 0; k < elementiFiltro; ++k) {
                    valore += valori.get(h - (elementiFiltro - 1) / 2 + k);
                }
                valore /= (double)elementiFiltro;
                if (!convertito) {
                    out.add(valore);
                    continue;
                }
                out.add(MeasuresUtil.GenericDataConverter(valore, vt, this));
            }
            for (h = valori.size() - (elementiFiltro - 1) / 2; h < valori.size(); ++h) {
                lunghezzaFiltroIniziale = (valori.size() - 1 - h) * 2 + 1;
                valore = 0.0;
                for (k = 0; k < lunghezzaFiltroIniziale; ++k) {
                    valore += valori.get(h - (lunghezzaFiltroIniziale - 1) / 2 + k);
                }
                valore /= (double)lunghezzaFiltroIniziale;
                if (!convertito) {
                    out.add(valore);
                    continue;
                }
                out.add(MeasuresUtil.GenericDataConverter(valore, vt, this));
            }
            return out;
        }
        return valori;
    }

    public List<DanasValueData> getAllValueData() {
        return this.values;
    }

    public void setNuoviValoriInterpolati(DanasDataStructureConstants.ValueType vt, double[] valori) {
        int puntiFuturi;
        System.out.println("Cambio dati, frequenza attuale=" + this.frequenzeCanali[vt.ordinal()] + " per canale:" + (Object)((Object)vt) + " punti attuali=" + this.getValori(vt).size() + " punti futuri=" + valori.length + " fattore=" + this.getFattoreInterpolazione(vt));
        if (this.frequenzeCanali[vt.ordinal()] == 0.0) {
            return;
        }
        int puntiAttuali = this.getValori(vt).size() * this.getFattoreInterpolazione(vt);
        if (puntiAttuali != (puntiFuturi = valori.length)) {
            return;
        }
        this.frequenzeCanali[vt.ordinal()] = this.frequenzeCanali[vt.ordinal()] * (double)this.getFattoreInterpolazione(vt);
        this.getValori(vt).clear();
        for (int i = 0; i < valori.length; ++i) {
            this.getValori(vt).add(valori[i]);
        }
        DanasDataStructureConstants.ValueType canaleDerivata = null;
        switch (vt) {
            case ANALOG1: {
                canaleDerivata = DanasDataStructureConstants.ValueType.dANALOG1;
                break;
            }
            case ANALOG2: {
                canaleDerivata = DanasDataStructureConstants.ValueType.dANALOG2;
                break;
            }
            case ANALOG3: {
                canaleDerivata = DanasDataStructureConstants.ValueType.dANALOG3;
                break;
            }
            case ANALOG4: {
                canaleDerivata = DanasDataStructureConstants.ValueType.dANALOG4;
                break;
            }
            case ANALOG5: {
                canaleDerivata = DanasDataStructureConstants.ValueType.dANALOG5;
                break;
            }
            case ANALOG6: {
                canaleDerivata = DanasDataStructureConstants.ValueType.dANALOG6;
                break;
            }
            case ANALOG7: {
                canaleDerivata = DanasDataStructureConstants.ValueType.dANALOG7;
                break;
            }
            case ANALOG8: {
                canaleDerivata = DanasDataStructureConstants.ValueType.dANALOG8;
                break;
            }
            case EXT1: {
                canaleDerivata = DanasDataStructureConstants.ValueType.dEXT1;
                break;
            }
            case EXT2: {
                canaleDerivata = DanasDataStructureConstants.ValueType.dEXT2;
                break;
            }
            case EXT3: {
                canaleDerivata = DanasDataStructureConstants.ValueType.dEXT3;
                break;
            }
            case EXT4: {
                canaleDerivata = DanasDataStructureConstants.ValueType.dEXT4;
            }
        }
        System.out.println("Cambiato dati interpolati, frequenza attuale=" + this.frequenzeCanali[vt.ordinal()] + " per canale:" + (Object)((Object)vt));
        if (canaleDerivata == null) {
            return;
        }
        this.frequenzeCanali[canaleDerivata.ordinal()] = this.frequenzeCanali[vt.ordinal()];
        this.getValori(canaleDerivata).clear();
        this.getValori(canaleDerivata).add(0.0);
        for (int i = 1; i < this.getValori(vt).size(); ++i) {
            this.getValori(canaleDerivata).add((this.getValori(vt).get(i) - this.getValori(vt).get(i - 1)) * this.frequenzeCanali[vt.ordinal()]);
        }
        this.consolidaArrayDati();
        this.calcolaTempiDistanze();
    }

    public int getIndiceAtTime(DanasDataStructureConstants.ValueType vt, double time, DanasDataStructureConstants.BoundLap t) {
        if (this.getFrequenzaCanale(vt) == 0.0) {
            return -1;
        }
        ArrayDouble valori = this.getAllValueData(vt, false);
        if (valori.size() == 0) {
            return -1;
        }
        double inizio = this.getTempoIniziale(vt);
        if (time <= inizio) {
            return 0;
        }
        double indiceDouble = (time - inizio) * this.getFrequenzaCanale(vt) / 100.0;
        int indice = 0;
        if (t == DanasDataStructureConstants.BoundLap.NEXT) {
            indice = (int)Math.ceil(indiceDouble);
        }
        if (t == DanasDataStructureConstants.BoundLap.PREVIOUS) {
            indice = (int)Math.floor(indiceDouble);
        }
        if (t == DanasDataStructureConstants.BoundLap.NEAREST) {
            indice = (int)Math.round(indiceDouble);
        }
        if (indice >= valori.size()) {
            return valori.size() - 1;
        }
        return indice;
    }

    public double getTimeAtIndex(DanasDataStructureConstants.ValueType vt, int indice) {
        if (this.frequenzeCanali[vt.ordinal()] == 0.0) {
            return 0.0;
        }
        return this.tempiIniziali[vt.ordinal()] + (double)indice * 100.0 / this.frequenzeCanali[vt.ordinal()];
    }

    public double getDatoAtIndex(DanasDataStructureConstants.ValueType vt, int indice) {
        if (indice > this.getValori(vt).size() - 1) {
            return 0.0;
        }
        return this.getValori(vt).get(indice);
    }

    public GPSPoint getPointAtIndex(int indice) {
        double time = this.getTempoIniziale(DanasDataStructureConstants.ValueType.LAT) + (double)indice * 100.0 / this.getFrequenzaCanale(DanasDataStructureConstants.ValueType.LAT);
        return new GPSPoint(this.getDatoAtIndex(DanasDataStructureConstants.ValueType.LAT, indice), this.getDatoAtIndex(DanasDataStructureConstants.ValueType.LONG, indice), this.getDatoAtIndex(DanasDataStructureConstants.ValueType.VEL_GPS, indice), time);
    }

    public double getDatoAtTime(DanasDataStructureConstants.ValueType vt, double time, DanasDataStructureConstants.BoundLap t, boolean filtrato) {
        if (this.getFrequenzaCanale(vt) == 0.0) {
            return 0.0;
        }
        ArrayDouble valori = this.getAllValueData(vt, false);
        if (valori.size() == 0) {
            return 0.0;
        }
        double inizio = this.getTempoIniziale(vt);
        if (time <= inizio) {
            return MeasuresUtil.GenericDataConverter(valori.get(0), vt, this);
        }
        double indiceDouble = (time - inizio) * this.getFrequenzaCanale(vt) / 100.0;
        int indice = 0;
        if (t == DanasDataStructureConstants.BoundLap.NEXT) {
            indice = (int)Math.ceil(indiceDouble);
        }
        if (t == DanasDataStructureConstants.BoundLap.PREVIOUS) {
            indice = (int)Math.floor(indiceDouble);
        }
        if (t == DanasDataStructureConstants.BoundLap.NEAREST) {
            indice = (int)Math.round(indiceDouble);
        }
        if (indice >= valori.size()) {
            return MeasuresUtil.GenericDataConverter(valori.get(valori.size() - 1), vt, this);
        }
        double origine = MeasuresUtil.GenericDataConverter(valori.get(indice), vt, this);
        if (!filtrato) {
            return origine;
        }
        double deltaT = 100.0 / this.frequenzeCanali[vt.ordinal()];
        int elementiFiltro = DanasPreferences.getLunghezzaFiltroPro(deltaT, vt);
        double valore = 0.0;
        if (elementiFiltro > 1) {
            if (valori.size() > elementiFiltro && elementiFiltro % 2 == 1) {
                if (indice < (elementiFiltro - 1) / 2) {
                    int lunghezzaFiltroIniziale = 1;
                    lunghezzaFiltroIniziale = indice * 2 + 1;
                    valore = 0.0;
                    for (int j = 0; j < lunghezzaFiltroIniziale; ++j) {
                        valore += MeasuresUtil.GenericDataConverter(valori.get(indice - (lunghezzaFiltroIniziale - 1) / 2 + j), vt, this);
                    }
                    return valore /= (double)lunghezzaFiltroIniziale;
                }
                if (indice >= valori.size() - (elementiFiltro - 1) / 2) {
                    int lunghezzaFiltroIniziale = 1;
                    lunghezzaFiltroIniziale = (valori.size() - 1 - indice) * 2 + 1;
                    valore = 0.0;
                    for (int j = 0; j < lunghezzaFiltroIniziale; ++j) {
                        valore += MeasuresUtil.GenericDataConverter(valori.get(indice - (lunghezzaFiltroIniziale - 1) / 2 + j), vt, this);
                    }
                    return valore /= (double)lunghezzaFiltroIniziale;
                }
                for (int j = 0; j < elementiFiltro; ++j) {
                    valore += MeasuresUtil.GenericDataConverter(valori.get(indice - (elementiFiltro - 1) / 2 + j), vt, this);
                }
                return valore /= (double)elementiFiltro;
            }
        } else {
            return origine;
        }
        return origine;
    }

    public double getTempoIniziale(DanasDataStructureConstants.ValueType vt) {
        double ritardo = 0.0;
        if (vt == DanasDataStructureConstants.ValueType.VEL_GPS || vt == DanasDataStructureConstants.ValueType.dVEL_GPS || vt == DanasDataStructureConstants.ValueType.LAT || vt == DanasDataStructureConstants.ValueType.LONG || vt == DanasDataStructureConstants.ValueType.GPS_TIME || vt == DanasDataStructureConstants.ValueType.ALTITUDE || vt == DanasDataStructureConstants.ValueType.ACC_LAT || vt == DanasDataStructureConstants.ValueType.DELAY || vt == DanasDataStructureConstants.ValueType.DDS || vt == DanasDataStructureConstants.ValueType.ANGLE_GPS) {
            ritardo = DanasDataStructure.getOffsetGps();
        }
        return this.tempiIniziali[vt.ordinal()] + ritardo;
    }

    public double getFrequenzaCanale(DanasDataStructureConstants.ValueType vt) {
        return this.frequenzeCanali[vt.ordinal()];
    }

    public List<Double> getValoriSpazio() {
        return this.canaleSpazio;
    }

    public List<Integer> getValoriPosizione() {
        return this.canalePosizioniStechio;
    }

    public List<Boolean> getValoriUsaInStechio() {
        return this.canaleUsaInStechio;
    }

    public double getTimeAtSpazio(double spazio, DanasDataStructureConstants.BoundLap t) {
        if (this.sessioneVuota) {
            return 0.0;
        }
        if (spazio < 0.0) {
            return 0.0;
        }
        List<Double> valori = this.getValoriSpazio();
        double primoDato = valori.get(0);
        double ultimoDato = valori.get(valori.size() - 1);
        if (spazio < primoDato) {
            return this.getTempoPrimoDato();
        }
        if (spazio > ultimoDato) {
            return this.getTempoPrimoDato() + (double)(valori.size() - 1) * this.risoluzioneTemporale;
        }
        for (int i = 1; i < valori.size(); ++i) {
            double distanza = valori.get(i);
            if (distanza > spazio) {
                double dt1 = distanza - spazio;
                double dt2 = spazio - primoDato;
                if (t == DanasDataStructureConstants.BoundLap.NEAREST) {
                    if (dt1 < dt2) {
                        return this.getTempoPrimoDato() + (double)i * this.risoluzioneTemporale;
                    }
                    return this.getTempoPrimoDato() + (double)(i - 1) * this.risoluzioneTemporale;
                }
                if (t == DanasDataStructureConstants.BoundLap.PREVIOUS) {
                    return this.getTempoPrimoDato() + (double)(i - 1) * this.risoluzioneTemporale;
                }
                if (t == DanasDataStructureConstants.BoundLap.NEXT) {
                    return this.getTempoPrimoDato() + (double)i * this.risoluzioneTemporale;
                }
            }
            primoDato = distanza;
        }
        return this.getTempoPrimoDato() + (double)(valori.size() - 1) * this.risoluzioneTemporale;
    }

    public double getSpazioAtTime(double time, DanasDataStructureConstants.BoundLap t) {
        if (this.sessioneVuota) {
            return 0.0;
        }
        List<Double> valori = this.getValoriSpazio();
        if (valori.size() == 0) {
            return 0.0;
        }
        double inizio = this.getTempoPrimoDato();
        if (time <= inizio) {
            return valori.get(0);
        }
        double indiceDouble = (time - inizio) / this.risoluzioneTemporale;
        int indice = 0;
        if (t == DanasDataStructureConstants.BoundLap.NEXT) {
            indice = (int)Math.ceil(indiceDouble);
        }
        if (t == DanasDataStructureConstants.BoundLap.PREVIOUS) {
            indice = (int)Math.floor(indiceDouble);
        }
        if (t == DanasDataStructureConstants.BoundLap.NEAREST) {
            indice = (int)Math.round(indiceDouble);
        }
        if (indice >= valori.size()) {
            return valori.get(valori.size() - 1);
        }
        return valori.get(indice);
    }

    public int getPosizioneStechioAtTime(double time, DanasDataStructureConstants.BoundLap t) {
        if (this.sessioneVuota) {
            return 0;
        }
        List<Integer> valori = this.getValoriPosizione();
        if (valori.size() == 0) {
            return 0;
        }
        double inizio = this.getTempoPrimoDato();
        if (time <= inizio) {
            return valori.get(0);
        }
        double indiceDouble = (time - inizio) / this.risoluzioneTemporale;
        int indice = 0;
        if (t == DanasDataStructureConstants.BoundLap.NEXT) {
            indice = (int)Math.ceil(indiceDouble);
        }
        if (t == DanasDataStructureConstants.BoundLap.PREVIOUS) {
            indice = (int)Math.floor(indiceDouble);
        }
        if (t == DanasDataStructureConstants.BoundLap.NEAREST) {
            indice = (int)Math.round(indiceDouble);
        }
        if (indice >= valori.size()) {
            return valori.get(valori.size() - 1);
        }
        return valori.get(indice);
    }

    public boolean getUsaInStechioAtTime(double time, DanasDataStructureConstants.BoundLap t) {
        if (this.sessioneVuota) {
            return false;
        }
        List<Boolean> valori = this.getValoriUsaInStechio();
        if (valori.size() == 0) {
            return false;
        }
        double inizio = this.getTempoPrimoDato();
        if (time <= inizio) {
            return valori.get(0);
        }
        double indiceDouble = (time - inizio) / this.risoluzioneTemporale;
        int indice = 0;
        if (t == DanasDataStructureConstants.BoundLap.NEXT) {
            indice = (int)Math.ceil(indiceDouble);
        }
        if (t == DanasDataStructureConstants.BoundLap.PREVIOUS) {
            indice = (int)Math.floor(indiceDouble);
        }
        if (t == DanasDataStructureConstants.BoundLap.NEAREST) {
            indice = (int)Math.round(indiceDouble);
        }
        if (indice >= valori.size()) {
            return valori.get(valori.size() - 1);
        }
        return valori.get(indice);
    }

    public void setValorePosizione(double time, int valore) {
        if (this.sessioneVuota) {
            return;
        }
        if (this.canalePosizioniStechio.size() == 0) {
            return;
        }
        double inizio = this.getTempoPrimoDato();
        if (time <= inizio) {
            this.canalePosizioniStechio.set(0, valore);
            return;
        }
        double indiceDouble = (time - inizio) / this.risoluzioneTemporale;
        int indice = (int)Math.round(indiceDouble);
        if (indice >= this.canalePosizioniStechio.size()) {
            this.canalePosizioniStechio.set(this.canalePosizioniStechio.size() - 1, valore);
        } else {
            this.canalePosizioniStechio.set(indice, valore);
        }
    }

    public void setValoreUsaInStechio(double time, boolean valore) {
        if (this.sessioneVuota) {
            return;
        }
        if (this.canaleUsaInStechio.size() == 0) {
            return;
        }
        double inizio = this.getTempoPrimoDato();
        if (time <= inizio) {
            this.canaleUsaInStechio.set(0, valore);
            return;
        }
        double indiceDouble = (time - inizio) / this.risoluzioneTemporale;
        int indice = (int)Math.round(indiceDouble);
        if (indice >= this.canaleUsaInStechio.size()) {
            this.canaleUsaInStechio.set(this.canaleUsaInStechio.size() - 1, valore);
        } else {
            this.canaleUsaInStechio.set(indice, valore);
        }
    }

    public double getTimeSpazioAtTime(double time, DanasDataStructureConstants.BoundLap t) {
        if (this.sessioneVuota) {
            return 0.0;
        }
        List<Double> valori = this.getValoriSpazio();
        if (valori.size() == 0) {
            return 0.0;
        }
        double inizio = this.getTempoPrimoDato();
        if (time <= inizio) {
            return inizio;
        }
        double indiceDouble = (time - inizio) / this.risoluzioneTemporale;
        int indice = 0;
        if (t == DanasDataStructureConstants.BoundLap.NEXT) {
            indice = (int)Math.ceil(indiceDouble);
        }
        if (t == DanasDataStructureConstants.BoundLap.PREVIOUS) {
            indice = (int)Math.floor(indiceDouble);
        }
        if (t == DanasDataStructureConstants.BoundLap.NEAREST) {
            indice = (int)Math.round(indiceDouble);
        }
        if (indice >= valori.size()) {
            return (double)(valori.size() - 1) * this.risoluzioneTemporale + inizio;
        }
        return (double)indice * this.risoluzioneTemporale + inizio;
    }

    public double getTempoPrimoDato() {
        if (this.sessioneVuota) {
            return 0.0;
        }
        return this.tempoPrimoDato;
    }

    public int getIndexSpazioTempoInizio(DanasDataStructureConstants.ValueType vt) {
        double tempoInizio = this.tempiIniziali[vt.ordinal()];
        double tempoInizioAssoluto = this.getTempoPrimoDato();
        if (vt == DanasDataStructureConstants.ValueType.VEL_GPS || vt == DanasDataStructureConstants.ValueType.dVEL_GPS || vt == DanasDataStructureConstants.ValueType.LAT || vt == DanasDataStructureConstants.ValueType.LONG || vt == DanasDataStructureConstants.ValueType.GPS_TIME || vt == DanasDataStructureConstants.ValueType.ALTITUDE || vt == DanasDataStructureConstants.ValueType.ACC_LAT || vt == DanasDataStructureConstants.ValueType.DELAY || vt == DanasDataStructureConstants.ValueType.DDS || vt == DanasDataStructureConstants.ValueType.ANGLE_GPS) {
            tempoInizio = this.tempiIniziali[vt.ordinal()] + (double)DanasDataStructure.getOffsetGps();
        }
        return (int)((tempoInizio - tempoInizioAssoluto) / this.risoluzioneTemporale);
    }

    public double getRisoluzioneTemporale() {
        return this.risoluzioneTemporale;
    }

    public Double getStartTelemetryTime() {
        return this.getTempoPrimoDato();
    }

    public double getEndTelemetryTime() {
        if (!this.sessioneVuota) {
            List<Double> valori = this.getValoriSpazio();
            int size = valori.size();
            double deltaTempo = this.risoluzioneTemporale;
            return this.getTempoPrimoDato() + ((double)size - 1.0) * deltaTempo;
        }
        return 0.0;
    }

    public long getDuration(DanasDataStructureConstants.SelectionFlag f, DanasDataStructureConstants.DataType t) {
        if (!this.sessioneVuota) {
            List<Double> valori = this.getValoriSpazio();
            int size = valori.size();
            double deltaTempo = this.risoluzioneTemporale;
            return (long)(10.0 * ((double)size - 1.0) * deltaTempo);
        }
        return -1L;
    }

    public long getDuration() {
        if (!this.sessioneVuota) {
            List<Double> valori = this.getValoriSpazio();
            int size = valori.size();
            double deltaTempo = this.risoluzioneTemporale;
            return (long)(10.0 * ((double)size - 1.0) * deltaTempo);
        }
        return -1L;
    }

    public double getDistanceCovered(DanasDataStructureConstants.DataType t) {
        double sessionDistance = 0.0;
        switch (t) {
            case GPS: {
                for (int i = 1; i < this.getDimensioneCanale(DanasDataStructureConstants.ValueType.LAT); ++i) {
                    double partialDistance = this.calculateDistanceGPS(this.getPointAtIndex(i - 1), this.getPointAtIndex(i));
                    sessionDistance += partialDistance;
                }
                return sessionDistance;
            }
            case VALUE: {
                if (!this.sessioneVuota) {
                    List<Double> valori = this.getValoriSpazio();
                    int size = valori.size();
                    return valori.get(size - 1);
                }
                return 0.0;
            }
        }
        System.err.println("Error: GPS or VALUE");
        return -1.0;
    }

    public double calcolaDistanzaInizioSessione(DanasDataStructureConstants.ValueType vt, double time) {
        if (this.getFrequenzaCanale(DanasDataStructureConstants.ValueType.LAT) == 0.0 || this.getDimensioneCanale(DanasDataStructureConstants.ValueType.LAT) == 0 || vt == DanasDataStructureConstants.ValueType.SPEED1) {
            double tempoLetto = this.getTimeSpazioAtTime(time, DanasDataStructureConstants.BoundLap.PREVIOUS);
            double dist = this.getDatoAtTime(DanasDataStructureConstants.ValueType.SPEED1, time, DanasDataStructureConstants.BoundLap.PREVIOUS, true) * (time - tempoLetto) / 100.0 / 3.6;
            return dist + this.getSpazioAtTime(time, DanasDataStructureConstants.BoundLap.PREVIOUS);
        }
        double tempoLetto = this.getTimeSpazioAtTime(time, DanasDataStructureConstants.BoundLap.PREVIOUS);
        double dist = this.getDatoAtTime(DanasDataStructureConstants.ValueType.VEL_GPS, time, DanasDataStructureConstants.BoundLap.PREVIOUS, true) * (time - tempoLetto) / 100.0 / 3.6;
        return dist + this.getSpazioAtTime(time, DanasDataStructureConstants.BoundLap.PREVIOUS);
    }

    public void aggiornaAnalisi() {
        ContenitoreGrafico grafico = DanasDataStructure.getInstance().getMainFrame().getContenitoreGrafico();
        try {
            double[][] gva = new double[DanasDataStructureConstants.ValueType.values().length][3];
            if (!grafico.isChannelOnInfo(MeasuresUtil.getPositionType(DanasDataStructureConstants.ValueType.MATH_1))) {
                this.percentualeM1 = -1.0;
            }
            if (!grafico.isChannelOnInfo(MeasuresUtil.getPositionType(DanasDataStructureConstants.ValueType.MATH_2))) {
                this.percentualeM2 = -1.0;
            }
            if (!grafico.isChannelOnInfo(MeasuresUtil.getPositionType(DanasDataStructureConstants.ValueType.MATH_3))) {
                this.percentualeM3 = -1.0;
            }
            if (!grafico.isChannelOnInfo(MeasuresUtil.getPositionType(DanasDataStructureConstants.ValueType.MATH_4))) {
                this.percentualeM4 = -1.0;
            }
            for (DanasDataStructureConstants.ValueType t : DanasDataStructureConstants.ValueType.values()) {
                if (t == DanasDataStructureConstants.ValueType.SIM1 || t == DanasDataStructureConstants.ValueType.SIM2 || !grafico.isChannelOnInfo(MeasuresUtil.getPositionType(t)) && t != DanasDataStructureConstants.ValueType.ANALOG1) continue;
                double max = Double.NaN;
                double min = Double.NaN;
                int gasAperto = 0;
                int m1 = 0;
                int m2 = 0;
                int m3 = 0;
                int m4 = 0;
                int numeroValoriMedia = 0;
                double valoreSomma = 0.0;
                int dimensione = 0;
                ArrayDouble out = this.getAllValueDataFiltrati(t, true);
                if (out != null) {
                    dimensione = out.size();
                }
                for (int i = 0; i < dimensione; ++i) {
                    if (Double.isNaN(max) && !Double.isNaN(out.get(i)) || out.get(i) > max) {
                        max = out.get(i);
                    }
                    if (Double.isNaN(min) && !Double.isNaN(out.get(i)) || out.get(i) < min) {
                        min = out.get(i);
                    }
                    if (!Double.isNaN(out.get(i))) {
                        ++numeroValoriMedia;
                        valoreSomma += out.get(i);
                    }
                    if (t == DanasDataStructureConstants.ValueType.ANALOG1 && out.get(i) > 95.0) {
                        ++gasAperto;
                    }
                    if (t == DanasDataStructureConstants.ValueType.MATH_1 && out.get(i) > 0.0) {
                        ++m1;
                    }
                    if (t == DanasDataStructureConstants.ValueType.MATH_2 && out.get(i) > 0.0) {
                        ++m2;
                    }
                    if (t == DanasDataStructureConstants.ValueType.MATH_3 && out.get(i) > 0.0) {
                        ++m3;
                    }
                    if (t != DanasDataStructureConstants.ValueType.MATH_4 || !(out.get(i) > 0.0)) continue;
                    ++m4;
                }
                gva[t.ordinal()][0] = max;
                gva[t.ordinal()][1] = min;
                gva[t.ordinal()][2] = numeroValoriMedia != 0 ? valoreSomma / (double)numeroValoriMedia : 0.0;
                if (t == DanasDataStructureConstants.ValueType.ANALOG1 && dimensione != 0) {
                    this.percentualeGasAperto = (double)gasAperto / (double)out.size();
                }
                if (t == DanasDataStructureConstants.ValueType.MATH_1 && dimensione != 0) {
                    this.percentualeM1 = (double)m1 / (double)out.size();
                }
                if (t == DanasDataStructureConstants.ValueType.MATH_2 && dimensione != 0) {
                    this.percentualeM2 = (double)m2 / (double)out.size();
                }
                if (t == DanasDataStructureConstants.ValueType.MATH_3 && dimensione != 0) {
                    this.percentualeM3 = (double)m3 / (double)out.size();
                }
                if (t != DanasDataStructureConstants.ValueType.MATH_4 || dimensione == 0) continue;
                this.percentualeM4 = (double)m4 / (double)out.size();
            }
            this.setGenericValueAnalisys(gva);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getFattoreInterpolazione(DanasDataStructureConstants.ValueType vt) {
        switch ((int)this.frequenzeCanali[vt.ordinal()]) {
            case 50: {
                return 8;
            }
            case 100: {
                return 4;
            }
            case 200: {
                return 2;
            }
        }
        return 1;
    }

    public void azzeraUsoePosizioni() {
        if (this.canaleSpazio == null) {
            return;
        }
        int dimensione = this.canaleSpazio.size();
        this.canalePosizioniStechio.clear();
        this.canaleUsaInStechio.clear();
        for (int i = 0; i < dimensione; ++i) {
            this.canalePosizioniStechio.add(0);
            this.canaleUsaInStechio.add(true);
        }
    }

    public void azzeraPosizioniValide() {
        int dimensione = this.canaleSpazio.size();
        this.canalePosizioniStechio.clear();
        for (int i = 0; i < dimensione; ++i) {
            this.canalePosizioniStechio.add(0);
        }
    }

    public String getNomeVariabileCanale(DanasDataStructureConstants.ValueType vt) {
        switch (vt) {
            case VEL_GPS: {
                return "gpsS";
            }
            case dVEL_GPS: {
                return "dgpsS";
            }
            case ACC_LAT: {
                return "lacc";
            }
            case ANGLE_GPS: {
                return "ang";
            }
            case ALTITUDE: {
                return "alt";
            }
            case RPM: {
                return "rpm";
            }
            case SPEED1: {
                return "spd1";
            }
            case SPEED2: {
                return "spd2";
            }
            case ANALOG1: {
                return "An1";
            }
            case ANALOG2: {
                return "An2";
            }
            case ANALOG3: {
                return "An3";
            }
            case ANALOG4: {
                return "An4";
            }
            case ANALOG5: {
                return "An5";
            }
            case ANALOG6: {
                return "An6";
            }
            case ANALOG7: {
                return "An7";
            }
            case ANALOG8: {
                return "An8";
            }
            case dRPM: {
                return "drpm";
            }
            case dSPEED1: {
                return "dspd1";
            }
            case dSPEED2: {
                return "dspd2";
            }
            case dANALOG1: {
                return "dAn1";
            }
            case dANALOG2: {
                return "dAn2";
            }
            case dANALOG3: {
                return "dAn3";
            }
            case dANALOG4: {
                return "dAn4";
            }
            case dANALOG5: {
                return "dAn5";
            }
            case dANALOG6: {
                return "dAn6";
            }
            case dANALOG7: {
                return "dAn7";
            }
            case dANALOG8: {
                return "dAn8";
            }
            case MULTI: {
                return "mu1";
            }
            case MULTI2: {
                return "mu2";
            }
            case MULTI3: {
                return "mu3";
            }
            case MULTI4: {
                return "mu4";
            }
            case MULTI5: {
                return "mu5";
            }
            case MULTI6: {
                return "mu6";
            }
            case MULTI7: {
                return "mu7";
            }
            case MULTI8: {
                return "mu8";
            }
            case MULTI9: {
                return "mu9";
            }
            case MULTI10: {
                return "mu10";
            }
            case EXT1: {
                return "Ext1";
            }
            case EXT2: {
                return "Ext2";
            }
            case EXT3: {
                return "Ext3";
            }
            case EXT4: {
                return "Ext4";
            }
            case dEXT1: {
                return "dExt1";
            }
            case dEXT2: {
                return "dExt2";
            }
            case dEXT3: {
                return "dExt3";
            }
            case dEXT4: {
                return "dExt4";
            }
            case P_ANT: {
                return "pAnt";
            }
            case T_ANT: {
                return "tAnt";
            }
            case P_POST: {
                return "pPost";
            }
            case T_POST: {
                return "tPost";
            }
        }
        if (vt.ordinal() >= DanasDataStructureConstants.ValueType.CAN1.ordinal() && vt.ordinal() <= DanasDataStructureConstants.ValueType.CAN128.ordinal()) {
            String nome = String.format("can%03d", vt.ordinal() - DanasDataStructureConstants.ValueType.CAN1.ordinal() + 1);
            return nome;
        }
        return null;
    }

    public void creaArrayMath(int index) {
        String funzione;
        boolean[] canaliPresenti = new boolean[DanasDataStructureConstants.ValueType.values().length];
        for (int i = 0; i < canaliPresenti.length; ++i) {
            canaliPresenti[i] = false;
        }
        String funzionePulita = funzione = DanasPreferences.getFormulaMath(index, false);
        if (funzione.startsWith("JavaScript(")) {
            String percorsoFile = funzione.substring(11);
            StringTokenizer st = new StringTokenizer(percorsoFile, ",");
            percorsoFile = st.hasMoreTokens() ? st.nextToken() : "";
            canaliPresenti = this.getCanaliPresenti(new File(percorsoFile));
        } else {
            for (int i = 0; i < DanasDataStructureConstants.ValueType.values().length; ++i) {
                String nome = this.getNomeVariabileCanale(DanasDataStructureConstants.ValueType.values()[i]);
                if (nome == null || !funzionePulita.contains(nome)) continue;
                if (!(DanasDataStructureConstants.ValueType.values()[i] != DanasDataStructureConstants.ValueType.ANGLE_GPS && DanasDataStructureConstants.ValueType.values()[i] != DanasDataStructureConstants.ValueType.ACC_LAT || this.getAngoliCalcolati())) {
                    this.calcolaRaggi();
                }
                canaliPresenti[i] = true;
            }
        }
        double frequenza = 0.0;
        double tempoIniziale = 0.0;
        DanasDataStructureConstants.ValueType canaleFrequenzaMax = DanasDataStructureConstants.ValueType.RPM;
        boolean vuoto = true;
        for (int i = 0; i < canaliPresenti.length; ++i) {
            if (!canaliPresenti[i] || !(this.getFrequenzaCanale(DanasDataStructureConstants.ValueType.values()[i]) > frequenza)) continue;
            frequenza = this.getFrequenzaCanale(DanasDataStructureConstants.ValueType.values()[i]);
            tempoIniziale = this.getTempoIniziale(DanasDataStructureConstants.ValueType.values()[i]);
            canaleFrequenzaMax = DanasDataStructureConstants.ValueType.values()[i];
            vuoto = false;
        }
        if (vuoto) {
            frequenza = this.getMaxFrequenza();
            tempoIniziale = this.getTempoPrimoDato();
        }
        if (frequenza == 0.0) {
            return;
        }
        int size = this.getDimensioneCanale(canaleFrequenzaMax);
        double[] mathData = funzione.startsWith("FRIZIONE(") ? this.calcolaFunzioneFrizione(frequenza, tempoIniziale, size, funzione) : (funzione.startsWith("TAGLIO(") || funzione.startsWith("ENGINE_BRAKE(") ? this.calcolaFunzioneTaglioBrake(frequenza, tempoIniziale, size, funzione) : (funzione.startsWith("JavaScript(") ? this.calcolaFunzioneScript(canaliPresenti, frequenza, tempoIniziale, size, funzione) : this.calcolaFunzione(canaliPresenti, frequenza, tempoIniziale, size, funzione)));
        this.frequenzeCanali[DanasDataStructureConstants.ValueType.MATH_1.ordinal() + index] = frequenza;
        this.tempiIniziali[DanasDataStructureConstants.ValueType.MATH_1.ordinal() + index] = tempoIniziale;
        this.valoriCanali[DanasDataStructureConstants.ValueType.MATH_1.ordinal() + index] = new ArrayDouble();
        for (int i = 0; i < mathData.length; ++i) {
            this.valoriCanali[DanasDataStructureConstants.ValueType.MATH_1.ordinal() + index].add(mathData[i]);
        }
        this.formuleMath[index] = funzione;
        this.consolidaArrayDati();
    }

    public void azzeraFunzioniMath() {
        for (int i = 0; i < 10; ++i) {
            this.formuleMath[i] = "0";
        }
    }

    public double[] calcolaFunzioneFrizione(double frequenza, double tempoIniziale, int dimensione, String funzione) {
        double[] valori = MeasuresUtil.estraiParametriFrizione(funzione);
        double marcia = -1.0;
        double[] mathData = new double[dimensione];
        for (int i = 0; i < dimensione; ++i) {
            double time = tempoIniziale + (double)(i * 100) / frequenza;
            int marciaInserita = (int)this.getDatoAtTime(DanasDataStructureConstants.ValueType.MULTI7, time, DanasDataStructureConstants.BoundLap.NEAREST, true);
            double rpm = this.getDatoAtTime(DanasDataStructureConstants.ValueType.RPM, time, DanasDataStructureConstants.BoundLap.NEAREST, true);
            switch (marciaInserita) {
                case 1: {
                    marcia = valori[0];
                    break;
                }
                case 2: {
                    marcia = valori[1];
                    break;
                }
                case 3: {
                    marcia = valori[2];
                    break;
                }
                case 4: {
                    marcia = valori[3];
                    break;
                }
                case 5: {
                    marcia = valori[4];
                    break;
                }
                case 6: {
                    marcia = valori[5];
                    break;
                }
                default: {
                    marcia = -1.0;
                }
            }
            mathData[i] = marcia == -1.0 ? -1.0 : (marcia == 0.0 || valori[6] == 0.0 || valori[8] == 0.0 ? 0.0 : rpm / 1000000.0 * 60.0 / valori[6] / marcia * (valori[7] / valori[8]) * valori[9]);
        }
        return mathData;
    }

    public double[] calcolaFunzioneTaglioBrake(double frequenza, double tempoIniziale, int dimensione, String funzione) {
        double[] mathData = new double[dimensione];
        boolean brake = funzione.startsWith("ENGINE_BRAKE(");
        int[] canali = MeasuresUtil.estraiParametriTaglioBrake(funzione, brake);
        for (int i = 0; i < dimensione; ++i) {
            double time = tempoIniziale + (double)(i * 100) / frequenza;
            double valore1 = this.getDatoAtTime(this.getCanaleTaglioBrake(canali[0]), time, DanasDataStructureConstants.BoundLap.NEAREST, true);
            double valore2 = this.getDatoAtTime(this.getCanaleTaglioBrake(canali[1]), time, DanasDataStructureConstants.BoundLap.NEAREST, true);
            if (brake) {
                if (valore1 - valore2 > 0.0) {
                    mathData[i] = valore1 - valore2;
                    continue;
                }
                mathData[i] = 0.0;
                continue;
            }
            mathData[i] = valore1 - valore2 < 0.0 ? valore2 - valore1 : 0.0;
        }
        return mathData;
    }

    public DanasDataStructureConstants.ValueType getCanaleTaglioBrake(int index) {
        switch (index) {
            case 1: {
                return DanasDataStructureConstants.ValueType.ANALOG1;
            }
            case 2: {
                return DanasDataStructureConstants.ValueType.ANALOG2;
            }
            case 3: {
                return DanasDataStructureConstants.ValueType.ANALOG3;
            }
            case 4: {
                return DanasDataStructureConstants.ValueType.ANALOG4;
            }
            case 5: {
                return DanasDataStructureConstants.ValueType.ANALOG5;
            }
            case 6: {
                return DanasDataStructureConstants.ValueType.ANALOG6;
            }
            case 7: {
                return DanasDataStructureConstants.ValueType.ANALOG7;
            }
            case 8: {
                return DanasDataStructureConstants.ValueType.ANALOG8;
            }
            case 9: {
                return DanasDataStructureConstants.ValueType.MULTI;
            }
            case 10: {
                return DanasDataStructureConstants.ValueType.MULTI2;
            }
            case 11: {
                return DanasDataStructureConstants.ValueType.MULTI3;
            }
            case 12: {
                return DanasDataStructureConstants.ValueType.MULTI4;
            }
            case 13: {
                return DanasDataStructureConstants.ValueType.MULTI5;
            }
            case 14: {
                return DanasDataStructureConstants.ValueType.MULTI6;
            }
            case 15: {
                return DanasDataStructureConstants.ValueType.MULTI7;
            }
            case 16: {
                return DanasDataStructureConstants.ValueType.MULTI8;
            }
            case 17: {
                return DanasDataStructureConstants.ValueType.MULTI9;
            }
            case 18: {
                return DanasDataStructureConstants.ValueType.MULTI10;
            }
            case 19: {
                return DanasDataStructureConstants.ValueType.EXT1;
            }
            case 20: {
                return DanasDataStructureConstants.ValueType.EXT2;
            }
            case 21: {
                return DanasDataStructureConstants.ValueType.EXT3;
            }
            case 22: {
                return DanasDataStructureConstants.ValueType.EXT4;
            }
        }
        if (index > 22 && index <= 150) {
            return DanasDataStructureConstants.ValueType.values()[DanasDataStructureConstants.ValueType.CAN1.ordinal() + index - 23];
        }
        return DanasDataStructureConstants.ValueType.ANALOG1;
    }

    public double[] calcolaFunzione(boolean[] canaliPresenti, double frequenza, double tempoIniziale, int dimensione, String funzione) {
        String nomeArray;
        double[] mathData = new double[dimensione];
        ScriptEngineManager factory = new ScriptEngineManager();
        final ScriptEngine engine = factory.getEngineByName("JavaScript");
        final MyBuffer finito = new MyBuffer();
        double[] tempo = new double[dimensione];
        for (int i = 0; i < canaliPresenti.length; ++i) {
            if (!canaliPresenti[i]) continue;
            double[] valori = new double[dimensione];
            for (int indice = 0; indice < dimensione; ++indice) {
                double time = tempoIniziale + (double)(indice * 100) / frequenza;
                valori[indice] = this.getDatoAtTime(DanasDataStructureConstants.ValueType.values()[i], time, DanasDataStructureConstants.BoundLap.NEAREST, true);
                tempo[indice] = time;
            }
            nomeArray = this.getNomeVariabileCanale(DanasDataStructureConstants.ValueType.values()[i]) + "b";
            if (nomeArray.equals("mu10b")) {
                nomeArray = "muXb";
            }
            engine.put(nomeArray, valori);
        }
        engine.put("tempob", tempo);
        engine.put("finito", finito);
        engine.put("mathData", mathData);
        engine.put("dimensione", dimensione);
        String nuovaVersione = funzione;
        for (int i = 0; i < canaliPresenti.length; ++i) {
            if (i == DanasDataStructureConstants.ValueType.dRPM.ordinal() || i == DanasDataStructureConstants.ValueType.dSPEED1.ordinal() || i == DanasDataStructureConstants.ValueType.dSPEED2.ordinal() || i >= DanasDataStructureConstants.ValueType.dANALOG1.ordinal() && i <= DanasDataStructureConstants.ValueType.dANALOG8.ordinal() || i == DanasDataStructureConstants.ValueType.dEXT1.ordinal() || i == DanasDataStructureConstants.ValueType.dEXT2.ordinal() || i == DanasDataStructureConstants.ValueType.dEXT3.ordinal() || i == DanasDataStructureConstants.ValueType.dEXT4.ordinal() || i == DanasDataStructureConstants.ValueType.dVEL_GPS.ordinal() || !canaliPresenti[i]) continue;
            String nomeOrigine = this.getNomeVariabileCanale(DanasDataStructureConstants.ValueType.values()[i]);
            nomeArray = nomeOrigine.equals("mu10") ? "muXb[x]" : nomeOrigine + "b[x]";
            nuovaVersione = nuovaVersione.replace(nomeOrigine, nomeArray);
        }
        nuovaVersione = this.replaceDerivative2(nuovaVersione);
        nuovaVersione = this.replaceDerivative(nuovaVersione);
        System.out.println("Log:nuova stringa calcolo math=" + nuovaVersione);
        final String prog2 = "function log10(x){return Math.log(x)/Math.log(10);}function BIT(x,indice){return (x&(Math.pow(2,indice)))/Math.pow(2,indice);}function IF(cond,a,b){if (cond){return a;}else{return b;}}function EXTRACT(valore,cifra){if (cifra==0) {return 0};res=valore; if (valore<0) {res=-valore};  sopra=res-(Math.floor(res/Math.pow(10,cifra))*Math.pow(10,cifra));res=Math.floor(sopra/Math.pow(10,cifra-1))  ;return res;}function DER(expr){if(x==0) { prec=eval(expr); x++; succ=eval(expr);x--; return (succ-prec)/(tempob[x+1]-tempob[x])/0.01;} else {x--, prec=eval(expr); x++; succ=eval(expr); return (succ-prec)/(tempob[x]-tempob[x-1])/0.01;}}function DER2(expr){if(x>=2) { x=x-2; prec2=eval(expr); x++; prec=eval(expr); x++; succ=eval(expr); return (   (((succ-prec)/(tempob[x]-tempob[x-1])/0.01)-((prec-prec2)/(tempob[x-1]-tempob[x-2])/0.01))/(tempob[x]-tempob[x-1])/0.01);} else {old=x; x=0; prec2=eval(expr); x++; prec=eval(expr); x++; succ=eval(expr);x=old; return ((((succ-prec)/(tempob[2]-tempob[1])/0.01)-((prec-prec2)/(tempob[1]-tempob[0])/0.01))/(tempob[2]-tempob[1])/0.01); }}for(x=0;x<dimensione;x++){with (Math){y=" + nuovaVersione + ";} mathData[x]=y;}finito.put(1);";
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    engine.eval(prog2);
                }
                catch (Exception ex) {
                    System.out.println("Log:Errore eval JavaScript");
                    ex.printStackTrace();
                    try {
                        finito.put(1.0);
                    }
                    catch (Exception e) {
                        System.out.println("Log:Errore asegnamento durante la eval");
                    }
                }
            }
        };
        t.start();
        try {
            finito.get();
        }
        catch (Exception e) {
            System.out.println("Log:Errore asegnamento");
        }
        for (int i = 0; i < mathData.length; ++i) {
            if (!Double.isInfinite(mathData[i]) && !Double.isInfinite(-mathData[i]) && !Double.isNaN(mathData[i])) continue;
            mathData[i] = 0.0;
        }
        return mathData;
    }

    public boolean[] getCanaliPresenti(File f) {
        boolean[] canaliPresenti = new boolean[DanasDataStructureConstants.ValueType.values().length];
        for (int i = 0; i < canaliPresenti.length; ++i) {
            canaliPresenti[i] = false;
        }
        try {
            FileInputStream fis2 = new FileInputStream(f);
            InputStreamReader isr2 = new InputStreamReader(fis2);
            BufferedReader br2 = new BufferedReader(isr2);
            String line = br2.readLine();
            while (line != null) {
                for (int i = 0; i < DanasDataStructureConstants.ValueType.values().length; ++i) {
                    String nome = this.getNomeVariabileCanale(DanasDataStructureConstants.ValueType.values()[i]);
                    if (nome == null) continue;
                    if (!(DanasDataStructureConstants.ValueType.values()[i] != DanasDataStructureConstants.ValueType.ANGLE_GPS && DanasDataStructureConstants.ValueType.values()[i] != DanasDataStructureConstants.ValueType.ACC_LAT || this.getAngoliCalcolati())) {
                        this.calcolaRaggi();
                    }
                    if (!line.contains(nome)) continue;
                    canaliPresenti[i] = true;
                }
                line = br2.readLine();
            }
            fis2.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return canaliPresenti;
    }

    public double[] calcolaFunzioneScript(boolean[] canaliPresenti, double frequenza, double tempoIniziale, int dimensione, String funzione) {
        double[] mathData = new double[dimensione];
        String percorsoFile = funzione.substring(11);
        StringTokenizer st = new StringTokenizer(percorsoFile, ",");
        percorsoFile = st.hasMoreTokens() ? st.nextToken() : "";
        System.out.println("Percorso file javascript=" + percorsoFile);
        ScriptEngineManager factory = new ScriptEngineManager();
        final ScriptEngine engine = factory.getEngineByName("JavaScript");
        final MyBuffer fineScript = new MyBuffer();
        for (int i = 0; i < canaliPresenti.length; ++i) {
            if (!canaliPresenti[i]) continue;
            double[] valori = new double[dimensione];
            for (int indice = 0; indice < dimensione; ++indice) {
                double time = tempoIniziale + (double)(indice * 100) / frequenza;
                valori[indice] = this.getDatoAtTime(DanasDataStructureConstants.ValueType.values()[i], time, DanasDataStructureConstants.BoundLap.NEAREST, false);
            }
            String nome = this.getNomeVariabileCanale(DanasDataStructureConstants.ValueType.values()[i]);
            engine.put(nome, valori);
        }
        double[] tempo = new double[dimensione];
        for (int i = 0; i < dimensione; ++i) {
            tempo[i] = (double)(i * 1) / frequenza;
        }
        engine.put("fineScript", fineScript);
        engine.put("output", mathData);
        engine.put("size", dimensione);
        engine.put("time", tempo);
        try {
            File f = File.createTempFile("tempScript", "tmp");
            f.deleteOnExit();
            MeasuresUtil.copy(new File(percorsoFile), f);
            PrintWriter scriviFile = new PrintWriter(new FileWriter(f, true));
            scriviFile.printf("\n\r fineScript.put(1);", new Object[0]);
            scriviFile.close();
            this.reader = new FileReader(f);
            Thread t = new Thread(){

                @Override
                public void run() {
                    try {
                        engine.eval(DanasSession.this.reader);
                    }
                    catch (Exception ex) {
                        System.out.println("Errore JavaScript");
                        ex.printStackTrace();
                        try {
                            fineScript.put(0.0);
                        }
                        catch (Exception e) {
                            System.out.println("Errore asegnamento");
                        }
                    }
                }
            };
            t.start();
            try {
                fineScript.get();
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (int i = 0; i < mathData.length; ++i) {
                if (!Double.isInfinite(mathData[i]) && !Double.isInfinite(-mathData[i]) && !Double.isNaN(mathData[i])) continue;
                mathData[i] = 0.0;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return mathData;
    }

    private void creaCanaliSimulazione() {
        DanasDataStructureConstants.ValueType canaleTps;
        double frequenzaMassima = 0.0;
        double tempoIniziale = 0.0;
        if (!DanasDataStructure.getInstance().getSimulazioneMarcieAttiva()) {
            return;
        }
        switch (DanasPreferences.getCanaleTpsSimulazione()) {
            case 0: {
                canaleTps = DanasDataStructureConstants.ValueType.ANALOG1;
                break;
            }
            case 1: {
                canaleTps = DanasDataStructureConstants.ValueType.ANALOG2;
                break;
            }
            case 2: {
                canaleTps = DanasDataStructureConstants.ValueType.ANALOG3;
                break;
            }
            case 3: {
                canaleTps = DanasDataStructureConstants.ValueType.ANALOG4;
                break;
            }
            case 4: {
                canaleTps = DanasDataStructureConstants.ValueType.ANALOG5;
                break;
            }
            case 5: {
                canaleTps = DanasDataStructureConstants.ValueType.ANALOG6;
                break;
            }
            case 6: {
                canaleTps = DanasDataStructureConstants.ValueType.ANALOG7;
                break;
            }
            case 7: {
                canaleTps = DanasDataStructureConstants.ValueType.ANALOG8;
                break;
            }
            case 8: {
                canaleTps = DanasDataStructureConstants.ValueType.EXT1;
                break;
            }
            case 9: {
                canaleTps = DanasDataStructureConstants.ValueType.EXT2;
                break;
            }
            case 10: {
                canaleTps = DanasDataStructureConstants.ValueType.EXT3;
                break;
            }
            case 11: {
                canaleTps = DanasDataStructureConstants.ValueType.EXT4;
                break;
            }
            default: {
                canaleTps = DanasDataStructureConstants.ValueType.ANALOG1;
            }
        }
        DanasDataStructureConstants.ValueType canaleMarce = DanasPreferences.getCanaleMarceSimulazione() == 1 ? DanasDataStructureConstants.ValueType.MULTI7 : DanasDataStructureConstants.ValueType.GEARS;
        DanasDataStructureConstants.ValueType canaleFrequenzaMax = DanasDataStructureConstants.ValueType.RPM;
        if (this.getFrequenzaCanale(DanasDataStructureConstants.ValueType.SPEED1) > frequenzaMassima) {
            canaleFrequenzaMax = DanasDataStructureConstants.ValueType.SPEED1;
        }
        if (this.getFrequenzaCanale(canaleTps) > frequenzaMassima) {
            canaleFrequenzaMax = canaleTps;
        }
        if (this.getFrequenzaCanale(canaleMarce) > frequenzaMassima) {
            canaleFrequenzaMax = canaleMarce;
        }
        frequenzaMassima = this.getFrequenzaCanale(canaleFrequenzaMax);
        tempoIniziale = this.getTempoIniziale(canaleFrequenzaMax);
        int dimensione = this.getDimensioneCanale(canaleFrequenzaMax);
        double[] rpmb = new double[dimensione];
        double[] spd1b = new double[dimensione];
        double[] tps = new double[dimensione];
        double[] gear = new double[dimensione];
        if (this.valoriCanali[DanasDataStructureConstants.ValueType.SIM1.ordinal()] != null) {
            this.valoriCanali[DanasDataStructureConstants.ValueType.SIM1.ordinal()].clear();
            this.valoriCanali[DanasDataStructureConstants.ValueType.SIM2.ordinal()].clear();
        } else {
            this.valoriCanali[DanasDataStructureConstants.ValueType.SIM1.ordinal()] = new ArrayDouble();
            this.valoriCanali[DanasDataStructureConstants.ValueType.SIM2.ordinal()] = new ArrayDouble();
        }
        this.frequenzeCanali[DanasDataStructureConstants.ValueType.SIM1.ordinal()] = frequenzaMassima;
        this.frequenzeCanali[DanasDataStructureConstants.ValueType.SIM2.ordinal()] = frequenzaMassima;
        this.tempiIniziali[DanasDataStructureConstants.ValueType.SIM1.ordinal()] = tempoIniziale;
        this.tempiIniziali[DanasDataStructureConstants.ValueType.SIM2.ordinal()] = tempoIniziale;
        for (int i = 0; i < dimensione; ++i) {
            double time = tempoIniziale + (double)(i * 100) / frequenzaMassima;
            rpmb[i] = this.getDatoAtTime(DanasDataStructureConstants.ValueType.RPM, time, DanasDataStructureConstants.BoundLap.NEAREST, true);
            spd1b[i] = this.getDatoAtTime(DanasDataStructureConstants.ValueType.SPEED1, time, DanasDataStructureConstants.BoundLap.NEAREST, true);
            tps[i] = this.getDatoAtTime(canaleTps, time, DanasDataStructureConstants.BoundLap.NEAREST, true);
            gear[i] = this.getDatoAtTime(canaleMarce, time, DanasDataStructureConstants.BoundLap.NEAREST, true);
        }
        DanasDataStructure.getInstance().calcolaParametriSimulazione();
        double marciaPrecedente = 1.0;
        Double[] rs = new Double[dimensione];
        Double[] ms = new Double[dimensione];
        for (int i = 0; i < dimensione; ++i) {
            Double[] risultato = new Double[2];
            risultato = DanasDataStructure.getInstance().getValoriSimulati(rpmb[i], tps[i], (int)gear[i], (int)marciaPrecedente);
            this.valoriCanali[DanasDataStructureConstants.ValueType.SIM1.ordinal()].add(risultato[0]);
            this.valoriCanali[DanasDataStructureConstants.ValueType.SIM2.ordinal()].add(risultato[1]);
            marciaPrecedente = risultato[1];
        }
        this.consolidaArrayDati();
    }

    public String cacheCanale(DanasDataStructureConstants.ValueType vt) {
        long tempoInizio = System.currentTimeMillis();
        try {
            File f = File.createTempFile(this.getSessionID() + vt.toString(), null);
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(f)));
            ArrayDouble valori = this.getAllValueData(vt, false);
            for (int i = 0; i < valori.size(); ++i) {
                out.writeDouble(valori.get(i));
            }
            out.close();
            System.out.println("Log:tempo cache " + (Object)((Object)vt) + ":" + (double)(System.currentTimeMillis() - tempoInizio) / 1000.0);
            return f.getAbsolutePath();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<Double> readCached(String absolutepath) {
        long tempoInizio = System.currentTimeMillis();
        File file = new File(absolutepath);
        long dimensione = file.length();
        ArrayList<Double> canaleLetto = new ArrayList<Double>();
        try {
            DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
            for (long i = 0L; i < dimensione / 8L; ++i) {
                canaleLetto.add(in.readDouble());
            }
            in.close();
            System.out.println("Log:tempo lettura cache x " + canaleLetto.size() + " valori:" + (double)(System.currentTimeMillis() - tempoInizio) / 1000.0);
            return canaleLetto;
        }
        catch (Exception e1) {
            e1.printStackTrace();
            return canaleLetto;
        }
    }

    private void findGears() {
        GearValueTime old_gear = null;
        double frequenza = 0.0;
        double tempoIniziale = 0.0;
        DanasDataStructureConstants.ValueType canaleFrequenzaMax = DanasDataStructureConstants.ValueType.RPM;
        if (this.getFrequenzaCanale(DanasDataStructureConstants.ValueType.SPEED1) > frequenza) {
            frequenza = this.getFrequenzaCanale(DanasDataStructureConstants.ValueType.SPEED1);
            tempoIniziale = this.getTempoIniziale(DanasDataStructureConstants.ValueType.SPEED1);
            canaleFrequenzaMax = DanasDataStructureConstants.ValueType.SPEED1;
        }
        if (frequenza == 0.0) {
            return;
        }
        int dimensione = this.getDimensioneCanale(canaleFrequenzaMax);
        for (int i = 0; i < dimensione; ++i) {
            int idx;
            double time = tempoIniziale + (double)(i * 100) / frequenza;
            double rpm = this.getDatoAtTime(DanasDataStructureConstants.ValueType.RPM, time, DanasDataStructureConstants.BoundLap.NEAREST, true);
            double speed = this.getDatoAtTime(DanasDataStructureConstants.ValueType.RPM, time, DanasDataStructureConstants.BoundLap.NEAREST, true);
            double vel = 1.0 / (speed * 2.56E-5);
            double rps = MeasuresUtil.doubleToRPM(rpm) / 60.0;
            double gear = DanasSession.normalizeGear(rps / vel);
            if (gear > 15.0) continue;
            GearValueTime vt = new GearValueTime(gear);
            if (old_gear != null) {
                if (!old_gear.equals(vt)) {
                    old_gear = vt;
                    continue;
                }
                old_gear.increase();
                if (old_gear.time < 10) continue;
            }
            if ((idx = this.gears.indexOf(vt)) == -1) {
                this.gears.add(vt);
            } else {
                GearValueTime tmp = this.gears.get(idx);
                tmp.increase();
                tmp.value = DanasSession.normalizeGear((tmp.value + vt.value) / 2.0);
                this.gears.set(idx, tmp);
            }
            old_gear = vt;
        }
    }

    public class MyBuffer {
        private Double data = null;

        public synchronized double get() throws Exception {
            while (this.data == null) {
                this.wait();
            }
            double d = this.data;
            this.data = null;
            this.notifyAll();
            return d;
        }

        public synchronized void put(double d) throws Exception {
            while (this.data != null) {
                this.wait();
            }
            this.data = d;
            this.notifyAll();
        }
    }
}

