/*
 * Decompiled with CFR 0.152.
 */
package i2m.DataStructure.danasDataStructure;

import i2m.DataStructure.danasDataStructure.DanasDataStructure;
import i2m.DataStructure.danasDataStructure.DanasDataStructureConstants;
import i2m.DataStructure.danasDataStructure.DanasIRData;
import i2m.DataStructure.danasDataStructure.DanasLap;
import i2m.DataStructure.danasDataStructure.DanasSession;
import i2m.DataStructure.danasDataStructure.DanasSessionSettings;
import i2m.DataStructure.danasDataStructure.DanasValueData;
import i2m.DataStructure.danasDataStructure.GPSPoint;
import i2m.Dialog.HwDasy6;
import i2m.traguardi.Circuit;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class DanasParserTask
implements Runnable {
    private static DanasDataStructure ds;
    private File f;
    private String t;
    private String imposFileName;
    private int sid;
    public static Boolean terminate;
    private static int tipoMotoImpos;
    double lastGPSTelemetry = 0.0;
    double lastValueTelemetry = 0.0;
    int percentualeTest = 0;
    List<DanasDataStructureConstants.ValueType>[] canaliPresenti = new List[DanasDataStructureConstants.FrequenzeDisponibili.values().length];

    public DanasParserTask(File f, String t, DanasDataStructure ds) {
        this.f = f;
        this.t = t;
        DanasParserTask.ds = ds;
    }

    public DanasParserTask(String f, String t, DanasDataStructure ds, int sid) {
        this.imposFileName = f;
        this.t = t;
        DanasParserTask.ds = ds;
        this.sid = sid;
    }

    @Override
    public void run() {
        boolean abilitato = DanasDataStructure.getInstance().getEnableNotifier();
        if (this.t.equals("Fill")) {
            DanasDataStructure.getInstance().disableNotifier();
            this.fillDSfromFile();
            if (abilitato) {
                DanasDataStructure.getInstance().enableNotifier();
            }
        } else {
            try {
                DanasParserTask.parseImposFile(this.imposFileName, this.sid, true);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        System.out.println("Log:finito il parser task:" + (double)(System.currentTimeMillis() - DanasDataStructure.getTempoApertura()) / 1000.0);
    }

    private void fillDSfromFile() {
        ArrayList listaDimensioni = new ArrayList();
        ArrayList<String[]> listaStringheIniziali = new ArrayList<String[]>();
        ArrayList<String[]> listaStringheFinali = new ArrayList<String[]>();
        String[] elencoPrimeStringhe = null;
        String[] elencoUltimeStringhe = null;
        int numeroRighe = 0;
        int indiceSessione = 0;
        boolean scambiaAnalogici = DanasDataStructure.getInstance().getScambiaAnalogici();
        System.out.println("Log:Inizio fillDSfromFile:" + (double)(System.currentTimeMillis() - DanasDataStructure.getTempoApertura()) / 1000.0);
        try {
            FileInputStream fis2 = new FileInputStream(this.f);
            InputStreamReader isr2 = new InputStreamReader(fis2);
            BufferedReader br2 = new BufferedReader(isr2);
            Object line2 = br2.readLine();
            long tempoApertura = System.currentTimeMillis();
            while (line2 != null) {
                int i;
                ++numeroRighe;
                if (((String)line2).startsWith("$NEW SESSION")) {
                    elencoPrimeStringhe = new String[DanasDataStructureConstants.FrequenzeDisponibili.values().length + 1];
                    elencoUltimeStringhe = new String[DanasDataStructureConstants.FrequenzeDisponibili.values().length + 1];
                    listaStringheIniziali.add(elencoPrimeStringhe);
                    listaStringheFinali.add(elencoUltimeStringhe);
                    for (i = 0; i < DanasDataStructureConstants.FrequenzeDisponibili.values().length + 1; ++i) {
                        elencoPrimeStringhe[i] = null;
                        elencoUltimeStringhe[i] = null;
                    }
                }
                if (((String)line2).startsWith("$GPS")) {
                    if (elencoPrimeStringhe[0] == null) {
                        elencoPrimeStringhe[0] = line2;
                        elencoUltimeStringhe[0] = line2;
                    } else {
                        elencoUltimeStringhe[0] = line2;
                    }
                }
                for (i = 0; i < DanasDataStructureConstants.FrequenzeDisponibili.values().length; ++i) {
                    String stringaFrequenza = "$VAL," + (int)DanasDataStructureConstants.FrequenzeDisponibili.values()[i].frequenza() + ",";
                    if (!((String)line2).startsWith(stringaFrequenza)) continue;
                    if (elencoPrimeStringhe[i + 1] == null) {
                        elencoPrimeStringhe[i + 1] = line2;
                        elencoUltimeStringhe[i + 1] = line2;
                        continue;
                    }
                    elencoUltimeStringhe[i + 1] = line2;
                }
                line2 = br2.readLine();
            }
            System.out.println("Eseguito pre scan in :" + (double)(System.currentTimeMillis() - tempoApertura) / 1000.0);
            fis2.close();
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int sid = 0;
        int pid = 0;
        int lapid = 0;
        for (DanasSession s : ds.getSessions()) {
            if (s.getSessionID() <= sid) continue;
            sid = s.getSessionID();
        }
        long lineNumber = 0L;
        try {
            FileInputStream fis = new FileInputStream(this.f);
            InputStreamReader isr = new InputStreamReader(fis);
            BufferedReader br = new BufferedReader(isr);
            String line = br.readLine();
            int iii = 0;
            while (line != null && !terminate.booleanValue()) {
                int o = numeroRighe / 95;
                if (++iii >= o - 1 && iii <= o + 1) {
                    int attuale = ds.getPercentualeApertura();
                    ds.setPercentualeApertura(attuale + 1);
                    iii = 0;
                }
                ++lineNumber;
                if (line.startsWith("$CIRCUIT")) {
                    try {
                        String newLine = line.substring(9);
                        if (newLine.startsWith("T,") || newLine.startsWith("t,")) {
                            Circuit c = new Circuit(newLine);
                            DanasDataStructure.getInstance().setCircuitoImportato(c);
                            System.out.println("Log:circuito trovato nel file, line=" + newLine);
                        }
                        if (newLine.startsWith("S,") || newLine.startsWith("s,")) {
                            if (DanasDataStructure.getInstance().getCircuitoImportato() != null) {
                                DanasDataStructure.getInstance().getCircuitoImportato().aggiungiSplit(newLine);
                            }
                            System.out.println("Log:circuito trovato nel file, line=" + newLine);
                        }
                    }
                    catch (Exception e) {
                        System.out.println("DEBUG: errore importazione circuito");
                    }
                }
                if (line.compareTo("$NEW SESSION") == 0) {
                    ++indiceSessione;
                    tipoMotoImpos = -1;
                    this.newSessionParser(line, ++sid, ++pid, this.f.getName());
                    lapid = 0;
                    for (DanasLap l : ds.getSession(sid).getLaps()) {
                        if (l.getLapID() <= lapid) continue;
                        lapid = l.getLapID();
                    }
                    try {
                        DanasParserTask.parseImposFile(DanasDataStructure.getInstance().getDefaultSettingsFile(), sid, false);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        System.err.println("ERROR defaultSettings.dfs\n");
                    }
                    this.canaliPresenti = new List[DanasDataStructureConstants.FrequenzeDisponibili.values().length];
                } else if (!line.equals("") && line.charAt(0) == '$') {
                    StringTokenizer st = new StringTokenizer(line, ",");
                    String t = st.nextToken();
                    t.replace(" ", "");
                    try {
                        LineDescriptor ld = LineDescriptor.valueOf(t);
                        switch (ld) {
                            case $CANALI: {
                                this.parseCanali(line);
                                break;
                            }
                            case $TYPE_CHROME: {
                                if (!DanasDataStructure.getInstance().getScambiaAnalogiciChrome()) break;
                                scambiaAnalogici = true;
                                break;
                            }
                            case $TYPE_DATALOG: {
                                if (!DanasDataStructure.getInstance().getScambiaAnalogiciDatalog()) break;
                                scambiaAnalogici = true;
                                break;
                            }
                            case $SETTAGGICANALI: {
                                DanasParserTask.parseSettaggiCanali(line, sid, this.f.getName(), true, scambiaAnalogici);
                                break;
                            }
                            case $SETTAGGIBASE: {
                                DanasParserTask.parseSettaggiBase(line, sid, this.f.getName(), true);
                                break;
                            }
                            case $VAL: {
                                this.parseValori(line, sid, scambiaAnalogici);
                                break;
                            }
                            case $NOTE: {
                                this.parseNote(line, sid);
                                break;
                            }
                            case $DATE: {
                                this.parseDate(line, sid);
                                break;
                            }
                            case $IMPOS: {
                                DanasDataStructure.impostazioni6 = new HwDasy6();
                                DanasDataStructure.impostazioni6.parseImposString6(line);
                                tipoMotoImpos = DanasDataStructure.impostazioni6.getSetting(17);
                                System.out.println("Log:Tipo moto impos=" + tipoMotoImpos);
                                break;
                            }
                            case $PATH: {
                                break;
                            }
                            case $CHECK: {
                                break;
                            }
                            case $GPS: {
                                this.parseGps(line, sid);
                                break;
                            }
                            case $VALUE: {
                                this.parseValue(line, sid, scambiaAnalogici);
                                break;
                            }
                            case $FORMULE: {
                                this.parseFormule(line, sid);
                                break;
                            }
                            case $IR: {
                                this.parseIr(line, sid, ++lapid);
                                break;
                            }
                            case $PILOTA: {
                                this.parsePilota(line, sid);
                                break;
                            }
                            case $TIPO: {
                                this.parseTipo(line, sid);
                                break;
                            }
                            case $NEW_LAP: {
                                this.parseNewlap(line, sid);
                                break;
                            }
                            case $SETTINGS: {
                                DanasParserTask.parseInternalImpos(line, sid, this.f.getName(), scambiaAnalogici);
                                ds.getSession(sid).setSettaggioInterno(true);
                                break;
                            }
                            case $VIDEO: {
                                this.parseVideo(line, sid);
                                break;
                            }
                            case $OFFSET_VIDEO: {
                                this.parseOffset(line, sid);
                                break;
                            }
                            case $FUSO: {
                                this.parseFuso(line, sid);
                                break;
                            }
                            case $SESSION_COLOR: {
                                StringTokenizer st1 = new StringTokenizer(line, ",");
                                String tt = st1.nextToken();
                                tt = st1.nextToken();
                                Color c = new Color(Integer.parseInt((String)tt.subSequence(0, 3)), Integer.parseInt((String)tt.subSequence(3, 6)), Integer.parseInt((String)tt.subSequence(6, 9)));
                                ds.getSession(sid).setColor(c);
                                break;
                            }
                        }
                    }
                    catch (Exception ex) {
                        System.err.println("ERROR in file: " + this.f.getAbsolutePath() + " at line: " + lineNumber);
                        System.err.println(line);
                        ex.printStackTrace();
                    }
                }
                if (terminate.booleanValue()) {
                    terminate = false;
                    break;
                }
                line = br.readLine();
            }
            if (ds.getSessions().size() > 0) {
                ds.setDefaultSession(ds.getSessions().get(0));
            }
            if (DanasDataStructure.getInstance().getApriUltimaSessione()) {
                try {
                    if (ds.getSession(ds.getNSessions()) != null) {
                        ds.getSession(ds.getNSessions()).select();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            for (DanasSession dans : ds.getSessions()) {
                if (dans.getAllIRData().size() <= 0 || dans.getLaps().size() != 0) continue;
                System.out.println("Giri IR creati");
                dans.createLaps(false);
            }
            if (ds.getNSessions() > 0 && ds.getDefaultLap() == null) {
                for (DanasSession das : ds.getSessions()) {
                    if (das.getNumberOfLaps() <= 0) continue;
                    ds.setDefaultLap(das.getLaps().get(0));
                    break;
                }
            }
            int attuale = ds.getPercentualeApertura();
            ds.setPercentualeApertura(attuale + 5);
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ds.setPercentualeApertura(100);
            fis.close();
        }
        catch (FileNotFoundException e) {
            System.err.println("ERROR file: " + this.f.getAbsolutePath() + " not found");
            ds.setPercentualeApertura(100);
            JOptionPane.showMessageDialog(new JPanel(), "File not found!\n" + this.f.getAbsolutePath(), "Error", 0);
            ds.clearDataStructure();
        }
        catch (IOException e) {
            System.err.println("ERROR in file: " + this.f.getAbsolutePath() + " I/O error");
            ds.setPercentualeApertura(100);
            JOptionPane.showMessageDialog(new JPanel(), " I/O error!\n" + this.f.getAbsolutePath(), "Error", 0);
            ds.clearDataStructure();
        }
    }

    private double parseTempoFrase(String line, boolean isGps) {
        StringTokenizer st = new StringTokenizer(line, ",");
        String t = st.nextToken();
        t = st.nextToken();
        if (!isGps) {
            t = st.nextToken();
        }
        return Double.parseDouble(t);
    }

    private void parseValori(String line, int sid, boolean scambia) {
        StringTokenizer st = new StringTokenizer(line, ",");
        String t = st.nextToken();
        t = st.nextToken();
        double f = Double.parseDouble(t);
        DanasDataStructureConstants.FrequenzeDisponibili frequenza = DanasDataStructureConstants.FrequenzeDisponibili.F_1;
        if ((frequenza = frequenza.getFrequenza(f)) == null) {
            return;
        }
        int indice = 0;
        List<DanasDataStructureConstants.ValueType> listaCanali = this.canaliPresenti[frequenza.ordinal()];
        if (listaCanali == null) {
            return;
        }
        t = st.nextToken();
        double tempo = Double.parseDouble(t);
        while (st.hasMoreTokens()) {
            t = st.nextToken();
            double valore = Double.valueOf(t);
            DanasDataStructureConstants.ValueType vt = DanasDataStructure.getInstance().getPosizioneCanale(listaCanali.get(indice), scambia);
            ++indice;
            ds.getSession(sid).aggiungiValorePro(vt, tempo, f, valore);
        }
    }

    private void parseCanali(String line) {
        StringTokenizer st = new StringTokenizer(line, ",");
        String t = st.nextToken();
        t = st.nextToken();
        double f = Double.parseDouble(t);
        DanasDataStructureConstants.FrequenzeDisponibili frequenza = DanasDataStructureConstants.FrequenzeDisponibili.F_1;
        if ((frequenza = frequenza.getFrequenza(f)) == null) {
            return;
        }
        List<DanasDataStructureConstants.ValueType> listaCanali = this.canaliPresenti[frequenza.ordinal()];
        if (listaCanali == null) {
            this.canaliPresenti[frequenza.ordinal()] = listaCanali = new ArrayList<DanasDataStructureConstants.ValueType>();
        }
        while (st.hasMoreTokens()) {
            t = st.nextToken();
            listaCanali.add(DanasDataStructureConstants.ValueType.values()[Integer.parseInt(t)]);
        }
        System.out.println("Log:Aggiunti canale a frquenza=" + (Object)((Object)frequenza) + " trovati:" + listaCanali.size());
    }

    public static void parseSettaggiCanali(String line, DanasSessionSettings settaggioAttuale) {
        StringTokenizer st = new StringTokenizer(line, ",");
        String t = st.nextToken();
        while (st.hasMoreTokens()) {
            t = st.nextToken();
            StringTokenizer st2 = new StringTokenizer(t, ";");
            String dato = st2.nextToken();
            int numeroCanale = Integer.parseInt(dato);
            String nome = st2.nextToken();
            dato = st2.nextToken();
            float min = Float.valueOf(dato).floatValue();
            dato = st2.nextToken();
            float max = Float.valueOf(dato).floatValue();
            DanasDataStructureConstants.ValueType vt = DanasDataStructureConstants.ValueType.values()[numeroCanale];
            settaggioAttuale.setNome(vt, nome);
            settaggioAttuale.setMinimo(vt, min);
            settaggioAttuale.setMassimo(vt, max);
        }
    }

    public static void parseSettaggiCanali(String line, int sid, String fileName, boolean aggiornaFile, boolean scambia) {
        DanasSession s = ds.getSession(sid);
        if (s == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(line, ",");
        String t = st.nextToken();
        while (st.hasMoreTokens()) {
            t = st.nextToken();
            StringTokenizer st2 = new StringTokenizer(t, ";");
            String dato = st2.nextToken();
            int numeroCanale = Integer.parseInt(dato);
            String nome = st2.nextToken();
            dato = st2.nextToken();
            float min = Float.valueOf(dato).floatValue();
            dato = st2.nextToken();
            float max = Float.valueOf(dato).floatValue();
            DanasSessionSettings set = s.getSessionSettings();
            DanasDataStructureConstants.ValueType vt = DanasDataStructure.getInstance().getPosizioneCanale(DanasDataStructureConstants.ValueType.values()[numeroCanale], scambia);
            set.setNome(vt, nome);
            set.setMinimo(vt, min);
            set.setMassimo(vt, max);
            File fileSettingInterno = new File(set.getSettingsFileName());
            try {
                if (aggiornaFile) {
                    fileSettingInterno = File.createTempFile(fileName + "-" + sid + "-", ".tmp");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            set.setSettingsFileName(fileSettingInterno.getAbsolutePath());
            set.saveSettingsToFile(fileSettingInterno);
            s.setSessionSettings(set);
            ds.getSession(sid).setSettaggioInterno(true);
        }
    }

    public static void parseSettaggiCanali(String line, int sid, String fileName, boolean aggiornaFile) {
        DanasSession s = ds.getSession(sid);
        if (s == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(line, ",");
        String t = st.nextToken();
        while (st.hasMoreTokens()) {
            t = st.nextToken();
            StringTokenizer st2 = new StringTokenizer(t, ";");
            String dato = st2.nextToken();
            int numeroCanale = Integer.parseInt(dato);
            String nome = st2.nextToken();
            dato = st2.nextToken();
            float min = Float.valueOf(dato).floatValue();
            dato = st2.nextToken();
            float max = Float.valueOf(dato).floatValue();
            DanasSessionSettings set = s.getSessionSettings();
            DanasDataStructureConstants.ValueType vt = DanasDataStructureConstants.ValueType.values()[numeroCanale];
            set.setNome(vt, nome);
            set.setMinimo(vt, min);
            set.setMassimo(vt, max);
            File fileSettingInterno = new File(set.getSettingsFileName());
            try {
                if (aggiornaFile) {
                    fileSettingInterno = File.createTempFile(fileName + "-" + sid + "-", ".tmp");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            set.setSettingsFileName(fileSettingInterno.getAbsolutePath());
            set.saveSettingsToFile(fileSettingInterno);
            s.setSessionSettings(set);
            ds.getSession(sid).setSettaggioInterno(true);
        }
    }

    public static void parseSettaggiBase(String line, DanasSessionSettings settaggioAttuale) {
        StringTokenizer st = new StringTokenizer(line, ",");
        String t = st.nextToken();
        t = st.nextToken();
        int tipo = Integer.parseInt(t);
        float[] marce = new float[6];
        for (int i = 0; i < 6; ++i) {
            t = st.nextToken();
            marce[i] = Float.valueOf(t).floatValue();
        }
        t = st.nextToken();
        int p1 = Integer.parseInt(t);
        t = st.nextToken();
        int co1 = Integer.parseInt(t);
        t = st.nextToken();
        int ci1 = Integer.parseInt(t);
        t = st.nextToken();
        int p2 = Integer.parseInt(t);
        t = st.nextToken();
        int co2 = Integer.parseInt(t);
        t = st.nextToken();
        int ci2 = Integer.parseInt(t);
        settaggioAttuale.setTipoMoto(tipo);
        settaggioAttuale.setGears(marce);
        settaggioAttuale.setPinion(1, p1);
        settaggioAttuale.setGearTeeth(1, co1);
        settaggioAttuale.setCircumference(1, ci1);
        settaggioAttuale.setPinion(2, p2);
        settaggioAttuale.setGearTeeth(2, co2);
        settaggioAttuale.setCircumference(2, ci2);
    }

    public static void parseSettaggiBase(String line, int sid, String fileName, boolean aggiornaFile) {
        DanasSession s = ds.getSession(sid);
        if (s == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(line, ",");
        String t = st.nextToken();
        t = st.nextToken();
        int tipo = Integer.parseInt(t);
        float[] marce = new float[6];
        for (int i = 0; i < 6; ++i) {
            t = st.nextToken();
            marce[i] = Float.valueOf(t).floatValue();
        }
        t = st.nextToken();
        int p1 = Integer.parseInt(t);
        t = st.nextToken();
        int co1 = Integer.parseInt(t);
        t = st.nextToken();
        int ci1 = (int)Float.parseFloat(t);
        t = st.nextToken();
        int p2 = Integer.parseInt(t);
        t = st.nextToken();
        int co2 = (int)Float.parseFloat(t);
        t = st.nextToken();
        int ci2 = (int)Float.parseFloat(t);
        DanasSessionSettings set = s.getSessionSettings();
        set.setTipoMoto(tipo);
        set.setGears(marce);
        set.setPinion(1, p1);
        set.setGearTeeth(1, co1);
        set.setCircumference(1, ci1);
        set.setPinion(2, p2);
        set.setGearTeeth(2, co2);
        set.setCircumference(2, ci2);
        File fileSettingInterno = new File(set.getSettingsFileName());
        try {
            if (aggiornaFile) {
                fileSettingInterno = File.createTempFile(fileName + "-" + sid + "-", ".tmp");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        set.setSettingsFileName(fileSettingInterno.getAbsolutePath());
        set.saveSettingsToFile(fileSettingInterno);
        s.setSessionSettings(set);
        ds.getSession(sid).setSettaggioInterno(true);
    }

    private void parseNote(String line, int sid) {
        StringTokenizer st = new StringTokenizer(line, ",");
        String t = st.nextToken();
        t = st.nextToken();
        t = t.replace('#', '\n');
        ds.getSession(sid).setNotes(t);
    }

    private void parseVideo(String line, int sid) {
        StringTokenizer st = new StringTokenizer(line, ",");
        String t = st.nextToken();
        t = st.nextToken();
        ds.getSession(sid).setVideoFilename(t);
    }

    private void parseOffset(String line, int sid) {
        StringTokenizer st = new StringTokenizer(line, ",");
        String t = st.nextToken();
        t = st.nextToken();
        ds.getSession(sid).setOffsetVideoSessione(Integer.parseInt(t));
    }

    private void parseFuso(String line, int sid) {
        StringTokenizer st = new StringTokenizer(line, ",");
        String t = st.nextToken();
        t = st.nextToken();
        ds.getSession(sid).setFusoSessione(Integer.parseInt(t));
    }

    private void parseIr(String line, int sid, int lapid) throws Exception {
        StringTokenizer st = new StringTokenizer(line, ",");
        String t = st.nextToken();
        DanasIRData irData = new DanasIRData();
        t = st.nextToken();
        irData.setTelemetry(Double.parseDouble(t));
        ds.getSession(sid).getAllIRData().add(irData);
        ds.getSession(sid).setGiriManual(true);
    }

    private void parseNewlap(String line, int sid) throws Exception {
        StringTokenizer st = new StringTokenizer(line, ",");
        String t = st.nextToken();
        double start = Double.parseDouble(st.nextToken());
        double end = Double.parseDouble(st.nextToken());
        t = st.nextToken();
        int a = Integer.parseInt(t.substring(0, 3));
        int b = Integer.parseInt(t.substring(3, 6));
        int d = Integer.parseInt(t.substring(6, 9));
        Color c = new Color(a, b, d);
        int lapid = Integer.parseInt(st.nextToken());
        boolean selected = Boolean.parseBoolean(st.nextToken());
        DanasLap l = new DanasLap(ds.getSession(sid), start, end, c, lapid, selected);
        ds.getSession(sid).getLaps().add(l);
    }

    private void parsePilota(String line, int sid) throws Exception {
        StringTokenizer st = new StringTokenizer(line, ",");
        String t = st.nextToken();
        DanasSession sess = ds.getSession(sid);
        try {
            t = st.nextToken();
            if (t == null || t == "") {
                return;
            }
            sess.setPilota(t);
        }
        catch (Exception ex) {
            System.err.println("Errore nel parsing della linea:" + line);
            return;
        }
    }

    private void parseTipo(String line, int sid) throws Exception {
        StringTokenizer st = new StringTokenizer(line, ",");
        String t = st.nextToken();
        DanasSession sess = ds.getSession(sid);
        try {
            t = st.nextToken();
            if (t == null || t == "") {
                return;
            }
            Integer tipo = Integer.valueOf(t);
            sess.setTipo(tipo);
        }
        catch (Exception ex) {
            if (sess != null) {
                System.err.println("Errore nel parsing della linea:" + line);
            }
            return;
        }
    }

    private void parseFormule(String line, int sid) throws Exception {
        StringTokenizer st = new StringTokenizer(line, ";");
        DanasSession sess = ds.getSession(sid);
        try {
            for (int i = 0; i < 9; ++i) {
                this.t = st.nextToken();
                if (this.t == null) {
                    return;
                }
                if (i == 0 && this.t.length() > 9) {
                    this.t = this.t.substring(9, this.t.length());
                }
                sess.setFormulaMath(this.t, i);
            }
        }
        catch (Exception ex) {
            System.err.println("Errore nel parsing della linea:" + line + " valore scartato");
            return;
        }
    }

    private void parseValue(String line, int sid, boolean scambia) throws Exception {
        StringTokenizer st = new StringTokenizer(line, ",");
        String t = st.nextToken();
        boolean parsingIncompleto = false;
        DanasValueData valueData = new DanasValueData();
        try {
            String tempoT = t = st.nextToken();
            t = st.nextToken();
            if (t == null || t == "") {
                parsingIncompleto = true;
            }
            valueData.setFront(Double.parseDouble(t));
            valueData.setAnalogs(Double.parseDouble(t), DanasDataStructure.getInstance().getPosizioneValueAnalogico(3, scambia));
            t = st.nextToken();
            if (t == null || t == "") {
                parsingIncompleto = true;
            }
            valueData.setRear(Double.parseDouble(t));
            valueData.setAnalogs(Double.parseDouble(t), DanasDataStructure.getInstance().getPosizioneValueAnalogico(4, scambia));
            t = st.nextToken();
            if (t == null || t == "") {
                parsingIncompleto = true;
            }
            valueData.setSpeed1(Double.parseDouble(t));
            t = st.nextToken();
            if (t == null || t == "") {
                parsingIncompleto = true;
            }
            valueData.setSpeed2(Double.parseDouble(t));
            t = st.nextToken();
            if (t == null || t == "") {
                parsingIncompleto = true;
            }
            valueData.setRPM(Integer.parseInt(t));
            t = st.nextToken();
            if (t == null || t == "") {
                parsingIncompleto = true;
            }
            valueData.setEnv_temp(Double.parseDouble(t));
            t = st.nextToken();
            if (t == null || t == "") {
                parsingIncompleto = true;
            }
            valueData.setThermocouple_temp(Double.parseDouble(t));
            t = st.nextToken();
            if (t == null || t == "") {
                parsingIncompleto = true;
            }
            valueData.setAnalogs(Double.parseDouble(t), DanasDataStructure.getInstance().getPosizioneValueAnalogico(1, scambia));
            t = st.nextToken();
            if (t == null || t == "") {
                parsingIncompleto = true;
            }
            valueData.setAnalogs(Double.parseDouble(t), DanasDataStructure.getInstance().getPosizioneValueAnalogico(2, scambia));
            if (st.hasMoreTokens()) {
                t = st.nextToken();
                if (t == null || t == "") {
                    t = "0";
                }
                valueData.setAnalogs(Double.parseDouble(t), DanasDataStructure.getInstance().getPosizioneValueAnalogico(5, scambia));
            }
            if (st.hasMoreTokens()) {
                t = st.nextToken();
                if (t == null || t == "") {
                    t = "0";
                }
                valueData.setAnalogs(Double.parseDouble(t), DanasDataStructure.getInstance().getPosizioneValueAnalogico(6, scambia));
            }
            if (st.hasMoreTokens()) {
                t = st.nextToken();
                if (t == null || t == "") {
                    t = "0";
                }
                valueData.setAnalogs(Double.parseDouble(t), DanasDataStructure.getInstance().getPosizioneValueAnalogico(7, scambia));
            }
            if (st.hasMoreTokens()) {
                t = st.nextToken();
                if (t == null || t == "") {
                    t = "0";
                }
                valueData.setAnalogs(Double.parseDouble(t), DanasDataStructure.getInstance().getPosizioneValueAnalogico(8, scambia));
            }
            if (st.hasMoreTokens()) {
                t = st.nextToken();
                if (t == null || t == "") {
                    t = "0";
                }
                valueData.setAnalogs(Double.parseDouble(t), 9);
            }
            if (st.hasMoreTokens()) {
                t = st.nextToken();
                if (t == null || t == "") {
                    t = "0";
                }
                valueData.setAnalogs(Double.parseDouble(t), DanasDataStructure.getInstance().getPosizioneValueAnalogico(10, scambia));
            }
            if (st.hasMoreTokens()) {
                t = st.nextToken();
                if (t == null || t == "") {
                    t = "0";
                }
                valueData.setAnalogs(Double.parseDouble(t), DanasDataStructure.getInstance().getPosizioneValueAnalogico(11, scambia));
            }
            if (st.hasMoreTokens()) {
                t = st.nextToken();
                if (t == null || t == "") {
                    t = "0";
                }
                valueData.setBattito(Double.parseDouble(t));
            }
            if (st.hasMoreTokens()) {
                t = st.nextToken();
                if (t == null || t == "") {
                    t = "0";
                }
                valueData.setAnalogs(Double.parseDouble(t), DanasDataStructure.getInstance().getPosizioneValueAnalogico(12, scambia));
            }
            if (st.hasMoreTokens()) {
                t = st.nextToken();
                if (t == null || t == "") {
                    t = "0";
                }
                valueData.setAnalogs(Double.parseDouble(t), DanasDataStructure.getInstance().getPosizioneValueAnalogico(13, scambia));
            }
            if (st.hasMoreTokens()) {
                t = st.nextToken();
                if (t == null || t == "") {
                    t = "-1";
                }
                valueData.setCanaleMultiTpms(Double.parseDouble(t));
            }
            if (st.hasMoreTokens()) {
                System.err.println("too many analog values at line " + line);
            }
            valueData.setTelemetryTime(Double.parseDouble(tempoT));
            if (Double.parseDouble(tempoT) < this.lastValueTelemetry) {
                System.err.println(line + "\nValue not in order\nLast telemetry time: " + this.lastValueTelemetry);
                return;
            }
            if (!parsingIncompleto) {
                this.lastValueTelemetry = Double.parseDouble(tempoT);
            }
            if (!parsingIncompleto) {
                ds.getSession(sid).getAllValueData().add(valueData);
                ds.getSession(sid).setDatiFormatoVecchio(true);
            }
        }
        catch (Exception ex) {
            System.err.println("Errore nel parsing della linea:" + line + " valore scartato");
            return;
        }
    }

    private void parseGps(String line, int id) throws Exception {
        StringTokenizer st = new StringTokenizer(line, ",");
        String t = st.nextToken();
        GPSPoint punto = new GPSPoint();
        try {
            if (!st.hasMoreTokens()) {
                return;
            }
            String tempo = t = st.nextToken();
            punto.setTelemetry_time(Double.parseDouble(t));
            if (!st.hasMoreTokens()) {
                return;
            }
            if (!st.nextToken().equals("A")) {
                return;
            }
            double lat = 0.0;
            String s = st.nextToken();
            s = String.format("%09.4f", Double.parseDouble(s));
            StringTokenizer st2 = new StringTokenizer(s, ".");
            String temp0 = st2.nextToken();
            String temp1 = temp0.substring(0, temp0.length() - 2);
            String temp2 = temp0.substring(temp0.length() - 2);
            String temp3 = st2.nextToken();
            lat = Double.parseDouble(temp1) * 60.0 * 10000.0 + Double.parseDouble(temp2 + "." + temp3) * 10000.0;
            if (!st.nextToken().equals("N")) {
                lat *= -1.0;
            }
            double lon = 0.0;
            s = st.nextToken();
            s = String.format("%010.4f", Double.parseDouble(s));
            st2 = new StringTokenizer(s, ".");
            temp0 = st2.nextToken();
            temp1 = temp0.substring(0, temp0.length() - 2);
            temp2 = temp0.substring(temp0.length() - 2);
            temp3 = st2.nextToken();
            lon = Double.parseDouble(temp1) * 60.0 * 10000.0 + Double.parseDouble(temp2 + "." + temp3) * 10000.0;
            if (!st.nextToken().equals("E")) {
                lon *= -1.0;
            }
            lat = Math.round(lat);
            lon = Math.round(lon);
            punto.setLat(lat);
            punto.setLon(lon);
            if (st.hasMoreTokens()) {
                t = st.nextToken();
                punto.setSpeed(Double.parseDouble(t));
            }
            if (st.hasMoreTokens()) {
                t = st.nextToken();
                punto.setGps_time(t);
            }
            try {
                t = st.nextToken();
                punto.setElev(Double.parseDouble(t));
            }
            catch (Exception e) {
                punto.setElev(Double.NaN);
            }
            if (Double.parseDouble(tempo) < this.lastGPSTelemetry) {
                System.err.println(line + "\nGPSData not in order\nLast telemetry time: " + this.lastGPSTelemetry);
                return;
            }
            this.lastGPSTelemetry = Double.parseDouble(tempo);
            ds.getSession(id).aggiungiPuntoGps(punto);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println("Errore nel parsing della linea:" + line + " valore scartato");
            return;
        }
    }

    private void newSessionParser(String line, int id, int pid, String fileName) {
        DanasSession dss = new DanasSession();
        this.lastGPSTelemetry = 0.0;
        this.lastValueTelemetry = 0.0;
        dss.setDanasDataStructure(ds);
        dss.setSessionID(id);
        dss.setSessionName("Session" + id);
        dss.setFilename(fileName);
        dss.setFilePosition(pid);
        dss.setColor(new Color((int)(Math.random() * 255.0), (int)(Math.random() * 255.0), (int)(Math.random() * 255.0)));
        if (DanasDataStructure.getInstance().getNSessions() > 0 || !ds.getApriPrimaSessione()) {
            dss.deselect();
        } else {
            dss.select();
        }
        ds.addSession(dss);
    }

    private void parseDate(String line, int index) throws Exception {
        StringTokenizer st = new StringTokenizer(line, ",");
        String t = st.nextToken();
        t = st.nextToken();
        SimpleDateFormat sdf = new SimpleDateFormat("ddMMyy");
        Date date = sdf.parse(t);
        ds.getSession(index).setDate(date);
    }

    public static final void parseInternalImpos(String line, int sid, String fileName, boolean scambia) {
        DanasDataStructure.getInstance().getSession(sid);
        DanasSessionSettings dImp = new DanasSessionSettings();
        dImp.setSessionID(sid);
        File fileSettingInterno = null;
        try {
            fileSettingInterno = File.createTempFile(fileName + "-" + sid + "-", ".tmp");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        dImp.setSettingsFileName(fileSettingInterno.getAbsolutePath());
        StringTokenizer st = new StringTokenizer(line, ",");
        try {
            int i;
            String t = st.nextToken();
            for (i = 0; i < 8; ++i) {
                t = st.nextToken();
                dImp.setNome(DanasDataStructure.getInstance().getPosizioneCanale(dImp.getValueAnalogico(i + 1), scambia), t);
                t = st.nextToken();
                dImp.setMinimo(DanasDataStructure.getInstance().getPosizioneCanale(dImp.getValueAnalogico(i + 1), scambia), Float.parseFloat(t));
                t = st.nextToken();
                dImp.setMassimo(DanasDataStructure.getInstance().getPosizioneCanale(dImp.getValueAnalogico(i + 1), scambia), Float.parseFloat(t));
            }
            t = st.nextToken();
            dImp.setCircumference(1, (int)Double.parseDouble(t));
            t = st.nextToken();
            dImp.setPinion(1, Integer.parseInt(t));
            t = st.nextToken();
            dImp.setGearTeeth(1, Integer.parseInt(t));
            t = st.nextToken();
            dImp.setCircumference(2, (int)Double.parseDouble(t));
            t = st.nextToken();
            dImp.setPinion(2, Integer.parseInt(t));
            t = st.nextToken();
            dImp.setGearTeeth(2, Integer.parseInt(t));
            for (i = 1; i < 7; ++i) {
                t = st.nextToken();
                dImp.setGears(Float.parseFloat(t), i);
            }
            t = st.nextToken();
            if (tipoMotoImpos != -1) {
                System.out.println("Stringa tipo moto=" + tipoMotoImpos);
                dImp.setTipoMoto(DanasParserTask.getSettingsMoto(tipoMotoImpos));
            } else {
                dImp.setTipoMoto(Integer.valueOf(t));
            }
            if (st.hasMoreTokens()) {
                t = st.nextToken();
                dImp.setNome(DanasDataStructure.getInstance().getPosizioneCanale(DanasDataStructureConstants.ValueType.EXT1, scambia), t);
                t = st.nextToken();
                dImp.setMinimo(DanasDataStructure.getInstance().getPosizioneCanale(DanasDataStructureConstants.ValueType.EXT1, scambia), Float.parseFloat(t));
                t = st.nextToken();
                dImp.setMassimo(DanasDataStructure.getInstance().getPosizioneCanale(DanasDataStructureConstants.ValueType.EXT1, scambia), Float.parseFloat(t));
                t = st.nextToken();
                dImp.setNome(DanasDataStructure.getInstance().getPosizioneCanale(DanasDataStructureConstants.ValueType.EXT2, scambia), t);
                t = st.nextToken();
                dImp.setMinimo(DanasDataStructure.getInstance().getPosizioneCanale(DanasDataStructureConstants.ValueType.EXT2, scambia), Float.parseFloat(t));
                t = st.nextToken();
                dImp.setMassimo(DanasDataStructure.getInstance().getPosizioneCanale(DanasDataStructureConstants.ValueType.EXT2, scambia), Float.parseFloat(t));
            }
            if (st.hasMoreTokens()) {
                t = st.nextToken();
                dImp.setNome(DanasDataStructure.getInstance().getPosizioneCanale(DanasDataStructureConstants.ValueType.EXT3, scambia), t);
                t = st.nextToken();
                dImp.setMinimo(DanasDataStructure.getInstance().getPosizioneCanale(DanasDataStructureConstants.ValueType.EXT3, scambia), Float.parseFloat(t));
                t = st.nextToken();
                dImp.setMassimo(DanasDataStructure.getInstance().getPosizioneCanale(DanasDataStructureConstants.ValueType.EXT3, scambia), Float.parseFloat(t));
                t = st.nextToken();
                dImp.setNome(DanasDataStructure.getInstance().getPosizioneCanale(DanasDataStructureConstants.ValueType.EXT4, scambia), t);
                t = st.nextToken();
                dImp.setMinimo(DanasDataStructure.getInstance().getPosizioneCanale(DanasDataStructureConstants.ValueType.EXT4, scambia), Float.parseFloat(t));
                t = st.nextToken();
                dImp.setMassimo(DanasDataStructure.getInstance().getPosizioneCanale(DanasDataStructureConstants.ValueType.EXT4, scambia), Float.parseFloat(t));
            }
            dImp.saveSettingsToFile(fileSettingInterno);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.out.println("Errore Parsing file interno");
            JOptionPane.showMessageDialog(null, "Error parsing internal file!", "Error", 0);
        }
        ds.getSession(sid).setSessionSettings(dImp);
        ds.setChange(DanasDataStructureConstants.ChangeType.NEW_SETTINGS);
    }

    static int getSettingsMoto(int tipoCan) {
        switch (tipoCan) {
            case 0: {
                return 8;
            }
            case 1: {
                return 14;
            }
            case 2: 
            case 3: {
                return 16;
            }
            case 4: 
            case 5: {
                return 18;
            }
            case 6: {
                return 19;
            }
            case 7: {
                return 20;
            }
            case 8: {
                return 22;
            }
            case 10: {
                return 29;
            }
            case 14: {
                return 39;
            }
            case 15: {
                return 40;
            }
            case 16: {
                return 43;
            }
            case 17: {
                return 44;
            }
            case 18: {
                return 45;
            }
            case 19: {
                return 46;
            }
            case 21: {
                return 47;
            }
            case 27: {
                return 55;
            }
        }
        return 8;
    }

    public static final void parseImposFile(String fileName, int sid, boolean aggiornaFile) throws IOException {
        DanasDataStructure.getInstance().getSession(sid);
        DanasSessionSettings dImp = DanasDataStructure.getInstance().getSession(sid).getSessionSettings();
        dImp.setSessionID(sid);
        File f = new File(fileName);
        if (f.getName().equals("defaultSettings.dfs") || !f.exists()) {
            dImp.setSettingsFileName("Default");
        } else {
            dImp.setSettingsFileName(fileName);
        }
        if (!f.exists()) {
            f.createNewFile();
        }
        FileInputStream fis = new FileInputStream(f);
        InputStreamReader isr = new InputStreamReader(fis);
        BufferedReader br = new BufferedReader(isr);
        String line = br.readLine();
        while (line != null) {
            line.replace(" ", "");
            if (line.startsWith("$SETTAGGICANALI")) {
                DanasParserTask.parseSettaggiCanali(line, sid, f.getName(), aggiornaFile);
            }
            if (line.startsWith("$SETTAGGIBASE")) {
                DanasParserTask.parseSettaggiBase(line, sid, f.getName(), aggiornaFile);
            }
            line = br.readLine();
        }
        dImp.toString();
        ds.getSession(sid).setSessionSettings(dImp);
        ds.setChange(DanasDataStructureConstants.ChangeType.NEW_SETTINGS);
        br.close();
    }

    static {
        terminate = false;
        tipoMotoImpos = -1;
    }

    private static enum LineDescriptor {
        $NEWSESSION,
        $DATE,
        $IMPOS,
        $PATH,
        $GPS,
        $VALUE,
        $IR,
        $VIDEO,
        $OFFSET_VIDEO,
        $FUSO,
        $NEW_LAP,
        $SESSION_COLOR,
        $NOTE,
        $MINILAP,
        $SETTINGS,
        $INTER,
        $MATH,
        $FORMULE,
        $PILOTA,
        $TIPO,
        $BEST,
        $DIST,
        $CANALI,
        $SETTAGGICANALI,
        $VAL,
        $SETTAGGIBASE,
        $CHECK,
        $GPRMC,
        $TYPE_CHROME,
        $TYPE_DATALOG,
        $CIRCUIT;

    }
}

