/*
 * Decompiled with CFR 0.152.
 */
package i2m.DataStructure.danasDataStructure;

import i2m.DataStructure.danasDataStructure.ArrayDouble;
import i2m.DataStructure.danasDataStructure.DanasDataStructure;
import i2m.DataStructure.danasDataStructure.DanasDataStructureConstants;
import i2m.DataStructure.danasDataStructure.DanasLap;
import i2m.DataStructure.danasDataStructure.DanasSession;
import i2m.DataStructure.danasUtils.MeasuresUtil;
import i2m.DataStructure.sessionViewer.SessionViewer;
import i2m.DataStructure.sessionViewer.SessionViewerGiri;
import i2m.Language;
import i2m.grafico.ContenitoreGrafico;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.GridLayout;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DanasGenericDataAnalysys
implements ChangeListener {
    private DanasDataStructure ds = DanasDataStructure.getInstance();
    private Thread aggiornaThread = null;
    private static JDialog frame;
    private static JProgressBar progressBar;

    public DanasGenericDataAnalysys() {
        this.ds.addChangeListener(this);
        DanasGenericDataAnalysys.createAndShowGUI();
    }

    public void stop() {
        if (this.aggiornaThread != null && this.aggiornaThread.isAlive()) {
            this.aggiornaThread.stop();
        }
        try {
            if (this.aggiornaThread != null) {
                this.aggiornaThread.join(1000L);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void forzaAggiornamentoSess() {
        System.out.println("DataGeneric: aggiornamento forzato sess");
        if (this.aggiornaThread != null && this.aggiornaThread.isAlive()) {
            this.aggiornaThread.stop();
        }
        frame.setVisible(false);
        System.out.println("DataGeneric: controllo se devo aggiornare");
        if (!this.isAggiornamentoRichiestoSess()) {
            return;
        }
        System.out.println("Avvio aggiornamento sess");
        frame.setVisible(true);
        this.aggiornaThread = new Thread(){

            @Override
            public void run() {
                DanasGenericDataAnalysys.this.updateAnalisysSessions(100);
                DanasDataStructure.getInstance().setAggiornaViewer(false);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SessionViewer.refreshAll();
                        progressBar.setValue(105);
                        frame.setVisible(false);
                    }
                });
            }
        };
        this.aggiornaThread.start();
    }

    public void forzaAggiornamentoLap() {
        System.out.println("DataGeneric: aggiornamento forzato lap");
        if (this.aggiornaThread != null && this.aggiornaThread.isAlive()) {
            this.aggiornaThread.stop();
        }
        frame.setVisible(false);
        if (!this.isAggiornamentoRichiestoLap()) {
            return;
        }
        System.out.println("Avvio aggiornamento lap");
        frame.setVisible(true);
        this.aggiornaThread = new Thread(){

            @Override
            public void run() {
                DanasGenericDataAnalysys.this.updateAnalisysLaps(100);
                DanasDataStructure.getInstance().setAggiornaViewer(false);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SessionViewerGiri.refreshAll();
                        progressBar.setValue(105);
                        frame.setVisible(false);
                    }
                });
            }
        };
        this.aggiornaThread.start();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.ds.getChange() == DanasDataStructureConstants.ChangeType.NEW_DATA || this.ds.getChange() == DanasDataStructureConstants.ChangeType.REMOVE_DATA || this.ds.getChange() == DanasDataStructureConstants.ChangeType.REMOVE_SESSION || this.ds.getChange() == DanasDataStructureConstants.ChangeType.NEW_SETTINGS || this.ds.getChange() == DanasDataStructureConstants.ChangeType.REFRESH_ALL) {
            DanasDataStructure.getInstance().azzeraCanaliAnalizzatiGiriSessioni();
            DanasDataStructure.getInstance().azzeraCanaliAnalizzatiGiri();
        } else if (this.ds.getChange() == DanasDataStructureConstants.ChangeType.SET_GOAL) {
            DanasDataStructure.getInstance().azzeraCanaliAnalizzatiGiri();
        }
    }

    private void updateAnalisysSessions(int per) {
        System.out.println("Analisi sessioni");
        ContenitoreGrafico grafico = DanasDataStructure.getInstance().getMainFrame().getContenitoreGrafico();
        long tot = 0L;
        long completed = 0L;
        int pre = progressBar.getValue();
        int numero = 0;
        for (DanasSession s : this.ds.getSessions()) {
            ++numero;
            for (DanasDataStructureConstants.ValueType t : DanasDataStructureConstants.ValueType.values()) {
                ArrayDouble out;
                if (t == DanasDataStructureConstants.ValueType.SIM1 || t == DanasDataStructureConstants.ValueType.SIM2 || !grafico.isChannelOnInfo(MeasuresUtil.getPositionType(t)) || s.isCanaleAnalizzato(t) || (out = s.getAllValueData(t, false)) == null) continue;
                tot += (long)out.size();
            }
        }
        if (tot == 0L) {
            progressBar.setValue(pre + per);
            return;
        }
        progressBar.setValue(pre + 5);
        numero = 0;
        for (DanasSession s : this.ds.getSessions()) {
            System.out.println("analisi sessione=" + ++numero);
            try {
                double[][] gva = new double[DanasDataStructureConstants.ValueType.values().length][3];
                for (DanasDataStructureConstants.ValueType t : DanasDataStructureConstants.ValueType.values()) {
                    if (t == DanasDataStructureConstants.ValueType.SIM1 || t == DanasDataStructureConstants.ValueType.SIM2 || !grafico.isChannelOnInfo(MeasuresUtil.getPositionType(t))) continue;
                    if (s.isCanaleAnalizzato(t)) {
                        gva[t.ordinal()][0] = s.getGenericValueAnalisys()[t.ordinal()][0];
                        gva[t.ordinal()][1] = s.getGenericValueAnalisys()[t.ordinal()][1];
                        gva[t.ordinal()][2] = s.getGenericValueAnalisys()[t.ordinal()][2];
                        continue;
                    }
                    double max = Double.NaN;
                    double min = Double.NaN;
                    int gasAperto = 0;
                    int numeroValoriMedia = 0;
                    double valoreSomma = 0.0;
                    int dimensione = 0;
                    ArrayDouble out = s.getAllValueData(t, true);
                    if (out != null) {
                        dimensione = out.size();
                    }
                    for (int i = 0; i < dimensione; ++i) {
                        if (Double.isNaN(max) && !Double.isNaN(out.get(i)) || out.get(i) > max) {
                            max = out.get(i);
                        }
                        if (Double.isNaN(min) && !Double.isNaN(out.get(i)) || out.get(i) < min) {
                            min = out.get(i);
                        }
                        if (!Double.isNaN(out.get(i))) {
                            ++numeroValoriMedia;
                            valoreSomma += out.get(i);
                        }
                        if (t == DanasDataStructureConstants.ValueType.ANALOG1 && out.get(i) > 95.0) {
                            ++gasAperto;
                        }
                        ++completed;
                    }
                    gva[t.ordinal()][0] = max;
                    gva[t.ordinal()][1] = min;
                    gva[t.ordinal()][2] = numeroValoriMedia != 0 ? valoreSomma / (double)numeroValoriMedia : 0.0;
                    progressBar.setValue(pre + 5 + (int)((float)completed / (float)tot * (float)(per - 5)));
                    s.setCanaleAnalizzato(t);
                    if (t != DanasDataStructureConstants.ValueType.ANALOG1 || dimensione == 0) continue;
                    s.setPercentualeGasAperto((double)gasAperto / (double)out.size());
                }
                s.setGenericValueAnalisys(gva);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private boolean isAggiornamentoRichiestoSess() {
        for (DanasSession s : this.ds.getSessions()) {
            if (!s.isAggiornamentoAnalisiRichiesto(false)) continue;
            return true;
        }
        return false;
    }

    private boolean isAggiornamentoRichiestoLap() {
        ContenitoreGrafico grafico = DanasDataStructure.getInstance().getMainFrame().getContenitoreGrafico();
        for (DanasSession s : this.ds.getSessions()) {
            for (DanasLap l : s.getLaps()) {
                if (!l.isAggiornamentoAnalisiRichiesto(false)) continue;
                return true;
            }
        }
        return false;
    }

    private void updateAnalisysLaps(int per) {
        long tot = 0L;
        long completed = 0L;
        int pre = progressBar.getValue();
        ContenitoreGrafico grafico = DanasDataStructure.getInstance().getMainFrame().getContenitoreGrafico();
        System.out.println("Analizzo giri in DanasGenericData");
        for (DanasSession s : this.ds.getSessions()) {
            for (DanasLap l : s.getLaps()) {
                for (DanasDataStructureConstants.ValueType t : DanasDataStructureConstants.ValueType.values()) {
                    List<Double> out;
                    if (t == DanasDataStructureConstants.ValueType.SIM1 || t == DanasDataStructureConstants.ValueType.SIM2 || !grafico.isChannelOnInfo(MeasuresUtil.getPositionType(t)) || l.isCanaleAnalizzato(t) || (out = s.getSelectionValueData(t, l.getStart(), l.getEnd(), false)) == null) continue;
                    tot += (long)out.size();
                }
            }
        }
        if (tot == 0L) {
            progressBar.setValue(pre + per);
            return;
        }
        progressBar.setValue(pre + 5);
        try {
            System.out.println("Analizzo giri in DanasGenericData seconda parte");
            for (DanasSession s : this.ds.getSessions()) {
                for (DanasLap l : s.getLaps()) {
                    double[][] gva = new double[DanasDataStructureConstants.ValueType.values().length][3];
                    for (DanasDataStructureConstants.ValueType t : DanasDataStructureConstants.ValueType.values()) {
                        if (t == DanasDataStructureConstants.ValueType.SIM1 || t == DanasDataStructureConstants.ValueType.SIM2 || !grafico.isChannelOnInfo(MeasuresUtil.getPositionType(t))) continue;
                        if (l.isCanaleAnalizzato(t)) {
                            gva[t.ordinal()][0] = l.getGenericValueAnalisys()[t.ordinal()][0];
                            gva[t.ordinal()][1] = l.getGenericValueAnalisys()[t.ordinal()][1];
                            gva[t.ordinal()][2] = l.getGenericValueAnalisys()[t.ordinal()][2];
                            continue;
                        }
                        double max = Double.NaN;
                        double min = Double.NaN;
                        int gasAperto = 0;
                        int numeroValoriMedia = 0;
                        double valoreSomma = 0.0;
                        int dimensione = 0;
                        List<Double> out = s.getSelectionValueDataFiltrati(t, l.getStart(), l.getEnd(), true);
                        if (out != null) {
                            dimensione = out.size();
                        }
                        for (int i = 0; i < dimensione; ++i) {
                            if (Double.isNaN(max) && !Double.isNaN(out.get(i)) || out.get(i) > max) {
                                max = out.get(i);
                            }
                            if (Double.isNaN(min) && !Double.isNaN(out.get(i)) || out.get(i) < min) {
                                min = out.get(i);
                            }
                            if (!Double.isNaN(out.get(i))) {
                                ++numeroValoriMedia;
                                valoreSomma += out.get(i).doubleValue();
                            }
                            if (t == DanasDataStructureConstants.ValueType.ANALOG1 && out.get(i) > 95.0) {
                                ++gasAperto;
                            }
                            ++completed;
                        }
                        gva[t.ordinal()][0] = max;
                        gva[t.ordinal()][1] = min;
                        gva[t.ordinal()][2] = numeroValoriMedia != 0 ? valoreSomma / (double)numeroValoriMedia : 0.0;
                        progressBar.setValue(pre + 5 + (int)((float)completed / (float)tot * (float)(per - 5)));
                        l.setCanaleAnalizzato(t);
                        if (t != DanasDataStructureConstants.ValueType.ANALOG1 || dimensione == 0) continue;
                        l.setPercentualeGasAperto((double)gasAperto / (double)out.size());
                    }
                    l.setGenericValueAnalisys(gva);
                }
            }
            System.out.println("Fine analisi giri");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void createAndShowGUI() {
        frame = new JDialog((Frame)DanasDataStructure.getInstance().getMainFrame(), Language.string("Elaborazione..  "));
        frame.setDefaultCloseOperation(0);
        frame.setResizable(false);
        frame.setLocationRelativeTo(null);
        frame.setResizable(false);
        progressBar1 newContentPane = new progressBar1();
        newContentPane.setOpaque(true);
        frame.setContentPane(newContentPane);
        frame.pack();
        frame.setAlwaysOnTop(true);
    }

    public static class progressBar1
    extends JPanel {
        private static final long serialVersionUID = 1L;

        private progressBar1() {
            super(new BorderLayout());
            this.setCursor(Cursor.getPredefinedCursor(3));
            progressBar = new JProgressBar(0, 100);
            progressBar.setValue(0);
            progressBar.setStringPainted(true);
            JPanel panel = new JPanel();
            panel.setLayout(new GridLayout(2, 1));
            panel.add(new JLabel(Language.string("Caricamento in corso..")));
            panel.add(progressBar);
            this.add((Component)panel, "First");
            this.setBorder(BorderFactory.createEmptyBorder(10, 20, 20, 20));
        }
    }
}

