/*
 * Decompiled with CFR 0.152.
 */
package i2m.DataStructure.danasDataStructure;

import i2m.DanasPreferences;
import i2m.DataStructure.danasDataStructure.ArrayDouble;
import i2m.DataStructure.danasDataStructure.DanasDataStructureConstants;
import i2m.DataStructure.danasDataStructure.DanasGenericDataAnalysys;
import i2m.DataStructure.danasDataStructure.DanasIRData;
import i2m.DataStructure.danasDataStructure.DanasLap;
import i2m.DataStructure.danasDataStructure.DanasSession;
import i2m.DataStructure.danasDataStructure.GPSPoint;
import i2m.DataStructure.danasTable.TableWindow;
import i2m.DataStructure.danasUtils.MeasuresUtil;
import i2m.DataStructure.sessionViewer.SessionViewer;
import i2m.Dialog.HwDasy4;
import i2m.Dialog.HwDasy6;
import i2m.Language;
import i2m.MainFrame;
import i2m.grafico.Curva;
import i2m.grafico.CurvaIstogramma;
import i2m.grafico.CurvaXY;
import i2m.grafico.Interpolatore;
import i2m.mappa.Mappa2D;
import i2m.mappa.Tracciato;
import i2m.traguardi.Circuit;
import java.awt.Color;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DanasDataStructure {
    private static long tempoApertura = System.currentTimeMillis();
    private static int offsetGPS = 1000;
    public static HwDasy4 impostazioni = null;
    public static HwDasy6 impostazioni6 = null;
    public static MainFrame danasFrame = null;
    private static boolean modTraslazione = false;
    private static boolean salvaGiriAutomatici = false;
    private static boolean calcolaSplit = true;
    private static boolean DisabilitaCalcolaSplitAuto = false;
    private static boolean ricalcolaTutto = false;
    private static int[] elencoDistanze;
    private static boolean interpolazioneAttiva;
    private static int percentualeApertura;
    private static int percentualeSalvataggio;
    private static int allineamentoSplit;
    private List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private boolean isChanged;
    private DanasDataStructureConstants.ChangeType Change;
    private String ChangeParameter;
    private boolean NotifierEnabled = true;
    private String[] nomiMulti;
    private boolean singoloDefault = true;
    private boolean confrontaDefault = false;
    private boolean mostraMassimi = false;
    private boolean chiudiGiro = false;
    private int posizioneTabellaAttuale = 0;
    private boolean mostraPosizioniTabella = false;
    private boolean simulazioneMarcieAttiva = false;
    Double[] cambio = new Double[7];
    Double[] cambioSim = new Double[7];
    Double[] minimiRpm = new Double[7];
    Double[] massimiRpm = new Double[7];
    double rappValue;
    double rappSimValue;
    Double rpmMin;
    Double rpmMax;
    Double sogliaTps;
    boolean usaOld;
    boolean apriPrimaSessione = false;
    boolean apriUltimaSessione = false;
    boolean apriBest = false;
    boolean aggiornareViewer = false;
    boolean aggiornaViewerSempre = true;
    boolean mostraAllarmi = false;
    DanasLap videoCompareLap = null;
    boolean mostraPuntiInfo = false;
    boolean mostraSerpentello = false;
    double risoluzioneStechio = 0.0;
    boolean[] canaleUtilizzato = new boolean[DanasDataStructureConstants.ValueType.values().length];
    boolean interrompiSalvataggio = false;
    boolean[] canaliPresenti = new boolean[MeasuresUtil.getNumeroCurve()];
    boolean isUnitCelsius = true;
    boolean isUnitkmh = true;
    boolean isPressBar = true;
    private Vector<DanasSession> DanasSessions = new Vector();
    private DanasSession defaultSession = null;
    private DanasLap defaultLap = null;
    private String DefaultSettingsFile = "./defaultSettings.dfs";
    private String CircuitName;
    private Circuit circuitoImportato = null;
    private boolean circuitoNuovo = false;
    private boolean circuitoDiverso = false;
    private int GPSOffset;
    private int[] posizioneAnalogici = new int[12];
    private boolean scambiaAnalogiciSempre = false;
    private boolean scambiaAnalogiciChrome = false;
    private boolean scambiaAnalogiciDatalog = false;
    private static DanasDataStructure instance;
    private static DanasGenericDataAnalysys gda;
    private final int YAMAHA = 8;
    private final int KAWASAKI = 9;
    private final int SUZUKI = 10;
    private final int HONDA = 11;
    private final int DUCATI = 12;
    private final int YAMAHA6 = 13;
    private final int KAWACAN = 14;
    private final int BMW = 15;
    private final int BMW_ABS = 16;
    private final int DUCATI_1198 = 17;
    private final int DUCATI_1198_TC = 18;
    private final int BMW_HP4 = 19;
    private final int BMW_HL = 20;
    private final int PEDERCINI = 21;
    private final int KAWA_RACE = 22;
    private final int K7_1000 = 23;
    private final int k7M_1000 = 24;
    private final int k9_1000 = 25;
    private final int k9M_1000 = 26;
    private final int k8_600 = 27;
    private final int k8M_600 = 28;
    private final int MV_F3_675 = 29;
    private final int CBR_1000_08 = 30;
    private final int ZX6R_07 = 31;
    private final int ZX10R_08 = 32;
    private final int R6_06 = 33;
    private final int CBR600_08 = 34;
    private final int R1_07 = 35;
    private final int EMU = 36;
    private final int MOTEC = 37;
    private final int DUCATI_899 = 38;
    private final int DUCATI_1199 = 39;
    private final int RSV4_ABS = 40;
    private final int RSV_08 = 41;
    private final int BMW2015 = 42;
    private final int BMW2015DDC = 43;
    private final int R1M_2015 = 44;
    private final int R1_2015 = 45;
    private final int MOTEC_AUTO = 46;
    private final int ZX10R_16 = 47;
    private final int CBR1000M = 48;
    private final int MKE7 = 49;
    private final int TEST_BIKE = 50;
    private final int DUCATI_1299 = 51;
    private final int DUCATI_1199R = 52;
    private final int GMT = 53;
    private final int NINJA300 = 54;
    private final int R62017 = 55;
    private final int RSV_APRC = 56;
    private final int GSXR_17 = 57;
    private final int F3_MEK = 58;
    private final int R6_MEK = 59;
    private final int R32017 = 60;
    private final int DUCATI_V4 = 61;
    private final int NINJA400 = 62;
    private final int R1_2018 = 63;
    private final int RSV4_17 = 64;
    private final int R1_SBK = 65;
    private final int CBR_2017 = 66;
    private final int NINJA400WSS = 67;
    private final int ZX_EWC = 68;
    private final int ZX636 = 69;
    private final int YZF250 = 70;
    private final int WSS19 = 71;
    private final int R1_2020 = 72;
    private final int GMT94_17 = 73;
    private final int FREE = 74;
    private final int RSV4_19 = 75;
    private final int BMW_19 = 76;
    private final int R1_TECH = 77;
    private final int R6_KIT = 78;
    private final int GMT94 = 79;
    private final int IGNITECH = 80;
    private final int GMT94_20 = 81;
    private final int DUCATI_959 = 82;
    private final int ZX10R_SBK = 83;
    private final int CBR1000_2020 = 84;
    private final int DUCATIV4S = 85;
    private final int R1_SBK2 = 86;
    private final int DUCATI_V4_20 = 87;
    private final int DUCATI_V4S_20 = 88;
    private final int CIV20 = 89;
    private final int CBR1000HRC = 90;
    private final int BIKE19 = 91;
    private final int DUCATI_V2 = 92;
    private final int DUCATI_V4R_19 = 93;
    private final int ZX10R_21 = 94;
    private final int ZX10R_21RACE = 95;
    private final int R7_2022 = 96;
    private final int DUCATIV4_22 = 97;
    private final int DUCATIV4S_22 = 98;
    private final int NG22 = 99;
    private final int RSV4_21 = 100;
    private final int CBR1000HRC22 = 101;
    private final int RS660 = 102;
    private final int DUCATIV4_23 = 104;
    private final int DUCATIV4S_23 = 105;
    private final int BMW_22 = 106;
    private final int BMW_23 = 107;
    private final int BMW2018DDC = 108;
    private final int CBR600_24 = 110;
    private final int CBR1000HRC24 = 114;
    private final int ZX6R_24 = 115;
    private final int R9_24 = 116;
    private final int DUCATIV4_25 = 117;
    private final int DUCATIV4S_25 = 118;
    private final int DUCATIV4_25E = 119;
    private final int DUCATIV4S_25E = 120;

    public static DanasDataStructure getInstance() {
        if (instance == null) {
            instance = new DanasDataStructure();
        }
        return instance;
    }

    private DanasDataStructure() {
        int i;
        for (i = 0; i < this.canaleUtilizzato.length; ++i) {
            this.canaleUtilizzato[i] = false;
        }
        for (i = 0; i < this.canaliPresenti.length; ++i) {
            this.canaliPresenti[i] = false;
        }
        for (i = 0; i < 12; ++i) {
            this.posizioneAnalogici[i] = DanasPreferences.getPosizioneScambioAnalogico(i);
        }
        this.scambiaAnalogiciChrome = DanasPreferences.getScambiaChrome();
        this.scambiaAnalogiciDatalog = DanasPreferences.getScambiaDatalog();
    }

    public void setScambiaAnalogici(boolean scambia) {
        this.scambiaAnalogiciSempre = scambia;
    }

    public boolean getScambiaAnalogici() {
        return this.scambiaAnalogiciSempre;
    }

    public void setScambiaAnalogiciChrome(boolean scambia) {
        this.scambiaAnalogiciChrome = scambia;
        DanasPreferences.setScambiaChrome(scambia);
    }

    public boolean getScambiaAnalogiciChrome() {
        return this.scambiaAnalogiciChrome;
    }

    public void setScambiaAnalogiciDatalog(boolean scambia) {
        this.scambiaAnalogiciDatalog = scambia;
        DanasPreferences.setScambiaDatalog(scambia);
    }

    public boolean getScambiaAnalogiciDatalog() {
        return this.scambiaAnalogiciDatalog;
    }

    public void setPosizioneAnalogico(int originale, int nuova) {
        this.posizioneAnalogici[originale] = nuova;
        DanasPreferences.setPosizioneScambioAnalogico(originale, nuova);
    }

    public int getPosizioneAnalogico(int originale, boolean modifica) {
        if (!modifica) {
            return originale;
        }
        return this.posizioneAnalogici[originale];
    }

    public int getPosizioneValueAnalogico(int originale, boolean modifica) {
        if (!modifica) {
            return originale;
        }
        int indice = originale;
        switch (originale) {
            case 1: {
                indice = 0;
                break;
            }
            case 2: {
                indice = 1;
                break;
            }
            case 3: {
                indice = 2;
                break;
            }
            case 4: {
                indice = 3;
                break;
            }
            case 5: {
                indice = 4;
                break;
            }
            case 6: {
                indice = 5;
                break;
            }
            case 7: {
                indice = 6;
                break;
            }
            case 8: {
                indice = 7;
                break;
            }
            case 10: {
                indice = 8;
                break;
            }
            case 11: {
                indice = 9;
                break;
            }
            case 12: {
                indice = 10;
                break;
            }
            case 13: {
                indice = 11;
            }
        }
        int res = this.posizioneAnalogici[indice];
        switch (res) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 5;
            }
            case 5: {
                return 6;
            }
            case 6: {
                return 7;
            }
            case 7: {
                return 8;
            }
            case 8: {
                return 10;
            }
            case 9: {
                return 11;
            }
            case 10: {
                return 12;
            }
            case 11: {
                return 13;
            }
        }
        return originale;
    }

    public DanasDataStructureConstants.ValueType getPosizioneCanale(DanasDataStructureConstants.ValueType vt, boolean modifica) {
        if (!modifica) {
            return vt;
        }
        if (vt == DanasDataStructureConstants.ValueType.ANALOG1) {
            return this.getValueTypeAnalogico(this.posizioneAnalogici[0]);
        }
        if (vt == DanasDataStructureConstants.ValueType.ANALOG2) {
            return this.getValueTypeAnalogico(this.posizioneAnalogici[1]);
        }
        if (vt == DanasDataStructureConstants.ValueType.ANALOG3) {
            return this.getValueTypeAnalogico(this.posizioneAnalogici[2]);
        }
        if (vt == DanasDataStructureConstants.ValueType.ANALOG4) {
            return this.getValueTypeAnalogico(this.posizioneAnalogici[3]);
        }
        if (vt == DanasDataStructureConstants.ValueType.ANALOG5) {
            return this.getValueTypeAnalogico(this.posizioneAnalogici[4]);
        }
        if (vt == DanasDataStructureConstants.ValueType.ANALOG6) {
            return this.getValueTypeAnalogico(this.posizioneAnalogici[5]);
        }
        if (vt == DanasDataStructureConstants.ValueType.ANALOG7) {
            return this.getValueTypeAnalogico(this.posizioneAnalogici[6]);
        }
        if (vt == DanasDataStructureConstants.ValueType.ANALOG8) {
            return this.getValueTypeAnalogico(this.posizioneAnalogici[7]);
        }
        if (vt == DanasDataStructureConstants.ValueType.EXT1) {
            return this.getValueTypeAnalogico(this.posizioneAnalogici[8]);
        }
        if (vt == DanasDataStructureConstants.ValueType.EXT2) {
            return this.getValueTypeAnalogico(this.posizioneAnalogici[9]);
        }
        if (vt == DanasDataStructureConstants.ValueType.EXT3) {
            return this.getValueTypeAnalogico(this.posizioneAnalogici[10]);
        }
        if (vt == DanasDataStructureConstants.ValueType.EXT4) {
            return this.getValueTypeAnalogico(this.posizioneAnalogici[11]);
        }
        return vt;
    }

    public DanasDataStructureConstants.ValueType getValueTypeAnalogico(int indice) {
        switch (indice) {
            case 0: {
                return DanasDataStructureConstants.ValueType.ANALOG1;
            }
            case 1: {
                return DanasDataStructureConstants.ValueType.ANALOG2;
            }
            case 2: {
                return DanasDataStructureConstants.ValueType.ANALOG3;
            }
            case 3: {
                return DanasDataStructureConstants.ValueType.ANALOG4;
            }
            case 4: {
                return DanasDataStructureConstants.ValueType.ANALOG5;
            }
            case 5: {
                return DanasDataStructureConstants.ValueType.ANALOG6;
            }
            case 6: {
                return DanasDataStructureConstants.ValueType.ANALOG7;
            }
            case 7: {
                return DanasDataStructureConstants.ValueType.ANALOG8;
            }
            case 8: {
                return DanasDataStructureConstants.ValueType.EXT1;
            }
            case 9: {
                return DanasDataStructureConstants.ValueType.EXT2;
            }
            case 10: {
                return DanasDataStructureConstants.ValueType.EXT3;
            }
            case 11: {
                return DanasDataStructureConstants.ValueType.EXT4;
            }
        }
        return DanasDataStructureConstants.ValueType.ANALOG1;
    }

    public boolean isTemperaturaCelsius() {
        return this.isUnitCelsius;
    }

    public void setTemperaturaCelsius(boolean celsius) {
        this.isUnitCelsius = celsius;
    }

    public boolean isVelocitakmh() {
        return this.isUnitkmh;
    }

    public void setVelocitakmh(boolean iskmh) {
        this.isUnitkmh = iskmh;
    }

    public boolean isPressioneBar() {
        return this.isPressBar;
    }

    public void setPressioneBar(boolean isBar) {
        this.isPressBar = isBar;
    }

    public boolean mostraSerpentello() {
        return this.mostraSerpentello;
    }

    public void setMostraSerpentello(boolean mostra) {
        this.mostraSerpentello = mostra;
    }

    public boolean getMostraAllarmi() {
        return this.mostraAllarmi;
    }

    public void setMostraAllarmi(boolean mostra) {
        this.mostraAllarmi = mostra;
    }

    public boolean[] getTuttiCanaliUtilizzati() {
        return this.canaleUtilizzato;
    }

    public boolean getCanaleUtilizzato2(DanasDataStructureConstants.ValueType vt) {
        return this.canaleUtilizzato[vt.ordinal()];
    }

    public void setCanaleUtilizzato(DanasDataStructureConstants.ValueType vt, boolean utilizzato) {
        this.canaleUtilizzato[vt.ordinal()] = utilizzato;
    }

    public void clearDataStructure() {
        this.enableNotifier();
        this.removeAllSessions2();
        this.setCircuitName("");
        this.setGPSOffset(0);
        this.setChange(DanasDataStructureConstants.ChangeType.REMOVE_DATA);
    }

    public void setRisoluzioneStechio(double risoluzione) {
        this.risoluzioneStechio = risoluzione;
    }

    public double getRisoluzioneStechio() {
        return this.risoluzioneStechio;
    }

    public DanasDataStructureConstants.ValueType getCanaleMarceAttuale() {
        if (this.getDefaultSession() == null) {
            return DanasDataStructureConstants.ValueType.GEARS;
        }
        int tipoMoto = this.getDefaultSession().getSessionSettings().getTipoMoto();
        if (tipoMoto == 14 || tipoMoto == 15 || tipoMoto == 16 || tipoMoto == 20 || tipoMoto == 21 || tipoMoto == 22 || tipoMoto == 20 || tipoMoto == 29 || tipoMoto == 38 || tipoMoto == 39 || tipoMoto == 40 || tipoMoto == 42 || tipoMoto == 43 || tipoMoto == 108 || tipoMoto == 44 || tipoMoto == 45 || tipoMoto == 47 || tipoMoto == 49 || tipoMoto == 51 || tipoMoto == 82 || tipoMoto == 52 || tipoMoto == 53 || tipoMoto == 55 || tipoMoto == 56 || tipoMoto == 57 || tipoMoto == 58 || tipoMoto == 59 || tipoMoto == 60 || tipoMoto == 61 || tipoMoto == 85 || tipoMoto == 63 || tipoMoto == 64 || tipoMoto == 66 || tipoMoto == 67 || tipoMoto == 72 || tipoMoto == 81 || tipoMoto == 73 || tipoMoto == 75 || tipoMoto == 68 || tipoMoto == 69 || tipoMoto == 71 || tipoMoto == 91 || tipoMoto == 77 || tipoMoto == 87 || tipoMoto == 88 || tipoMoto == 92 || tipoMoto == 93 || tipoMoto == 98 || tipoMoto == 97 || tipoMoto == 104 || tipoMoto == 105 || tipoMoto == 117 || tipoMoto == 118 || tipoMoto == 119 || tipoMoto == 120 || tipoMoto == 78 || tipoMoto > 71) {
            return DanasDataStructureConstants.ValueType.MULTI7;
        }
        return DanasDataStructureConstants.ValueType.GEARS;
    }

    public static long getTempoApertura() {
        return tempoApertura;
    }

    public static int[] getElencoDistanze() {
        return elencoDistanze;
    }

    public static void setElencoDistanze(int[] elenco) {
        elencoDistanze = elenco;
    }

    public void calcolaSpaziPercorsiSessioni(int startingSession) {
        if (startingSession > this.getNSessions()) {
            return;
        }
        for (int j = 1; j <= this.getNSessions(); ++j) {
            DanasSession sess = this.getSession(j);
            if (sess == null) continue;
            sess.calcolaTempiDistanze();
            sess.azzeraFunzioniMath();
        }
    }

    public void calcolaSpaziPercorsiLap() {
        int i;
        System.out.println("DEBUG:calcolaSpaziPercorsiLap");
        DanasLap deaultLap = this.getDefaultLap();
        if (this.defaultLap == null) {
            return;
        }
        deaultLap.calcolaTempiDistanze();
        int nSplit = this.defaultLap.getNSplit();
        Vector<Double> distanze = new Vector<Double>();
        double dist = 0.0;
        for (i = 1; i <= nSplit; ++i) {
            dist = this.defaultLap.getDistanceSplit(i);
            distanze.add(dist);
        }
        if (nSplit == 0) {
            if (this.defaultLap.isGpsPresent()) {
                distanze.add(this.defaultLap.getDistanceCovered(DanasDataStructureConstants.DataType.GPS));
            } else {
                distanze.add(this.defaultLap.getDistanceCovered(DanasDataStructureConstants.DataType.VALUE));
            }
        }
        for (i = 1; i <= this.getNSessions(); ++i) {
            DanasSession sess = this.getSession(i);
            for (int j = 1; j <= sess.getNumberOfLaps(); ++j) {
                sess.getLap(j).normalizzaDistanze(distanze);
            }
        }
        System.out.println("Log:fine calcolo spazi percorsi lap:" + (double)(System.currentTimeMillis() - DanasDataStructure.getTempoApertura()) / 1000.0);
    }

    public static void setModTraslazione(boolean trasla) {
        modTraslazione = trasla;
    }

    public boolean getModTraslazione() {
        return modTraslazione;
    }

    public static void setAllienamentoSPlit(int split) {
        allineamentoSplit = split;
    }

    public int getAllienamentoSPlit() {
        return allineamentoSplit;
    }

    public static void setCalcolaSplitAuto(boolean abilita) {
        DisabilitaCalcolaSplitAuto = abilita;
    }

    public boolean getCalcolaSplitAuto() {
        return DisabilitaCalcolaSplitAuto;
    }

    public static void setCalcolaSplit(boolean abilita) {
        calcolaSplit = abilita;
    }

    public boolean getCalcolaSplit() {
        return calcolaSplit;
    }

    public synchronized int getPercentualeSalvataggio() {
        return percentualeSalvataggio;
    }

    public synchronized void setPercentualeSalvataggio(int valore) {
        percentualeSalvataggio = valore;
    }

    public synchronized void interrompiSalvataggio() {
        this.interrompiSalvataggio = true;
    }

    public synchronized int getPercentualeApertura() {
        return percentualeApertura;
    }

    public synchronized void setPercentualeApertura(int valore) {
        percentualeApertura = valore;
    }

    public static void setModInterpolazione(boolean interpola) {
        interpolazioneAttiva = interpola;
    }

    public static boolean getModInterpolazione() {
        return interpolazioneAttiva;
    }

    public void interpolaDati(DanasDataStructureConstants.ValueType vt, DanasSession s) {
        ArrayDouble values = s.getAllValueData(vt, false);
        int numeroDecimali = 3;
        int fattoreInterpolazione = s.getFattoreInterpolazione(vt);
        double[] analog = new double[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            analog[i] = values.get(i);
        }
        double[] analogInterpolato = Interpolatore.Complex.interpola(analog, fattoreInterpolazione, numeroDecimali);
        s.setNuoviValoriInterpolati(vt, analogInterpolato);
    }

    public List<Double> getDatiInterpolati(DanasDataStructureConstants.ValueType vt, DanasSession s, double fattoreInterpolazione) {
        ArrayDouble values = s.getAllValueData(vt, false);
        int numeroDecimali = 3;
        double[] analog = new double[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            analog[i] = values.get(i);
        }
        double[] analogInterpolato = Interpolatore.Complex.interpola(analog, fattoreInterpolazione, numeroDecimali);
        ArrayList<Double> out = new ArrayList<Double>();
        for (int i = 0; i < analogInterpolato.length; ++i) {
            out.add(analogInterpolato[i]);
        }
        return out;
    }

    public static void setRicalcolaTutto(boolean ricalcola) {
        ricalcolaTutto = ricalcola;
    }

    public boolean getRicalcolaTutto() {
        return ricalcolaTutto;
    }

    public static void setSalvaGiriAutomatici(boolean salva) {
        salvaGiriAutomatici = salva;
    }

    public static boolean getSalvaGiriAutomatici() {
        return salvaGiriAutomatici;
    }

    public static void setOffsetGps(int offset) {
        offsetGPS = offset;
    }

    public static int getOffsetGps() {
        return offsetGPS;
    }

    public void setMainFrame(MainFrame danas) {
        danasFrame = danas;
    }

    public MainFrame getMainFrame() {
        return danasFrame;
    }

    public boolean isColorSelected(Color colore) {
        for (int i = 1; i <= this.getNSessions(); ++i) {
            DanasSession sess = this.getSession(i);
            if (!sess.isSelected()) continue;
            for (int giro = 1; giro <= sess.getNumberOfLaps(); ++giro) {
                if (!sess.getLap(giro).getSelected() || sess.getLap(giro).getColor().getRGB() != colore.getRGB()) continue;
                return true;
            }
        }
        return false;
    }

    public Vector<String> getSelectedLapList() {
        Vector<String> elencoGiri = new Vector<String>();
        for (int i = 1; i <= this.getNSessions(); ++i) {
            DanasSession sess = this.getSession(i);
            if (!sess.isSelected()) continue;
            for (int giro = 1; giro <= sess.getNumberOfLaps(); ++giro) {
                if (!sess.getLap(giro).getSelected()) continue;
                String nome = "Lap-" + sess.getSessionID() + "-" + sess.getLap(giro).getLapID();
                elencoGiri.add(nome);
            }
        }
        return elencoGiri;
    }

    public boolean getMostraPuntiInfo() {
        return this.mostraPuntiInfo;
    }

    public void setMostraPuntiInfo(boolean mostra) {
        this.mostraPuntiInfo = mostra;
    }

    public void setApriPrimaSessione(boolean aggiorna) {
        this.apriPrimaSessione = aggiorna;
    }

    public boolean getApriPrimaSessione() {
        return this.apriPrimaSessione;
    }

    public void setApriUltimaSessione(boolean aggiorna) {
        this.apriUltimaSessione = aggiorna;
    }

    public boolean getApriUltimaSessione() {
        return this.apriUltimaSessione;
    }

    public void setApriBest(boolean aggiorna) {
        this.apriBest = aggiorna;
    }

    public boolean getApriBest() {
        return this.apriBest;
    }

    public void setVideoCompareLap(DanasLap lap) {
        this.videoCompareLap = lap;
        danasFrame.aggiornaFileVideoCompare();
        TableWindow.refreshAll();
    }

    public DanasLap getVideoCompareLap() {
        return this.videoCompareLap;
    }

    public void setAggiornaViewer(boolean aggiorna) {
        this.aggiornareViewer = aggiorna;
    }

    public boolean getAggiornareViewer() {
        return true;
    }

    public void setAggiornaViewerSempre(boolean aggiorna) {
        this.aggiornaViewerSempre = aggiorna;
    }

    public boolean getAggiornareViewerSempre() {
        return this.aggiornaViewerSempre;
    }

    public void calcolaParametriSimulazione() {
        int i;
        for (i = 0; i < 7; ++i) {
            this.cambio[i] = DanasPreferences.getPreferenzeSimulazioni(i + 1);
            this.cambioSim[i] = DanasPreferences.getPreferenzeSimulazioni(i + 10);
        }
        for (i = 0; i < 6; ++i) {
            this.minimiRpm[i + 1] = DanasPreferences.getPreferenzeSimulazioni(i * 2 + 23);
            this.massimiRpm[i + 1] = DanasPreferences.getPreferenzeSimulazioni(i * 2 + 24);
        }
        this.rappValue = DanasPreferences.getPreferenzeSimulazioni(9) / DanasPreferences.getPreferenzeSimulazioni(8);
        this.rappSimValue = DanasPreferences.getPreferenzeSimulazioni(18) / DanasPreferences.getPreferenzeSimulazioni(17);
        this.rpmMin = DanasPreferences.getPreferenzeSimulazioni(19);
        this.rpmMax = DanasPreferences.getPreferenzeSimulazioni(20);
        this.sogliaTps = DanasPreferences.getPreferenzeSimulazioni(21);
        this.usaOld = DanasPreferences.getPreferenzeSimulazioni(22) == 1.0;
    }

    public Double[] getMarceSimulate(int marcia, double rpm) {
        Double[] R = new Double[7];
        for (int i = 1; i <= 6; ++i) {
            R[i] = rpm / this.rappValue / this.cambio[0] / this.cambio[marcia] * this.rappSimValue * this.cambioSim[0] * this.cambioSim[i];
        }
        return R;
    }

    public Double[] getValoriSimulati(double _rpm, double _tps, int _gear, int gearPrecedente) {
        int gearSim;
        Double rpmSim;
        Double[] out;
        block9: {
            out = new Double[2];
            Double tps = _tps;
            int gear = _gear;
            Double rpm = _rpm;
            rpmSim = 0.0;
            gearSim = 1;
            if (gear < 1) {
                gear = 1;
            }
            if (gear > 6) {
                gear = 6;
            }
            Double[] x = this.getMarceSimulate(gear, rpm);
            gearSim = this.usaOld ? gear : gearPrecedente;
            rpmSim = x[gearSim];
            try {
                int m;
                if (!(x[gearSim] >= this.massimiRpm[gearSim]) && !(x[gearSim] <= this.minimiRpm[gearSim])) break block9;
                if (tps > this.sogliaTps) {
                    for (int m2 = 1; m2 < 7; ++m2) {
                        if (!(x[m2] <= this.massimiRpm[m2])) continue;
                        gearSim = m2;
                        rpmSim = x[m2];
                        break block9;
                    }
                    break block9;
                }
                rpmSim = x[gearSim];
                if (x[gearSim] >= this.massimiRpm[gearSim]) {
                    for (m = gearSim; m < 7; ++m) {
                        if (!(x[m] <= this.massimiRpm[m])) continue;
                        gearSim = m;
                        rpmSim = x[m];
                        break;
                    }
                }
                if (!(x[gearSim] <= this.minimiRpm[gearSim]) || gearSim <= 1) break block9;
                for (m = gearSim - 1; m >= 1; --m) {
                    if (!(x[m] < this.minimiRpm[m + 1])) continue;
                    gearSim = m;
                    rpmSim = x[m];
                    break;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.out.println("Errore calcolo marce simulate");
            }
        }
        out[0] = rpmSim;
        out[1] = gearSim;
        return out;
    }

    public void setSimulazioneMarcieAttiva(boolean attivo) {
        this.simulazioneMarcieAttiva = attivo;
        if (attivo) {
            this.calcolaParametriSimulazione();
        }
    }

    public boolean getSimulazioneMarcieAttiva() {
        return this.simulazioneMarcieAttiva;
    }

    public void setMostraPosizioniTabella(boolean attivo) {
        this.mostraPosizioniTabella = attivo;
    }

    public boolean getMostraPosizioniTabella() {
        return this.mostraPosizioniTabella;
    }

    public void setPosizioneTabellaAttuale(int posizione) {
        this.posizioneTabellaAttuale = posizione;
    }

    public int getPosizioneTabellaAttuale() {
        return this.posizioneTabellaAttuale;
    }

    public void setMostraMassimiMinimi(boolean attivo) {
        this.mostraMassimi = attivo;
    }

    public boolean getMostramassimiMinimi() {
        return this.mostraMassimi;
    }

    public void setConfrontaDefault(boolean attivo) {
        this.confrontaDefault = attivo;
    }

    public boolean getConfrontaDefault() {
        return this.confrontaDefault;
    }

    public void setSingoloDefault(boolean attivo) {
        this.singoloDefault = attivo;
    }

    public boolean getSingoloDefault() {
        return this.singoloDefault;
    }

    public void setChiudiGiro(boolean chiudi) {
        this.chiudiGiro = chiudi;
    }

    public String getMath1Name() {
        return "Sim.Rpm";
    }

    public String getMath2Name() {
        return "Sim.Gear";
    }

    public boolean isChanged() {
        return this.isChanged;
    }

    public DanasDataStructureConstants.ChangeType getChange() {
        return this.Change;
    }

    public String getChangeParameter() {
        return this.ChangeParameter;
    }

    public void setChange(DanasDataStructureConstants.ChangeType c) {
        if (!this.NotifierEnabled) {
            return;
        }
        this.isChanged = true;
        this.Change = c;
        this.ChangeParameter = "";
        this.notifyStateChanged();
    }

    public GPSPoint getPrimoPuntoGPS() {
        if (this.getNSessions() == 0) {
            return null;
        }
        for (int i = 1; i <= this.getNSessions(); ++i) {
            DanasSession sess = this.getSession(i);
            if (sess.getDimensioneCanale(DanasDataStructureConstants.ValueType.LAT) == 0) continue;
            return new GPSPoint(sess.getDatoAtIndex(DanasDataStructureConstants.ValueType.LAT, 0), sess.getDatoAtIndex(DanasDataStructureConstants.ValueType.LONG, 0));
        }
        return null;
    }

    public void calcolaGiri(double latitudine, double longitudine, double dimensioneTraguardo, long verso, int startingSession, double tempoMinimo) {
        Vector<Double> elencoTempi = new Vector();
        boolean aggiuntoDefaultLap = false;
        if (this.getDefaultLap() != null) {
            aggiuntoDefaultLap = true;
        }
        if (startingSession >= this.getNSessions()) {
            return;
        }
        for (int j = startingSession + 1; j <= this.getNSessions(); ++j) {
            DanasSession sess = this.getSession(j);
            sess.setTempoMinimo(tempoMinimo);
            if (sess == null || sess.getGiriManual()) continue;
            elencoTempi = this.calcolaAttraversamenti(latitudine, longitudine, dimensioneTraguardo, verso, j);
            if (this.chiudiGiro && sess.getDimensioneCanale(DanasDataStructureConstants.ValueType.LAT) > 1) {
                elencoTempi.add(sess.getTempoIniziale(DanasDataStructureConstants.ValueType.LAT) + (double)(sess.getDimensioneCanale(DanasDataStructureConstants.ValueType.LAT) - 1) * 100.0 / sess.getFrequenzaCanale(DanasDataStructureConstants.ValueType.LAT));
            }
            sess.removeLaps();
            sess.createLapsNew(elencoTempi, false);
            if (aggiuntoDefaultLap || sess.getNumberOfLaps() == 0) continue;
            this.setDefaultLap(sess.getLaps().elementAt(0));
            aggiuntoDefaultLap = true;
        }
    }

    public void inserisciTempi(int session, Vector<Double> vettoreTempi) {
        Vector<Object> elencoTempi = new Vector();
        Vector<Double> elencoTempiOffset = new Vector<Double>();
        elencoTempiOffset = new Vector();
        boolean aggiuntoDefaultLap = false;
        if (this.getDefaultLap() != null) {
            aggiuntoDefaultLap = true;
        }
        elencoTempi = vettoreTempi;
        DanasSession sess = this.getSession(session);
        if (sess == null) {
            return;
        }
        sess.removeLaps();
        for (int i = 0; i < elencoTempi.size(); ++i) {
            elencoTempiOffset.add((Double)elencoTempi.get(i) + sess.getStartTelemetryTime());
        }
        sess.createLapsNew(elencoTempiOffset, false);
        if (!aggiuntoDefaultLap && sess.getNumberOfLaps() != 0) {
            this.setDefaultLap(sess.getLaps().elementAt(0));
            aggiuntoDefaultLap = true;
        }
    }

    public double calcolaVersoAutomatico(double latitudine, double longitudine, double dimensioneTraguardo, int velocitaMinima, int numeroSessione) {
        double verso = 0.0;
        double vel = 0.0;
        vel = (double)velocitaMinima / 1.85;
        DanasSession sess = this.getSession(numeroSessione);
        int dimensione = sess.getDimensioneCanale(DanasDataStructureConstants.ValueType.LAT);
        for (int i = 0; i < dimensione; ++i) {
            if (sess.getPointAtIndex(i).getSpeed() < vel || i + 1 >= dimensione || !(this.traguardoAttraversato(sess.getPointAtIndex(i), sess.getPointAtIndex(i + 1), latitudine, longitudine, dimensioneTraguardo, -1L) ? (verso = this.calcolaVerso(sess.getPointAtIndex(i), sess.getPointAtIndex(i + 1))) != -1.0 : i + 2 < dimensione && this.traguardoAttraversato(sess.getPointAtIndex(i), sess.getPointAtIndex(i + 2), latitudine, longitudine, dimensioneTraguardo, -1L) && (verso = this.calcolaVerso(sess.getPointAtIndex(i), sess.getPointAtIndex(i + 2))) != -1.0)) continue;
            return verso;
        }
        return -1.0;
    }

    public double calcolaVerso(GPSPoint start, GPSPoint stop) {
        double y = stop.getLat() - start.getLat();
        double x = Mappa2D.convertiX(stop.getLon(), stop.getLat()) - Mappa2D.convertiX(start.getLon(), start.getLat());
        double angolo = 360.0 + 57.324840764331206 * Math.atan2(y, x);
        return angolo %= 360.0;
    }

    public boolean traguardoAttraversato(GPSPoint start, GPSPoint stop, double latitudine, double longitudine, double dimensione, long verso) {
        double ya = start.getLat() - latitudine;
        double xa = Mappa2D.convertiX(start.getLon(), start.getLat()) - Mappa2D.convertiX(longitudine, latitudine);
        double yb = stop.getLat() - latitudine;
        double xb = Mappa2D.convertiX(stop.getLon(), stop.getLat()) - Mappa2D.convertiX(longitudine, latitudine);
        if (verso != -1L) {
            double angolo = 360.0 + 57.324840764331206 * Math.atan2(yb - ya, xb - xa);
            double deltaAngolo = Math.abs((angolo %= 360.0) - (double)verso);
            if (deltaAngolo > 45.0 && deltaAngolo < 315.0) {
                return false;
            }
        }
        if (start.getLat() == stop.getLat() && start.getLon() == stop.getLon()) {
            return false;
        }
        double numParziale = xa * yb - xb * ya;
        double numParzialex = yb - ya;
        double denominatore = (xa - xb) * (xa - xb) + (ya - yb) * (ya - yb);
        double numParzialey = xa - xb;
        double x0 = numParziale * numParzialex / denominatore;
        double y0 = numParziale * numParzialey / denominatore;
        if (!((xa >= x0 && x0 >= xb || xa <= x0 && x0 <= xb) && (ya >= y0 && y0 >= yb || ya <= y0 && y0 <= yb) && (xa != x0 || ya != y0))) {
            return false;
        }
        return !(Math.sqrt(x0 * x0 + y0 * y0) > dimensione);
    }

    public Vector<Double> calcolaAttraversamenti(double latitudine, double longitudine, double dimensioneTraguardo, long verso, int numeroSessione) {
        Vector<Double> elencoTempi = new Vector<Double>();
        if (numeroSessione > this.getNSessions() || numeroSessione <= 0) {
            return null;
        }
        DanasSession sess = this.getSession(numeroSessione);
        int dimensione = sess.getDimensioneCanale(DanasDataStructureConstants.ValueType.LAT);
        for (int i = 2; i < dimensione; ++i) {
            if (i + 1 >= dimensione) continue;
            if (this.traguardoAttraversato(sess.getPointAtIndex(i - 1), sess.getPointAtIndex(i), latitudine, longitudine, dimensioneTraguardo, verso)) {
                elencoTempi.add(this.calcolaTempo(sess.getPointAtIndex(i - 1), sess.getPointAtIndex(i), latitudine, longitudine, dimensioneTraguardo, verso));
                i += 2;
                continue;
            }
            if (i + 2 >= dimensione || !this.traguardoAttraversato(sess.getPointAtIndex(i - 2), sess.getPointAtIndex(i), latitudine, longitudine, dimensioneTraguardo, verso)) continue;
            elencoTempi.add(this.calcolaTempo(sess.getPointAtIndex(i - 2), sess.getPointAtIndex(i), latitudine, longitudine, dimensioneTraguardo, verso));
            i += 3;
        }
        return elencoTempi;
    }

    public double calcolaTempo(GPSPoint start, GPSPoint stop, double latitudine, double longitudine, double dimensione, long verso) {
        double delta0;
        double deltaAB;
        double ya = start.getLat() - latitudine;
        double xa = start.getLon() - longitudine;
        double yb = stop.getLat() - latitudine;
        double xb = stop.getLon() - longitudine;
        double numParziale = xa * yb - xb * ya;
        double numParzialex = yb - ya;
        double denominatore = (xa - xb) * (xa - xb) + (ya - yb) * (ya - yb);
        double numParzialey = xa - xb;
        double x0 = numParziale * numParzialex / denominatore;
        double y0 = numParziale * numParzialey / denominatore;
        if (Math.abs(yb - ya) > Math.abs(xb - xa)) {
            deltaAB = Math.abs(yb - ya);
            delta0 = Math.abs(y0 - ya);
        } else {
            deltaAB = Math.abs(xb - xa);
            delta0 = Math.abs(x0 - xa);
        }
        double deltaTempo = (stop.getTelemetry_time() - start.getTelemetry_time()) * delta0 / deltaAB;
        return start.getTelemetry_time() + deltaTempo;
    }

    public int getNumberSelectedLaps() {
        int giriSelezionati = 0;
        for (int i = 1; i <= this.getNSessions(); ++i) {
            if (!this.getSession(i).isSelected()) continue;
            for (int j = 1; j <= this.getSession(i).getNumberOfLaps(); ++j) {
                if (!this.getSession(i).getLap(j).getSelected()) continue;
                ++giriSelezionati;
            }
        }
        return giriSelezionati;
    }

    public int getNumberSelectedSessions() {
        int sessioniSelezionate = 0;
        for (int i = 1; i <= this.getNSessions(); ++i) {
            if (!this.getSession(i).isSelected()) continue;
            ++sessioniSelezionate;
        }
        return sessioniSelezionate;
    }

    public void ricalcolaCanaliPresenti() {
        int i;
        for (i = 0; i < MeasuresUtil.getNumeroCurve(); ++i) {
            this.canaliPresenti[i] = false;
        }
        for (i = 0; i < MeasuresUtil.getNumeroCurve(); ++i) {
            for (int s = 0; s < this.getNSessions(); ++s) {
                if (!this.getSession(s + 1).isCanaleUsato(DanasDataStructureConstants.ValueType.values()[i])) continue;
                this.canaliPresenti[i] = true;
            }
        }
    }

    public boolean getCanalePresente(DanasDataStructureConstants.ValueType vt) {
        return this.canaliPresenti[vt.ordinal()];
    }

    public void ricalcolaValoriGiri() {
        if (!calcolaSplit) {
            return;
        }
        TableWindow.refreshAll();
        SessionViewer.refreshAll();
        this.setChange(DanasDataStructureConstants.ChangeType.SET_GOAL);
    }

    public void aggiornaOffset() {
        this.calcolaSpaziPercorsiSessioni(0);
        System.out.println("refresh all table 2");
        TableWindow.refreshAll();
        SessionViewer.refreshAll();
        this.setChange(DanasDataStructureConstants.ChangeType.REFRESH_ALL);
    }

    public void calcolaSplit(double latitudine, double longitudine, double dimensioneTraguardo, long verso, int startingSession) {
        Vector<Object> elencoTempi = new Vector();
        boolean aggiuntoSplit = false;
        if (startingSession > this.getNSessions()) {
            return;
        }
        for (int j = startingSession + 1; j <= this.getNSessions(); ++j) {
            DanasSession sess = this.getSession(j);
            if (sess == null) continue;
            elencoTempi = this.calcolaAttraversamenti(latitudine, longitudine, dimensioneTraguardo, verso, j);
            for (int l = 1; l <= sess.getNumberOfLaps(); ++l) {
                DanasLap lap = sess.getLap(l);
                aggiuntoSplit = false;
                for (int t = 0; t < elencoTempi.size(); ++t) {
                    if (!((Double)elencoTempi.get(t) > lap.getStart()) || !((Double)elencoTempi.get(t) < lap.getEnd())) continue;
                    lap.addSplit((Double)elencoTempi.get(t));
                    aggiuntoSplit = true;
                    break;
                }
                if (aggiuntoSplit) continue;
                lap.addSplit(null);
            }
        }
    }

    public void rimuoviAllSplit() {
        for (int j = 1; j <= this.getNSessions(); ++j) {
            DanasSession sess = this.getSession(j);
            if (sess == null) continue;
            for (int l = 1; l <= sess.getNumberOfLaps(); ++l) {
                DanasLap lap = sess.getLap(l);
                lap.removeAllSplit();
            }
        }
    }

    public void removeAllLaps() {
        for (int j = 1; j <= this.getNSessions(); ++j) {
            DanasSession sess = this.getSession(j);
            sess.removeLaps();
        }
        System.out.println("refresh all table 3");
        TableWindow.refreshAll();
        SessionViewer.refreshAll();
        this.setDefaultLap(null);
        this.setChange(DanasDataStructureConstants.ChangeType.SET_GOAL);
    }

    public void setChange(DanasDataStructureConstants.ChangeType c, String cp) {
        this.isChanged = true;
        this.Change = c;
        this.ChangeParameter = cp == null ? "" : cp;
        this.notifyStateChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener l) {
        List<ChangeListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener l) {
        List<ChangeListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(l);
        }
    }

    public boolean getEnableNotifier() {
        return this.NotifierEnabled;
    }

    public void enableNotifier() {
        this.NotifierEnabled = true;
    }

    public void disableNotifier() {
        this.NotifierEnabled = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyStateChanged() {
        if (!this.NotifierEnabled) {
            return;
        }
        ChangeEvent e = new ChangeEvent(this);
        List<ChangeListener> list = this.listeners;
        synchronized (list) {
            for (ChangeListener l : this.listeners) {
                l.stateChanged(e);
            }
        }
        this.isChanged = false;
    }

    public void setDefaultSession(DanasSession defaultSession) {
        if (this.DanasSessions.size() == 0) {
            this.defaultSession = null;
        }
        this.defaultSession = defaultSession;
        this.setChange(DanasDataStructureConstants.ChangeType.SET_REF_SESSION);
    }

    public DanasSession getDefaultSession() {
        return this.defaultSession;
    }

    public Vector<DanasSession> getSessions() {
        return this.DanasSessions;
    }

    public DanasSession getSession(int sessionID) {
        for (int i = 0; i < this.DanasSessions.size(); ++i) {
            if (this.DanasSessions.get(i).getSessionID() != sessionID) continue;
            return this.DanasSessions.get(i);
        }
        return null;
    }

    public DanasSession getSession(String sessionName) {
        for (int i = 0; i < this.DanasSessions.size(); ++i) {
            if (!this.DanasSessions.get(i).getSessionName().equals(sessionName)) continue;
            return this.DanasSessions.get(i);
        }
        return null;
    }

    public void addSession(DanasSession newSession) {
        this.DanasSessions.add(newSession);
        this.setChange(DanasDataStructureConstants.ChangeType.NEW_DATA);
    }

    public void removeSession(int sessionID) {
        int i;
        gda.stop();
        for (i = 0; i < this.DanasSessions.size(); ++i) {
            if (this.DanasSessions.get(i).getSessionID() != sessionID) continue;
            this.DanasSessions.removeElementAt(i);
        }
        for (i = 0; i < this.DanasSessions.size(); ++i) {
            this.DanasSessions.get(i).setSessionID(i + 1);
            this.DanasSessions.get(i).getSessionSettings().setSessionID(i + 1);
            this.DanasSessions.get(i).setSessionName("Session" + (i + 1));
        }
    }

    public void removeSession(Vector<Integer> sessionID) {
        gda.stop();
        for (int j = 0; j < sessionID.size(); ++j) {
            for (int i = 0; i < this.DanasSessions.size(); ++i) {
                if (this.DanasSessions.get(i).getSessionID() != sessionID.get(j).intValue()) continue;
                this.DanasSessions.removeElementAt(i);
            }
        }
        for (int i = 0; i < this.DanasSessions.size(); ++i) {
            this.DanasSessions.get(i).setSessionID(i + 1);
            this.DanasSessions.get(i).setSessionName("Session" + (i + 1));
        }
    }

    public void removeSession(String sessionName) {
        gda.stop();
        for (int i = 0; i < this.DanasSessions.size(); ++i) {
            if (!this.DanasSessions.get(i).getSessionName().equals(sessionName)) continue;
            this.DanasSessions.removeElementAt(i);
        }
    }

    public void removeAllSessions() {
        gda.stop();
        this.setDefaultLapNull();
        this.defaultSession = null;
        this.DanasSessions.clear();
        this.setChange(DanasDataStructureConstants.ChangeType.REMOVE_DATA);
    }

    private void removeAllSessions2() {
        this.setDefaultLap(null);
        this.DanasSessions.clear();
    }

    public int getNSessions() {
        return this.DanasSessions.size();
    }

    public void selectAllSessions() {
        for (int i = 0; i < this.DanasSessions.size(); ++i) {
            this.DanasSessions.get(i).select2();
        }
        this.setChange(DanasDataStructureConstants.ChangeType.SEL_ALL_SESSION);
    }

    public void deselectAllSessions() {
        for (int i = 0; i < this.DanasSessions.size(); ++i) {
            this.DanasSessions.get(i).deselect2();
        }
        this.setChange(DanasDataStructureConstants.ChangeType.DESEL_ALL_SESSION);
    }

    public void selectAllLaps() {
        for (DanasSession ds : this.DanasSessions) {
            for (DanasLap dl : ds.getLaps()) {
                dl.setSelected2(true);
            }
        }
        this.setChange(DanasDataStructureConstants.ChangeType.SEL_ALL_LAP);
    }

    public void deselectAllLaps() {
        for (DanasSession ds : this.DanasSessions) {
            for (DanasLap dl : ds.getLaps()) {
                dl.setSelected2(false);
            }
        }
        this.setChange(DanasDataStructureConstants.ChangeType.DESEL_ALL_LAP);
    }

    public GPSPoint[] getGPSBound() {
        GPSPoint north = null;
        GPSPoint south = null;
        GPSPoint east = null;
        GPSPoint west = null;
        double latitudine = 0.0;
        double longitudine = 0.0;
        boolean noGps = true;
        for (DanasSession s : this.DanasSessions) {
            if (!s.isSelected() || s.getDimensioneCanale(DanasDataStructureConstants.ValueType.LAT) == 0) continue;
            noGps = false;
            for (int indice = 0; indice < s.getDimensioneCanale(DanasDataStructureConstants.ValueType.LAT); ++indice) {
                latitudine = s.getDatoAtIndex(DanasDataStructureConstants.ValueType.LAT, indice);
                longitudine = s.getDatoAtIndex(DanasDataStructureConstants.ValueType.LONG, indice);
                if (north == null) {
                    north = new GPSPoint(latitudine, longitudine);
                }
                if (south == null) {
                    south = new GPSPoint(latitudine, longitudine);
                }
                if (east == null) {
                    east = new GPSPoint(latitudine, longitudine);
                }
                if (west == null) {
                    west = new GPSPoint(latitudine, longitudine);
                }
                if (latitudine > north.getLat()) {
                    north.setLat(latitudine);
                    north.setLon(longitudine);
                }
                if (latitudine < south.getLat()) {
                    south.setLat(latitudine);
                    south.setLon(longitudine);
                }
                if (Mappa2D.convertiX(longitudine, latitudine) > Mappa2D.convertiX(east.getLon(), east.getLat())) {
                    east.setLat(latitudine);
                    east.setLon(longitudine);
                }
                if (!(Mappa2D.convertiX(longitudine, latitudine) < Mappa2D.convertiX(west.getLon(), west.getLat()))) continue;
                west.setLat(latitudine);
                west.setLon(longitudine);
            }
        }
        if (noGps) {
            return null;
        }
        GPSPoint[] estremi = new GPSPoint[]{new GPSPoint(north.getLat(), north.getLon()), new GPSPoint(east.getLat(), east.getLon()), new GPSPoint(south.getLat(), south.getLon()), new GPSPoint(west.getLat(), west.getLon())};
        return estremi;
    }

    public DanasLap getBestLap(DanasDataStructureConstants.SelectionFlag f) {
        DanasLap d = null;
        if (f.equals((Object)DanasDataStructureConstants.SelectionFlag.ALL)) {
            for (DanasSession ds : this.getSessions()) {
                if (d == null) {
                    d = ds.getBestLap(f);
                    continue;
                }
                if (d == null || ds.getBestLap(f) == null || !(ds.getBestLap(f).getDuration() < d.getDuration())) continue;
                d = ds.getBestLap(f);
            }
            return d;
        }
        if (f.equals((Object)DanasDataStructureConstants.SelectionFlag.SELECTED)) {
            for (DanasSession ds : this.getSessions()) {
                if (d == null && ds.isSelected()) {
                    d = ds.getBestLap(f);
                    continue;
                }
                if (d == null || ds.getBestLap(f) == null || !(ds.getBestLap(f).getDuration() < d.getDuration()) || !ds.isSelected()) continue;
                d = ds.getBestLap(f);
            }
            return d;
        }
        return null;
    }

    public double getIdealTime(DanasDataStructureConstants.SelectionFlag f) {
        DanasLap lap = this.getBestLap(f);
        if (lap == null) {
            return 0.0;
        }
        int numSplit = lap.getNSplit();
        if (numSplit == 0) {
            return lap.getDuration();
        }
        double ideal = 0.0;
        for (int i = 1; i <= numSplit; ++i) {
            ideal += this.getBestLapSplit(i, f).getSplitTime(i) * 10.0;
        }
        return ideal;
    }

    public DanasLap getBestLapSplit(int numeroSplit, DanasDataStructureConstants.SelectionFlag f) {
        DanasLap d = null;
        if (f.equals((Object)DanasDataStructureConstants.SelectionFlag.ALL)) {
            for (DanasSession ds : this.getSessions()) {
                if (d == null) {
                    d = ds.getBestLapSplit(numeroSplit, f);
                    continue;
                }
                if (d == null || ds.getBestLapSplit(numeroSplit, f) == null || !(ds.getBestLapSplit(numeroSplit, f).getSplitTime(numeroSplit) < d.getSplitTime(numeroSplit))) continue;
                d = ds.getBestLapSplit(numeroSplit, f);
            }
            return d;
        }
        if (f.equals((Object)DanasDataStructureConstants.SelectionFlag.SELECTED)) {
            for (DanasSession ds : this.getSessions()) {
                if (d == null && ds.isSelected()) {
                    d = ds.getBestLapSplit(numeroSplit, f);
                    continue;
                }
                if (d == null || ds.getBestLap(f) == null || !(ds.getBestLapSplit(numeroSplit, f).getSplitTime(numeroSplit) < d.getSplitTime(numeroSplit)) || !ds.isSelected()) continue;
                d = ds.getBestLapSplit(numeroSplit, f);
            }
            return d;
        }
        return null;
    }

    public double getAvgLap(DanasDataStructureConstants.SelectionFlag f) {
        double avgTime = 0.0;
        int c = 0;
        if (f.equals((Object)DanasDataStructureConstants.SelectionFlag.SELECTED)) {
            for (DanasSession dss : this.getSessions()) {
                if (!dss.isSelected()) continue;
                for (DanasLap dl : dss.getLaps()) {
                    if (!dl.getSelected()) continue;
                    ++c;
                    avgTime += dl.getDuration();
                }
            }
            return avgTime / (double)c;
        }
        avgTime = 0.0;
        c = 0;
        if (f.equals((Object)DanasDataStructureConstants.SelectionFlag.ALL)) {
            for (DanasSession dss : this.getSessions()) {
                for (DanasLap dl : dss.getLaps()) {
                    ++c;
                    avgTime += dl.getDuration();
                }
            }
            return avgTime / (double)c;
        }
        return -1.0;
    }

    public void forzaAggiornamentoSessionViewer() {
        gda.forzaAggiornamentoSess();
    }

    public void forzaAggiornamentoLapViewer() {
        gda.forzaAggiornamentoLap();
    }

    public void azzeraCanaliAnalizzatiGiri() {
        for (DanasSession s : this.getSessions()) {
            for (DanasLap l : s.getLaps()) {
                l.azzeraCanaliAnalizzati();
            }
        }
    }

    public void azzeraCanaliAnalizzatiGiriSessioni() {
        for (DanasSession s : this.getSessions()) {
            s.azzeraCanaliAnalizzati();
        }
    }

    public void setDefaultSettingsFile(String defaultSettingsFile) {
        this.DefaultSettingsFile = defaultSettingsFile;
    }

    public String getDefaultSettingsFile() {
        return this.DefaultSettingsFile;
    }

    public void setCircuitName(String circuitName) {
        this.CircuitName = circuitName;
    }

    public String getCircuitName() {
        return this.CircuitName;
    }

    public void setCircuitoImportato(Circuit c) {
        this.circuitoImportato = c;
    }

    public Circuit getCircuitoImportato() {
        return this.circuitoImportato;
    }

    public void setCircuitoNuovo(boolean nuovo) {
        this.circuitoNuovo = nuovo;
    }

    public boolean getCircuitoNuovo() {
        return this.circuitoNuovo;
    }

    public void setCircuitoDiverso(boolean diverso) {
        this.circuitoDiverso = diverso;
    }

    public boolean getCircuitoDiverso() {
        return this.circuitoDiverso;
    }

    public void setGPSOffset(int gPSOffset) {
        this.GPSOffset = gPSOffset;
    }

    public int getGPSOffset() {
        return this.GPSOffset;
    }

    public void saveDataStructure(File f, boolean onlySelected) {
        int best = Integer.MAX_VALUE;
        double distanza = 0.0;
        percentualeSalvataggio = 0;
        int valoriScritti = 0;
        this.interrompiSalvataggio = false;
        try {
            FileOutputStream fos = new FileOutputStream(f);
            PrintStream ps = new PrintStream(fos);
            Vector<Integer> elencoTipi = new Vector<Integer>();
            int tipoAttuale = 0;
            String tipoStringa = "$TIPO,";
            for (DanasSession danasSession : this.getSessions()) {
                int bestAttuale;
                DanasDataStructureConstants.FrequenzeDisponibili[] lap;
                if (onlySelected && !danasSession.isSelected()) continue;
                tipoAttuale = danasSession.getTipo();
                boolean presente = false;
                for (int i = 0; i < elencoTipi.size(); ++i) {
                    if ((Integer)elencoTipi.get(i) != tipoAttuale) continue;
                    presente = true;
                }
                if (!presente) {
                    elencoTipi.add(tipoAttuale);
                    tipoStringa = tipoStringa + danasSession.getTipo() + ",";
                }
                if ((lap = danasSession.getBestLap(DanasDataStructureConstants.SelectionFlag.ALL)) != null && (bestAttuale = (int)danasSession.getBestLap(DanasDataStructureConstants.SelectionFlag.ALL).getDuration()) < best) {
                    best = bestAttuale;
                }
                distanza += danasSession.getDistanceCovered(DanasDataStructureConstants.DataType.GPS);
            }
            if (elencoTipi.size() != 0) {
                ps.println(tipoStringa);
            }
            if (best != Integer.MAX_VALUE) {
                ps.println("$BEST," + MeasuresUtil.timeToHumanReadable(best) + ",");
            }
            if (distanza > 0.0) {
                ps.println("$DIST," + MeasuresUtil.valueToHumanReadableDouble(distanza / 1000.0, 2));
            }
            int numeroValori = 0;
            for (DanasSession s : this.getSessions()) {
                for (DanasDataStructureConstants.FrequenzeDisponibili frequenza : DanasDataStructureConstants.FrequenzeDisponibili.values()) {
                    DanasDataStructureConstants.ValueType primoCanaleFrequenza = null;
                    for (DanasDataStructureConstants.ValueType vt : DanasDataStructureConstants.ValueType.values()) {
                        if (!MeasuresUtil.isTipoDaSalvare(vt) || s.getFrequenzaCanale(vt) != frequenza.frequenza()) continue;
                        primoCanaleFrequenza = vt;
                        break;
                    }
                    if (primoCanaleFrequenza == null) continue;
                    numeroValori += s.getDimensioneCanale(primoCanaleFrequenza);
                }
            }
            for (DanasSession s : this.getSessions()) {
                if (this.interrompiSalvataggio) break;
                if (onlySelected && !s.isSelected()) continue;
                ps.println("$NEW SESSION");
                ps.println("$PILOTA," + s.getPilota() + ",");
                ps.println("$TIPO," + s.getTipo() + ",");
                ps.println(s.getStringaSettaggiCanali());
                ps.println(s.getStringaSettaggiBase());
                if (s.getDate() != null) {
                    ps.println("$DATE," + String.format("%02d%02d%02d", s.getDate().getDate(), s.getDate().getMonth() + 1, s.getDate().getYear() + 1900 - 2000));
                }
                if (s.hasVideo()) {
                    ps.println("$VIDEO," + s.getVideoFilename());
                    ps.println("$OFFSET_VIDEO," + s.getOffsetVideoSessione());
                }
                ps.println("$FUSO," + s.getFusoSessione());
                ps.println("$SESSION_COLOR," + String.format("%03d%03d%03d", s.getColor().getRed(), s.getColor().getGreen(), s.getColor().getBlue()));
                if (!s.getNotes().equals("")) {
                    String fnote = s.getNotes();
                    fnote = fnote.replace('$', ' ');
                    fnote = fnote.replace('\n', '#');
                    fnote = fnote.replace('\r', '#');
                    ps.println("$NOTE," + fnote);
                }
                String formula = "$FORMULE,";
                for (int i = 0; i < 10; ++i) {
                    formula = formula + s.getFormulaMath(i) + ";";
                }
                ps.println(formula);
                for (DanasDataStructureConstants.FrequenzeDisponibili frequenza : DanasDataStructureConstants.FrequenzeDisponibili.values()) {
                    String fraseCanali = s.getStringaCanaliAtFrequenza(frequenza.frequenza());
                    if (fraseCanali == null) continue;
                    ps.println(fraseCanali);
                }
                if (s.getFrequenzaCanale(DanasDataStructureConstants.ValueType.VEL_GPS) != 0.0) {
                    ArrayDouble latitudine = s.getAllValueData(DanasDataStructureConstants.ValueType.LAT, false);
                    ArrayDouble longitudine = s.getAllValueData(DanasDataStructureConstants.ValueType.LONG, false);
                    ArrayDouble vel = s.getAllValueData(DanasDataStructureConstants.ValueType.VEL_GPS, false);
                    ArrayDouble ora = s.getAllValueData(DanasDataStructureConstants.ValueType.GPS_TIME, false);
                    ArrayDouble altitudine = s.getAllValueData(DanasDataStructureConstants.ValueType.ALTITUDE, false);
                    double tempoIniziale = s.getTempoIniziale(DanasDataStructureConstants.ValueType.VEL_GPS);
                    double deltaT = 100.0 / s.getFrequenzaCanale(DanasDataStructureConstants.ValueType.VEL_GPS);
                    for (int i = 0; i < latitudine.size(); ++i) {
                        double tempo = tempoIniziale + (double)i * deltaT;
                        ps.println(MeasuresUtil.getFraseGps(latitudine.get(i), longitudine.get(i), vel.get(i), ora.get(i), altitudine.get(i), tempo));
                    }
                }
                block15: for (DanasDataStructureConstants.FrequenzeDisponibili frequenza : DanasDataStructureConstants.FrequenzeDisponibili.values()) {
                    DanasDataStructureConstants.ValueType primoCanaleFrequenza = null;
                    for (DanasDataStructureConstants.ValueType vt : DanasDataStructureConstants.ValueType.values()) {
                        if (!MeasuresUtil.isTipoDaSalvare(vt) || s.getFrequenzaCanale(vt) != frequenza.frequenza()) continue;
                        primoCanaleFrequenza = vt;
                        System.out.println("DEBUG: primo canale frequenza=" + (Object)((Object)primoCanaleFrequenza));
                        break;
                    }
                    if (primoCanaleFrequenza == null) continue;
                    double tempoIniziale = s.getTempoIniziale(primoCanaleFrequenza);
                    double deltaTempo = 100.0 / s.getFrequenzaCanale(primoCanaleFrequenza);
                    int dimensione = s.getDimensioneCanale(primoCanaleFrequenza);
                    for (int i = 0; i < dimensione; ++i) {
                        String frase = String.format("$VAL,%d,%.03f,", (int)frequenza.frequenza(), tempoIniziale + (double)i * deltaTempo);
                        for (DanasDataStructureConstants.ValueType vt : DanasDataStructureConstants.ValueType.values()) {
                            if (!MeasuresUtil.isTipoDaSalvare(vt) || s.getFrequenzaCanale(vt) != frequenza.frequenza()) continue;
                            try {
                                frase = frase + String.format("%.3f,", s.getAllValueData(vt, false).get(i));
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        ps.println(frase);
                        int attuale = 100 * ++valoriScritti / numeroValori;
                        if (attuale != percentualeSalvataggio) {
                            percentualeSalvataggio = attuale;
                        }
                        if (this.interrompiSalvataggio) continue block15;
                    }
                }
                for (DanasIRData irD : s.getAllIRData()) {
                    String vd = "$IR," + (int)irD.getTelemetry() + ",";
                    ps.println(vd);
                }
                if (!salvaGiriAutomatici) continue;
                for (DanasLap dL : s.getLaps()) {
                    ps.println("$IR," + (int)dL.getStart() + ",");
                }
                if (s.getLaps().size() == 0) continue;
                ps.println("$IR," + (int)s.getLap(s.getLaps().size()).getEnd() + ",");
            }
            try {
                percentualeSalvataggio = 100;
                ps.close();
                fos.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public Vector<Tracciato> getTracciatoSelected(DanasDataStructureConstants.ValueType vt, boolean mono) {
        Vector<Tracciato> tr = new Vector<Tracciato>();
        for (DanasSession s : this.DanasSessions) {
            if (!s.isSelected()) continue;
            tr.add(this.getTracciato(vt, s.getSessionID(), mono));
        }
        return tr;
    }

    public Vector<Tracciato> getTracciatoSelectedLap(int index) {
        int defId = -1;
        int defSess = -1;
        if (DanasDataStructure.getInstance().getDefaultLap() != null) {
            defId = DanasDataStructure.getInstance().getDefaultLap().getLapID();
            defSess = DanasDataStructure.getInstance().getDefaultLap().getSession().getSessionID();
        }
        Vector<Tracciato> tr = new Vector<Tracciato>();
        for (DanasSession s : this.DanasSessions) {
            if (!s.isSelected()) continue;
            for (DanasLap l : s.getLaps()) {
                if (!l.getSelected() || MeasuresUtil.getValueType(index) == DanasDataStructureConstants.ValueType.DELAY && defSess == s.getSessionID() && defId == l.getLapID()) continue;
                tr.add(this.getTracciatoLap(MeasuresUtil.getValueType(index), s.getSessionID(), l.getLapID()));
            }
        }
        return tr;
    }

    public Vector<Tracciato> getTracciatoSelected(int index) {
        Vector<Tracciato> tr = new Vector<Tracciato>();
        for (DanasSession s : this.DanasSessions) {
            if (!s.isSelected()) continue;
            tr.add(this.getTracciato(MeasuresUtil.getValueType(index), s.getSessionID(), true));
        }
        return tr;
    }

    public Tracciato getTracciato(DanasDataStructureConstants.ValueType vt, int sid, boolean mono) {
        Tracciato tr = null;
        DanasSession s = this.getSession(sid);
        double[] x = null;
        double[] y = null;
        double[] t = null;
        double[] val = null;
        Color col = null;
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        if (s == null) {
            return null;
        }
        if (s.getFrequenzaCanale(DanasDataStructureConstants.ValueType.VEL_GPS) == 0.0) {
            return null;
        }
        ArrayDouble gpsLon = s.getAllValueData(DanasDataStructureConstants.ValueType.LONG, false);
        ArrayDouble gpsLat = s.getAllValueData(DanasDataStructureConstants.ValueType.LAT, false);
        ArrayDouble valori = s.getAllValueDataFiltrati(vt, true);
        int dimensione = gpsLon.size();
        x = new double[dimensione];
        y = new double[dimensione];
        t = new double[dimensione];
        val = new double[dimensione];
        col = s.getColor();
        for (int i = 0; i < dimensione; ++i) {
            x[i] = gpsLat.get(i);
            y[i] = gpsLon.get(i);
            t[i] = s.getTempoIniziale(DanasDataStructureConstants.ValueType.VEL_GPS) + (double)(i * 100) / s.getFrequenzaCanale(DanasDataStructureConstants.ValueType.VEL_GPS);
            int indice = s.getIndiceAtTime(vt, t[i], DanasDataStructureConstants.BoundLap.NEAREST);
            val[i] = valori.get(indice);
            if (val[i] < min) {
                min = val[i];
            }
            if (!(val[i] > max)) continue;
            max = val[i];
        }
        tr = new Tracciato(x, y, t, val, (float)min, (float)max, col, mono, Integer.valueOf(s.getSessionID()).toString());
        return tr;
    }

    public Tracciato getTracciatoLap(DanasDataStructureConstants.ValueType vt, int sid, int lid) {
        Tracciato tr = null;
        DanasSession s = this.getSession(sid);
        DanasLap l = null;
        double[] x = null;
        double[] y = null;
        double[] t = null;
        double[] val = null;
        Color col = null;
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        if (s == null) {
            return null;
        }
        l = s.getLap(lid);
        if (vt == DanasDataStructureConstants.ValueType.DELAY) {
            l.calcolaRitardi();
        }
        ArrayDouble gpsLon = s.getAllValueData(DanasDataStructureConstants.ValueType.LONG, false);
        ArrayDouble gpsLat = s.getAllValueData(DanasDataStructureConstants.ValueType.LAT, false);
        ArrayDouble valori = s.getAllValueDataFiltrati(vt, true);
        int indiceStart = s.getIndiceAtTime(DanasDataStructureConstants.ValueType.VEL_GPS, l.getStart(), DanasDataStructureConstants.BoundLap.NEXT);
        int indiceStop = s.getIndiceAtTime(DanasDataStructureConstants.ValueType.VEL_GPS, l.getEnd(), DanasDataStructureConstants.BoundLap.PREVIOUS);
        int dimensione = indiceStop - indiceStart;
        if (dimensione <= 0) {
            return null;
        }
        x = new double[dimensione];
        y = new double[dimensione];
        t = new double[dimensione];
        val = new double[dimensione];
        col = l.getColor();
        for (int i = 0; i < dimensione; ++i) {
            x[i] = gpsLat.get(i + indiceStart);
            y[i] = gpsLon.get(i + indiceStart);
            t[i] = s.getTempoIniziale(DanasDataStructureConstants.ValueType.VEL_GPS) + (double)((i + indiceStart) * 100) / s.getFrequenzaCanale(DanasDataStructureConstants.ValueType.VEL_GPS);
            int indice = s.getIndiceAtTime(vt, t[i], DanasDataStructureConstants.BoundLap.NEAREST);
            if (indice < 0 || indice > valori.size() - 1) continue;
            val[i] = valori.get(indice);
            if (val[i] < min) {
                min = val[i];
            }
            if (!(val[i] > max)) continue;
            max = val[i];
        }
        tr = new Tracciato(x, y, t, val, (float)min, (float)max, col, true, Integer.valueOf(s.getSessionID()).toString() + "-" + Integer.valueOf(l.getLapID()).toString());
        return tr;
    }

    public Vector<CurvaIstogramma> getCurveSelectedSessionIstogramma(DanasDataStructureConstants.ValueType vtX, DanasDataStructureConstants.ValueType vtC, boolean autoX, double minX, double maxX, boolean condizione, double limBasso, double limAlto, int step, boolean escludi, double start, double stop, boolean segment) {
        Vector<CurvaIstogramma> curve = new Vector<CurvaIstogramma>();
        CurvaIstogramma curva = null;
        for (DanasSession s : this.DanasSessions) {
            if (!s.isSelected()) continue;
            curva = this.getCurvaIstogramma(vtX, vtC, autoX, minX, maxX, condizione, limBasso, limAlto, s.getSessionID(), 0, step, true, escludi, start, stop, segment);
            curva.setColore(s.getColor());
            curve.add(curva);
        }
        return curve;
    }

    public Vector<CurvaIstogramma> getCurveSelectedLapIstogramma(DanasDataStructureConstants.ValueType vtX, DanasDataStructureConstants.ValueType vtC, boolean autoX, double minX, double maxX, boolean condizione, double limBasso, double limAlto, int step, double start, double stop, boolean segment) {
        Vector<CurvaIstogramma> curve = new Vector<CurvaIstogramma>();
        CurvaIstogramma curva = null;
        for (DanasSession s : this.DanasSessions) {
            if (!s.isSelected()) continue;
            for (DanasLap l : s.getLaps()) {
                if (!l.getSelected()) continue;
                curva = this.getCurvaIstogramma(vtX, vtC, autoX, minX, maxX, condizione, limBasso, limAlto, s.getSessionID(), l.getLapID(), step, false, false, start, stop, segment);
                curva.setColore(l.getColor());
                curve.add(curva);
            }
        }
        return curve;
    }

    public CurvaIstogramma getCurvaIstogramma(DanasDataStructureConstants.ValueType vtX, DanasDataStructureConstants.ValueType vtC, boolean autoX, double minX, double maxX, boolean condizione, double limBasso, double limAlto, int sessId, int lapId, int step, boolean isSessione, boolean escludiEstremi, double start, double stop, boolean selezione) {
        DanasSession s = this.getSession(sessId);
        if (s == null) {
            return null;
        }
        double[] x = null;
        double[] c = null;
        double[] res = new double[step];
        double minimo = Double.MAX_VALUE;
        double massimo = Double.MIN_VALUE;
        for (int i = 0; i < res.length; ++i) {
            res[i] = 0.0;
        }
        if (isSessione && escludiEstremi && s.getLaps().size() > 2 && !selezione) {
            x = new double[]{};
            c = new double[]{};
            Vector<DanasLap> elencoGiri = s.getLaps();
            for (int i = 1; i < elencoGiri.size() - 1; ++i) {
                int lid = elencoGiri.get(i).getLapID();
                x = this.unisciArray(this.getArrayIstogramma(vtX, vtC, sessId, lid, false, 0.0, 0.0, false, condizione, limBasso, limAlto), x);
                c = this.unisciArray(this.getArrayIstogramma(vtC, vtC, sessId, lid, false, 0.0, 0.0, false, condizione, limBasso, limAlto), c);
            }
        } else {
            x = this.getArrayIstogramma(vtX, vtC, sessId, lapId, isSessione, start, stop, selezione, condizione, limBasso, limAlto);
            c = this.getArrayIstogramma(vtC, vtC, sessId, lapId, isSessione, start, stop, selezione, condizione, limBasso, limAlto);
        }
        if (x == null || x.length == 0) {
            return null;
        }
        for (int i = 0; i < x.length; ++i) {
            if (x[i] > massimo) {
                massimo = x[i];
            }
            if (!(x[i] < minimo)) continue;
            minimo = x[i];
        }
        if (!autoX) {
            minimo = minX;
            massimo = maxX;
        }
        double valoreStep = (massimo - minimo) / (double)step;
        for (int i = 0; i < x.length; ++i) {
            double differenza;
            int indice;
            if (!(x[i] > minimo) || (indice = (int)Math.abs((differenza = Math.abs(x[i] - minimo)) / valoreStep)) >= res.length) continue;
            res[indice] = res[indice] + 100.0 / (double)x.length;
        }
        CurvaIstogramma curva = new CurvaIstogramma(minimo, massimo, res, Color.red);
        return curva;
    }

    public double[] getArrayIstogramma(DanasDataStructureConstants.ValueType vt, DanasDataStructureConstants.ValueType vtC, int sid, int lid, boolean sessione, double start, double stop, boolean soloSelezione, boolean condizione, double limBasso, double limAlto) {
        List<Double> valori;
        DanasSession s = this.getSession(sid);
        if (s == null) {
            return null;
        }
        double[] x = null;
        double tempoInizio = 0.0;
        double tempoFine = Double.MAX_VALUE;
        if (sessione) {
            if (soloSelezione) {
                if (this.getMainFrame().getModoSpazio()) {
                    tempoInizio = s.getTimeAtSpazio(start, DanasDataStructureConstants.BoundLap.NEAREST);
                    tempoFine = s.getTimeAtSpazio(stop, DanasDataStructureConstants.BoundLap.NEAREST);
                } else {
                    tempoInizio = start + s.getStartTelemetryTime();
                    tempoFine = stop + s.getStartTelemetryTime();
                }
            }
        } else {
            DanasLap l = s.getLap(lid);
            if (soloSelezione) {
                if (this.getMainFrame().getModoSpazio()) {
                    tempoInizio = s.getTimeAtSpazio(start + l.getDistanzaInizio(), DanasDataStructureConstants.BoundLap.NEAREST);
                    tempoFine = s.getTimeAtSpazio(stop + l.getDistanzaInizio(), DanasDataStructureConstants.BoundLap.NEAREST);
                } else {
                    tempoInizio = start + l.getStart();
                    tempoFine = stop + l.getStart();
                }
            } else {
                tempoInizio = l.getStart();
                tempoFine = l.getEnd();
            }
        }
        if ((valori = s.getSelectionValueDataFiltrati(vt, tempoInizio, tempoFine, true)) == null || valori.size() == 0) {
            return null;
        }
        ArrayDouble valoriCondizione = s.getAllValueDataFiltrati(vtC, true);
        int indiceInizio = s.getIndiceAtTime(vt, tempoInizio, DanasDataStructureConstants.BoundLap.NEXT);
        double tempoInizioCanale = s.getTempoIniziale(vt);
        double frequenzaCanale = s.getFrequenzaCanale(vt);
        double frequenzaCondizione = s.getFrequenzaCanale(vtC);
        x = new double[valori.size()];
        for (int i = 0; i < valori.size(); ++i) {
            double tempo;
            double valoreCondizione;
            if (condizione && frequenzaCondizione != 0.0 && ((valoreCondizione = valoriCondizione.get(s.getIndiceAtTime(vtC, tempo = tempoInizioCanale + (double)(i + indiceInizio) * 100.0 / frequenzaCanale, DanasDataStructureConstants.BoundLap.NEAREST))) < limBasso || valoreCondizione > limAlto)) continue;
            x[i] = valori.get(i);
        }
        return x;
    }

    private double[] unisciArray(double[] x1, double[] x2) {
        int i;
        double[] res = new double[x1.length + x2.length];
        for (i = 0; i < x1.length; ++i) {
            res[i] = x1[i];
        }
        for (i = 0; i < x2.length; ++i) {
            res[i + x1.length] = x2[i];
        }
        return res;
    }

    public Vector<CurvaXY> getCurvaSelectedLapXY(DanasDataStructureConstants.ValueType vtX, DanasDataStructureConstants.ValueType vtY, DanasDataStructureConstants.ValueType vtZ, int riduzione, boolean monocolore) {
        Vector<CurvaXY> cr = new Vector<CurvaXY>();
        CurvaXY curvaXY = null;
        for (DanasSession s : this.DanasSessions) {
            if (!s.isSelected()) continue;
            for (DanasLap l : s.getLaps()) {
                if (!l.getSelected() || (curvaXY = this.getCurvaLapXY(vtX, vtY, vtZ, s.getSessionID(), l.getLapID(), riduzione, monocolore)) == null) continue;
                cr.add(curvaXY);
            }
        }
        return cr;
    }

    public Vector<Curva> getCurvaSelectedFFT(DanasDataStructureConstants.ValueType vt) {
        Vector<Curva> cr = new Vector<Curva>();
        Curva curva = null;
        for (DanasSession s : this.DanasSessions) {
            if (!s.isSelected() || (curva = this.getCurvaFFT(vt, s.getSessionID())) == null) continue;
            cr.add(curva);
        }
        return cr;
    }

    public Vector<Curva> getCurvaSelected(DanasDataStructureConstants.ValueType vt) {
        Vector<Curva> cr = new Vector<Curva>();
        Curva curva = null;
        for (DanasSession s : this.DanasSessions) {
            if (!s.isSelected() || (curva = this.getMainFrame().getFftMode() ? this.getCurvaFFT(vt, s.getSessionID()) : this.getCurva(vt, s.getSessionID())) == null) continue;
            cr.add(curva);
        }
        return cr;
    }

    public Vector<Curva> getCurvaSelectedLap(DanasDataStructureConstants.ValueType vt) {
        Vector<Curva> cr = new Vector<Curva>();
        Curva curva = null;
        for (DanasSession s : this.DanasSessions) {
            if (!s.isSelected()) continue;
            for (DanasLap l : s.getLaps()) {
                if (!l.getSelected() || (curva = this.getMainFrame().getFftMode() ? this.getCurvaLapFFT(vt, s.getSessionID(), l.getLapID()) : this.getCurvaLap(vt, s.getSessionID(), l.getLapID())) == null) continue;
                cr.add(curva);
            }
        }
        return cr;
    }

    public static double log2(int n) {
        return Math.log(n) / Math.log(2.0);
    }

    public Curva getCurvaFFT(DanasDataStructureConstants.ValueType vt, int sid) {
        int dimensione;
        int indiceStart;
        int indiceStop;
        DanasSession s = this.getSession(sid);
        if (s == null) {
            return null;
        }
        if (vt == DanasDataStructureConstants.ValueType.DELAY) {
            s.calcolaRitardiGiri();
        }
        double[] val = null;
        double[] x = null;
        double[] t = null;
        double[] p = null;
        double[] out = null;
        boolean[] usa = null;
        Color col = null;
        col = s.getColor();
        ArrayDouble valori = s.getAllValueDataFiltrati(vt, true);
        if (valori == null || valori.size() == 0) {
            return null;
        }
        if (!DanasDataStructure.getInstance().getMainFrame().getFftSelezione()) {
            indiceStop = valori.size() - 1;
            indiceStart = 0;
        } else {
            double stop;
            double start;
            if (DanasDataStructure.getInstance().getMainFrame().getContenitoreGrafico().getModoSpazio()) {
                double spazio_1 = DanasDataStructure.getInstance().getMainFrame().getFftStart();
                double spazio_2 = DanasDataStructure.getInstance().getMainFrame().getFftStop();
                start = s.getTimeAtSpazio(spazio_1, DanasDataStructureConstants.BoundLap.NEAREST);
                stop = s.getTimeAtSpazio(spazio_2, DanasDataStructureConstants.BoundLap.NEAREST);
            } else {
                start = DanasDataStructure.getInstance().getMainFrame().getFftStart() + s.getStartTelemetryTime();
                stop = DanasDataStructure.getInstance().getMainFrame().getFftStop() + s.getStartTelemetryTime();
            }
            indiceStop = s.getIndiceAtTime(vt, stop, DanasDataStructureConstants.BoundLap.PREVIOUS);
            indiceStart = s.getIndiceAtTime(vt, start, DanasDataStructureConstants.BoundLap.NEXT);
        }
        if (indiceStop < indiceStart) {
            int c = indiceStop;
            indiceStop = indiceStart;
            indiceStart = c;
        }
        if ((dimensione = indiceStop - indiceStart) <= 0) {
            return null;
        }
        int numeroPunti = dimensione;
        val = new double[numeroPunti];
        for (int i = 0; i < numeroPunti; ++i) {
            val[i] = valori.get(i + indiceStart);
        }
        double[] fft = Interpolatore.Complex.absFFT(val);
        double logaritmo = DanasDataStructure.log2(numeroPunti);
        int base2 = (int)logaritmo;
        int numeroPuntiOut = (int)Math.pow(2.0, base2 + 1);
        x = new double[numeroPuntiOut / 2];
        out = new double[x.length];
        t = new double[x.length];
        p = new double[x.length];
        usa = new boolean[x.length];
        for (int i = 0; i < numeroPuntiOut / 2; ++i) {
            out[i] = fft[i];
            t[i] = (double)i / (double)numeroPuntiOut * s.getFrequenzaCanale(vt);
            x[i] = t[i];
            p[i] = 0.0;
            usa[i] = false;
            if (!(t[i] >= 15.0) || !(t[i] <= 15.5)) continue;
            System.out.println("DEBUG: FFT a 15 Hz =" + out[i] + " f=" + t[i] + " --------------------------------");
        }
        String name = Integer.valueOf(s.getSessionID()).toString();
        if (x.length == 0) {
            System.out.println("Ritornato null per sessione (FFT):" + s.getSessionID());
            return null;
        }
        return new Curva(x, t, out, col, name, p, usa, Double.MAX_VALUE, Double.MIN_VALUE);
    }

    public Curva getCurva(DanasDataStructureConstants.ValueType vt, int sid) {
        DanasSession s = this.getSession(sid);
        if (s == null) {
            return null;
        }
        if (vt == DanasDataStructureConstants.ValueType.DELAY) {
            s.calcolaRitardiGiri();
        }
        double[] val = null;
        double[] x = null;
        double[] t = null;
        double[] p = null;
        boolean[] usa = null;
        Color col = null;
        double firstT = 0.0;
        col = s.getColor();
        ArrayDouble valori = s.getAllValueDataFiltrati(vt, true);
        if (valori == null || valori.size() == 0) {
            return null;
        }
        List<Double> spazi = s.getValoriSpazio();
        x = new double[valori.size()];
        t = new double[x.length];
        val = new double[x.length];
        p = new double[x.length];
        usa = new boolean[x.length];
        firstT = s.getTempoPrimoDato();
        int indiceInizio = s.getIndexSpazioTempoInizio(vt);
        int indice = 0;
        for (int i = 0; i < valori.size(); ++i) {
            val[i] = valori.get(i);
            t[i] = s.getTempoIniziale(vt) + (double)i * 100.0 / s.getFrequenzaCanale(vt) - firstT;
            indice = indiceInizio + i * (int)(100.0 / s.getRisoluzioneTemporale() / s.getFrequenzaCanale(vt));
            x[i] = spazi.get(indice);
            p[i] = s.getPosizioneStechioAtTime(t[i] + firstT, DanasDataStructureConstants.BoundLap.NEAREST);
            usa[i] = s.getUsaInStechioAtTime(t[i] + firstT, DanasDataStructureConstants.BoundLap.NEAREST);
        }
        String name = Integer.valueOf(s.getSessionID()).toString();
        if (x.length == 0) {
            System.out.println("Ritornato null per sessione:" + s.getSessionID());
            return null;
        }
        int modoAttuale = DanasDataStructure.getInstance().getMainFrame().getModoAttuale();
        return new Curva(x, t, val, col, name, p, usa, DanasPreferences.getAlarmHi(vt, modoAttuale), DanasPreferences.getAlarmLow(vt, modoAttuale));
    }

    public void setNomiMulti() {
        this.nomiMulti = new String[10];
        this.nomiMulti[0] = Language.string("T.Acqua");
        this.nomiMulti[1] = Language.string("Olio");
        this.nomiMulti[2] = Language.string("V.Batteria");
        if (this.getDefaultSession() == null) {
            this.nomiMulti[3] = "Vuoto4";
            this.nomiMulti[4] = "Vuoto5";
            this.nomiMulti[5] = "Vuoto6";
            this.nomiMulti[6] = "Vuoto7";
            this.nomiMulti[7] = "Vuoto8";
            this.nomiMulti[8] = "Vuoto9";
            this.nomiMulti[9] = "Vuoto10";
            return;
        }
        int moto = this.getDefaultSession().getSessionSettings().getTipoMoto();
        for (int i = 0; i < 10; ++i) {
            this.nomiMulti[i] = this.getNomeMulti(moto, i);
        }
    }

    public String getNomeMulti(int indice) {
        return this.nomiMulti[indice];
    }

    public String getNomeTipo(DanasDataStructureConstants.ValueType vt) {
        if (DanasDataStructure.getInstance().getDefaultSession() == null) {
            return vt.toString();
        }
        return DanasDataStructure.getInstance().getDefaultSession().getSessionSettings().getNome(vt);
    }

    public String getNomeMulti(int moto, int indice) {
        String nome = "vuoto";
        if (indice == 0) {
            switch (moto) {
                case 58: 
                case 59: 
                case 71: 
                case 78: 
                case 91: 
                case 99: {
                    return Language.string("WTS");
                }
            }
            return Language.string("T.Acqua");
        }
        if (indice == 1) {
            switch (moto) {
                case 46: {
                    return Language.string("Vuoto");
                }
                case 47: 
                case 68: {
                    return Language.string("Set-1");
                }
                case 58: {
                    return Language.string("YTS");
                }
                case 78: {
                    return Language.string("Oil P.");
                }
                case 77: {
                    return Language.string("P. Oil");
                }
                case 71: 
                case 91: 
                case 99: {
                    return Language.string("T. Oil");
                }
                case 15: 
                case 16: 
                case 19: 
                case 20: 
                case 43: 
                case 76: 
                case 106: 
                case 107: 
                case 108: {
                    return Language.string("Vuoto");
                }
            }
            return Language.string("Olio");
        }
        if (indice == 2) {
            switch (moto) {
                case 46: {
                    return Language.string("Vuoto");
                }
            }
            return Language.string("V.Batteria");
        }
        if (indice == 3) {
            switch (moto) {
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 29: 
                case 38: 
                case 39: 
                case 43: 
                case 44: 
                case 45: 
                case 47: 
                case 51: 
                case 55: 
                case 57: 
                case 59: 
                case 61: 
                case 63: 
                case 68: 
                case 69: 
                case 72: 
                case 73: 
                case 76: 
                case 77: 
                case 78: 
                case 81: 
                case 82: 
                case 85: 
                case 87: 
                case 88: 
                case 92: 
                case 93: 
                case 94: 
                case 95: 
                case 96: 
                case 97: 
                case 98: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: {
                    nome = Language.string("T.Aria");
                    break;
                }
                case 84: 
                case 90: 
                case 101: 
                case 114: {
                    return Language.string("Power Mode");
                }
                case 46: {
                    nome = Language.string("Throttle1");
                    break;
                }
                case 37: {
                    nome = Language.string("TPS2");
                    break;
                }
                case 115: {
                    nome = Language.string("Riding");
                    break;
                }
                case 49: 
                case 71: 
                case 91: 
                case 99: {
                    nome = Language.string("T.Aria");
                    break;
                }
                case 58: {
                    nome = Language.string("Strategy Active F.");
                    break;
                }
                case 60: {
                    nome = Language.string("Errori");
                    break;
                }
                case 66: {
                    nome = Language.string("P");
                    break;
                }
                case 70: {
                    nome = Language.string("Temp Aria");
                    break;
                }
                case 89: {
                    nome = Language.string("Temp Olio");
                    break;
                }
                default: {
                    nome = Language.string("Vuoto") + indice;
                }
            }
        }
        if (indice == 4) {
            switch (moto) {
                case 14: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 29: 
                case 38: 
                case 39: 
                case 40: 
                case 43: 
                case 51: 
                case 56: 
                case 57: 
                case 64: 
                case 69: 
                case 75: 
                case 76: 
                case 77: 
                case 82: 
                case 100: 
                case 102: 
                case 106: 
                case 107: 
                case 108: {
                    nome = "TC level";
                    break;
                }
                case 61: 
                case 85: 
                case 87: 
                case 88: 
                case 92: 
                case 93: 
                case 97: 
                case 98: 
                case 104: 
                case 105: 
                case 117: 
                case 118: 
                case 119: 
                case 120: {
                    nome = "DTC level";
                    break;
                }
                case 84: 
                case 90: 
                case 101: 
                case 114: {
                    return Language.string("EB Mode");
                }
                case 44: 
                case 45: 
                case 63: 
                case 72: 
                case 73: 
                case 81: {
                    nome = "Set 1";
                    break;
                }
                case 116: {
                    nome = "Mode";
                    break;
                }
                case 115: {
                    nome = Language.string("KTRC");
                    break;
                }
                case 55: {
                    nome = "MAP";
                    break;
                }
                case 46: {
                    nome = Language.string("Gear Force");
                    break;
                }
                case 37: {
                    nome = Language.string("Distance ECU");
                    break;
                }
                case 47: 
                case 68: 
                case 94: 
                case 95: {
                    nome = "S-KTRC/Power";
                    break;
                }
                case 49: {
                    nome = "Work mode";
                    break;
                }
                case 58: {
                    nome = "TC Trimmer";
                    break;
                }
                case 59: 
                case 71: 
                case 78: 
                case 91: 
                case 99: {
                    nome = "BAP";
                    break;
                }
                case 66: {
                    nome = "EB";
                    break;
                }
                case 70: {
                    nome = Language.string("Errori");
                    break;
                }
                case 89: {
                    nome = Language.string("Temp Airbox");
                    break;
                }
                default: {
                    nome = Language.string("Vuoto") + indice;
                }
            }
        }
        if (indice == 5) {
            switch (moto) {
                case 14: 
                case 15: 
                case 16: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 43: 
                case 69: 
                case 76: 
                case 106: 
                case 107: 
                case 108: {
                    nome = "Power map";
                    break;
                }
                case 115: {
                    nome = Language.string("PWR");
                    break;
                }
                case 29: 
                case 38: 
                case 39: 
                case 40: 
                case 51: 
                case 56: 
                case 57: 
                case 61: 
                case 64: 
                case 75: 
                case 82: 
                case 85: 
                case 87: 
                case 88: 
                case 92: 
                case 93: 
                case 97: 
                case 98: 
                case 104: 
                case 105: 
                case 117: 
                case 118: 
                case 119: 
                case 120: {
                    nome = "Map";
                    break;
                }
                case 94: 
                case 95: 
                case 100: 
                case 102: {
                    nome = "Riding Mode";
                    break;
                }
                case 84: 
                case 90: 
                case 101: 
                case 114: {
                    return Language.string("TC Mode");
                }
                case 44: 
                case 45: 
                case 63: 
                case 72: 
                case 73: 
                case 81: {
                    nome = "Set 2";
                    break;
                }
                case 116: {
                    nome = "PWR";
                    break;
                }
                case 55: {
                    nome = "TC level";
                    break;
                }
                case 77: {
                    nome = "WC Level";
                    break;
                }
                case 37: 
                case 46: {
                    nome = "Map pos";
                    break;
                }
                case 68: {
                    nome = "Fuel Sensor";
                    break;
                }
                case 47: {
                    nome = "KQS Sensor";
                    break;
                }
                case 49: {
                    nome = "Gear";
                    break;
                }
                case 58: {
                    nome = "DTC Present";
                    break;
                }
                case 78: {
                    nome = "TC Trim";
                    break;
                }
                case 66: {
                    nome = "TC";
                    break;
                }
                case 71: 
                case 91: 
                case 99: {
                    nome = "MAP";
                    break;
                }
                case 70: {
                    nome = Language.string("Total Running");
                    break;
                }
                default: {
                    nome = Language.string("Vuoto") + indice;
                }
            }
        }
        if (indice == 6) {
            switch (moto) {
                case 14: 
                case 15: 
                case 16: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 29: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 51: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 61: 
                case 63: 
                case 64: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 72: 
                case 73: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 81: 
                case 82: 
                case 84: 
                case 85: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 92: 
                case 93: 
                case 94: 
                case 95: 
                case 96: 
                case 97: 
                case 98: 
                case 100: 
                case 101: 
                case 102: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: {
                    nome = Language.string("Marce can");
                    break;
                }
                case 49: {
                    nome = Language.string("Temp Ex1");
                    break;
                }
                case 60: 
                case 71: 
                case 91: 
                case 99: {
                    nome = Language.string("Marce");
                    break;
                }
                case 70: {
                    nome = Language.string("Marce");
                    break;
                }
                default: {
                    nome = Language.string("Vuoto") + indice;
                }
            }
        }
        if (indice == 7) {
            switch (moto) {
                case 15: 
                case 16: 
                case 19: 
                case 20: 
                case 43: 
                case 66: 
                case 76: 
                case 108: {
                    nome = Language.string("Angle");
                    break;
                }
                case 22: {
                    nome = "Pit";
                    break;
                }
                case 77: {
                    nome = "WorkMode";
                    break;
                }
                case 72: 
                case 81: 
                case 116: {
                    nome = "EBM";
                    break;
                }
                case 37: 
                case 46: {
                    nome = "Aim Slip";
                    break;
                }
                case 78: {
                    nome = "Oil temperature";
                    break;
                }
                case 61: 
                case 85: 
                case 87: 
                case 88: 
                case 92: 
                case 93: 
                case 97: 
                case 98: 
                case 104: 
                case 105: 
                case 117: 
                case 118: 
                case 119: 
                case 120: {
                    nome = "DWC level";
                    break;
                }
                case 94: 
                case 95: {
                    nome = "KLCM-KEBC-KQS";
                    break;
                }
                case 47: 
                case 68: {
                    nome = "KEBC";
                    break;
                }
                case 84: 
                case 90: 
                case 101: 
                case 114: {
                    return Language.string("Wheelie Mode");
                }
                case 100: 
                case 102: {
                    nome = "AWC level";
                    break;
                }
                case 71: 
                case 91: {
                    nome = "Drop off";
                    break;
                }
                case 49: {
                    nome = Language.string("Temp Ex2");
                    break;
                }
                case 58: {
                    nome = "Eng State";
                    break;
                }
                case 89: {
                    nome = Language.string("Fuel used");
                    break;
                }
                default: {
                    nome = Language.string("Vuoto") + indice;
                }
            }
        }
        if (indice == 8) {
            switch (moto) {
                case 15: 
                case 16: 
                case 19: 
                case 20: {
                    nome = Language.string("APS");
                    break;
                }
                case 22: {
                    nome = Language.string("Angle");
                    break;
                }
                case 38: 
                case 39: 
                case 40: 
                case 51: 
                case 56: 
                case 64: 
                case 75: 
                case 82: {
                    nome = Language.string("TPS1");
                    break;
                }
                case 84: 
                case 90: 
                case 101: 
                case 114: {
                    return Language.string("DTC");
                }
                case 94: 
                case 95: {
                    nome = "Lean Angle";
                    break;
                }
                case 61: 
                case 85: 
                case 87: 
                case 88: 
                case 93: 
                case 97: 
                case 98: 
                case 104: 
                case 105: 
                case 117: 
                case 118: 
                case 119: 
                case 120: {
                    nome = "DSC level";
                    break;
                }
                case 92: {
                    nome = Language.string("Vuoto") + indice;
                    break;
                }
                case 46: {
                    nome = Language.string("Throttle2");
                    break;
                }
                case 37: {
                    nome = "Aim Servo";
                    break;
                }
                case 47: 
                case 68: {
                    nome = "Lean Angle";
                    break;
                }
                case 49: {
                    nome = Language.string("Temp Ex3");
                    break;
                }
                case 58: {
                    nome = "Workmode active";
                    break;
                }
                case 66: {
                    nome = "DTC";
                    break;
                }
                case 71: 
                case 91: 
                case 99: {
                    nome = "Drum pos";
                    break;
                }
                case 45: 
                case 63: 
                case 72: 
                case 73: 
                case 81: {
                    nome = "IMU Angle";
                    break;
                }
                case 116: {
                    nome = "TCS";
                    break;
                }
                case 89: {
                    nome = Language.string("Versione");
                    break;
                }
                default: {
                    nome = Language.string("Vuoto") + indice;
                }
            }
        }
        if (indice == 9) {
            switch (moto) {
                case 38: 
                case 39: 
                case 40: 
                case 51: 
                case 56: 
                case 64: 
                case 75: 
                case 82: {
                    nome = Language.string("TPS2");
                    break;
                }
                case 37: 
                case 46: {
                    nome = "TC Disable";
                    break;
                }
                case 61: 
                case 85: 
                case 87: 
                case 88: 
                case 92: 
                case 93: 
                case 97: 
                case 98: 
                case 104: 
                case 105: 
                case 117: 
                case 118: 
                case 119: 
                case 120: {
                    nome = "EBC";
                    break;
                }
                case 47: 
                case 68: {
                    nome = "Wheelie Angle";
                    break;
                }
                case 49: {
                    nome = Language.string("Temp Ex4");
                    break;
                }
                case 58: {
                    nome = Language.string("DBW State");
                    break;
                }
                case 59: 
                case 71: 
                case 78: 
                case 91: 
                case 99: {
                    nome = Language.string("WorkMode");
                    break;
                }
                case 44: 
                case 45: 
                case 55: 
                case 63: 
                case 72: 
                case 73: 
                case 81: {
                    nome = "Fuel sensor";
                    break;
                }
                case 116: {
                    nome = "SCS";
                    break;
                }
                default: {
                    nome = Language.string("Vuoto") + indice;
                }
            }
        }
        return nome;
    }

    public double getValoreCanaleMulti(int canaleSelezionato, int tipoMoto, double val) {
        double valore = val;
        if (canaleSelezionato == 0) {
            valore = MeasuresUtil.getTemperatura(val - 60.0);
        }
        if (canaleSelezionato == 2) {
            valore = val / 10.0;
        }
        switch (tipoMoto) {
            case 14: 
            case 22: 
            case 69: {
                if (canaleSelezionato == 8) {
                    valore = (val - 512.0) / 50.0 * 16.0;
                }
                if (canaleSelezionato != 3) break;
                valore = MeasuresUtil.getTemperatura(val - 60.0);
                break;
            }
            case 46: {
                if (canaleSelezionato == 3) {
                    valore = val / 10.0;
                }
                if (canaleSelezionato == 4) {
                    valore = (val - 512.0) * 16.0 / 10.0;
                }
                if (canaleSelezionato == 7) {
                    valore = val / 10.0;
                }
                if (canaleSelezionato != 8) break;
                valore = val / 10.0;
                break;
            }
            case 37: {
                if (canaleSelezionato == 3) {
                    valore = val / 10.0;
                }
                if (canaleSelezionato == 1) {
                    valore = val / 10.0;
                }
                if (canaleSelezionato == 4) {
                    valore = val * 8.0;
                }
                if (canaleSelezionato == 7) {
                    valore = val / 10.0;
                }
                if (canaleSelezionato != 8) break;
                valore = val / 10.0;
                break;
            }
            case 38: 
            case 39: 
            case 51: 
            case 82: {
                if (canaleSelezionato == 7 || canaleSelezionato == 8 || canaleSelezionato == 9) {
                    valore = val / 2.0;
                }
                if (canaleSelezionato != 3) break;
                valore = MeasuresUtil.getTemperatura(val - 60.0);
                break;
            }
            case 40: 
            case 56: 
            case 64: 
            case 75: {
                if (canaleSelezionato == 8 || canaleSelezionato == 9) {
                    valore = val / 10.0;
                }
                if (canaleSelezionato != 3) break;
                valore = MeasuresUtil.getTemperatura(val - 60.0);
                break;
            }
            case 100: 
            case 102: {
                if (canaleSelezionato == 3) {
                    valore = MeasuresUtil.getTemperatura(val - 60.0);
                }
                if (canaleSelezionato != 8) break;
                valore = val * 0.35156224 - 180.0;
                break;
            }
            case 44: 
            case 45: 
            case 63: 
            case 72: 
            case 73: 
            case 81: {
                int res;
                int raw;
                if (canaleSelezionato == 0) {
                    valore = MeasuresUtil.getTemperatura(val * 0.625 - 30.0);
                }
                if (canaleSelezionato == 3) {
                    valore = MeasuresUtil.getTemperatura(val * 0.625 - 30.0);
                }
                if (canaleSelezionato == 4) {
                    raw = (int)val;
                    res = (raw & 3) + (raw & 0x3C) / 4 * 10 + ((raw & 0xC0) / 64 + 1) * 100 + ((raw & 0x300) / 256 + 1) * 1000;
                    valore = res;
                }
                if (canaleSelezionato == 5) {
                    raw = (int)val;
                    res = (raw & 0xF) + (raw & 0x30) / 16 * 1000 + (raw & 0xC0) / 64 * 10 + (raw & 0x300) / 256 * 100;
                    valore = res;
                }
                if (canaleSelezionato == 6 && (tipoMoto == 63 || tipoMoto == 72 || tipoMoto == 81) && valore >= 16.0) {
                    valore -= 16.0;
                }
                if (canaleSelezionato == 8) {
                    valore = val * 0.32 - 90.0;
                }
                if (canaleSelezionato != 9) break;
                valore = val;
                break;
            }
            case 55: {
                if (canaleSelezionato == 0) {
                    valore = MeasuresUtil.getTemperatura(val * 0.625 - 30.0);
                }
                if (canaleSelezionato != 3) break;
                valore = MeasuresUtil.getTemperatura(val * 0.625 - 30.0);
                break;
            }
            case 47: 
            case 68: {
                if (canaleSelezionato == 3) {
                    valore = MeasuresUtil.getTemperatura(val - 60.0);
                }
                if (canaleSelezionato == 4) {
                    valore = val / 10.0;
                }
                if (canaleSelezionato == 5) {
                    valore = val / 1023.0 * 5.0;
                }
                if (canaleSelezionato == 7) {
                    valore = val / 10.0;
                }
                if (canaleSelezionato == 8) {
                    valore = (val - 512.0) / 1024.0 * 200.0;
                }
                if (canaleSelezionato != 9) break;
                valore = val / 1024.0 * 100.0;
                break;
            }
            case 94: 
            case 95: {
                if (canaleSelezionato == 3) {
                    valore = MeasuresUtil.getTemperatura(val - 60.0);
                }
                if (canaleSelezionato != 8) break;
                valore = (val - 512.0) / 1024.0 * 200.0;
                break;
            }
            case 49: {
                if (canaleSelezionato == 1) {
                    valore = val / 100.0;
                }
                if (canaleSelezionato == 3) {
                    valore = MeasuresUtil.getTemperatura(val - 60.0);
                }
                if (canaleSelezionato == 6) {
                    valore = MeasuresUtil.getTemperatura(val);
                }
                if (canaleSelezionato == 7) {
                    valore = MeasuresUtil.getTemperatura(val);
                }
                if (canaleSelezionato == 8) {
                    valore = MeasuresUtil.getTemperatura(val);
                }
                if (canaleSelezionato != 9) break;
                valore = MeasuresUtil.getTemperatura(val);
                break;
            }
            case 71: 
            case 91: 
            case 99: {
                if (canaleSelezionato == 0) {
                    valore = MeasuresUtil.getTemperatura(val - 60.0);
                }
                if (canaleSelezionato == 1) {
                    valore = MeasuresUtil.getTemperatura(val - 60.0);
                }
                if (canaleSelezionato == 2) {
                    valore = val / 10.0;
                }
                if (canaleSelezionato == 3) {
                    valore = MeasuresUtil.getTemperatura(val - 60.0);
                }
                if (canaleSelezionato == 4) {
                    valore = val + 512.0;
                }
                if (canaleSelezionato == 5) {
                    valore = val + 100.0;
                }
                if (canaleSelezionato == 6) {
                    valore = val;
                }
                if (canaleSelezionato == 7) {
                    valore = val;
                }
                if (canaleSelezionato == 8) {
                    valore = val / 1024.0 * 5.0;
                }
                if (canaleSelezionato != 9) break;
                valore = val;
                break;
            }
            case 57: {
                if (canaleSelezionato != 3) break;
                valore = MeasuresUtil.getTemperatura(val - 60.0);
                break;
            }
            case 89: {
                if (canaleSelezionato == 3) {
                    valore = 0.8 * val;
                }
                if (canaleSelezionato == 4) {
                    valore = 0.8 * val;
                }
                if (canaleSelezionato != 7) break;
                valore = 0.08 * val;
                break;
            }
            case 84: 
            case 90: 
            case 101: 
            case 114: {
                break;
            }
            case 58: {
                if (canaleSelezionato == 0) {
                    valore = MeasuresUtil.getTemperatura(val - 60.0);
                }
                if (canaleSelezionato != 1) break;
                valore = MeasuresUtil.getTemperatura(val / 5.0);
                break;
            }
            case 60: {
                if (canaleSelezionato == 3) {
                    valore = val;
                }
                if (canaleSelezionato != 6) break;
                valore = val;
                break;
            }
            case 115: {
                if (canaleSelezionato == 3) {
                    valore = val;
                }
                if (canaleSelezionato == 4) {
                    valore = val;
                }
                if (canaleSelezionato == 5) {
                    valore = val;
                }
                if (canaleSelezionato != 6) break;
                valore = val;
                break;
            }
            case 61: 
            case 85: 
            case 87: 
            case 88: 
            case 92: 
            case 93: 
            case 97: 
            case 98: 
            case 104: 
            case 105: 
            case 117: 
            case 118: 
            case 119: 
            case 120: {
                if (canaleSelezionato == 0) {
                    valore = MeasuresUtil.getTemperatura(val - 60.0);
                }
                if (canaleSelezionato == 2) {
                    valore = val / 10.0;
                }
                if (canaleSelezionato != 3) break;
                valore = MeasuresUtil.getTemperatura(val - 60.0);
                break;
            }
            case 66: {
                if (canaleSelezionato == 0) {
                    valore = MeasuresUtil.getTemperatura(val - 60.0);
                }
                if (canaleSelezionato == 2) {
                    valore = val / 10.0;
                }
                if (canaleSelezionato == 3) {
                    valore = val;
                }
                if (canaleSelezionato == 7) {
                    valore = -(val / 2.0 - 90.0);
                }
                if (canaleSelezionato != 8) break;
                valore = val;
                break;
            }
            case 70: 
            case 96: {
                if (canaleSelezionato == 0) {
                    valore = MeasuresUtil.getTemperatura(val - 60.0);
                }
                if (canaleSelezionato == 2) {
                    valore = val / 10.0;
                }
                if (canaleSelezionato != 3) break;
                valore = MeasuresUtil.getTemperatura(0.625 * val - 30.0);
                break;
            }
            case 77: {
                if (canaleSelezionato == 0) {
                    valore = MeasuresUtil.getTemperatura(val - 60.0);
                }
                if (canaleSelezionato == 1) {
                    valore = val / 100.0;
                }
                if (canaleSelezionato == 2) {
                    valore = val / 10.0;
                }
                if (canaleSelezionato == 3) {
                    valore = MeasuresUtil.getTemperatura(val - 60.0);
                }
                if (canaleSelezionato == 4) {
                    valore = val - 20.0;
                }
                if (canaleSelezionato == 5) {
                    valore = val - 20.0;
                }
                if (canaleSelezionato == 6) {
                    valore = val;
                }
                if (canaleSelezionato != 7) break;
                valore = val;
                break;
            }
            case 59: 
            case 78: {
                if (canaleSelezionato == 0) {
                    valore = MeasuresUtil.getTemperatura(val - 60.0);
                }
                if (canaleSelezionato == 1) {
                    valore = val / 100.0;
                }
                if (canaleSelezionato == 2) {
                    valore = val / 10.0;
                }
                if (canaleSelezionato == 3) {
                    valore = MeasuresUtil.getTemperatura(val - 60.0);
                }
                if (canaleSelezionato == 4) {
                    valore = val - 20.0;
                }
                if (canaleSelezionato == 5) {
                    valore = val;
                }
                if (canaleSelezionato == 6) {
                    valore = val + 500.0;
                }
                if (canaleSelezionato == 7) {
                    valore = MeasuresUtil.getTemperatura(val / 5.0 - 40.0);
                }
                if (canaleSelezionato != 9) break;
                valore = val;
                break;
            }
            case 76: 
            case 106: 
            case 107: {
                if (canaleSelezionato == 3) {
                    valore = MeasuresUtil.getTemperatura(val - 60.0);
                }
                if (canaleSelezionato != 7) break;
                valore = (val - 128.0) / 1.94;
                break;
            }
            default: {
                if (canaleSelezionato == 3) {
                    valore = MeasuresUtil.getTemperatura(val - 60.0);
                }
                if (canaleSelezionato == 7) {
                    valore = (val - 32768.0) / 364.0;
                }
                if (canaleSelezionato != 8) break;
                valore = val / 2.55;
            }
        }
        return valore;
    }

    public DanasLap getfirstLapSelected() {
        for (DanasSession s : this.DanasSessions) {
            if (!s.isSelected()) continue;
            for (DanasLap l : s.getLaps()) {
                if (!l.getSelected()) continue;
                return l;
            }
        }
        return null;
    }

    public DanasSession getfirstSessionSelected() {
        for (DanasSession s : this.DanasSessions) {
            if (!s.isSelected()) continue;
            return s;
        }
        return null;
    }

    public CurvaXY getCurvaLapXY(DanasDataStructureConstants.ValueType vtAsseX, DanasDataStructureConstants.ValueType vtAsseY, DanasDataStructureConstants.ValueType vtAsseZ, int sid, int lid, int riduzione, boolean monocolore) {
        DanasSession s = this.getSession(sid);
        if (s == null) {
            return null;
        }
        double[] x = null;
        double[] y = null;
        double[] z = null;
        DanasLap l = s.getLap(lid);
        String name = Integer.valueOf(s.getSessionID()).toString() + "-" + Integer.valueOf(l.getLapID()).toString();
        Color col = l.getColor();
        ArrayDouble valoriX = s.getAllValueDataFiltrati(vtAsseX, true);
        ArrayDouble valoriY = s.getAllValueDataFiltrati(vtAsseY, true);
        ArrayDouble valoriZ = s.getAllValueDataFiltrati(vtAsseZ, true);
        double frequenzaX = s.getFrequenzaCanale(vtAsseX);
        double frequenzaY = s.getFrequenzaCanale(vtAsseY);
        double frequenzaZ = s.getFrequenzaCanale(vtAsseZ);
        double frequenzaMax = frequenzaX;
        DanasDataStructureConstants.ValueType canaleMax = vtAsseX;
        if (frequenzaX == 0.0 || frequenzaY == 0.0) {
            return null;
        }
        if (frequenzaY > frequenzaMax) {
            frequenzaMax = frequenzaY;
            canaleMax = vtAsseY;
        }
        if (!monocolore && frequenzaZ > frequenzaMax) {
            frequenzaMax = frequenzaZ;
            canaleMax = vtAsseZ;
        }
        int indiceStart = s.getIndiceAtTime(canaleMax, l.getStart(), DanasDataStructureConstants.BoundLap.NEXT);
        int indiceStop = s.getIndiceAtTime(canaleMax, l.getEnd(), DanasDataStructureConstants.BoundLap.PREVIOUS);
        int dimensione = indiceStop - indiceStart;
        if (dimensione <= 0) {
            return null;
        }
        x = new double[dimensione];
        y = new double[dimensione];
        z = new double[dimensione];
        double tempoInizio = s.getTempoIniziale(canaleMax);
        for (int i = 0; i < dimensione; ++i) {
            double tempo = tempoInizio + (double)(i + indiceStart) * 100.0 / frequenzaMax;
            x[i] = valoriX.get(s.getIndiceAtTime(vtAsseX, tempo, DanasDataStructureConstants.BoundLap.NEAREST));
            y[i] = valoriY.get(s.getIndiceAtTime(vtAsseY, tempo, DanasDataStructureConstants.BoundLap.NEAREST));
            z[i] = monocolore ? 0.0 : valoriZ.get(s.getIndiceAtTime(vtAsseZ, tempo, DanasDataStructureConstants.BoundLap.NEAREST));
        }
        CurvaXY curva = new CurvaXY(x, y, z, col, name, riduzione, monocolore);
        return curva;
    }

    public Curva getCurvaLap(DanasDataStructureConstants.ValueType vt, int sid, int lid) {
        int indiceStart;
        DanasSession s = this.getSession(sid);
        DanasLap l = null;
        if (s == null) {
            return null;
        }
        l = s.getLap(lid);
        if (vt == DanasDataStructureConstants.ValueType.DELAY) {
            l.calcolaRitardi();
        }
        double[] val = null;
        double[] x = null;
        double[] t = null;
        double[] p = null;
        boolean[] usa = null;
        Color col = null;
        ArrayDouble valori = s.getAllValueDataFiltrati(vt, true);
        if (valori == null || valori.size() == 0) {
            return null;
        }
        List<Double> spazi = l.getValoriSpazio();
        int indiceStop = s.getIndiceAtTime(vt, l.getEnd(), DanasDataStructureConstants.BoundLap.PREVIOUS);
        int dimensione = indiceStop - (indiceStart = s.getIndiceAtTime(vt, l.getStart(), DanasDataStructureConstants.BoundLap.NEXT));
        if (dimensione <= 0) {
            return null;
        }
        x = new double[dimensione];
        t = new double[x.length];
        val = new double[x.length];
        p = new double[x.length];
        usa = new boolean[x.length];
        int dimensioneSpazioGiro = spazi.size() / (int)(100.0 / s.getRisoluzioneTemporale() / s.getFrequenzaCanale(vt));
        if (dimensioneSpazioGiro < dimensione || dimensioneSpazioGiro - dimensione > 5) {
            l.calcolaTempiDistanze();
        }
        try {
            for (int i = 0; i < dimensione; ++i) {
                val[i] = valori.get(i + indiceStart);
                t[i] = s.getTempoIniziale(vt) + (double)(i + indiceStart) * 100.0 / s.getFrequenzaCanale(vt) - l.getStart() + l.getOffsetTempo();
                x[i] = spazi.get(i * (int)(100.0 / s.getRisoluzioneTemporale() / s.getFrequenzaCanale(vt)));
                p[i] = s.getPosizioneStechioAtTime(t[i] + l.getStart() - l.getOffsetTempo(), DanasDataStructureConstants.BoundLap.NEAREST);
                usa[i] = s.getUsaInStechioAtTime(t[i] + l.getStart() - l.getOffsetTempo(), DanasDataStructureConstants.BoundLap.NEAREST);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Errore generazione curva Lap");
            System.out.println("tempo start=" + l.getEnd() + " tempo stop=" + l.getEnd() + " dimensione=" + dimensione + " dimensione spazi=" + spazi.size());
        }
        col = l.getColor();
        String name = Integer.valueOf(s.getSessionID()).toString() + "-" + Integer.valueOf(l.getLapID()).toString();
        if (x.length == 0) {
            System.out.println("Ritornato null per lap:" + name);
            return null;
        }
        int modoAttuale = DanasDataStructure.getInstance().getMainFrame().getModoAttuale();
        return new Curva(x, t, val, col, name, p, usa, DanasPreferences.getAlarmHi(vt, modoAttuale), DanasPreferences.getAlarmLow(vt, modoAttuale));
    }

    public Curva getCurvaLapFFT(DanasDataStructureConstants.ValueType vt, int sid, int lid) {
        int dimensione;
        int indiceStart;
        int indiceStop;
        DanasSession s = this.getSession(sid);
        DanasLap l = null;
        if (s == null) {
            return null;
        }
        l = s.getLap(lid);
        if (vt == DanasDataStructureConstants.ValueType.DELAY) {
            l.calcolaRitardi();
        }
        double[] val = null;
        double[] x = null;
        double[] t = null;
        double[] p = null;
        double[] out = null;
        boolean[] usa = null;
        Color col = null;
        ArrayDouble valori = s.getAllValueDataFiltrati(vt, true);
        if (valori == null || valori.size() == 0) {
            return null;
        }
        if (!DanasDataStructure.getInstance().getMainFrame().getFftSelezione()) {
            indiceStop = s.getIndiceAtTime(vt, l.getEnd(), DanasDataStructureConstants.BoundLap.PREVIOUS);
            indiceStart = s.getIndiceAtTime(vt, l.getStart(), DanasDataStructureConstants.BoundLap.NEXT);
        } else {
            double stop;
            double start;
            double fftStart = DanasDataStructure.getInstance().getMainFrame().getFftStart();
            double fftStop = DanasDataStructure.getInstance().getMainFrame().getFftStop();
            if (DanasDataStructure.getInstance().getMainFrame().getContenitoreGrafico().getModoSpazio()) {
                start = s.getTimeAtSpazio(fftStart + l.getDistanzaInizio(), DanasDataStructureConstants.BoundLap.NEAREST);
                stop = s.getTimeAtSpazio(fftStop + l.getDistanzaInizio(), DanasDataStructureConstants.BoundLap.NEAREST);
            } else {
                start = fftStart - l.getOffsetTempo() + l.getStart();
                stop = fftStop - l.getOffsetTempo() + l.getStart();
            }
            indiceStop = s.getIndiceAtTime(vt, stop, DanasDataStructureConstants.BoundLap.PREVIOUS);
            indiceStart = s.getIndiceAtTime(vt, start, DanasDataStructureConstants.BoundLap.NEXT);
        }
        if (indiceStop < indiceStart) {
            int c = indiceStop;
            indiceStop = indiceStart;
            indiceStart = c;
        }
        if ((dimensione = indiceStop - indiceStart) <= 0) {
            return null;
        }
        int numeroPunti = dimensione;
        val = new double[numeroPunti];
        for (int i = 0; i < numeroPunti; ++i) {
            val[i] = valori.get(i + indiceStart);
        }
        double[] fft = Interpolatore.Complex.absFFT(val);
        double logaritmo = DanasDataStructure.log2(numeroPunti);
        int base2 = (int)logaritmo;
        int numeroPuntiOut = (int)Math.pow(2.0, base2 + 1);
        x = new double[numeroPuntiOut / 2];
        t = new double[x.length];
        out = new double[x.length];
        p = new double[x.length];
        usa = new boolean[x.length];
        for (int i = 0; i < numeroPuntiOut / 2; ++i) {
            out[i] = fft[i];
            t[i] = (double)i / (double)numeroPuntiOut * s.getFrequenzaCanale(vt);
            x[i] = t[i];
            p[i] = 0.0;
            usa[i] = false;
        }
        col = l.getColor();
        String name = Integer.valueOf(s.getSessionID()).toString() + "-" + Integer.valueOf(l.getLapID()).toString();
        if (x.length == 0) {
            System.out.println("Ritornato null per lap:" + name);
            return null;
        }
        return new Curva(x, t, out, col, name, p, usa, Double.MAX_VALUE, Double.MIN_VALUE);
    }

    public void setDefaultLap(DanasLap defaultLap) {
        this.defaultLap = defaultLap;
        if (this.defaultLap != null) {
            defaultLap.setOffsetTempo(0.0);
            defaultLap.setTraslabile(false);
        }
        if (this.getAllienamentoSPlit() != 0) {
            this.getMainFrame().traslaCurve();
        }
        this.setChange(DanasDataStructureConstants.ChangeType.SET_REF_LAP);
    }

    public void setDefaultLapNull() {
        this.defaultLap = null;
    }

    public void aggiornaDefaultLap() {
        if (this.defaultLap != null) {
            return;
        }
        for (int i = 1; i <= this.getNSessions(); ++i) {
            DanasSession sess = this.getSession(i);
            if (sess.getNumberOfLaps() == 0) continue;
            this.setDefaultLap(sess.getLap(1));
            return;
        }
    }

    public DanasLap getDefaultLap() {
        return this.defaultLap;
    }

    public void saveDataDefaultLap(File f) {
        percentualeSalvataggio = 0;
        int valoriScritti = 0;
        this.interrompiSalvataggio = false;
        try {
            DanasDataStructureConstants.ValueType primoCanaleFrequenza;
            FileOutputStream fos = new FileOutputStream(f);
            PrintStream ps = new PrintStream(fos);
            DanasLap l = this.getDefaultLap();
            DanasSession s = l.getSession();
            ps.println("$TIPO," + s.getTipo() + ",");
            ps.println("$BEST," + MeasuresUtil.timeToHumanReadable((int)this.getDefaultLap().getDuration()) + ",");
            ps.println("$DIST," + MeasuresUtil.valueToHumanReadableDouble(this.getDefaultLap().getDistanceCovered(DanasDataStructureConstants.DataType.GPS) / 1000.0, 2));
            ps.println("$NEW SESSION");
            ps.println("$PILOTA," + s.getPilota() + ",");
            ps.println("$TIPO," + s.getTipo() + ",");
            ps.println(s.getStringaSettaggiCanali());
            ps.println(s.getStringaSettaggiBase());
            if (s.getDate() != null) {
                ps.println("$DATE," + String.format("%02d%02d%02d", s.getDate().getDate(), s.getDate().getMonth() + 1, s.getDate().getYear() + 1900 - 2000));
            }
            ps.println("$SESSION_COLOR," + String.format("%03d%03d%03d", s.getColor().getRed(), s.getColor().getGreen(), s.getColor().getBlue()));
            if (!s.getNotes().equals("")) {
                String fnote = s.getNotes();
                fnote = fnote.replace('$', ' ');
                fnote = fnote.replace('\n', '#');
                fnote = fnote.replace('\r', '#');
                ps.println("$NOTE," + fnote);
            }
            String formula = "$FORMULE,";
            for (int i = 0; i < 10; ++i) {
                formula = formula + s.getFormulaMath(i) + ";";
            }
            for (DanasDataStructureConstants.FrequenzeDisponibili frequenza : DanasDataStructureConstants.FrequenzeDisponibili.values()) {
                String fraseCanali = s.getStringaCanaliAtFrequenza(frequenza.frequenza());
                if (fraseCanali == null) continue;
                ps.println(fraseCanali);
            }
            ps.println(formula);
            if (s.getFrequenzaCanale(DanasDataStructureConstants.ValueType.VEL_GPS) != 0.0) {
                int indicePrimoValore = s.getIndiceAtTime(DanasDataStructureConstants.ValueType.LAT, l.getStart() - 200.0, DanasDataStructureConstants.BoundLap.NEXT);
                List<Double> latitudine = s.getSelectionValueData(DanasDataStructureConstants.ValueType.LAT, l.getStart() - 200.0, l.getEnd() + 200.0, false);
                List<Double> longitudine = s.getSelectionValueData(DanasDataStructureConstants.ValueType.LONG, l.getStart() - 200.0, l.getEnd() + 200.0, false);
                List<Double> vel = s.getSelectionValueData(DanasDataStructureConstants.ValueType.VEL_GPS, l.getStart() - 200.0, l.getEnd() + 200.0, false);
                List<Double> ora = s.getSelectionValueData(DanasDataStructureConstants.ValueType.GPS_TIME, l.getStart() - 200.0, l.getEnd() + 200.0, false);
                List<Double> altitudine = s.getSelectionValueData(DanasDataStructureConstants.ValueType.ALTITUDE, l.getStart() - 200.0, l.getEnd() + 200.0, false);
                double tempoIniziale = s.getTempoIniziale(DanasDataStructureConstants.ValueType.VEL_GPS);
                double deltaT = 100.0 / s.getFrequenzaCanale(DanasDataStructureConstants.ValueType.VEL_GPS);
                for (int i = 0; i < latitudine.size(); ++i) {
                    double tempo = tempoIniziale + (double)(i + indicePrimoValore) * deltaT;
                    ps.println(MeasuresUtil.getFraseGps(latitudine.get(i), longitudine.get(i), vel.get(i), ora.get(i), altitudine.get(i), tempo));
                }
            }
            int numeroValori = 0;
            for (DanasDataStructureConstants.FrequenzeDisponibili frequenza : DanasDataStructureConstants.FrequenzeDisponibili.values()) {
                primoCanaleFrequenza = null;
                for (DanasDataStructureConstants.ValueType vt : DanasDataStructureConstants.ValueType.values()) {
                    if (!MeasuresUtil.isTipoDaSalvare(vt) || s.getFrequenzaCanale(vt) != frequenza.frequenza()) continue;
                    primoCanaleFrequenza = vt;
                    break;
                }
                if (primoCanaleFrequenza == null) continue;
                numeroValori += s.getDimensioneCanale(primoCanaleFrequenza);
            }
            for (DanasDataStructureConstants.FrequenzeDisponibili frequenza : DanasDataStructureConstants.FrequenzeDisponibili.values()) {
                primoCanaleFrequenza = null;
                for (DanasDataStructureConstants.ValueType vt : DanasDataStructureConstants.ValueType.values()) {
                    if (!MeasuresUtil.isTipoDaSalvare(vt) || s.getFrequenzaCanale(vt) != frequenza.frequenza()) continue;
                    primoCanaleFrequenza = vt;
                    break;
                }
                if (primoCanaleFrequenza == null) continue;
                int primoIndice = s.getIndiceAtTime(primoCanaleFrequenza, l.getStart() - 200.0, DanasDataStructureConstants.BoundLap.NEXT);
                int ultimoIndice = s.getIndiceAtTime(primoCanaleFrequenza, l.getEnd() + 200.0, DanasDataStructureConstants.BoundLap.PREVIOUS);
                double tempoIniziale = s.getTempoIniziale(primoCanaleFrequenza);
                double deltaTempo = 100.0 / s.getFrequenzaCanale(primoCanaleFrequenza);
                int dimensione = ultimoIndice - primoIndice;
                if (dimensione <= 0) continue;
                for (int i = 0; i < dimensione; ++i) {
                    String frase = String.format("$VAL,%d,%.03f,", (int)frequenza.frequenza(), tempoIniziale + (double)(i + primoIndice) * deltaTempo);
                    for (DanasDataStructureConstants.ValueType vt : DanasDataStructureConstants.ValueType.values()) {
                        if (!MeasuresUtil.isTipoDaSalvare(vt) || s.getFrequenzaCanale(vt) != frequenza.frequenza()) continue;
                        frase = frase + String.format("%.3f,", s.getAllValueData(vt, false).get(i + primoIndice));
                    }
                    ps.println(frase);
                    int attuale = 100 * ++valoriScritti / numeroValori;
                    if (attuale == percentualeSalvataggio) continue;
                    percentualeSalvataggio = attuale;
                }
            }
            try {
                percentualeSalvataggio = 100;
                ps.close();
                fos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void refreshSettings(boolean refresh) {
        this.disableNotifier();
        System.out.println("refresh settings, totale sessioni:" + this.DanasSessions.size());
        for (DanasSession s : this.DanasSessions) {
            System.out.println("sessione id=" + s.getSessionID() + " file=" + s.getSessionSettings().getSettingsFileName());
            s.getSessionSettings().refreshSettings();
            s.ricalcolaValoriSlip(refresh);
        }
        this.enableNotifier();
        this.setChange(DanasDataStructureConstants.ChangeType.NEW_SETTINGS);
    }

    static {
        interpolazioneAttiva = false;
        percentualeApertura = 0;
        percentualeSalvataggio = 0;
        allineamentoSplit = 0;
        instance = null;
        gda = new DanasGenericDataAnalysys();
    }
}

