/*
 * Decompiled with CFR 0.152.
 */
package i2m;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.InvalidPropertiesFormatException;
import java.util.Properties;

public class DanasProperties {
    private String propertiesFilePath = "./configurations.xml";
    private Properties properties = new Properties();
    private boolean abilitaSalvataggio = true;

    public DanasProperties() {
        try {
            this.properties.loadFromXML(new FileInputStream(this.propertiesFilePath));
        }
        catch (InvalidPropertiesFormatException invalidPropertiesFormatException) {
        }
        catch (FileNotFoundException e) {
            System.out.println("File propriet\u00e0 non trovato: apertura");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void abilitaSalvataggio(boolean abilita) {
        this.abilitaSalvataggio = abilita;
    }

    public void put(String key, String value) {
        this.properties.setProperty(key, value);
        this.store();
    }

    public void putBoolean(String key, boolean value) {
        if (value) {
            this.properties.setProperty(key, "true");
        } else {
            this.properties.setProperty(key, "false");
        }
        this.store();
    }

    public void putInt(String key, int value) {
        this.properties.setProperty(key, "" + value);
        this.store();
    }

    public void putFloat(String key, float value) {
        this.properties.setProperty(key, "" + value);
        this.store();
    }

    public void putDouble(String key, double value) {
        this.properties.setProperty(key, "" + value);
        this.store();
    }

    public String get(String key, String def) {
        String s = this.properties.getProperty(key);
        if (s == null) {
            return def;
        }
        return this.properties.getProperty(key);
    }

    public boolean getBoolean(String key, boolean def) {
        String s = this.properties.getProperty(key);
        if (s == null) {
            return def;
        }
        return Boolean.parseBoolean(this.properties.getProperty(key));
    }

    public int getInt(String key, int def) {
        String s = this.properties.getProperty(key);
        if (s == null) {
            return def;
        }
        return Integer.parseInt(this.properties.getProperty(key));
    }

    public float getFloat(String key, float def) {
        String s = this.properties.getProperty(key);
        if (s == null) {
            return def;
        }
        return Float.parseFloat(this.properties.getProperty(key));
    }

    public double getDouble(String key, double def) {
        String s = this.properties.getProperty(key);
        if (s == null) {
            return def;
        }
        return Double.parseDouble(this.properties.getProperty(key));
    }

    private void store() {
        if (!this.abilitaSalvataggio) {
            return;
        }
        String commentText = "Program parameters";
        try {
            this.properties.storeToXML(new FileOutputStream(this.propertiesFilePath), commentText);
        }
        catch (FileNotFoundException e) {
            System.out.println("File salvataggio propriet\u00e0 non esiste");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void exportSubtree(OutputStream out) {
        String commentText = "Program parameters";
        try {
            this.properties.storeToXML(out, commentText);
        }
        catch (FileNotFoundException e) {
            System.out.println("File di esprtazione propriet\u00e0 non esiste");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void importPreferences(FileInputStream in) {
        try {
            this.properties.loadFromXML(in);
            this.store();
        }
        catch (InvalidPropertiesFormatException invalidPropertiesFormatException) {
        }
        catch (FileNotFoundException e) {
            System.out.println("File di importazione propriet\u00e0 non esiste");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void clear() {
        File f = new File("./configurations.xml");
        f.delete();
        this.propertiesFilePath = "./configurations.xml";
        this.properties = new Properties();
        try {
            this.properties.loadFromXML(new FileInputStream(this.propertiesFilePath));
        }
        catch (InvalidPropertiesFormatException invalidPropertiesFormatException) {
        }
        catch (FileNotFoundException e) {
            System.out.println("File propriet\u00e0 non trovato: clear");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

